/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.heuristics;

import edu.purdue.smas.timetable.serverfwk.ParameterDefinition;
import edu.purdue.smas.timetable.util.Constants;
import ifs.extension.ConflictStatistics;
import ifs.extension.Extension;
import ifs.extension.MacPropagation;
import ifs.extension.ViolatedInitials;
import ifs.heuristics.ValueSelection;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.perturbations.PerturbationsCounter;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import ttsolver.TimetableModel;
import ttsolver.constraint.DepartmentSpreadConstraint;
import ttsolver.constraint.GroupConstraint;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.constraint.JenrlConstraint;
import ttsolver.constraint.RoomConstraint;
import ttsolver.heuristics.HeuristicSelector;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class PlacementSelection
implements ValueSelection {
    static final int NR_LEVELS = 3;
    private static final double PRECISION = 1.0;
    private static final boolean USE_THRESHOLD = true;
    private boolean iUseThreshold = true;
    private double iGoodSelectionProb;
    public static final String GOOD_SELECTION_PROB = "Placement.GoodSelectionProb";
    private double iRandomWalkProb;
    public static final String RW_SELECTION_PROB = "Placement.RandomWalkProb";
    private double iInitialSelectionProb;
    public static final String INITIAL_SELECTION_PROB = "Placement.MPP_InitialProb";
    private int iMPPLimit;
    public static final String NR_MPP_LIMIT = "Placement.MPP_Limit";
    private double iMPPPenaltyLimit;
    public static final String NR_MPP_PENALTY_LIMIT = "Placement.MPP_PenaltyLimit";
    private double[] iNrConflictsWeight = new double[3];
    public static final String NR_CONFLICTS_WEIGHT = "Placement.NrConflictsWeight";
    private double[] iNrPotentialConflictsWeight = new double[3];
    public static final String NR_POTENTIAL_CONFLICTS_WEIGHT = "Placement.NrPotentialConflictsWeight";
    private double[] iNrWeightedConflictsWeight = new double[3];
    public static final String WEIGHTED_CONFLICTS_WEIGHT = "Placement.WeightedConflictsWeight";
    private double[] iDeltaTimePreferenceWeight = new double[3];
    public static final String DELTA_TIME_PREFERENCE_WEIGHT = "Placement.DeltaTimePreferenceWeight";
    private double[] iPerturbationPenaltyWeight = new double[3];
    public static final String DELTA_INITIAL_ASSIGNMENT_WEIGHT = "Placement.MPP_DeltaInitialAssignmentWeight";
    private double[] iNrStudentConflictsWeight = new double[3];
    public static final String NR_STUDENT_CONF_WEIGHT = "Placement.NrStudConfsWeight";
    private double[] iNrHardStudentConflictsWeight = new double[3];
    public static final String NR_HARD_STUDENT_CONF_WEIGHT = "Placement.NrHardStudConfsWeight";
    private double[] iUselessSlotsWeight = new double[3];
    public static final String USELESS_SLOTS_WEIGHT = "Placement.UselessSlotsWeight";
    private double[] iSumConstrPreferencesWeight = new double[3];
    public static final String SUM_CONSTR_PREFERENCE_WEIGHT = "Placement.ConstrPreferenceWeight";
    private double[] iSumRoomPreferencesWeight = new double[3];
    public static final String SUM_ROOM_PREFERENCE_WEIGHT = "Placement.RoomPreferenceWeight";
    private double[] iSumTimePreferencesWeight = new double[3];
    public static final String SUM_TIME_PREFERENCE_WEIGHT = "Placement.TimePreferenceWeight";
    private double[] iNrAssignmentsWeight = new double[3];
    public static final String NR_ASSIGNMENTS_WEIGHT = "Placement.NrAssignmentsWeight";
    private double[] iThresholdKoef = new double[3];
    public static final String NR_THRESHOLD_KOEF = "Placement.ThresholdKoef";
    private double[] iTooBigRoomWeight = new double[3];
    public static final String TOO_BIG_ROOM_WEIGHT = "Placement.TooBigRoomWeight";
    private double[] iDeptSpreadWeight = new double[3];
    public static final String DEPT_SPREAD_WEIGHT = "Placement.DeptSpreadPenaltyWeight";
    private double[] iDistanceInstructorPreferenceWeight = new double[3];
    public static final String DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT = "Placement.DistanceInstructorPreferenceWeight";
    private int iTabuSize = 0;
    private ArrayList iTabu = null;
    private int iTabuPos = 0;
    public static final String TABU_LENGTH = "Placement.TabuLength";
    private ConflictStatistics iStat = null;
    private MacPropagation iProp = null;
    private ViolatedInitials iViolatedInitials = null;
    private PerturbationsCounter iPerturbationsCounter = null;
    private boolean iRW = false;
    private boolean iMPP = false;
    private boolean iSW = false;

    public static Vector parameters() {
        FastVector fastVector = new FastVector();
        ParameterDefinition.Dependency dependency = new ParameterDefinition.Dependency("General.MPP", "true");
        ParameterDefinition.Dependency dependency2 = new ParameterDefinition.Dependency("General.SwitchStudents", "true");
        ParameterDefinition.Dependency dependency3 = new ParameterDefinition.Dependency("General.UseDepartmentSpreadConstraints", "true");
        ParameterDefinition.Dependency dependency4 = new ParameterDefinition.Dependency("Placement.AutoConfigure", "false");
        ParameterDefinition.Dependency dependency5 = new ParameterDefinition.Dependency("ConflictStatistics.Enabled", "true");
        ParameterDefinition.Dependency dependency6 = new ParameterDefinition.Dependency("ConflictStatistics.Enabled", "false");
        fastVector.addElement(new ParameterDefinition("Placement Selection", RW_SELECTION_PROB, "Random-walk probability", 1, "0.00"));
        fastVector.addElement(new ParameterDefinition("Placement Selection", INITIAL_SELECTION_PROB, "Select initial probability", 1, "0.75").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Placement Selection", NR_MPP_LIMIT, "Added perturbations limit", 0, "-1").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Placement Selection", NR_MPP_PENALTY_LIMIT, "Perturbations penalty limit", 1, "-1.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Placement Selection", "Placement.AutoConfigure", "Automatic configuration", 2, "true"));
        for (int i = 0; i < 3; ++i) {
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), NR_CONFLICTS_WEIGHT + (i + 1), "Hard conflicts", 1, i == 0 ? "1.0" : "0.0").addDependency(dependency4).addDependency(dependency6));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), WEIGHTED_CONFLICTS_WEIGHT + (i + 1), "Weighted hard conflicts (CBS)", 1, i == 0 ? "1.0" : "0.0").addDependency(dependency4).addDependency(dependency5));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), DELTA_TIME_PREFERENCE_WEIGHT + (i + 1), "Time preferences delta", 1, i == 0 ? "0.5" : "0.0").addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), DELTA_INITIAL_ASSIGNMENT_WEIGHT + (i + 1), "Perturbation penalty", 1, i == 0 ? "0.5" : (i == 1 ? "1.0" : "0.0")).addDependency(dependency).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), NR_STUDENT_CONF_WEIGHT + (i + 1), "Student conflicts", 1, i == 0 ? "0.1" : (i == 1 ? "0.2" : "0.0")).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), NR_HARD_STUDENT_CONF_WEIGHT + (i + 1), "Hard student conflicts", 1, i == 0 ? "0.5" : (i == 1 ? "1.0" : "0.0")).addDependency(dependency2).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), USELESS_SLOTS_WEIGHT + (i + 1), "Useless slots", 1, "0.0").addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), SUM_CONSTR_PREFERENCE_WEIGHT + (i + 1), "Group constraint preferences", 1, i == 0 ? "0.0" : (i == 1 ? "1.0" : "0.0")).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), SUM_ROOM_PREFERENCE_WEIGHT + (i + 1), "Room preferences", 1, i == 1 ? "0.1" : "0.0").addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), SUM_TIME_PREFERENCE_WEIGHT + (i + 1), "Time preferences", 1, i == 1 ? "1.0" : "0.0").addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), TOO_BIG_ROOM_WEIGHT + (i + 1), "Too big rooms", 1, "0.0").addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), DEPT_SPREAD_WEIGHT + (i + 1), "Deparment balancing penalty", 1, i == 0 ? "0.5" : (i == 1 ? "1.0" : "0.0")).addDependency(dependency3).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection - Weights Level " + (i + 1), DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT + (i + 1), "Distance instructor preference", 1, i == 0 ? "0.5" : (i == 1 ? "1.0" : "0.0")).addDependency(dependency4));
            fastVector.addElement(new ParameterDefinition("Placement Selection", NR_THRESHOLD_KOEF + (i + 1), "Threshold koeficient for level " + (i + 1), 1, i == 0 ? "0.1" : "0.0").addDependency(dependency4));
        }
        return fastVector;
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension instanceof ConflictStatistics) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (extension instanceof MacPropagation) {
                this.iProp = (MacPropagation)extension;
            }
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
        this.iPerturbationsCounter = solver.getPerturbationsCounter();
    }

    public PlacementSelection(DataProperties dataProperties) {
        this.iMPP = dataProperties.getPropertyBoolean("General.MPP", false);
        this.iRW = dataProperties.getPropertyBoolean("General.RandomWalk", true);
        this.iSW = dataProperties.getPropertyBoolean("General.SwitchStudents", true);
        boolean bl = dataProperties.getPropertyBoolean("Placement.AutoConfigure", false);
        this.iRandomWalkProb = this.iRW ? dataProperties.getPropertyDouble(RW_SELECTION_PROB, 0.0) : 0.0;
        this.iGoodSelectionProb = dataProperties.getPropertyDouble(GOOD_SELECTION_PROB, 1.0);
        this.iInitialSelectionProb = this.iMPP ? dataProperties.getPropertyDouble(INITIAL_SELECTION_PROB, 0.75) : 0.0;
        this.iMPPLimit = this.iMPP ? dataProperties.getPropertyInt(NR_MPP_LIMIT, -1) : -1;
        this.iMPPPenaltyLimit = this.iMPP ? dataProperties.getPropertyDouble(NR_MPP_PENALTY_LIMIT, -1.0) : -1.0;
        this.iTabuSize = dataProperties.getPropertyInt(TABU_LENGTH, -1);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
        this.iUseThreshold = dataProperties.getPropertyBoolean("Placement.UseThreshold", true);
        for (int i = 0; i < 3; ++i) {
            this.iNrConflictsWeight[i] = dataProperties.getPropertyDouble(NR_CONFLICTS_WEIGHT + (i + 1), i == 0 ? 1.0 : 0.0);
            this.iNrPotentialConflictsWeight[i] = dataProperties.getPropertyDouble(NR_POTENTIAL_CONFLICTS_WEIGHT + (i + 1), 0.0);
            this.iNrWeightedConflictsWeight[i] = dataProperties.getPropertyDouble(WEIGHTED_CONFLICTS_WEIGHT + (i + 1), i == 0 ? 1.0 : 0.0);
            this.iDeltaTimePreferenceWeight[i] = dataProperties.getPropertyDouble(DELTA_TIME_PREFERENCE_WEIGHT + (i + 1), i == 0 ? 0.5 : 0.0);
            this.iPerturbationPenaltyWeight[i] = this.iMPP ? dataProperties.getPropertyDouble(DELTA_INITIAL_ASSIGNMENT_WEIGHT + (i + 1), i == 0 ? 0.5 : (i == 1 ? 1.0 : 0.0)) : 0.0;
            this.iNrStudentConflictsWeight[i] = dataProperties.getPropertyDouble(NR_STUDENT_CONF_WEIGHT + (i + 1), i == 0 ? 0.1 : (i == 1 ? 0.2 : 0.0));
            this.iNrHardStudentConflictsWeight[i] = this.iSW ? dataProperties.getPropertyDouble(NR_HARD_STUDENT_CONF_WEIGHT + (i + 1), i == 0 ? 0.5 : (i == 1 ? 1.0 : 0.0)) : 0.0;
            this.iUselessSlotsWeight[i] = dataProperties.getPropertyDouble(USELESS_SLOTS_WEIGHT + (i + 1), 0.0);
            this.iSumConstrPreferencesWeight[i] = dataProperties.getPropertyDouble(SUM_CONSTR_PREFERENCE_WEIGHT + (i + 1), i == 0 ? 0.5 : (i == 1 ? 1.0 : 0.0));
            this.iSumRoomPreferencesWeight[i] = dataProperties.getPropertyDouble(SUM_ROOM_PREFERENCE_WEIGHT + (i + 1), i == 1 ? 0.1 : 0.0);
            this.iSumTimePreferencesWeight[i] = dataProperties.getPropertyDouble(SUM_TIME_PREFERENCE_WEIGHT + (i + 1), i == 1 ? 1.0 : 0.0);
            this.iNrAssignmentsWeight[i] = dataProperties.getPropertyDouble(NR_ASSIGNMENTS_WEIGHT + (i + 1), 0.0);
            this.iThresholdKoef[i] = dataProperties.getPropertyDouble(NR_THRESHOLD_KOEF + (i + 1), i == 0 ? 0.1 : 0.0);
            this.iTooBigRoomWeight[i] = dataProperties.getPropertyDouble(TOO_BIG_ROOM_WEIGHT + (i + 1), 0.0);
            this.iDeptSpreadWeight[i] = dataProperties.getPropertyDouble(DEPT_SPREAD_WEIGHT + (i + 1), i == 0 ? 0.5 : (i == 1 ? 1.0 : 0.0));
            this.iDistanceInstructorPreferenceWeight[i] = dataProperties.getPropertyDouble(DISTANCE_INSTRUCTOR_PREFERENCE_WEIGHT + (i + 1), i == 0 ? 0.1 : (i == 1 ? 1.0 : 0.0));
        }
        if (bl) {
            this.iNrConflictsWeight[0] = 3.0;
            this.iNrPotentialConflictsWeight[0] = 0.0;
            this.iNrWeightedConflictsWeight[0] = 3.0;
            this.iDeltaTimePreferenceWeight[0] = dataProperties.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0) / 2.0;
            this.iNrAssignmentsWeight[0] = 0.0;
            this.iThresholdKoef[0] = 0.1;
            this.iNrStudentConflictsWeight[0] = dataProperties.getPropertyDouble("Comparator.StudentConflictWeight", 0.2);
            this.iNrHardStudentConflictsWeight[0] = dataProperties.getPropertyDouble("Comparator.HardStudentConflictWeight", 1.0);
            this.iUselessSlotsWeight[0] = dataProperties.getPropertyDouble("Comparator.UselessSlotWeight", 0.0);
            this.iSumConstrPreferencesWeight[0] = dataProperties.getPropertyDouble("Comparator.ContrPreferenceWeight", 1.0);
            this.iSumRoomPreferencesWeight[0] = dataProperties.getPropertyDouble("Comparator.RoomPreferenceWeight", 0.1);
            this.iSumTimePreferencesWeight[0] = dataProperties.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0);
            this.iTooBigRoomWeight[0] = dataProperties.getPropertyDouble("Comparator.TooBigRoomWeight", 0.0);
            this.iDeptSpreadWeight[0] = dataProperties.getPropertyDouble("Comparator.DeptSpreadPenaltyWeight", 1.0);
            this.iDistanceInstructorPreferenceWeight[0] = dataProperties.getPropertyDouble("Comparator.DistanceInstructorPreferenceWeight", 1.0);
            this.iPerturbationPenaltyWeight[0] = this.iMPP ? dataProperties.getPropertyDouble("Comparator.PerturbationPenaltyWeight", 1.0) : 0.0;
            this.iNrConflictsWeight[1] = 0.0;
            this.iNrPotentialConflictsWeight[1] = 0.0;
            this.iNrWeightedConflictsWeight[1] = 0.0;
            this.iDeltaTimePreferenceWeight[1] = 0.0;
            this.iNrAssignmentsWeight[1] = 0.0;
            this.iThresholdKoef[1] = 0.0;
            this.iNrStudentConflictsWeight[1] = dataProperties.getPropertyDouble("Comparator.StudentConflictWeight", 0.2);
            this.iNrHardStudentConflictsWeight[1] = dataProperties.getPropertyDouble("Comparator.HardStudentConflictWeight", 1.0);
            this.iUselessSlotsWeight[1] = dataProperties.getPropertyDouble("Comparator.UselessSlotWeight", 0.0);
            this.iSumConstrPreferencesWeight[1] = dataProperties.getPropertyDouble("Comparator.ContrPreferenceWeight", 1.0);
            this.iSumRoomPreferencesWeight[1] = dataProperties.getPropertyDouble("Comparator.RoomPreferenceWeight", 0.1);
            this.iSumTimePreferencesWeight[1] = dataProperties.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0);
            this.iTooBigRoomWeight[1] = dataProperties.getPropertyDouble("Comparator.TooBigRoomWeight", 0.0);
            this.iDeptSpreadWeight[1] = dataProperties.getPropertyDouble("Comparator.DeptSpreadPenaltyWeight", 1.0);
            this.iDistanceInstructorPreferenceWeight[1] = dataProperties.getPropertyDouble("Comparator.DistanceInstructorPreferenceWeight", 1.0);
            this.iPerturbationPenaltyWeight[1] = this.iMPP ? dataProperties.getPropertyDouble("Comparator.PerturbationPenaltyWeight", 1.0) : 0.0;
            this.iNrConflictsWeight[2] = 0.0;
            this.iNrPotentialConflictsWeight[2] = 0.0;
            this.iNrWeightedConflictsWeight[2] = 0.0;
            this.iDeltaTimePreferenceWeight[2] = 0.0;
            this.iPerturbationPenaltyWeight[2] = 0.0;
            this.iNrStudentConflictsWeight[2] = 0.0;
            this.iNrHardStudentConflictsWeight[2] = 0.0;
            this.iUselessSlotsWeight[2] = 0.0;
            this.iSumConstrPreferencesWeight[2] = 0.0;
            this.iSumRoomPreferencesWeight[2] = 0.0;
            this.iSumTimePreferencesWeight[2] = 0.0;
            this.iNrAssignmentsWeight[2] = 0.0;
            this.iThresholdKoef[2] = 0.0;
            this.iTooBigRoomWeight[2] = 0.0;
            this.iDeptSpreadWeight[2] = 0.0;
            this.iDistanceInstructorPreferenceWeight[2] = 0.0;
        }
    }

    public Value selectValue(Solution solution, Variable variable) {
        ParamRetriever paramRetriever;
        Object object;
        Object object2;
        if (variable.getInitialAssignment() != null) {
            if (this.iMPPLimit >= 0 && solution.getModel().perturbVariables().size() >= this.iMPPLimit) {
                return this.checkValue(variable.getInitialAssignment());
            }
            if (this.iMPPPenaltyLimit >= 0.0 && solution.getPerturbationsCounter() != null && solution.getPerturbationsCounter().getPerturbationPenalty(solution) > this.iMPPPenaltyLimit) {
                return this.checkValue(variable.getInitialAssignment());
            }
            if (variable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb) {
                return this.checkValue(variable.getInitialAssignment());
            }
        }
        Vector vector = variable.values();
        if (this.iRW && ToolBox.random() <= this.iRandomWalkProb) {
            return this.checkValue((Value)ToolBox.random((Collection)vector));
        }
        if (this.iProp != null && variable.getAssignment() == null && ToolBox.random() <= this.iGoodSelectionProb && !(object2 = (Object)this.iProp.goodValues(variable)).isEmpty()) {
            vector = new FastVector((Collection)object2);
        }
        if (vector.size() == 1) {
            return this.checkValue((Value)vector.firstElement());
        }
        object2 = new long[3];
        Vector vector2 = null;
        HeuristicSelector heuristicSelector = this.iUseThreshold ? new HeuristicSelector(this.iThresholdKoef) : null;
        Object object3 = vector.elements();
        while (object3.hasMoreElements()) {
            int n;
            object = (Value)object3.nextElement();
            if (this.iTabu != null && this.iTabu.contains(object) || variable.getAssignment() != null && variable.getAssignment().equals(object)) continue;
            paramRetriever = new ParamRetriever(solution, (Lecture)variable, (Placement)((Object)object));
            if (this.iUseThreshold) {
                double[] dArray = new double[3];
                for (n = 0; n < 3; ++n) {
                    double d;
                    dArray[n] = d = (this.iNrConflictsWeight[n] == 0.0 ? 0.0 : this.iNrConflictsWeight[n] * (double)paramRetriever.nrContlicts()) + (this.iNrWeightedConflictsWeight[n] == 0.0 ? 0.0 : this.iNrWeightedConflictsWeight[n] * paramRetriever.weightedConflicts()) + (this.iNrPotentialConflictsWeight[n] == 0.0 ? 0.0 : this.iNrPotentialConflictsWeight[n] * paramRetriever.potentialConflicts(3)) + (this.iDeltaTimePreferenceWeight[n] == 0.0 ? 0.0 : this.iDeltaTimePreferenceWeight[n] * paramRetriever.deltaTimePreference()) + (this.iPerturbationPenaltyWeight[n] == 0.0 ? 0.0 : this.iPerturbationPenaltyWeight[n] * paramRetriever.perturbationsPenalty()) + (this.iNrStudentConflictsWeight[n] == 0.0 ? 0.0 : this.iNrStudentConflictsWeight[n] * (double)paramRetriever.sumStudentConflicts()) + (this.iNrHardStudentConflictsWeight[n] == 0.0 ? 0.0 : this.iNrHardStudentConflictsWeight[n] * (double)paramRetriever.sumHardStudentConflicts()) + (this.iUselessSlotsWeight[n] == 0.0 ? 0.0 : this.iUselessSlotsWeight[n] * (double)paramRetriever.emptySingleHalfHours()) + (this.iSumConstrPreferencesWeight[n] == 0.0 ? 0.0 : this.iSumConstrPreferencesWeight[n] * (double)paramRetriever.constrPreference()) + (this.iSumRoomPreferencesWeight[n] == 0.0 ? 0.0 : this.iSumRoomPreferencesWeight[n] * (double)paramRetriever.roomPreference()) + (this.iSumTimePreferencesWeight[n] == 0.0 ? 0.0 : this.iSumTimePreferencesWeight[n] * paramRetriever.timePreference()) + (this.iNrAssignmentsWeight[n] == 0.0 ? 0.0 : this.iNrAssignmentsWeight[n] * (double)paramRetriever.nrAssignments()) + (this.iTooBigRoomWeight[n] == 0.0 ? 0.0 : (paramRetriever.tooBig() ? this.iTooBigRoomWeight[n] : 0.0)) + (this.iDeptSpreadWeight[n] == 0.0 ? 0.0 : this.iDeptSpreadWeight[n] * (double)paramRetriever.deptSpread()) + (this.iDistanceInstructorPreferenceWeight[n] == 0.0 ? 0.0 : this.iDistanceInstructorPreferenceWeight[n] * (double)paramRetriever.distanceInstructorPreference());
                }
                heuristicSelector.add(dArray, object);
                continue;
            }
            boolean bl = false;
            n = 0;
            for (int i = 0; !bl && i < 1; ++i) {
                long l = Math.round(1.0 * ((this.iNrConflictsWeight[i] == 0.0 ? 0.0 : this.iNrConflictsWeight[i] * (double)paramRetriever.nrContlicts()) + (this.iNrWeightedConflictsWeight[i] == 0.0 ? 0.0 : this.iNrWeightedConflictsWeight[i] * paramRetriever.weightedConflicts()) + (this.iNrPotentialConflictsWeight[i] == 0.0 ? 0.0 : this.iNrPotentialConflictsWeight[i] * paramRetriever.potentialConflicts(0)) + (this.iDeltaTimePreferenceWeight[i] == 0.0 ? 0.0 : this.iDeltaTimePreferenceWeight[i] * paramRetriever.deltaTimePreference()) + (this.iPerturbationPenaltyWeight[i] == 0.0 ? 0.0 : this.iPerturbationPenaltyWeight[i] * paramRetriever.perturbationsPenalty()) + (this.iNrStudentConflictsWeight[i] == 0.0 ? 0.0 : this.iNrStudentConflictsWeight[i] * (double)paramRetriever.sumStudentConflicts()) + (this.iNrHardStudentConflictsWeight[i] == 0.0 ? 0.0 : this.iNrHardStudentConflictsWeight[i] * (double)paramRetriever.sumHardStudentConflicts()) + (this.iUselessSlotsWeight[i] == 0.0 ? 0.0 : this.iUselessSlotsWeight[i] * (double)paramRetriever.emptySingleHalfHours()) + (this.iSumConstrPreferencesWeight[i] == 0.0 ? 0.0 : this.iSumConstrPreferencesWeight[i] * (double)paramRetriever.constrPreference()) + (this.iSumRoomPreferencesWeight[i] == 0.0 ? 0.0 : this.iSumRoomPreferencesWeight[i] * (double)paramRetriever.roomPreference()) + (this.iSumTimePreferencesWeight[i] == 0.0 ? 0.0 : this.iSumTimePreferencesWeight[i] * paramRetriever.timePreference()) + (this.iNrAssignmentsWeight[i] == 0.0 ? 0.0 : this.iNrAssignmentsWeight[i] * (double)paramRetriever.nrAssignments()) + (this.iTooBigRoomWeight[i] == 0.0 ? 0.0 : (paramRetriever.tooBig() ? this.iTooBigRoomWeight[i] : 0.0)) + (this.iDeptSpreadWeight[i] == 0.0 ? 0.0 : this.iDeptSpreadWeight[i] * (double)paramRetriever.deptSpread()) + (this.iDistanceInstructorPreferenceWeight[i] == 0.0 ? 0.0 : this.iDistanceInstructorPreferenceWeight[i] * (double)paramRetriever.distanceInstructorPreference())));
                if (vector2 != null && n == 0) {
                    if (l > object2[i]) {
                        bl = true;
                    }
                    if (l >= object2[i]) continue;
                    object2[i] = l;
                    vector2.clear();
                    n = 1;
                    continue;
                }
                object2[i] = l;
            }
            if (vector2 == null) {
                vector2 = new FastVector(vector.size());
            }
            if (bl) continue;
            vector2.addElement(object);
        }
        object3 = null;
        if (this.iUseThreshold) {
            vector2 = heuristicSelector.selection();
            if (variable.getInitialAssignment() != null) {
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    paramRetriever = (Value)((HeuristicSelector.Element)object.nextElement()).getObject();
                    if (!paramRetriever.equals(variable.getInitialAssignment())) continue;
                    object3 = paramRetriever;
                    break;
                }
            }
            if (object3 == null) {
                object = (HeuristicSelector.Element)ToolBox.random((Collection)vector2);
                object3 = (Value)(object == null ? null : ((HeuristicSelector.Element)object).getObject());
            }
        } else {
            if (variable.getInitialAssignment() != null && vector2.contains(variable.getInitialAssignment())) {
                return this.checkValue(variable.getInitialAssignment());
            }
            object3 = (Value)ToolBox.random((Collection)vector2);
        }
        if (object3 != null && this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(object3);
            } else {
                this.iTabu.set(this.iTabuPos, object3);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return this.checkValue((Value)object3);
    }

    private Value checkValue(Value value) {
        if (value == null) {
            return null;
        }
        DepartmentSpreadConstraint departmentSpreadConstraint = ((Lecture)value.variable()).getDeptSpreadConstraint();
        if (departmentSpreadConstraint != null && departmentSpreadConstraint.inConflict(value)) {
            departmentSpreadConstraint.incUnassignmentCounter(value);
        }
        return value;
    }

    private class ParamRetriever {
        private Lecture iLecture;
        private Placement iPlacement;
        private Solution iSolution;
        Collection iConf = null;
        private Double iWeightedConflicts = null;
        private Double iPotentialConflicts = null;
        Double iDeltaTimePreference = null;
        Double iPerturbationsPenalty = null;
        Integer iSumStudentConflicts = null;
        Integer iConstrPreference = null;
        Integer iEmptySingleHalfHours = null;
        Integer iSumHardStudentConflicts = null;
        Integer iDeptSpreadCache = null;
        Integer iDistanceInstructorPreferenceCache = null;

        private ParamRetriever(Solution solution, Lecture lecture, Placement placement) {
            this.iSolution = solution;
            this.iLecture = lecture;
            this.iPlacement = placement;
        }

        private Collection conf() {
            if (this.iConf == null) {
                this.iConf = this.iSolution.getModel().conflictValues((Value)this.iPlacement);
            }
            return this.iConf;
        }

        public long nrContlicts() {
            return this.conf().size();
        }

        public double weightedConflicts() {
            if (this.iWeightedConflicts == null) {
                this.iWeightedConflicts = new Double(PlacementSelection.this.iStat == null ? 0.0 : PlacementSelection.this.iStat.countRemovals(this.iSolution.getIteration(), this.conf(), (Value)this.iPlacement));
            }
            return this.iWeightedConflicts;
        }

        public double potentialConflicts(int n) {
            if (this.iPotentialConflicts == null) {
                this.iPotentialConflicts = new Double(PlacementSelection.this.iStat == null ? 0.0 : (double)PlacementSelection.this.iStat.countPotentialConflicts(this.iSolution.getIteration(), (Value)this.iPlacement, n));
            }
            return this.iPotentialConflicts;
        }

        public double deltaTimePreference() {
            if (this.iDeltaTimePreference == null) {
                double d = 0.0;
                Iterator iterator = this.conf().iterator();
                while (iterator.hasNext()) {
                    Placement placement = (Placement)((Object)iterator.next());
                    double d2 = placement.getTimeLocation().getNormalizedPreference();
                    d -= d2 - ((Lecture)placement.variable()).getBestTimePreference();
                }
                this.iDeltaTimePreference = new Double(d += this.iPlacement.getTimeLocation().getNormalizedPreference() - this.iLecture.getBestTimePreference());
            }
            return this.iDeltaTimePreference;
        }

        public double perturbationsPenalty() {
            if (this.iPerturbationsPenalty == null) {
                this.iPerturbationsPenalty = new Double(PlacementSelection.this.iPerturbationsCounter.getPerturbationPenalty(this.iSolution, (Value)this.iPlacement, this.conf()));
            }
            return this.iPerturbationsPenalty;
        }

        public int sumStudentConflicts() {
            if (this.iSumStudentConflicts == null) {
                this.iSumStudentConflicts = new Integer(this.iLecture.countStudentConflicts(this.iPlacement));
            }
            return this.iSumStudentConflicts;
        }

        public int constrPreference() {
            if (this.iConstrPreference == null) {
                int n = 0;
                Enumeration enumeration = this.iLecture.softConstraints().elements();
                while (enumeration.hasMoreElements()) {
                    Constraint constraint = (Constraint)enumeration.nextElement();
                    if (!(constraint instanceof GroupConstraint)) continue;
                    GroupConstraint groupConstraint = (GroupConstraint)constraint;
                    n += groupConstraint.getCurrentPreference(this.iPlacement);
                }
                this.iConstrPreference = new Integer(n);
            }
            return this.iConstrPreference;
        }

        public int emptySingleHalfHours() {
            if (this.iEmptySingleHalfHours == null) {
                int n = 0;
                Enumeration enumeration = this.iLecture.hardConstraints().elements();
                while (enumeration.hasMoreElements()) {
                    Constraint constraint = (Constraint)enumeration.nextElement();
                    if (!(constraint instanceof RoomConstraint)) continue;
                    RoomConstraint roomConstraint = (RoomConstraint)constraint;
                    for (int i = 0; i < this.iPlacement.getTimeLocation().getStartSlots().length; ++i) {
                        int n2 = this.iPlacement.getTimeLocation().getStartSlots()[i];
                        int n3 = n2 + this.iPlacement.getTimeLocation().getLength() - 1;
                        if (n2 % Constants.SLOTS_PER_DAY >= 2 && roomConstraint.getResource()[n2 - 1] == null && roomConstraint.getResource()[n2 - 2] != null) {
                            ++n;
                        }
                        if (n3 % Constants.SLOTS_PER_DAY >= Constants.SLOTS_PER_DAY - 2 || roomConstraint.getResource()[n2 + 1] != null || roomConstraint.getResource()[n2 + 2] == null) continue;
                        ++n;
                    }
                }
                this.iEmptySingleHalfHours = new Integer(n);
            }
            return this.iEmptySingleHalfHours;
        }

        public int sumHardStudentConflicts() {
            if (this.iSumHardStudentConflicts == null) {
                boolean bl = this.iLecture.sameLectures() == null ? false : this.iLecture.sameLectures().size() > 1;
                int n = 0;
                if (!bl) {
                    Enumeration enumeration = this.iLecture.jenrlConstraints().elements();
                    while (enumeration.hasMoreElements()) {
                        JenrlConstraint jenrlConstraint = (JenrlConstraint)((Object)enumeration.nextElement());
                        Vector vector = ((Lecture)jenrlConstraint.another(this.iLecture)).sameLectures();
                        if (vector != null && vector.size() != 1) continue;
                        n = (int)((long)n + jenrlConstraint.jenrl(this.iLecture, this.iPlacement));
                    }
                }
                this.iSumHardStudentConflicts = new Integer(n);
            }
            return this.iSumHardStudentConflicts;
        }

        public int roomPreference() {
            return this.iPlacement.getRoomLocation().getPreference();
        }

        public long nrAssignments() {
            return this.iPlacement.countAssignments();
        }

        public double timePreference() {
            return this.iPlacement.getTimeLocation().getNormalizedPreference();
        }

        public boolean tooBig() {
            return this.iPlacement.getRoomLocation().getRoomSize() > TimetableModel.getMaxCapacity(this.iLecture.countStudents());
        }

        public int deptSpread() {
            if (this.iLecture.getDeptSpreadConstraint() == null) {
                return 0;
            }
            if (this.iDeptSpreadCache == null) {
                this.iDeptSpreadCache = new Integer(this.iLecture.getDeptSpreadConstraint().getPenalty(this.iPlacement));
            }
            return this.iDeptSpreadCache;
        }

        public int distanceInstructorPreference() {
            if (this.iDistanceInstructorPreferenceCache == null) {
                int n = 0;
                if (this.iPlacement.getInstructorId() != null) {
                    Enumeration enumeration = this.iLecture.constraints().elements();
                    while (enumeration.hasMoreElements()) {
                        Constraint constraint = (Constraint)enumeration.nextElement();
                        if (!(constraint instanceof InstructorConstraint)) continue;
                        n += ((InstructorConstraint)constraint).getPreference(this.iPlacement);
                        break;
                    }
                }
                this.iDistanceInstructorPreferenceCache = new Integer(n);
            }
            return this.iDistanceInstructorPreferenceCache;
        }
    }
}

