/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.heuristics;

import edu.purdue.smas.timetable.serverfwk.ParameterDefinition;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.perturbations.DefaultPerturbationsCounter;
import ifs.solution.Solution;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import ttsolver.constraint.InstructorConstraint;
import ttsolver.model.Lecture;
import ttsolver.model.Placement;

public class UniversalPerturbationsCounter
extends DefaultPerturbationsCounter {
    private double iDifferentPlacement = 1.0;
    private double iAffectedStudentWeight = 0.0;
    private double iAffectedInstructorWeight = 0.0;
    private double iAffectedStudentByTimeWeight = 0.0;
    private double iAffectedInstructorByTimeWeight = 0.0;
    private double iAffectedStudentByRoomWeight = 0.0;
    private double iAffectedInstructorByRoomWeight = 0.0;
    private double iAffectedStudentByBldgWeight = 0.0;
    private double iAffectedInstructorByBldgWeight = 0.0;
    private double iDifferentRoomWeight = 0.0;
    private double iDifferentBuildingWeight = 0.0;
    private double iDifferentTimeWeight = 0.0;
    private double iDifferentDayWeight = 0.0;
    private double iDifferentHourWeight = 0.0;
    private double iNewStudentConflictsWeight = 0.0;
    private double iDeltaStudentConflictsWeight = 0.0;
    private double iTooFarForInstructorsWeight = 0.0;
    private double iTooFarForStudentsWeight = 0.0;
    private double iDeltaInstructorDistancePreferenceWeight = 0.0;
    private double iDeltaRoomPreferenceWeight = 0.0;
    private double iDeltaTimePreferenceWeight = 0.0;
    private boolean iMPP = false;

    public UniversalPerturbationsCounter(DataProperties dataProperties) {
        super(dataProperties);
        this.iMPP = dataProperties.getPropertyBoolean("General.MPP", false);
        this.iDifferentPlacement = dataProperties.getPropertyDouble("Perturbations.DifferentPlacement", this.iDifferentPlacement);
        this.iAffectedStudentWeight = dataProperties.getPropertyDouble("Perturbations.AffectedStudentWeight", this.iAffectedStudentWeight);
        this.iAffectedInstructorWeight = dataProperties.getPropertyDouble("Perturbations.AffectedInstructorWeight", this.iAffectedInstructorWeight);
        this.iAffectedStudentByTimeWeight = dataProperties.getPropertyDouble("Perturbations.AffectedStudentByTimeWeight", this.iAffectedStudentByTimeWeight);
        this.iAffectedInstructorByTimeWeight = dataProperties.getPropertyDouble("Perturbations.AffectedInstructorByTimeWeight", this.iAffectedInstructorByTimeWeight);
        this.iAffectedStudentByRoomWeight = dataProperties.getPropertyDouble("Perturbations.AffectedStudentByRoomWeight", this.iAffectedStudentByRoomWeight);
        this.iAffectedInstructorByRoomWeight = dataProperties.getPropertyDouble("Perturbations.AffectedInstructorByRoomWeight", this.iAffectedInstructorByRoomWeight);
        this.iAffectedStudentByBldgWeight = dataProperties.getPropertyDouble("Perturbations.AffectedStudentByBldgWeight", this.iAffectedStudentByBldgWeight);
        this.iAffectedInstructorByBldgWeight = dataProperties.getPropertyDouble("Perturbations.AffectedInstructorByBldgWeight", this.iAffectedInstructorByBldgWeight);
        this.iDifferentRoomWeight = dataProperties.getPropertyDouble("Perturbations.DifferentRoomWeight", this.iDifferentRoomWeight);
        this.iDifferentBuildingWeight = dataProperties.getPropertyDouble("Perturbations.DifferentBuildingWeight", this.iDifferentBuildingWeight);
        this.iDifferentTimeWeight = dataProperties.getPropertyDouble("Perturbations.DifferentTimeWeight", this.iDifferentTimeWeight);
        this.iDifferentDayWeight = dataProperties.getPropertyDouble("Perturbations.DifferentDayWeight", this.iDifferentDayWeight);
        this.iDifferentHourWeight = dataProperties.getPropertyDouble("Perturbations.DifferentHourWeight", this.iDifferentHourWeight);
        this.iDeltaStudentConflictsWeight = dataProperties.getPropertyDouble("Perturbations.DeltaStudentConflictsWeight", this.iDeltaStudentConflictsWeight);
        this.iNewStudentConflictsWeight = dataProperties.getPropertyDouble("Perturbations.NewStudentConflictsWeight", this.iNewStudentConflictsWeight);
        this.iTooFarForInstructorsWeight = dataProperties.getPropertyDouble("Perturbations.TooFarForInstructorsWeight", this.iTooFarForInstructorsWeight);
        this.iTooFarForStudentsWeight = dataProperties.getPropertyDouble("Perturbations.TooFarForStudentsWeight", this.iTooFarForStudentsWeight);
        this.iDeltaInstructorDistancePreferenceWeight = dataProperties.getPropertyDouble("Perturbations.DeltaInstructorDistancePreferenceWeight", this.iDeltaInstructorDistancePreferenceWeight);
        this.iDeltaRoomPreferenceWeight = dataProperties.getPropertyDouble("Perturbations.DeltaRoomPreferenceWeight", this.iDeltaRoomPreferenceWeight);
        this.iDeltaTimePreferenceWeight = dataProperties.getPropertyDouble("Perturbations.DeltaTimePreferenceWeight", this.iDeltaTimePreferenceWeight);
    }

    public static Vector parameters() {
        FastVector fastVector = new FastVector();
        ParameterDefinition.Dependency dependency = new ParameterDefinition.Dependency("General.MPP", "true");
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentPlacement", "Different placement than initial", 1, "1.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedStudentWeight", "Number of students", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedInstructorWeight", "An instructor is assigned", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedStudentByTimeWeight", "Number of students (time change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedInstructorByTimeWeight", "An instructor is assigned (time change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedStudentByRoomWeight", "Number of students (room change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedInstructorByRoomWeight", "An instructor is assigned (room change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedStudentByBldgWeight", "Number of students (building change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.AffectedInstructorByBldgWeight", "An instructor is assigned (building change)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentRoomWeight", "Different room used", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentBuildingWeight", "Different building used", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentTimeWeight", "Different time used", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentDayWeight", "Different day(s) used", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DifferentHourWeight", "Different hour(s) used", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DeltaStudentConflictsWeight", "Delta of student conflicts", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.NewStudentConflictsWeight", "New students in conflict", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.TooFarForInstructorsWeight", "New placement too far from initial (fot instructors)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.TooFarForStudentsWeight", "New placement too far from initial (for students)", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DeltaInstructorDistancePreferenceWeight", "Delta of instructor distance preferences", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DeltaRoomPreferenceWeight", "Delta of room preferences", 1, "0.0").addDependency(dependency));
        fastVector.addElement(new ParameterDefinition("Perturbations - Weights", "Perturbations.DeltaTimePreferenceWeight", "Delta of time preferences", 1, "0.0").addDependency(dependency));
        return fastVector;
    }

    protected double getPenalty(Value value, Value value2) {
        Lecture lecture = (Lecture)value2.variable();
        Placement placement = value == null ? null : (Placement)value;
        Placement placement2 = (Placement)value2;
        double d = 0.0;
        if (this.iDifferentPlacement != 0.0) {
            d += this.iDifferentPlacement;
        }
        if (this.iAffectedStudentWeight != 0.0) {
            d += this.iAffectedStudentWeight * (double)lecture.countStudents();
        }
        if (this.iAffectedInstructorWeight != 0.0 && placement2.getInstructorId() != null) {
            d += this.iAffectedInstructorWeight;
        }
        if (value != null) {
            InstructorConstraint instructorConstraint;
            Object object;
            if (!(this.iDifferentRoomWeight == 0.0 && this.iAffectedInstructorByRoomWeight == 0.0 && this.iAffectedStudentByRoomWeight == 0.0 || placement2.getRoomId().equals(placement.getRoomId()))) {
                d += this.iDifferentRoomWeight;
                if (placement2.getInstructorId() != null) {
                    d += this.iAffectedInstructorByRoomWeight;
                }
                d += this.iAffectedStudentByRoomWeight * (double)lecture.countStudents();
            }
            if (!(this.iDifferentBuildingWeight == 0.0 && this.iAffectedInstructorByBldgWeight == 0.0 && this.iAffectedStudentByBldgWeight == 0.0 || placement2.getBuildingId().equals(placement.getBuildingId()))) {
                d += this.iDifferentBuildingWeight;
                if (placement2.getInstructorId() != null) {
                    d += this.iAffectedInstructorByBldgWeight;
                }
                d += this.iAffectedStudentByBldgWeight * (double)lecture.countStudents();
            }
            if (!(this.iDifferentTimeWeight == 0.0 && this.iAffectedInstructorByTimeWeight == 0.0 && this.iAffectedStudentByTimeWeight == 0.0 || placement2.getTimeLocation().equals(placement.getTimeLocation()))) {
                d += this.iDifferentTimeWeight;
                if (placement2.getInstructorId() != null) {
                    d += this.iAffectedInstructorByTimeWeight;
                }
                d += this.iAffectedStudentByTimeWeight * (double)lecture.countStudents();
            }
            if (this.iDifferentDayWeight != 0.0 && placement2.getTimeLocation().getDayCode() != placement.getTimeLocation().getDayCode()) {
                d += this.iDifferentDayWeight;
            }
            if (this.iDifferentHourWeight != 0.0 && placement2.getTimeLocation().getTimeCode() != placement.getTimeLocation().getTimeCode()) {
                d += this.iDifferentHourWeight;
            }
            if (!(this.iTooFarForInstructorsWeight == 0.0 && this.iTooFarForStudentsWeight == 0.0 || placement2.getTimeLocation().equals(placement.getTimeLocation()))) {
                double d2 = Placement.getDistance(placement2, placement);
                if (placement2.getInstructorId() != null && this.iTooFarForInstructorsWeight != 0.0) {
                    if (d2 > 0.0 && d2 <= 5.0) {
                        d += this.iTooFarForInstructorsWeight;
                    } else if (d2 > 5.0 && d2 <= 20.0) {
                        d += 2.0 * this.iTooFarForInstructorsWeight;
                    } else if (d2 > 20.0) {
                        d += 10.0 * this.iTooFarForInstructorsWeight;
                    }
                }
                if (this.iTooFarForStudentsWeight != 0.0 && d2 > 67.0) {
                    d += this.iTooFarForStudentsWeight * (double)lecture.countStudents();
                }
            }
            if (this.iDeltaStudentConflictsWeight != 0.0) {
                int n = lecture.countStudentConflicts(value);
                int n2 = lecture.countInitialStudentConflicts();
                d += this.iDeltaStudentConflictsWeight * (double)(n - n2);
            }
            if (this.iNewStudentConflictsWeight != 0.0) {
                Vector vector = lecture.conflictStudents(value);
                Set set = lecture.initialStudentConflicts();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    if (set.contains(object.nextElement())) continue;
                    d += this.iNewStudentConflictsWeight;
                }
            }
            if (this.iDeltaTimePreferenceWeight != 0.0) {
                d += this.iDeltaTimePreferenceWeight * (double)(placement.getTimeLocation().getPreference() - placement2.getTimeLocation().getPreference());
            }
            if (this.iDeltaRoomPreferenceWeight != 0.0) {
                d += this.iDeltaRoomPreferenceWeight * (double)(placement.getRoomLocation().getPreference() - placement2.getRoomLocation().getPreference());
            }
            if (this.iDeltaInstructorDistancePreferenceWeight != 0.0 && (instructorConstraint = lecture.getInstructorConstraint()) != null) {
                Enumeration enumeration = instructorConstraint.variables().elements();
                while (enumeration.hasMoreElements()) {
                    object = (Lecture)((Object)enumeration.nextElement());
                    if (((Lecture)((Object)object)).equals((Object)lecture)) continue;
                    int n = object.getInitialAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement2, (Placement)object.getInitialAssignment());
                    int n3 = object.getAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement, (Placement)object.getAssignment());
                    d += this.iDeltaInstructorDistancePreferenceWeight * (double)(n3 - n);
                }
            }
        }
        return d;
    }

    public void getInfo(Dictionary dictionary, Solution solution) {
        super.getInfo(dictionary, solution);
        if (!this.iMPP) {
            return;
        }
        int n = 0;
        long l = 0L;
        int n2 = 0;
        long l2 = 0L;
        int n3 = 0;
        long l3 = 0L;
        int n4 = 0;
        long l4 = 0L;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        Enumeration enumeration = solution.getModel().perturbVariables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getAssignment() == null || variable.getInitialAssignment() == null || variable.getAssignment().equals((Object)variable.getInitialAssignment())) continue;
            ++n;
            Lecture lecture = (Lecture)variable;
            Placement placement = (Placement)variable.getAssignment();
            Placement placement2 = (Placement)variable.getInitialAssignment();
            l += lecture.countStudents();
            if (placement2.getInstructorId() != null) {
                ++n2;
            }
            if (!placement2.getRoomId().equals(placement.getRoomId())) {
                ++n6;
                if (placement2.getInstructorId() != null) {
                    ++n4;
                }
                l3 += lecture.countStudents();
            }
            if (!placement2.getBuildingId().equals(placement.getBuildingId())) {
                ++n7;
                if (placement2.getInstructorId() != null) {
                    ++n5;
                }
                l4 += lecture.countStudents();
            }
            if (!placement2.getTimeLocation().equals(placement.getTimeLocation())) {
                ++n8;
                if (placement2.getInstructorId() != null) {
                    ++n3;
                }
                l2 += lecture.countStudents();
            }
            if (placement2.getTimeLocation().getDayCode() != placement.getTimeLocation().getDayCode()) {
                ++n9;
            }
            if (placement2.getTimeLocation().getTimeCode() != placement.getTimeLocation().getTimeCode()) {
                ++n10;
            }
            if (!placement2.getTimeLocation().equals(placement.getTimeLocation())) {
                double d = Placement.getDistance(placement2, placement);
                if (placement2.getInstructorId() != null) {
                    if (d > 0.0 && d <= 5.0) {
                        ++n11;
                    } else if (d > 5.0 && d <= 20.0) {
                        n11 += 2;
                    } else if (d > 20.0) {
                        n11 += 10;
                    }
                }
                if (d > 67.0) {
                    n12 = (int)((long)n12 + lecture.countStudents());
                }
            }
            n13 += lecture.countStudentConflicts(placement) - lecture.countInitialStudentConflicts();
            Vector vector = lecture.conflictStudents(placement);
            Set set = lecture.initialStudentConflicts();
            Object object = vector.elements();
            while (object.hasMoreElements()) {
                if (set.contains(object.nextElement())) continue;
                ++n14;
            }
            n15 += placement.getTimeLocation().getPreference() - placement2.getTimeLocation().getPreference();
            n16 += placement.getRoomLocation().getPreference() - placement2.getRoomLocation().getPreference();
            object = lecture.getInstructorConstraint();
            if (object == null) continue;
            Enumeration enumeration2 = object.variables().elements();
            while (enumeration2.hasMoreElements()) {
                Lecture lecture2 = (Lecture)((Object)enumeration2.nextElement());
                if (lecture2.equals((Object)lecture)) continue;
                int n18 = lecture2.getInitialAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement2, (Placement)lecture2.getInitialAssignment());
                int n19 = lecture2.getAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement, (Placement)lecture2.getAssignment());
                n17 += n19 - n18;
            }
        }
        dictionary.put("Perturbations: Different placement", String.valueOf(n) + " (weighted " + sDoubleFormat.format(this.iDifferentPlacement * (double)n) + ")");
        dictionary.put("Perturbations: Number of affected students", String.valueOf(l) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentWeight * (double)l) + ")");
        dictionary.put("Perturbations: Number of affected instructors", String.valueOf(n2) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorWeight * (double)n2) + ")");
        dictionary.put("Perturbations: Number of affected students (time change)", String.valueOf(l2) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByTimeWeight * (double)l2) + ")");
        dictionary.put("Perturbations: Number of affected instructors (time change)", String.valueOf(n3) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByTimeWeight * (double)n3) + ")");
        dictionary.put("Perturbations: Number of affected students (room change)", String.valueOf(l3) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByRoomWeight * (double)l3) + ")");
        dictionary.put("Perturbations: Number of affected instructors (room change)", String.valueOf(n4) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByRoomWeight * (double)n4) + ")");
        dictionary.put("Perturbations: Number of affected students (bldg change)", String.valueOf(l4) + " (weighted " + sDoubleFormat.format(this.iAffectedStudentByBldgWeight * (double)l4) + ")");
        dictionary.put("Perturbations: Number of affected instructors (bldg change)", String.valueOf(n5) + " (weighted " + sDoubleFormat.format(this.iAffectedInstructorByBldgWeight * (double)n5) + ")");
        dictionary.put("Perturbations: Different room", String.valueOf(n6) + " (weighted " + sDoubleFormat.format(this.iDifferentRoomWeight * (double)n6) + ")");
        dictionary.put("Perturbations: Different building", String.valueOf(n7) + " (weighted " + sDoubleFormat.format(this.iDifferentBuildingWeight * (double)n7) + ")");
        dictionary.put("Perturbations: Different time", String.valueOf(n8) + " (weighted " + sDoubleFormat.format(this.iDifferentTimeWeight * (double)n8) + ")");
        dictionary.put("Perturbations: Different day", String.valueOf(n9) + " (weighted " + sDoubleFormat.format(this.iDifferentDayWeight * (double)n9) + ")");
        dictionary.put("Perturbations: Different hour", String.valueOf(n10) + " (weighted " + sDoubleFormat.format(this.iDifferentHourWeight * (double)n10) + ")");
        dictionary.put("Perturbations: New placement too far from initial (for instructors)", String.valueOf(n11) + " (weighted " + sDoubleFormat.format(this.iTooFarForInstructorsWeight * (double)n11) + ")");
        dictionary.put("Perturbations: New placement too far from initial (for students)", String.valueOf(n12) + " (weighted " + sDoubleFormat.format(this.iTooFarForStudentsWeight * (double)n12) + ")");
        dictionary.put("Perturbations: Delta student conflicts", String.valueOf(n13) + " (weighted " + sDoubleFormat.format(this.iDeltaStudentConflictsWeight * (double)n13) + ")");
        dictionary.put("Perturbations: New student conflicts", String.valueOf(n14) + " (weighted " + sDoubleFormat.format(this.iNewStudentConflictsWeight * (double)n14) + ")");
        dictionary.put("Perturbations: Delta time preferences", String.valueOf(n15) + " (weighted " + sDoubleFormat.format(this.iDeltaTimePreferenceWeight * (double)n15) + ")");
        dictionary.put("Perturbations: Delta room preferences", String.valueOf(n16) + " (weighted " + sDoubleFormat.format(this.iDeltaRoomPreferenceWeight * (double)n16) + ")");
        dictionary.put("Perturbations: Delta instructor distance preferences", String.valueOf(n17) + " (weighted " + sDoubleFormat.format(this.iDeltaInstructorDistancePreferenceWeight * (double)n17) + ")");
    }

    public Hashtable getCompactInfo(Solution solution, boolean bl, boolean bl2) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        if (!this.iMPP) {
            return hashtable;
        }
        int n = 0;
        long l = 0L;
        int n2 = 0;
        long l2 = 0L;
        int n3 = 0;
        long l3 = 0L;
        int n4 = 0;
        long l4 = 0L;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        Enumeration enumeration = solution.getModel().perturbVariables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getAssignment() == null || variable.getInitialAssignment() == null || variable.getAssignment().equals((Object)variable.getInitialAssignment())) continue;
            ++n;
            Lecture lecture = (Lecture)variable;
            Placement placement = (Placement)variable.getAssignment();
            Placement placement2 = (Placement)variable.getInitialAssignment();
            l += lecture.countStudents();
            if (placement2.getInstructorId() != null) {
                ++n2;
            }
            if (!placement2.getRoomId().equals(placement.getRoomId())) {
                ++n6;
                if (placement2.getInstructorId() != null) {
                    ++n4;
                }
                l3 += lecture.countStudents();
            }
            if (!placement2.getBuildingId().equals(placement.getBuildingId())) {
                ++n7;
                if (placement2.getInstructorId() != null) {
                    ++n5;
                }
                l4 += lecture.countStudents();
            }
            if (!placement2.getTimeLocation().equals(placement.getTimeLocation())) {
                ++n8;
                if (placement2.getInstructorId() != null) {
                    ++n3;
                }
                l2 += lecture.countStudents();
            }
            if (placement2.getTimeLocation().getDayCode() != placement.getTimeLocation().getDayCode()) {
                ++n9;
            }
            if (placement2.getTimeLocation().getTimeCode() != placement.getTimeLocation().getTimeCode()) {
                ++n10;
            }
            if (!placement2.getTimeLocation().equals(placement.getTimeLocation())) {
                double d = Placement.getDistance(placement2, placement);
                if (placement2.getInstructorId() != null) {
                    if (d > 0.0 && d <= 5.0) {
                        ++n11;
                    } else if (d > 5.0 && d <= 20.0) {
                        n11 += 2;
                    } else if (d > 20.0) {
                        n11 += 10;
                    }
                }
                if (d > 67.0) {
                    n12 = (int)((long)n12 + lecture.countStudents());
                }
            }
            n13 += lecture.countStudentConflicts(placement) - lecture.countInitialStudentConflicts();
            Vector vector = lecture.conflictStudents(placement);
            Set set = lecture.initialStudentConflicts();
            Object object = vector.elements();
            while (object.hasMoreElements()) {
                if (set.contains(object.nextElement())) continue;
                ++n14;
            }
            n15 += placement.getTimeLocation().getPreference() - placement2.getTimeLocation().getPreference();
            n16 += placement.getRoomLocation().getPreference() - placement2.getRoomLocation().getPreference();
            object = lecture.getInstructorConstraint();
            if (object == null) continue;
            Enumeration enumeration2 = object.variables().elements();
            while (enumeration2.hasMoreElements()) {
                Lecture lecture2 = (Lecture)((Object)enumeration2.nextElement());
                if (lecture2.equals((Object)lecture)) continue;
                int n18 = lecture2.getInitialAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement2, (Placement)lecture2.getInitialAssignment());
                int n19 = lecture2.getAssignment() == null ? 0 : InstructorConstraint.getDistancePreference(placement, (Placement)lecture2.getAssignment());
                n17 += n19 - n18;
            }
        }
        if (bl || this.iDifferentPlacement != 0.0) {
            hashtable.put("Different placement", new Double(bl2 ? this.iDifferentPlacement * (double)n : (double)n));
        }
        if (bl || this.iAffectedStudentWeight != 0.0) {
            hashtable.put("Affected students", new Double(bl2 ? this.iAffectedStudentWeight * (double)l : (double)l));
        }
        if (bl || this.iAffectedInstructorWeight != 0.0) {
            hashtable.put("Affected instructors", new Double(bl2 ? this.iAffectedInstructorWeight * (double)n2 : (double)n2));
        }
        if (bl || this.iAffectedStudentByTimeWeight != 0.0) {
            hashtable.put("Affected students [time]", new Double(bl2 ? this.iAffectedStudentByTimeWeight * (double)l2 : (double)l2));
        }
        if (bl || this.iAffectedInstructorByTimeWeight != 0.0) {
            hashtable.put("Affected instructors [time]", new Double(bl2 ? this.iAffectedInstructorByTimeWeight * (double)n3 : (double)n3));
        }
        if (bl || this.iAffectedStudentByRoomWeight != 0.0) {
            hashtable.put("Affected students [room]", new Double(bl2 ? this.iAffectedStudentByRoomWeight * (double)l3 : (double)l3));
        }
        if (bl || this.iAffectedInstructorByRoomWeight != 0.0) {
            hashtable.put("Affected instructors [room]", new Double(bl2 ? this.iAffectedInstructorByRoomWeight * (double)n4 : (double)n4));
        }
        if (bl || this.iAffectedStudentByBldgWeight != 0.0) {
            hashtable.put("Affected students [bldg]", new Double(bl2 ? this.iAffectedStudentByBldgWeight * (double)l4 : (double)l4));
        }
        if (bl || this.iAffectedInstructorByBldgWeight != 0.0) {
            hashtable.put("Affected instructors [bldg]", new Double(bl2 ? this.iAffectedInstructorByBldgWeight * (double)n5 : (double)n5));
        }
        if (bl || this.iDifferentRoomWeight != 0.0) {
            hashtable.put("Different room", new Double(bl2 ? this.iDifferentRoomWeight * (double)n6 : (double)n6));
        }
        if (bl || this.iDifferentBuildingWeight != 0.0) {
            hashtable.put("Different building", new Double(bl2 ? this.iDifferentBuildingWeight * (double)n7 : (double)n7));
        }
        if (bl || this.iDifferentTimeWeight != 0.0) {
            hashtable.put("Different time", new Double(bl2 ? this.iDifferentTimeWeight * (double)n8 : (double)n8));
        }
        if (bl || this.iDifferentDayWeight != 0.0) {
            hashtable.put("Different day", new Double(bl2 ? this.iDifferentDayWeight * (double)n9 : (double)n9));
        }
        if (bl || this.iDifferentHourWeight != 0.0) {
            hashtable.put("Different hour", new Double(bl2 ? this.iDifferentHourWeight * (double)n10 : (double)n10));
        }
        if (bl || this.iTooFarForInstructorsWeight != 0.0) {
            hashtable.put("New placement too far for initial [instructors]", new Double(bl2 ? this.iTooFarForInstructorsWeight * (double)n11 : (double)n11));
        }
        if (bl || this.iTooFarForStudentsWeight != 0.0) {
            hashtable.put("New placement too far for initial [students]", new Double(bl2 ? this.iTooFarForStudentsWeight * (double)n12 : (double)n12));
        }
        if (bl || this.iDeltaStudentConflictsWeight != 0.0) {
            hashtable.put("Delta student conflicts", new Double(bl2 ? this.iDeltaStudentConflictsWeight * (double)n13 : (double)n13));
        }
        if (bl || this.iNewStudentConflictsWeight != 0.0) {
            hashtable.put("New student conflicts", new Double(bl2 ? this.iNewStudentConflictsWeight * (double)n14 : (double)n14));
        }
        if (bl || this.iDeltaTimePreferenceWeight != 0.0) {
            hashtable.put("Delta time preferences", new Double(bl2 ? this.iDeltaTimePreferenceWeight * (double)n15 : (double)n15));
        }
        if (bl || this.iDeltaRoomPreferenceWeight != 0.0) {
            hashtable.put("Delta room preferences", new Double(bl2 ? this.iDeltaRoomPreferenceWeight * (double)n16 : (double)n16));
        }
        if (bl || this.iDeltaInstructorDistancePreferenceWeight != 0.0) {
            hashtable.put("Delta instructor distance preferences", new Double(bl2 ? this.iDeltaInstructorDistancePreferenceWeight * (double)n17 : (double)n17));
        }
        return hashtable;
    }
}

