/*
 * Decompiled with CFR 0.152.
 */
package ttsolver.model;

import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.util.Constants;
import ifs.util.FastVector;
import java.util.Collection;
import java.util.Vector;

public class TimeLocation {
    private int iStartSlot;
    private int[] iStartSlots;
    private int[] iSlots;
    private int iPreference;
    private double iNormalizedPreference;
    private TimePatternModel iTimePatternModel = null;
    private String iText = null;
    private int iHashCode;
    private int iDayCode;
    private int iTimeCode;
    private int iLength;

    public TimeLocation(TimePatternModel timePatternModel, int n, int n2) {
        this.iTimePatternModel = timePatternModel;
        this.iText = this.iTimePatternModel.getText(n, n2);
        this.iLength = this.iTimePatternModel.getNrHalfHoursPerMeeting();
        this.iDayCode = this.iTimePatternModel.getDayCode(n);
        this.iNormalizedPreference = this.iTimePatternModel.getNormalizedPreference(n, n2);
        Collection collection = this.iTimePatternModel.getSlots(n, n2);
        this.iSlots = new int[collection.size()];
        int n3 = 0;
        Object object = collection.iterator();
        while (object.hasNext()) {
            this.iSlots[n3++] = (Integer)object.next();
        }
        object = this.iTimePatternModel.getStartSlots(n, n2);
        this.iStartSlots = new int[object.size()];
        n3 = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            this.iStartSlots[n3++] = (Integer)object2.next();
        }
        this.iStartSlot = this.iStartSlots[0] % Constants.SLOTS_PER_DAY;
        object2 = this.iTimePatternModel.getPreference(n, n2).getProlog();
        this.iPreference = ((String)object2).equalsIgnoreCase("R") ? 0 : Integer.parseInt(this.iTimePatternModel.getPreference(n, n2).getProlog());
        this.iHashCode = TimeLocation.combine(TimeLocation.combine(n, n2), TimeLocation.combine(this.iTimePatternModel.getNrMeetings(), this.iTimePatternModel.getNrDays()));
        this.iTimeCode = 0;
        for (int i = 0; i < this.iLength; ++i) {
            this.iTimeCode |= 1 << this.iStartSlot + i;
        }
    }

    public TimeLocation(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.iPreference = n4;
        this.iNormalizedPreference = n4;
        this.iStartSlot = n2;
        this.iDayCode = n;
        this.iLength = n3;
        int n7 = 0;
        for (n6 = 0; n6 < Constants.DAY_CODES.length; ++n6) {
            if ((this.iDayCode & Constants.DAY_CODES[n6]) == 0) continue;
            ++n7;
        }
        this.iSlots = new int[n7 * n3];
        this.iStartSlots = new int[n7];
        n6 = 0;
        int n8 = 0;
        for (n5 = 0; n5 < Constants.DAY_CODES.length; ++n5) {
            if ((this.iDayCode & Constants.DAY_CODES[n5]) == 0) continue;
            int n9 = n5 * Constants.SLOTS_PER_DAY + this.iStartSlot;
            this.iStartSlots[n6++] = n9;
            for (int i = 0; i < n3; ++i) {
                this.iSlots[n8++] = n9 + i;
            }
        }
        this.iHashCode = TimeLocation.combine(TimeLocation.combine(n, this.iStartSlot), TimeLocation.combine(this.iLength, n7));
        this.iTimeCode = 0;
        for (n5 = 0; n5 < this.iLength; ++n5) {
            this.iTimeCode |= 1 << this.iStartSlot + n5;
        }
        this.iText = this.getDayHeader() + " " + this.getStartTimeHeader();
    }

    public int getNrMeetings() {
        return this.iStartSlots.length;
    }

    private static int combine(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 15; ++i) {
            n3 = n3 | (n & 1 << i) << i | (n2 & 1 << i) << i + 1;
        }
        return n3;
    }

    public int getDayCode() {
        return this.iDayCode;
    }

    public String getDayHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            stringBuffer.append(Constants.DAY_NAMES_SHORT[i]);
        }
        return stringBuffer.toString();
    }

    public String getStartTimeHeader() {
        int n = (this.iStartSlot + 15) / 2;
        int n2 = (this.iStartSlot + 15) % 2 == 0 ? 0 : 30;
        return (n > 12 ? n - 12 : n) + ":" + (n2 < 10 ? "0" : "") + n2 + " " + (n >= 12 ? "pm" : "am");
    }

    public String getEndTimeHeader() {
        int n = (this.iStartSlot + 15) / 2;
        int n2 = (this.iStartSlot + 15) % 2 == 0 ? 0 : 30;
        int n3 = n * 60 + n2 + this.iLength * 25;
        n2 = n3 % 60;
        n = n3 / 60;
        return (n > 12 ? n - 12 : n) + ":" + (n2 < 10 ? "0" : "") + n2 + " " + (n >= 12 ? "pm" : "am");
    }

    public int getStartSlot() {
        return this.iStartSlot;
    }

    public int getTimeCode() {
        return this.iTimeCode;
    }

    public boolean shareDays(TimeLocation timeLocation) {
        return (this.iDayCode & timeLocation.iDayCode) != 0;
    }

    public boolean shareHours(TimeLocation timeLocation) {
        return (this.iTimeCode & timeLocation.iTimeCode) != 0;
    }

    public boolean hasIntersection(TimeLocation timeLocation) {
        return this.shareDays(timeLocation) && this.shareHours(timeLocation);
    }

    public Collection getIntersection(TimeLocation timeLocation) {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getSlots().length; ++i) {
            for (int j = 0; j < timeLocation.getSlots().length; ++j) {
                if (this.getSlots()[i] != timeLocation.getSlots()[j]) continue;
                fastVector.addElement(new Integer(this.getSlots()[i]));
            }
        }
        return fastVector;
    }

    public int[] getSlots() {
        return this.iSlots;
    }

    public int[] getStartSlots() {
        return this.iStartSlots;
    }

    public String getText() {
        return this.iText;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int getLength() {
        return this.iLength;
    }

    public int getNrHalfHoursPerMeeting() {
        return this.iLength;
    }

    public double getNormalizedPreference() {
        return this.iNormalizedPreference;
    }

    public TimePatternModel getModel() {
        return this.iTimePatternModel;
    }

    private static Vector toVector(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        FastVector fastVector = new FastVector(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            fastVector.add(new Integer(nArray[i]));
        }
        return fastVector;
    }

    public String toString() {
        return "TimeLocation{text=" + this.getText() + ", pref=" + this.iPreference + ", normPref=" + this.getNormalizedPreference() + (this.iTimePatternModel != null ? ", tansform=" + this.iTimePatternModel.getTransformPreference() + ", treshold=" + this.iTimePatternModel.getTresholdPreference() : "") + ", slots=" + TimeLocation.toVector(this.iSlots) + "}";
    }

    public int hashCode() {
        return this.iHashCode;
    }
}

