/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.monitoring;

public class StatisticsAccumulator {
    protected double max = Double.MIN_VALUE;
    protected double min = Double.MAX_VALUE;
    private double sampleSum;
    private double sampleSquareSum;
    private long sampleCount;
    protected String unit;

    public void sample(double d2) {
        ++this.sampleCount;
        if (d2 < this.min) {
            this.min = d2;
        }
        if (d2 > this.max) {
            this.max = d2;
        }
        this.sampleSum += d2;
        this.sampleSquareSum += d2 * d2;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return "Minimum Value = " + this.min + " " + this.unit + " " + "Maximum Value = " + this.max + " " + this.unit + " " + "Average Value = " + this.computeAverage() + " " + this.unit + " " + "Standard Deviation = " + this.computeStandardDeviation() + " " + this.unit + " " + "Samples Collected = " + this.sampleCount;
    }

    protected double computeAverage() {
        return this.sampleSum / (double)this.sampleCount;
    }

    protected double computeStandardDeviation() {
        double d2 = this.sampleSum * this.sampleSum;
        return Math.sqrt((this.sampleSquareSum - d2 / (double)this.sampleCount) / (double)(this.sampleCount - 1L));
    }

    public StatisticsAccumulator(String string) {
        this.unit = string;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    void clearState() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    public void unitTestValidate(String string, double d2, double d3, long l2, double d4, double d5) {
        if (!string.equals(this.unit)) {
            throw new RuntimeException("Unit is not same as expected Unit\nUnit = " + this.unit + "ExpectedUnit = " + string);
        }
        if (this.min != d2) {
            throw new RuntimeException("Minimum value is not same as expected minimum value\nMin Value = " + this.min + "Expected Min Value = " + d2);
        }
        if (this.max != d3) {
            throw new RuntimeException("Maximum value is not same as expected maximum value\nMax Value = " + this.max + "Expected Max Value = " + d3);
        }
        if (this.sampleCount != l2) {
            throw new RuntimeException("Sample count is not same as expected Sample Count\nSampleCount = " + this.sampleCount + "Expected Sample Count = " + l2);
        }
        if (this.computeAverage() != d4) {
            throw new RuntimeException("Average is not same as expected Average\nAverage = " + this.computeAverage() + "Expected Average = " + d4);
        }
        double d6 = Math.abs(this.computeStandardDeviation() - d5);
        if (d6 > 1.0) {
            throw new RuntimeException("Standard Deviation is not same as expected Std Deviation\nStandard Dev = " + this.computeStandardDeviation() + "Expected Standard Dev = " + d5);
        }
    }
}

