/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.pStream = new PrintStream(outputStream);
    }

    protected void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n2) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println();
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return i2;
            }
            byArray[i2] = (byte)n2;
        }
        return byArray.length;
    }

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n2 = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n2);
            for (int i2 = 0; i2 < n2; i2 += this.bytesPerAtom()) {
                if (i2 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outputStream, byArray, i2, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i2, n2 - i2);
            }
            if (n2 < this.bytesPerLine()) break;
            this.encodeLineSuffix(outputStream);
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encode(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encode(byteArrayInputStream, outputStream);
    }

    public String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = null;
        try {
            this.encode(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString("8859_1");
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return string;
    }

    private byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] byArray;
        byte[] byArray2 = null;
        if (byteBuffer.hasArray() && (byArray = byteBuffer.array()).length == byteBuffer.capacity() && byArray.length == byteBuffer.remaining()) {
            byArray2 = byArray;
            byteBuffer.position(byteBuffer.limit());
        }
        if (byArray2 == null) {
            byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
        }
        return byArray2;
    }

    public void encode(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBytes(byteBuffer);
        this.encode(byArray, outputStream);
    }

    public String encode(ByteBuffer byteBuffer) {
        byte[] byArray = this.getBytes(byteBuffer);
        return this.encode(byArray);
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n2 = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n2);
            for (int i2 = 0; i2 < n2; i2 += this.bytesPerAtom()) {
                if (i2 + this.bytesPerAtom() <= n2) {
                    this.encodeAtom(outputStream, byArray, i2, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i2, n2 - i2);
            }
            this.encodeLineSuffix(outputStream);
            if (n2 >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }

    public void encodeBuffer(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBytes(byteBuffer);
        this.encodeBuffer(byArray, outputStream);
    }

    public String encodeBuffer(ByteBuffer byteBuffer) {
        byte[] byArray = this.getBytes(byteBuffer);
        return this.encodeBuffer(byArray);
    }
}

