/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.bn;
import sun.security.krb5.internal.util.o;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class TicketFlags
extends o {
    public TicketFlags() {
        super(32);
    }

    public TicketFlags(boolean[] blArray) throws Asn1Exception {
        super(blArray);
        if (blArray.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(int n2, byte[] byArray) throws Asn1Exception {
        super(n2, byArray);
        if (n2 > byArray.length * 8 || n2 > 32) {
            throw new Asn1Exception(502);
        }
    }

    public TicketFlags(DerValue derValue) throws IOException, Asn1Exception {
        this(derValue.getUnalignedBitString(true).toBooleanArray());
    }

    public static TicketFlags parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new TicketFlags(derValue2);
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.a()));
        return derOutputStream.toByteArray();
    }

    public Object clone() {
        try {
            return new TicketFlags(this.a());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean match(bn bn2) {
        boolean bl2 = false;
        if (this.a(1) == bn2.a(1) && this.a(3) == bn2.a(3) && this.a(8) == bn2.a(8)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean match(TicketFlags ticketFlags) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < 12; ++i2) {
            if (this.a(i2) == ticketFlags.a(i2)) continue;
            return false;
        }
        return bl2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = this.a();
        block14: for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            switch (i2) {
                case 0: {
                    stringBuffer.append("RESERVED;");
                    continue block14;
                }
                case 1: {
                    stringBuffer.append("FORWARDABLE;");
                    continue block14;
                }
                case 2: {
                    stringBuffer.append("FORWARDED;");
                    continue block14;
                }
                case 3: {
                    stringBuffer.append("PROXIABLE;");
                    continue block14;
                }
                case 4: {
                    stringBuffer.append("PROXY;");
                    continue block14;
                }
                case 5: {
                    stringBuffer.append("MAY-POSTDATE;");
                    continue block14;
                }
                case 6: {
                    stringBuffer.append("POSTDATED;");
                    continue block14;
                }
                case 7: {
                    stringBuffer.append("INVALID;");
                    continue block14;
                }
                case 8: {
                    stringBuffer.append("RENEWABLE;");
                    continue block14;
                }
                case 9: {
                    stringBuffer.append("INITIAL;");
                    continue block14;
                }
                case 10: {
                    stringBuffer.append("PRE-AUTHENT;");
                    continue block14;
                }
                case 11: {
                    stringBuffer.append("HW-AUTHENT;");
                }
            }
        }
        String string = stringBuffer.toString();
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

