/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.data.ResourceGroup;
import timetable.data.TimePreference;
import timetable.util.Config;
import timetable.util.TimetableException;

public class Activity {
    public static int SHORT_CUT_MAX_LENGTH = 7;
    protected Config config = null;
    public String shortCut = null;
    public String name = null;
    public int length = 1;
    public String note = null;
    protected TimePreference preference = null;
    public ActivityResources resources = new ActivityResources();
    public int start = -1;
    public ActivityResources selectedResources = null;
    public ResourceGroup corespondingResources = null;
    public int lastStart = -1;
    public ActivityResources lastSelectedResources = null;
    public int bestStart = -1;
    public ActivityResources bestSelectedResources = null;
    public Activity lastRemovedBy = null;
    public boolean canReschedule = true;
    public int nrRemoves = 0;
    public ActivityGroup paralelActivities = null;
    public int[] paralelActivitiesInitIndexes = null;

    public Activity(Config config, String shortCut, String name, String note, int length) throws TimetableException {
        this.config = config;
        this.name = name;
        this.shortCut = shortCut == null || shortCut.length() <= SHORT_CUT_MAX_LENGTH ? shortCut : shortCut.substring(0, SHORT_CUT_MAX_LENGTH);
        this.note = note;
        this.length = length;
        this.preference = new TimePreference(config);
    }

    public Activity(Config config, String name, int length) throws TimetableException {
        this(config, name, name, null, length);
    }

    public Activity(Config config) throws TimetableException {
        this(config, null, null, null, 1);
    }

    public void reset() {
        this.nrRemoves = 0;
        this.lastRemovedBy = null;
    }

    public boolean isScheduled() {
        return this.start >= 0;
    }

    public TimePreference getPreference() {
        return this.preference;
    }

    public void setPreference(TimePreference preference) {
        this.preference = preference;
    }

    public void remove(Activity removedBy) {
        if (this.start == -1) {
            return;
        }
        int i = 0;
        while (i < this.selectedResources.size()) {
            if (this.selectedResources.isGroup(i)) {
                int k = 0;
                while (k < this.selectedResources.getResources(i).size()) {
                    int j = 0;
                    while (j < this.length) {
                        this.selectedResources.getResources(i).get(k).setActivityAt(j + this.start, null);
                        ++j;
                    }
                    ++k;
                }
            } else {
                int j = 0;
                while (j < this.length) {
                    this.selectedResources.getResource(i).setActivityAt(j + this.start, null);
                    ++j;
                }
            }
            ++i;
        }
        if (this.paralelActivities != null && this.paralelActivities.size() > 0) {
            ActivityGroup pAct = this.paralelActivities;
            ResourceGroup cRes = null;
            if (!this.resources.getResources((int)0).conjunctive) {
                cRes = this.resources.getResources(0);
            } else if (this.corespondingResources != null && this.corespondingResources.size() > 0) {
                cRes = this.corespondingResources;
            }
            if (cRes != null) {
                int i2 = 0;
                while (i2 < cRes.size()) {
                    if (cRes.get(i2).getActivityAt(this.start) == this) {
                        int j = 0;
                        while (j < this.length) {
                            cRes.get(i2).setActivityAt(j + this.start, null);
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
        }
        this.selectedResources.removeAll();
        this.start = -1;
        ++this.nrRemoves;
        this.lastRemovedBy = removedBy;
    }

    public void removeParalels() {
        if (this.paralelActivities != null && this.paralelActivities.size() > 0) {
            ActivityGroup pAct = this.paralelActivities;
            ResourceGroup cRes = null;
            if (!this.resources.getResources((int)0).conjunctive) {
                cRes = this.resources.getResources(0);
            } else if (this.corespondingResources != null && this.corespondingResources.size() > 0) {
                cRes = this.corespondingResources;
            }
            if (cRes != null) {
                int i = 0;
                while (i < cRes.size()) {
                    if (cRes.get(i).getActivityAt(this.start) == this && !this.selectedResources.isInGroup(cRes.get(i))) {
                        int j = 0;
                        while (j < this.length) {
                            cRes.get(i).setActivityAt(j + this.start, null);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void schedule(int slot, ActivityResources selectedResorces) {
        this.start = slot;
        this.selectedResources = selectedResorces;
        if (this.start < 0) {
            return;
        }
        int i = 0;
        while (i < this.selectedResources.size()) {
            if (this.selectedResources.isGroup(i)) {
                int k = 0;
                while (k < this.selectedResources.getResources(i).size()) {
                    int j = 0;
                    while (j < this.length) {
                        this.selectedResources.getResources(i).get(k).setActivityAt(j + this.start, this);
                        ++j;
                    }
                    ++k;
                }
            } else {
                int j = 0;
                while (j < this.length) {
                    this.selectedResources.getResource(i).setActivityAt(j + this.start, this);
                    ++j;
                }
            }
            ++i;
        }
        if (this.paralelActivities != null && this.paralelActivities.size() > 0) {
            ActivityGroup pAct = this.paralelActivities;
            ResourceGroup cRes = null;
            if (!this.resources.getResources((int)0).conjunctive) {
                cRes = this.resources.getResources(0);
            } else if (this.corespondingResources != null && this.corespondingResources.size() > 0) {
                cRes = this.corespondingResources;
            }
            if (cRes != null) {
                int i2 = 0;
                while (i2 < cRes.size()) {
                    if (cRes.get(i2).isFreeAt(this.start, this.length)) {
                        int j = 0;
                        while (j < this.length) {
                            cRes.get(i2).setActivityAt(j + this.start, this);
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    public boolean isConsistent(ActivityDependenceGroup dependences) throws TimetableException {
        if (this.isScheduled()) {
            int slot = this.start;
            if (slot < 0 || slot + this.length > this.config.getInt(Config.NR_SLOTS)) {
                System.err.println("  " + this.shortCut + ": Out of schedule.");
                return false;
            }
            int nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
            if (slot / nrSlotsPerDay != (slot + this.length - 1) / nrSlotsPerDay) {
                System.err.println("  " + this.shortCut + ": Scheduled during the night.");
                return false;
            }
            int j = 0;
            while (j < this.length) {
                if (this.preference.isHARD(j + slot)) {
                    System.err.println("  " + this.shortCut + ": Hard prefference on the activity.");
                    return false;
                }
                ++j;
            }
            if (dependences != null && !dependences.isOK(this, slot)) {
                System.err.println("  " + this.shortCut + ": Dependences are not satisfied.");
                return false;
            }
            int i = 0;
            while (i < this.selectedResources.size()) {
                if (this.selectedResources.isGroup(i)) {
                    int j2 = 0;
                    while (j2 < this.selectedResources.getResources(i).size()) {
                        if (!this.selectedResources.getResources(i).get(j2).isConsistentFor(this)) {
                            System.err.println("  " + this.shortCut + ": Selected resource " + this.selectedResources.getResources((int)i).get((int)j2).shortCut + " is not consistent.");
                            return false;
                        }
                        ++j2;
                    }
                } else {
                    if (!this.selectedResources.getResource(i).isConsistentFor(this)) {
                        System.err.println("  " + this.shortCut + ": Selected resource " + this.selectedResources.getResource((int)i).shortCut + " is not consistent.");
                        return false;
                    }
                    if (this.resources.isGroup(i)) {
                        if (this.resources.getResources(i).indexOf(this.selectedResources.getResource(i)) < 0) {
                            System.err.println("  " + this.shortCut + ": Selected resource " + this.selectedResources.getResource((int)i).shortCut + " is not in resources.");
                            return false;
                        }
                    } else if (!this.resources.getResource(i).equals(this.selectedResources.getResource(i))) {
                        System.err.println("  " + this.shortCut + ": Selected resource " + this.selectedResources.getResource((int)i).shortCut + " is not equal to required resource.");
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean canScheduleAt(int slot, ActivityDependenceGroup dependences) throws TimetableException {
        if (slot < 0 || slot + this.length > this.config.getInt(Config.NR_SLOTS)) {
            return false;
        }
        int nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
        if (slot / nrSlotsPerDay != (slot + this.length - 1) / nrSlotsPerDay) {
            return false;
        }
        int j = 0;
        while (j < this.length) {
            if (this.preference.isHARD(j + slot)) {
                return false;
            }
            ++j;
        }
        if (dependences != null && !dependences.isFixedOK(this, slot)) {
            return false;
        }
        return this.resources.canAllBeFreeAt(slot, this.length);
    }

    public boolean canScheduleWithoutCollisionAt(int slot, ActivityDependenceGroup dependences) throws TimetableException {
        if (slot < 0 || slot + this.length > this.config.getInt(Config.NR_SLOTS)) {
            return false;
        }
        int nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
        if (slot / nrSlotsPerDay != (slot + this.length - 1) / nrSlotsPerDay) {
            return false;
        }
        int j = 0;
        while (j < this.length) {
            if (this.preference.isHARD(j + slot)) {
                return false;
            }
            ++j;
        }
        if (dependences != null && !dependences.isOK(this, slot)) {
            return false;
        }
        return this.resources.isAllFreeAt(slot, this.length);
    }

    public int countScheduleWithoutCollisionAt(int slot, ActivityDependenceGroup dependences) throws TimetableException {
        if (slot < 0 || slot + this.length > this.config.getInt(Config.NR_SLOTS)) {
            return 0;
        }
        int nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
        if (slot / nrSlotsPerDay != (slot + this.length - 1) / nrSlotsPerDay) {
            return 0;
        }
        int j = 0;
        while (j < this.length) {
            if (this.preference.isHARD(j + slot)) {
                return 0;
            }
            ++j;
        }
        if (dependences != null && !dependences.isOK(this, slot)) {
            return 0;
        }
        return this.resources.countAllFreeAt(slot, this.length);
    }

    public int countScheduleWithoutCollision(ActivityDependenceGroup dependences) throws TimetableException {
        int sum = 0;
        int i = 0;
        while (i < this.config.getInt(Config.NR_SLOTS)) {
            sum += this.countScheduleWithoutCollisionAt(i, dependences);
            ++i;
        }
        return sum;
    }

    public int countSchedule(ActivityDependenceGroup dependences) throws TimetableException {
        int sum = 0;
        int i = 0;
        while (i < this.config.getInt(Config.NR_SLOTS)) {
            if (this.canScheduleAt(i, dependences)) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    public void write(ObjectOutputStream out, ResourceGroup allResources, ActivityGroup allActivities) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.start);
        out.writeObject(this.name);
        out.writeObject(this.shortCut);
        out.writeObject(this.note);
        out.writeObject(this.preference);
        this.resources.write(out, allResources);
        if (this.selectedResources == null || this.start < 0) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.selectedResources.write(out, allResources);
        }
        out.writeBoolean(this.canReschedule);
        out.writeBoolean(this.paralelActivities != null);
        if (this.paralelActivities != null) {
            out.writeInt(this.paralelActivities.size());
            int i = 0;
            while (i < this.paralelActivities.size()) {
                out.writeInt(allActivities.indexOf(this.paralelActivities.get(i)));
                ++i;
            }
        }
        out.writeBoolean(this.corespondingResources != null);
        if (this.corespondingResources != null) {
            this.corespondingResources.write(out, allResources);
        }
    }

    public static Activity read(ObjectInputStream in, Config config, ResourceGroup allResources) throws IOException, ClassNotFoundException, TimetableException {
        Activity a = new Activity(config);
        a.length = in.readInt();
        a.start = in.readInt();
        a.name = (String)in.readObject();
        a.shortCut = (String)in.readObject();
        a.note = (String)in.readObject();
        a.preference = (TimePreference)in.readObject();
        a.preference.config = config;
        a.resources = ActivityResources.read(in, allResources);
        a.selectedResources = in.readBoolean() ? ActivityResources.read(in, allResources) : null;
        a.lastStart = -1;
        a.lastSelectedResources = null;
        a.lastRemovedBy = null;
        a.canReschedule = in.readBoolean();
        a.nrRemoves = 0;
        if (in.readBoolean()) {
            a.paralelActivitiesInitIndexes = new int[in.readInt()];
            int i = 0;
            while (i < a.paralelActivitiesInitIndexes.length) {
                a.paralelActivitiesInitIndexes[i] = in.readInt();
                ++i;
            }
        }
        a.corespondingResources = in.readBoolean() ? ResourceGroup.read(in, allResources) : null;
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            Activity b = new Activity(this.config, this.shortCut, this.name, this.note, this.length);
            b.preference = (TimePreference)this.preference.clone();
            b.resources = (ActivityResources)this.resources.clone();
            b.corespondingResources = this.corespondingResources == null ? null : (ResourceGroup)this.corespondingResources.clone();
            b.start = this.start;
            b.lastRemovedBy = this.lastRemovedBy;
            b.selectedResources = this.selectedResources;
            b.paralelActivities = this.paralelActivities == null ? null : (ActivityGroup)this.paralelActivities.clone();
            b.canReschedule = this.canReschedule;
            return e;
        }
        catch (Exception e) {
            return null;
        }
    }
}

