/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import timetable.data.Activity;
import timetable.data.ActivityDependenceInterface;
import timetable.data.ActivityGroup;
import timetable.data.TimeActivityDependence;
import timetable.util.Config;

public class ActivityDependenceGroup {
    protected Vector dependences = new Vector();

    public ActivityDependenceGroup() {
    }

    public ActivityDependenceGroup(ActivityDependenceInterface dep) {
        this.dependences.add(dep);
    }

    public ActivityDependenceGroup(ActivityDependenceInterface[] dep) {
        int i = 0;
        while (i < dep.length) {
            this.dependences.add(dep[i]);
            ++i;
        }
    }

    public void add(ActivityDependenceInterface dep) {
        this.dependences.add(dep);
    }

    public void remove(ActivityDependenceInterface dep) {
        this.dependences.remove(dep);
    }

    public void removeAll() {
        this.dependences.clear();
    }

    public int size() {
        return this.dependences.size();
    }

    public ActivityDependenceInterface get(int i) {
        try {
            return (ActivityDependenceInterface)this.dependences.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int countDependences(Activity a) {
        int sum = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.get(i).participate(a)) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    public boolean isOK() {
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).isOK()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOK(Activity a, int start) {
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).isOK(a, start)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isFixedOK(Activity a, int start) {
        int i = 0;
        while (i < this.size()) {
            Activity b = this.get(i).getAnotherActivity(a);
            if (b != null && !b.canReschedule && !this.get(i).isOK(a, start)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ActivityGroup getConflictActivities(Activity a, int start) {
        ActivityGroup g = new ActivityGroup();
        int i = 0;
        while (i < this.size()) {
            if (!this.get(i).isOK(a, start)) {
                g.addIfIsNot(this.get(i).getAnotherActivity(a));
            }
            ++i;
        }
        return g;
    }

    public void write(ObjectOutputStream out, ActivityGroup allActivities) throws IOException {
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size()) {
            out.writeObject(this.get(i).getClass().getName());
            this.get(i).write(out, allActivities);
            ++i;
        }
    }

    public static ActivityDependenceGroup read(ObjectInputStream in, ActivityGroup allActivities, Config config) throws IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int size = in.readInt();
        ActivityDependenceGroup g = new ActivityDependenceGroup();
        int i = 0;
        while (i < size) {
            String className = (String)in.readObject();
            g.add(new TimeActivityDependence(config).read(in, allActivities, config));
            ++i;
        }
        return g;
    }
}

