/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import timetable.data.Activity;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.util.Config;
import timetable.util.TimetableException;

public class ActivityGroup
implements Serializable {
    protected Vector activities = new Vector();
    public boolean changed = false;

    public ActivityGroup() {
    }

    public ActivityGroup(Activity activity) {
        this.activities.add(activity);
    }

    public ActivityGroup(Activity[] activity) {
        int i = 0;
        while (i < activity.length) {
            this.activities.add(activity[i]);
            ++i;
        }
    }

    public void add(Activity activity) {
        this.activities.add(activity);
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void addIfIsNot(Activity activity) {
        if (this.indexOf(activity) < 0) {
            this.add(activity);
        }
    }

    public void addIfIsNot(ActivityGroup activities) {
        int i = 0;
        while (i < activities.size()) {
            this.addIfIsNot(activities.get(i));
            ++i;
        }
    }

    public void remove(Activity activity) {
        this.activities.remove(activity);
        this.changed = true;
    }

    public void removeAll() {
        this.activities.clear();
    }

    public int size() {
        return this.activities.size();
    }

    public Activity get(int i) {
        try {
            return (Activity)this.activities.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int indexOf(Activity activity) {
        return this.activities.indexOf(activity);
    }

    public Object clone() {
        ActivityGroup g = new ActivityGroup();
        int i = 0;
        while (i < this.size()) {
            g.add(this.get(i));
            ++i;
        }
        return g;
    }

    public int containsResource(Resource resource) {
        int i = 0;
        while (i < this.size()) {
            if (this.get((int)i).resources.contains(resource) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int containsResources(ResourceGroup resources) {
        int i = 0;
        while (i < this.size()) {
            if (this.get((int)i).resources.indexOf(resources) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.get((int)i).shortCut);
            ++i;
        }
        s.append("}");
        return s.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.activities);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.activities = (Vector)in.readObject();
    }

    public void write(ObjectOutputStream out, ResourceGroup allResources) throws IOException {
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size()) {
            this.get(i).write(out, allResources, this);
            ++i;
        }
        this.changed = false;
    }

    public static ActivityGroup read(ObjectInputStream in, Config config, ResourceGroup allResources) throws IOException, ClassNotFoundException, TimetableException {
        ActivityGroup g = new ActivityGroup();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            g.add(Activity.read(in, config, allResources));
            ++i;
        }
        int i2 = 0;
        while (i2 < g.size()) {
            if (g.get((int)i2).paralelActivitiesInitIndexes != null) {
                g.get((int)i2).paralelActivities = new ActivityGroup();
                int j = 0;
                while (j < g.get((int)i2).paralelActivitiesInitIndexes.length) {
                    if (g.get((int)i2).paralelActivitiesInitIndexes[j] >= 0) {
                        g.get((int)i2).paralelActivities.add(g.get(g.get((int)i2).paralelActivitiesInitIndexes[j]));
                    } else {
                        System.err.println("Error: index of paralel activity < 0");
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return g;
    }

    public Enumeration elements() {
        return this.activities.elements();
    }
}

