/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import timetable.data.Resource;
import timetable.data.ResourceGroup;

public class ActivityResources
implements Serializable {
    private Vector resources = new Vector();

    public void add(Resource resource) {
        this.resources.add(resource);
    }

    public void add(ResourceGroup resources) {
        this.resources.add(resources);
    }

    public boolean isInGroup(Resource resource) {
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i)) {
                ResourceGroup g = this.getResources(i);
                int j = 0;
                while (j < g.size()) {
                    if (g.get(j) == resource) {
                        return true;
                    }
                    ++j;
                }
            } else if (this.getResource(i) == resource) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAt(int pos, Object o) {
        this.resources.setElementAt(o, pos);
    }

    public void remove(int i) {
        this.resources.remove(i);
    }

    public void remove(Object o) {
        this.resources.remove(o);
    }

    public void removeAll() {
        this.resources.removeAllElements();
    }

    public int size() {
        return this.resources.size();
    }

    public boolean isGroup(int i) {
        return this.resources.get(i) instanceof ResourceGroup;
    }

    public int indexOf(Object o) {
        return this.resources.indexOf(o);
    }

    public int contains(Resource resource) {
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i) ? this.getResources(i).indexOf(resource) >= 0 : this.getResource(i) == resource) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Resource getResource(int i) {
        try {
            return (Resource)this.resources.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceGroup getResources(int i) {
        try {
            return (ResourceGroup)this.resources.get(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canAllBeFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i) ? (this.getResources((int)i).conjunctive ? !this.getResources(i).canAllBeFreeAt(slot, length) : !this.getResources(i).canOneBeFreeAt(slot, length)) : !this.getResource(i).canBeFreeAt(slot, length)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAllFreeAt(int slot, int length) {
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i) ? (this.getResources((int)i).conjunctive ? !this.getResources(i).isAllFreeAt(slot, length) : !this.getResources(i).isOneFreeAt(slot, length)) : !this.getResource(i).isFreeAt(slot, length)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int countAllFreeAt(int slot, int length) {
        int sum = 1;
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i) ? (this.getResources((int)i).conjunctive ? !this.getResources(i).isAllFreeAt(slot, length) : (sum *= this.getResources(i).countFreeAt(slot, length)) == 0) : !this.getResource(i).isFreeAt(slot, length)) {
                return 0;
            }
            ++i;
        }
        return sum;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.resources);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.resources = (Vector)in.readObject();
    }

    public void write(ObjectOutputStream out, ResourceGroup allResources) throws IOException {
        out.writeInt(this.size());
        int i = 0;
        while (i < this.size()) {
            out.writeBoolean(this.isGroup(i));
            if (this.isGroup(i)) {
                this.getResources(i).write(out, allResources);
            } else {
                this.getResource(i).write(out, allResources);
            }
            ++i;
        }
    }

    public static ActivityResources read(ObjectInputStream in, ResourceGroup allResources) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ActivityResources ar = new ActivityResources();
        int i = 0;
        while (i < size) {
            if (in.readBoolean()) {
                ar.add(ResourceGroup.read(in, allResources));
            } else {
                ar.add(Resource.read(in, allResources));
            }
            ++i;
        }
        return ar;
    }

    public Object clone() {
        ActivityResources g = new ActivityResources();
        int i = 0;
        while (i < this.size()) {
            if (this.isGroup(i)) {
                g.add(this.getResources(i));
            } else {
                g.add(this.getResource(i));
            }
            ++i;
        }
        return g;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.isGroup(i)) {
                sb.append(this.getResources(i).toString());
            } else {
                sb.append(this.getResource(i).toString());
            }
            ++i;
        }
        return sb.toString();
    }
}

