/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import timetable.data.Activity;
import timetable.data.ActivityGroup;
import timetable.data.ResourceGroup;
import timetable.data.TimePreference;
import timetable.util.Config;
import timetable.util.TimetableException;

public class Resource {
    protected Config config = null;
    public static int SHORT_CUT_MAX_LENGTH = 7;
    public String shortCut = null;
    public String name = null;
    public String note = null;
    protected TimePreference preference = null;
    protected Activity[] table = null;
    protected int[] tableIndexes = null;

    public Resource(Config config) throws TimetableException {
        this.config = config;
        this.preference = new TimePreference(config);
        this.table = new Activity[config.getInt(Config.NR_SLOTS)];
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = null;
            ++i;
        }
    }

    public Resource(Config config, String shortCut, String name, String note) throws TimetableException {
        this(config);
        this.name = name;
        this.shortCut = shortCut == null || shortCut.length() <= SHORT_CUT_MAX_LENGTH ? shortCut : shortCut.substring(0, SHORT_CUT_MAX_LENGTH);
        this.note = note;
    }

    public Resource(Config config, String name) throws TimetableException {
        this(config, name, name, null);
    }

    public TimePreference getPreference() {
        return this.preference;
    }

    public void setPreference(TimePreference preference) {
        this.preference = preference;
    }

    public Activity getActivityAt(int slot) {
        return this.table[slot];
    }

    public void setActivityAt(int slot, Activity activity) {
        this.table[slot] = activity;
    }

    public boolean isFreeAt(int slot) {
        return !this.preference.isHARD(slot) && this.getActivityAt(slot) == null;
    }

    public boolean isFreeAt(int slot, ActivityGroup doNotConsider) {
        return !this.preference.isHARD(slot) && (this.getActivityAt(slot) == null || doNotConsider.indexOf(this.getActivityAt(slot)) >= 0);
    }

    public boolean canBeFreeAt(int slot) {
        return !this.preference.isHARD(slot) && (this.getActivityAt(slot) == null || this.getActivityAt((int)slot).canReschedule);
    }

    public boolean canBeFreeAt(int slot, int length) {
        int j = 0;
        while (j < length) {
            if (!this.canBeFreeAt(slot + j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isFreeAt(int slot, int length) {
        int j = 0;
        while (j < length) {
            if (!this.isFreeAt(slot + j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isFreeAt(int slot, int length, ActivityGroup doNotConsider) {
        int j = 0;
        while (j < length) {
            if (!this.isFreeAt(slot + j, doNotConsider)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isConsistentFor(Activity activity) {
        int i = activity.start;
        while (i < activity.start + activity.length) {
            if (this.preference.isHARD(i) || this.table[i] != activity) {
                System.err.println("  Activity=" + activity.shortCut + ", resource=" + this.shortCut + ", slot=" + i + ", table[slot]=" + (this.table[i] != null ? this.table[i].shortCut : "null") + ", hard=" + this.preference.isHARD(i));
                return false;
            }
            ++i;
        }
        return true;
    }

    public int countHoursInDay(int slot, ActivityGroup conflictActivities) {
        int res = 0;
        try {
            int slots = this.config.getInt(Config.NR_SLOTS);
            int days = this.config.getInt(Config.NR_DAYS);
            int slotsPerDay = slots / days;
            int day = slot / slotsPerDay;
            int s = day * slotsPerDay;
            while (s < (day + 1) * slotsPerDay) {
                Activity r = this.table[s];
                if (r != null && conflictActivities.indexOf(r) < 0) {
                    ++res;
                }
                ++s;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    public ActivityGroup getActivitiesAt(int slot, int length) {
        ActivityGroup ag = new ActivityGroup();
        int j = 0;
        while (j < length) {
            if (this.getActivityAt(slot + j) != null) {
                ag.addIfIsNot(this.getActivityAt(slot + j));
            }
            ++j;
        }
        return ag;
    }

    protected void write(ObjectOutputStream out, ActivityGroup allActivities) throws IOException {
        out.writeObject(this.shortCut);
        out.writeObject(this.name);
        out.writeObject(this.note);
        out.writeObject(this.preference);
        out.writeInt(this.table.length);
        int i = 0;
        while (i < this.table.length) {
            if (this.getActivityAt(i) != null) {
                out.writeInt(allActivities.indexOf(this.getActivityAt(i)));
            } else {
                out.writeInt(-1);
            }
            ++i;
        }
    }

    protected static Resource read(ObjectInputStream in, Config config) throws IOException, ClassNotFoundException, TimetableException {
        Resource z = new Resource(config);
        z.shortCut = (String)in.readObject();
        z.name = (String)in.readObject();
        z.note = (String)in.readObject();
        z.preference = (TimePreference)in.readObject();
        z.preference.config = config;
        z.table = null;
        z.tableIndexes = new int[in.readInt()];
        int i = 0;
        while (i < z.tableIndexes.length) {
            z.tableIndexes[i] = in.readInt();
            ++i;
        }
        return z;
    }

    protected void write(ObjectOutputStream out, ResourceGroup allResources) throws IOException {
        out.writeInt(allResources.indexOf(this));
    }

    protected static Resource read(ObjectInputStream in, ResourceGroup allResources) throws IOException {
        return allResources.get(in.readInt());
    }

    protected void init(ActivityGroup allActivities) {
        if (this.tableIndexes == null) {
            return;
        }
        this.table = new Activity[this.tableIndexes.length];
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = this.tableIndexes[i] == -1 ? null : allActivities.get(this.tableIndexes[i]);
            ++i;
        }
        this.tableIndexes = null;
    }

    public String toString() {
        return this.shortCut;
    }
}

