/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import timetable.gui.DNDEvent;
import timetable.gui.DNDListener;
import timetable.gui.DNDTableEngine;

public class DefaultDNDTableEngine
implements DNDTableEngine {
    protected Object dValue;
    protected int dRow;
    protected int dColumn;
    protected JTable dSource;
    protected EventListenerList listenerList = new EventListenerList();

    public boolean canDrag(int row, int column, JTable source) {
        return source.getValueAt(row, column) != null;
    }

    public void drag(int row, int column, JTable source) {
        this.dRow = row;
        this.dColumn = column;
        this.dValue = source.getValueAt(row, column);
        this.dSource = source;
        this.fireDNDListenerDrag(source, row, column);
    }

    public boolean canDrop(int row, int column, JTable target) {
        return this.dValue != null;
    }

    public void drop(int row, int column, JTable target) {
        target.setValueAt(this.dValue, row, column);
        this.dSource.setValueAt(null, this.dRow, this.dColumn);
        this.dValue = null;
        this.fireDNDListenerDrop(target, row, column);
    }

    public void done() {
        this.dValue = null;
    }

    public void addDNDListener(DNDListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("timetable.gui.DNDListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.add(clazz, l);
    }

    public void removeDNDListener(DNDListener l) {
        Class<?> clazz;
        try {
            clazz = Class.forName("timetable.gui.DNDListener");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireDNDListenerDrop(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Class<?> clazz;
            try {
                clazz = Class.forName("timetable.gui.DNDListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (listeners[i] == clazz) {
                if (dndEvent == null) {
                    dndEvent = new DNDEvent(source, row, column);
                }
                ((DNDListener)listeners[i]).drop(dndEvent);
            }
            i -= 2;
        }
    }

    protected void fireDNDListenerDrag(Object source, int row, int column) {
        DNDEvent dndEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Class<?> clazz;
            try {
                clazz = Class.forName("timetable.gui.DNDListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (listeners[i] == clazz) {
                if (dndEvent == null) {
                    dndEvent = new DNDEvent(source, row, column);
                }
                ((DNDListener)listeners[i]).drag(dndEvent);
            }
            i -= 2;
        }
    }
}

