/*
 * Decompiled with CFR 0.152.
 */
package timetable.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.TimetableException;

public class GlobalTimePreferencePanel
extends JPanel
implements ActionListener {
    public static Color[] BG_PREF = new Color[]{new Color(200, 30, 20), new Color(240, 100, 40), new Color(240, 170, 40), new Color(240, 240, 40), new Color(150, 240, 40), new Color(50, 200, 40), new Color(10, 160, 40)};
    public static LineBorder BORDER_DEFAULT = new LineBorder(Color.darkGray, 1);
    public static Color COLOR_HEAD = new Color(120, 120, 255);
    public int[] preference;
    static int PREF_MIN = -3;
    static int PREF_MID = 0;
    static int PREF_MAX = 3;
    static int PREF_MOVE = 3;
    private JPopupMenu menu;
    private JMenuItem mRed;
    private JMenuItem mRem;
    private JMenuItem mYellow;
    private JMenuItem mAdd;
    private JMenuItem mGreen;

    public GlobalTimePreferencePanel(Config config, int[] preference) throws TimetableException {
        int NrRows = config.getInt(Config.NR_DAYS);
        if (NrRows == 0) {
            NrRows = 5;
        }
        int slots = config.getInt(Config.NR_SLOTS);
        int NrColumns = slots / NrRows;
        this.menu = new JPopupMenu();
        this.mRed = new JMenuItem(Loc.get("timetable.gui.preferrence.min"));
        this.mRem = new JMenuItem(Loc.get("timetable.gui.preferrence.dec"));
        this.mYellow = new JMenuItem(Loc.get("timetable.gui.preferrence.middle"));
        this.mAdd = new JMenuItem(Loc.get("timetable.gui.preferrence.inc"));
        this.mGreen = new JMenuItem(Loc.get("timetable.gui.preferrence.max"));
        this.menu.add(this.mRed);
        this.menu.add(this.mRem);
        this.menu.add(this.mYellow);
        this.menu.add(this.mAdd);
        this.menu.add(this.mGreen);
        this.mRed.addActionListener(this);
        this.mRem.addActionListener(this);
        this.mYellow.addActionListener(this);
        this.mAdd.addActionListener(this);
        this.mGreen.addActionListener(this);
        this.setLayout(new GridLayout(NrRows + 1, NrColumns + 1, 0, 0));
        this.add(new OnePrefPanel(""));
        int i = 0;
        while (i < NrColumns) {
            this.add(new OnePrefPanel("" + (i + 1)));
            ++i;
        }
        i = 0;
        while (i < slots) {
            if (i % NrColumns == 0) {
                this.add(new OnePrefPanel(config.dayOfWeek(i)));
            }
            this.add(new OnePrefPanel(preference, i));
            ++i;
        }
        this.setPreferredSize(new Dimension((1 + NrColumns) * 20, (1 + NrRows) * 20));
    }

    private void initComponents() {
        this.setLayout(new GridLayout(5, 10));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRed) {
            ((OnePrefPanel)this.menu.getInvoker()).setMin();
        }
        if (e.getSource() == this.mRem) {
            ((OnePrefPanel)this.menu.getInvoker()).setRem();
        }
        if (e.getSource() == this.mYellow) {
            ((OnePrefPanel)this.menu.getInvoker()).setMiddle();
        }
        if (e.getSource() == this.mAdd) {
            ((OnePrefPanel)this.menu.getInvoker()).setAdd();
        }
        if (e.getSource() == this.mGreen) {
            ((OnePrefPanel)this.menu.getInvoker()).setMax();
        }
    }

    static /* synthetic */ void access$1(GlobalTimePreferencePanel accsParam$0, JPopupMenu accParam$1) {
        accsParam$0.menu = accParam$1;
    }

    public class OnePrefPanel
    extends JPanel {
        private int[] preference;
        private int slot;
        private boolean selected = false;

        public OnePrefPanel(String text) {
            this.preference = null;
            this.setPreferredSize(new Dimension(20, 20));
            this.setBorder(BORDER_DEFAULT);
            this.setBackground(COLOR_HEAD);
            this.add(new JLabel(text));
        }

        public OnePrefPanel(int[] _preference, int slot) {
            this.preference = _preference;
            this.slot = slot;
            this.setBackground(BG_PREF[this.preference[slot] + PREF_MOVE]);
            this.setPreferredSize(new Dimension(20, 20));
            this.setBorder(BORDER_DEFAULT);
            this.addMouseListener(new 1());
        }

        public int getPref() {
            return this.preference[this.slot];
        }

        public void setMiddle() {
            this.preference[this.slot] = PREF_MID;
            this.setBackground(BG_PREF[this.preference[this.slot] + PREF_MOVE]);
        }

        public void setMax() {
            this.preference[this.slot] = PREF_MAX;
            this.setBackground(BG_PREF[this.preference[this.slot] + PREF_MOVE]);
        }

        public void setMin() {
            this.preference[this.slot] = PREF_MIN;
            this.setBackground(BG_PREF[this.preference[this.slot] + PREF_MOVE]);
        }

        public void setAdd() {
            this.preference[this.slot] = this.preference[this.slot] >= PREF_MAX ? PREF_MAX : this.preference[this.slot] + 1;
            this.setBackground(BG_PREF[this.preference[this.slot] + PREF_MOVE]);
        }

        public void setRem() {
            this.preference[this.slot] = this.preference[this.slot] <= PREF_MIN ? PREF_MIN : this.preference[this.slot] - 1;
            this.setBackground(BG_PREF[this.preference[this.slot] + PREF_MOVE]);
        }

        private final class 1
        extends MouseAdapter {
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) > 0) {
                    GlobalTimePreferencePanel.this.menu.show(OnePrefPanel.this, e.getX(), e.getY());
                }
                if ((e.getModifiers() & 0x10) > 0) {
                    if (e.isControlDown()) {
                        OnePrefPanel.this.setAdd();
                    } else if (e.isAltDown()) {
                        OnePrefPanel.this.setRem();
                    } else if (OnePrefPanel.this.getPref() == PREF_MID) {
                        OnePrefPanel.this.setMax();
                    } else if (OnePrefPanel.this.getPref() == PREF_MAX) {
                        OnePrefPanel.this.setMin();
                    } else {
                        OnePrefPanel.this.setMiddle();
                    }
                }
            }

            /* synthetic */ 1() {
            }
        }
    }
}

