/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver;

import timetable.data.Activity;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.data.Problem;
import timetable.data.Resource;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.value.ValueSelectionInterface;
import timetable.solver.strategy.variable.VariableSelectionInterface;
import timetable.util.Config;
import timetable.util.TimetableException;

public class Solver {
    Config config;
    Problem problem;
    Tabu tabu = null;
    VariableSelectionInterface variableSelection = null;
    ValueSelectionInterface valueSelection = null;
    public int nrIters = 0;
    public long solveTime = 0L;
    public long generateTime = 0L;
    public long selectValueTime = 0L;
    public long selectVariableTime = 0L;
    public long maxScheduledActivities = 0L;
    private long generateCount = 0L;

    public Solver(Config config, Problem problem) throws TimetableException {
        this.problem = problem;
        this.config = config;
        this.nrIters = 0;
        this.selectVariableTime = 0L;
        this.selectValueTime = 0L;
        this.generateTime = 0L;
        this.solveTime = 0L;
        this.maxScheduledActivities = 0L;
        this.tabu = new Tabu(config);
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void reset() throws TimetableException {
        this.nrIters = 0;
        this.selectVariableTime = 0L;
        this.selectValueTime = 0L;
        this.generateTime = 0L;
        this.solveTime = 0L;
        this.maxScheduledActivities = 0L;
        this.problem.reset();
        this.tabu = new Tabu(this.config);
    }

    public void setVariableSelection(VariableSelectionInterface variableSelection) {
        this.variableSelection = variableSelection;
    }

    public void setValueSelection(ValueSelectionInterface valueSelection) {
        this.valueSelection = valueSelection;
    }

    public void solve() throws TimetableException {
        this.selectVariableTime = 0L;
        this.selectValueTime = 0L;
        this.generateTime = 0L;
        this.solveTime = 0L;
        this.maxScheduledActivities = 0L;
        this.nrIters = 0;
        this.problem.saveBestState();
        int canNotSchedule = 0;
        long solveStart = System.currentTimeMillis();
        ActivityGroup unscheduled = this.problem.unscheduledActivities();
        while (unscheduled.size() > 0 && this.nrIters < this.config.getInt(Config.NR_TRIES)) {
            this.config.log("Try: " + this.nrIters + ", Unscheduled: " + unscheduled.size());
            System.err.print("Try: " + this.nrIters + ", Unscheduled: " + unscheduled.size());
            if (this.maxScheduledActivities < (long)(this.problem.activities.size() - unscheduled.size())) {
                this.maxScheduledActivities = this.problem.activities.size() - unscheduled.size();
                this.problem.saveBestState();
            }
            long selectVariableStart = System.currentTimeMillis();
            Activity activity = this.variableSelection.select(unscheduled, this.problem.dependences);
            this.selectVariableTime += System.currentTimeMillis() - selectVariableStart;
            System.err.println(", Selected activity: " + activity.shortCut);
            long generateStart = System.currentTimeMillis();
            int slot = this.schedule(activity);
            this.generateTime += System.currentTimeMillis() - generateStart;
            if (slot < 0) {
                ++canNotSchedule;
            } else {
                this.config.log("Activity: " + activity.name + " -> " + slot + " (resources: " + activity.selectedResources.toString() + " )");
                if (this.config.existKey("DEBUG_LOG") && this.problem.resources != null) {
                    try {
                        this.problem.print(this.config.getLogWriter(), this.problem.resources[0], 0, this.problem.resources.length);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            unscheduled = this.problem.unscheduledActivities();
            ++this.nrIters;
            System.err.println();
        }
        if (this.maxScheduledActivities < (long)(this.problem.activities.size() - unscheduled.size())) {
            this.maxScheduledActivities = this.problem.activities.size() - unscheduled.size();
        }
        this.solveTime = System.currentTimeMillis() - solveStart;
        this.generateTime -= this.selectValueTime;
    }

    public int schedule(Activity activity) throws TimetableException {
        this.valueSelection.reset(activity);
        this.config.log("SCHEDULE: " + activity.name);
        int slot = 0;
        while (slot < this.config.getInt(Config.NR_SLOTS)) {
            if (activity.canScheduleAt(slot, null)) {
                ActivityGroup conflictActivities = this.problem.dependences.getConflictActivities(activity, slot);
                boolean can = true;
                int i = 0;
                while (i < conflictActivities.size()) {
                    if (!conflictActivities.get((int)i).canReschedule) {
                        can = false;
                    }
                    ++i;
                }
                this.config.log("  -> " + slot + " (conflict: " + conflictActivities.toString() + ")");
                this.generateCount = 0L;
                if (can) {
                    this.generate(activity, this.valueSelection, slot, new ActivityResources(), conflictActivities);
                }
            }
            ++slot;
        }
        long selectValueStart = System.currentTimeMillis();
        this.valueSelection.select();
        int selectedSlot = this.valueSelection.selectedSlot();
        this.selectValueTime += System.currentTimeMillis() - selectValueStart;
        if (selectedSlot < 0) {
            return selectedSlot;
        }
        ActivityGroup conflictActivities = this.valueSelection.selectedConflictActivities();
        int i = 0;
        while (i < conflictActivities.size()) {
            conflictActivities.get(i).remove(activity);
            ++i;
        }
        activity.schedule(selectedSlot, this.valueSelection.selectedResources());
        return selectedSlot;
    }

    public boolean schedule(Activity activity, int slot, Resource useResource) throws TimetableException {
        this.valueSelection.reset(activity);
        this.config.log("SCHEDULE: " + activity.name);
        if (activity.canScheduleAt(slot, null)) {
            ActivityGroup conflictActivities = this.problem.dependences.getConflictActivities(activity, slot);
            boolean can = true;
            int i = 0;
            while (i < conflictActivities.size()) {
                if (!conflictActivities.get((int)i).canReschedule) {
                    can = false;
                }
                ++i;
            }
            this.config.log("  -> " + slot + " (conflict: " + conflictActivities.toString() + ")");
            this.generateCount = 0L;
            if (can) {
                this.generate(activity, this.valueSelection, slot, new ActivityResources(), conflictActivities, useResource);
            }
        }
        long selectValueStart = System.currentTimeMillis();
        this.valueSelection.select();
        int selectedSlot = this.valueSelection.selectedSlot();
        this.selectValueTime += System.currentTimeMillis() - selectValueStart;
        if (selectedSlot < 0) {
            return false;
        }
        ActivityGroup conflictActivities = this.valueSelection.selectedConflictActivities();
        int i = 0;
        while (i < conflictActivities.size()) {
            conflictActivities.get(i).remove(activity);
            ++i;
        }
        activity.schedule(selectedSlot, this.valueSelection.selectedResources());
        return true;
    }

    private void generate(Activity activity, ValueSelectionInterface valueSelection, int slot, ActivityResources resources, ActivityGroup conflict) throws TimetableException {
        int number = resources.size();
        if (number < activity.resources.size()) {
            if (activity.resources.isGroup(number)) {
                if (activity.resources.getResources((int)number).conjunctive) {
                    resources.add(activity.resources.getResources(number));
                    this.generate(activity, valueSelection, slot, resources, conflict);
                    resources.remove(activity.resources.getResources(number));
                } else if (activity.resources.getResources(number).size() == 0) {
                    resources.add(activity.resources.getResource(number));
                    this.generate(activity, valueSelection, slot, resources, conflict);
                    resources.remove(activity.resources.getResource(number));
                } else {
                    int i = 0;
                    while (i < activity.resources.getResources(number).size()) {
                        if (activity.resources.getResources(number).get(i).canBeFreeAt(slot, activity.length)) {
                            resources.add(activity.resources.getResources(number).get(i));
                            this.generate(activity, valueSelection, slot, resources, conflict);
                            resources.remove(activity.resources.getResources(number).get(i));
                        }
                        ++i;
                    }
                }
            } else {
                resources.add(activity.resources.getResource(number));
                this.generate(activity, valueSelection, slot, resources, conflict);
                resources.remove(activity.resources.getResource(number));
            }
        } else {
            ActivityGroup conflictActivities = (ActivityGroup)conflict.clone();
            int i = 0;
            while (i < resources.size()) {
                if (resources.isGroup(i)) {
                    int k = 0;
                    while (k < resources.getResources(i).size()) {
                        conflictActivities.addIfIsNot(resources.getResources(i).get(k).getActivitiesAt(slot, activity.length));
                        ++k;
                    }
                } else {
                    conflictActivities.addIfIsNot(resources.getResource(i).getActivitiesAt(slot, activity.length));
                }
                ++i;
            }
            this.config.log("    GENER: resources=" + resources.toString() + " (conflict: " + conflictActivities + ")");
            long start = System.currentTimeMillis();
            if (this.generateCount++ % 10L == 0L) {
                System.err.print(".");
            }
            valueSelection.addValue(slot, resources, this.problem.dependences, conflictActivities);
            this.selectValueTime += System.currentTimeMillis() - start;
        }
    }

    private void generateNoConflict(Activity activity, ValueSelectionInterface valueSelection, int slot, ActivityResources resources) throws TimetableException {
        int number = resources.size();
        if (number < activity.resources.size()) {
            if (activity.resources.isGroup(number)) {
                if (activity.resources.getResources((int)number).conjunctive) {
                    boolean isFree = true;
                    int k = 0;
                    while (k < activity.resources.getResources(number).size()) {
                        if (!activity.resources.getResources(number).get(k).isFreeAt(slot, activity.length)) {
                            isFree = false;
                        }
                        ++k;
                    }
                    if (isFree) {
                        resources.add(activity.resources.getResources(number));
                        this.generateNoConflict(activity, valueSelection, slot, resources);
                        resources.remove(activity.resources.getResources(number));
                    }
                } else {
                    int i = 0;
                    while (i < activity.resources.getResources(number).size()) {
                        if (activity.resources.getResources(number).get(i).isFreeAt(slot, activity.length)) {
                            resources.add(activity.resources.getResources(number).get(i));
                            this.generateNoConflict(activity, valueSelection, slot, resources);
                            resources.remove(activity.resources.getResources(number).get(i));
                        }
                        ++i;
                    }
                }
            } else if (activity.resources.getResource(number).isFreeAt(slot, activity.length)) {
                resources.add(activity.resources.getResource(number));
                this.generateNoConflict(activity, valueSelection, slot, resources);
                resources.remove(activity.resources.getResource(number));
            }
        } else {
            this.config.log("    GENER: resources=" + resources.toString() + " (noconflict)");
            long start = System.currentTimeMillis();
            if (this.generateCount++ % 10L == 0L) {
                System.err.print("*");
            }
            valueSelection.addValue(slot, resources, this.problem.dependences, new ActivityGroup());
            this.selectValueTime += System.currentTimeMillis() - start;
        }
    }

    private void generate(Activity activity, ValueSelectionInterface valueSelection, int slot, ActivityResources resources, ActivityGroup conflict, Resource useResource) throws TimetableException {
        if (useResource == null) {
            this.generate(activity, valueSelection, slot, resources, conflict);
            return;
        }
        int number = resources.size();
        if (number < activity.resources.size()) {
            if (activity.resources.isGroup(number)) {
                if (activity.resources.getResources((int)number).conjunctive) {
                    resources.add(activity.resources.getResources(number));
                    this.generate(activity, valueSelection, slot, resources, conflict, useResource);
                    resources.remove(activity.resources.getResources(number));
                } else if (activity.resources.getResources(number).indexOf(useResource) >= 0) {
                    resources.add(useResource);
                    this.generate(activity, valueSelection, slot, resources, conflict, useResource);
                    resources.remove(useResource);
                } else if (activity.resources.getResources(number).size() == 0) {
                    resources.add(activity.resources.getResource(number));
                    this.generate(activity, valueSelection, slot, resources, conflict);
                    resources.remove(activity.resources.getResource(number));
                } else {
                    int i = 0;
                    while (i < activity.resources.getResources(number).size()) {
                        if (activity.resources.getResources(number).get(i).canBeFreeAt(slot, activity.length)) {
                            resources.add(activity.resources.getResources(number).get(i));
                            this.generate(activity, valueSelection, slot, resources, conflict, useResource);
                            resources.remove(activity.resources.getResources(number).get(i));
                        }
                        ++i;
                    }
                }
            } else {
                resources.add(activity.resources.getResource(number));
                this.generate(activity, valueSelection, slot, resources, conflict, useResource);
                resources.remove(activity.resources.getResource(number));
            }
        } else {
            ActivityGroup conflictActivities = (ActivityGroup)conflict.clone();
            int i = 0;
            while (i < resources.size()) {
                if (resources.isGroup(i)) {
                    int k = 0;
                    while (k < resources.getResources(i).size()) {
                        conflictActivities.addIfIsNot(resources.getResources(i).get(k).getActivitiesAt(slot, activity.length));
                        ++k;
                    }
                } else {
                    conflictActivities.addIfIsNot(resources.getResource(i).getActivitiesAt(slot, activity.length));
                }
                ++i;
            }
            this.config.log("    GENER: resources=" + resources.toString() + " (conflict: " + conflictActivities + ")");
            long start = System.currentTimeMillis();
            if (this.generateCount++ % 10L == 0L) {
                System.err.print(".");
            }
            valueSelection.addValue(slot, resources, this.problem.dependences, conflictActivities);
            this.selectValueTime += System.currentTimeMillis() - start;
        }
    }
}

