/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver.strategy.value;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import timetable.util.Config;
import timetable.util.Loc;

public class HumanValueSelectionDlg
extends JDialog {
    private Config config;
    private SelectButtonGroup selectButtonGroup;
    private int returnStatus = -1;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JPanel solutionPanel;

    public HumanValueSelectionDlg(Frame parent, Config config) {
        super(parent, true);
        this.initComponents();
        this.pack();
        this.config = config;
        this.selectButtonGroup = new SelectButtonGroup();
    }

    public void addAdept(int slot, String selectedResources, String conflictActivities) {
        String time;
        try {
            int nrSlotsPerDay = this.config.getInt(Config.NR_SLOTS) / this.config.getInt(Config.NR_DAYS);
            time = String.valueOf(this.config.dayOfWeek(slot)) + " " + (slot % nrSlotsPerDay + 1);
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            e.printStackTrace();
            time = "?";
        }
        JRadioButton rb = new JRadioButton(String.valueOf(Loc.get("timetable.humanvalueselect.hour")) + " " + time);
        this.selectButtonGroup.addButton(rb);
        JLabel l1 = new JLabel(String.valueOf(Loc.get("timetable.humanvalueselect.resources")) + " " + selectedResources);
        JLabel l2 = new JLabel(String.valueOf(Loc.get("timetable.humanvalueselect.conflicts")) + " " + conflictActivities);
        l1.setForeground(rb.getForeground());
        l1.setBorder(new EmptyBorder(0, 18, 0, 0));
        l2.setBorder(new EmptyBorder(0, 18, 0, 0));
        if (!conflictActivities.equals("")) {
            l2.setForeground(new Color(255, 100, 100));
        }
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(new EtchedBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        p.add((Component)rb, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        p.add((Component)l1, c);
        if (!conflictActivities.equals("")) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.anchor = 17;
            p.add((Component)l2, c);
        }
        JPanel dummy = new JPanel();
        dummy.setPreferredSize(new Dimension(300, 1));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        p.add((Component)dummy, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 2;
        this.solutionPanel.add((Component)p, c);
        ((Component)this).setSize(330, this.getPreferredSize().height <= 250 ? this.getPreferredSize().height : 250);
        ((Component)this).setLocation(200, 200);
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public int getSelected() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.solutionPanel = new JPanel();
        this.setTitle(Loc.get("timetable.humanvalueselect.title"));
        this.addWindowListener(new 1());
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okButton.setText(Loc.get("timetable.button.select"));
        this.okButton.addActionListener(new 2());
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(Loc.get("timetable.button.cancel"));
        this.cancelButton.addActionListener(new 3());
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setMaximumSize(new Dimension(400, 200));
        this.jScrollPane1.setAutoscrolls(true);
        this.solutionPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.solutionPanel);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.returnStatus = -1;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.returnStatus = this.selectButtonGroup.getSelected();
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private class SelectButtonGroup
    extends ButtonGroup
    implements ActionListener {
        private Vector buttons = new Vector();
        private int selected = 0;

        public void addButton(JRadioButton b) {
            this.add(b);
            b.setSelected(this.buttons.size() == 0);
            this.buttons.add(b);
            b.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.selected = this.buttons.indexOf(e.getSource());
        }

        public int getSelected() {
            return this.selected;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            HumanValueSelectionDlg.this.closeDialog(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            HumanValueSelectionDlg.this.okButtonActionPerformed(evt);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            HumanValueSelectionDlg.this.cancelButtonActionPerformed(evt);
        }

        /* synthetic */ 3() {
        }
    }
}

