/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver.strategy.value;

import timetable.data.Activity;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.Top10Value;
import timetable.solver.strategy.price.SingleActivityEvaluationInterface;
import timetable.solver.strategy.value.AbstractValueSelection;
import timetable.util.Config;
import timetable.util.Math;
import timetable.util.TimetableException;

public class MinValueSelection
extends AbstractValueSelection {
    protected int TOP10MAX = 5;
    protected Top10Value top10 = null;
    protected Tabu tabu = null;
    protected int tabuSize = -1;
    protected int nrAdepts = 0;
    protected int min = -1;
    protected ActivityResources solution = null;
    protected ActivityGroup conflictActivities = null;
    protected int minSlot = -1;

    public MinValueSelection(Config config, Tabu tabu, SingleActivityEvaluationInterface evaluation) throws TimetableException {
        super(config, evaluation);
        this.tabu = tabu;
        this.TOP10MAX = config.getInt("VYBER_HODNOTY_POCET_TOP");
        this.top10 = new Top10Value(this.TOP10MAX);
        this.tabuSize = config.getInt("DELKA_TABU");
    }

    public void reset(Activity activity) {
        this.top10.reset();
        this.nrAdepts = 0;
        this.min = -1;
        this.minSlot = -1;
        this.activity = activity;
    }

    public void addValue(int slot, ActivityResources selectedResources, ActivityDependenceGroup dependences, ActivityGroup conflictActivities) throws TimetableException {
        if (this.tabuSize > 0 && this.tabu.isTabuMove(this.activity, slot, selectedResources)) {
            if (this.tabu.isTabuMoveTwiceMore(this.activity, slot, selectedResources)) {
                return;
            }
            int adept = this.evaluation.value(this.activity, slot, selectedResources, dependences, conflictActivities);
            if (adept < this.min || this.minSlot == -1) {
                this.minSlot = slot;
                this.solution = (ActivityResources)selectedResources.clone();
                this.conflictActivities = conflictActivities;
                this.min = adept;
            }
        } else {
            int adept = this.evaluation.value(this.activity, slot, selectedResources, dependences, conflictActivities);
            this.config.log("      VALUE=" + adept);
            if (this.top10.willBeAdded(adept)) {
                this.top10.add(adept, slot, (ActivityResources)selectedResources.clone(), conflictActivities);
                this.config.log("        ADDED");
            }
            ++this.nrAdepts;
        }
    }

    public void select() throws TimetableException {
        this.config.log("    IN TOP10 ARE " + this.top10.size() + " (INTERESTING " + this.top10.countInteresting() + ") ADEPTS FROM " + this.nrAdepts);
        if (this.top10.size() == 0 && this.minSlot < 0) {
            return;
        }
        if (this.top10.size() > 0 && (this.minSlot < 0 || this.min >= this.top10.top(0))) {
            int selected = Math.random(this.top10.countInteresting());
            this.solution = this.top10.resources(selected);
            this.conflictActivities = this.top10.activities(selected);
            this.minSlot = this.top10.slot(selected);
            this.config.log("    SELECTED VALUE " + this.top10.top(selected) + " (" + (selected + 1) + ". best adept)");
        } else {
            this.config.log("    SELECTED VALUE " + this.min + " (TABU)");
        }
        if (this.tabuSize > 0) {
            this.tabu.add(this.activity, this.minSlot, this.solution);
        }
        this.config.log("  REMOVED ACTIVITIES : " + this.conflictActivities.toString());
    }

    public int selectedSlot() {
        if (this.top10.size() == 0 && this.minSlot < 0) {
            return -1;
        }
        return this.minSlot;
    }

    public ActivityResources selectedResources() {
        if (this.top10.size() == 0 && this.minSlot < 0) {
            return null;
        }
        return this.solution;
    }

    public ActivityGroup selectedConflictActivities() {
        if (this.top10.size() == 0 && this.minSlot < 0) {
            return null;
        }
        return this.conflictActivities;
    }
}

