/*
 * Decompiled with CFR 0.152.
 */
package timetable.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import timetable.data.Activity;
import timetable.data.Problem;
import timetable.solver.Solver;
import timetable.solver.strategy.Tabu;
import timetable.solver.strategy.price.SingleActivityEvaluation;
import timetable.solver.strategy.value.MinValueSelection;
import timetable.solver.strategy.variable.WorstFirstVariableSelection;
import timetable.test.SmartGenerator;
import timetable.util.Config;

public class Test2D {
    protected OutputStreamWriter osw = null;
    protected FileOutputStream fos = null;

    public void openOutput(String filename) throws IOException {
        this.fos = new FileOutputStream(filename);
        this.osw = new OutputStreamWriter(this.fos);
    }

    public void closeOutput() throws IOException {
        this.osw.flush();
        this.osw.close();
        this.fos.close();
    }

    public void print(String s) throws IOException {
        this.osw.write(s);
        this.osw.flush();
    }

    public void println(String s) throws IOException {
        this.print(String.valueOf(s) + "\n");
    }

    public void test(String file) {
        try {
            try {
                Config k = null;
                System.out.println("Test2D ");
                System.out.println("File:" + file);
                if (file == null) {
                    k = new Config();
                } else {
                    k = new Config(file);
                    System.out.println("Using configuration file: " + file);
                }
                System.out.println("Config loaded.");
                this.openOutput(k.get("T2_OUTPUT"));
                System.out.println("Outut file: " + k.get("T2_OUTPUT"));
                String firstVar = k.get("T2_FIRST_VAR");
                String secondVar = k.get("T2_SECOND_VAR");
                int fVFrom = k.getInt("T2_FIRST_VAL_FROM");
                int fVTo = k.getInt("T2_FIRST_VAL_TO");
                int fVStep = k.getInt("T2_FIRST_VAL_STEP");
                int sVFrom = k.getInt("T2_SECOND_VAL_FROM");
                int sVTo = k.getInt("T2_SECOND_VAL_TO");
                int sVStep = k.getInt("T2_SECOND_VAL_STEP");
                System.out.println("Variable \"" + firstVar + "\" is iterated from " + fVFrom + " to " + fVTo + " step " + fVStep + ".");
                System.out.println("Variable \"" + secondVar + "\" is iterated from " + sVFrom + " to " + sVTo + " step " + sVStep + ".");
                System.out.println("--------------------------------------------------------------------------------");
                this.println("" + firstVar + "," + secondVar + ",MinIter,PrumIter,PrumAkt," + "MaxNaplAkt,PrumNaplAkt,MaxNapl%,PrumNapl%,Poc100%," + "Doba,PrumDoba,PrumIterNap,PrumDobaNap,#SoftTotal,#SoftViolated");
                int first = fVFrom;
                while (first <= fVTo) {
                    if (firstVar.equalsIgnoreCase("ZDROJE")) {
                        k.set("GEN_UCEBEN", first);
                        k.set("GEN_VYUCUJICICH", first);
                        k.set("GEN_TRID", first);
                        k.set("GEN_SKUPIN_UCEBEN", first);
                    } else if (firstVar.equalsIgnoreCase("GEN_SOFT")) {
                        k.set("GEN_SOFT_VE_VOLNYCH_ZDROJICH_PROC", first);
                        k.set("GEN_SOFT_VE_VOLNYCH_AKTIVITACH_PROC", first);
                    } else {
                        k.set(firstVar, first);
                    }
                    Problem[] prob = new Problem[k.getInt("POCET_POKUSU")];
                    int i = 0;
                    while (i < k.getInt("POCET_POKUSU")) {
                        if (k.existKey("T2_LOAD_PROBLEM")) {
                            String fname = String.valueOf(k.get("T2_LOAD_PROBLEM")) + first + "_" + (i + 1) + ".shd";
                            if (new File(fname).exists()) {
                                System.out.println("Using schedule: " + fname);
                                prob[i] = Problem.load(fname);
                            } else {
                                System.out.println("Generating schedule: " + fname);
                                SmartGenerator g = new SmartGenerator(k);
                                prob[i] = g.generujCele();
                                prob[i].save(fname);
                            }
                        } else {
                            SmartGenerator g = new SmartGenerator(k);
                            prob[i] = g.generujCele();
                        }
                        ++i;
                    }
                    boolean solverSucceed = false;
                    int second = sVFrom;
                    while (second <= sVTo) {
                        long prumPocIter = 0L;
                        long prumPocIterNapl = 0L;
                        long minPocIter = 0L;
                        long prumPocAkt = 0L;
                        long minPocAkt = 0L;
                        long prumPocNaplAkt = 0L;
                        long minPocNaplAkt = 0L;
                        long prumDobaPlanNap = 0L;
                        long prumDobaPlan = 0L;
                        long minDobaPlan = 0L;
                        long prumSoftTotal = 0L;
                        long prumSoftViolated = 0L;
                        long poc100 = 0L;
                        int pokus = 0;
                        while (pokus < k.getInt("POCET_POKUSU")) {
                            int j;
                            System.out.println("" + (pokus + 1) + ". Pokus");
                            Problem p = !k.existKey("T2_SAME_PROBLEMS") || k.getInt("T2_SAME_PROBLEMS") == 0 ? prob[pokus] : prob[0];
                            p.config.set(firstVar, first);
                            if (secondVar.equalsIgnoreCase("OHODNOCENI_VAHA_SOFT")) {
                                p.config.set("OHODNOCENI_VAHA_SOFT_AKTIVITY", second);
                                p.config.set("OHODNOCENI_VAHA_SOFT_ZDROJE", second);
                            }
                            p.config.set(secondVar, second);
                            System.out.println("Variable \"" + firstVar + "\" set to " + p.config.get(firstVar) + ".");
                            System.out.println("Variable \"" + secondVar + "\" set to " + p.config.get(secondVar) + ".");
                            p.reset();
                            Solver s = new Solver(p.config, p);
                            s.setValueSelection(new MinValueSelection(p.config, new Tabu(p.config), new SingleActivityEvaluation(p.config)));
                            s.setVariableSelection(new WorstFirstVariableSelection(p.config));
                            s.solve();
                            System.out.println("Podarilo se naplanovat " + s.maxScheduledActivities + " aktivit z " + p.activities.size() + ".");
                            System.out.println("Pouzito " + s.nrIters + " iteraci.");
                            Activity a = null;
                            int max = 0;
                            int i2 = 0;
                            while (i2 < p.activities.size()) {
                                if (p.activities.get((int)i2).nrRemoves > max || a == null) {
                                    max = p.activities.get((int)i2).nrRemoves;
                                    a = p.activities.get(i2);
                                }
                                ++i2;
                            }
                            System.out.println("Nejvice vadi aktivita " + a.name + " , vyhozena byla " + a.nrRemoves + "x");
                            System.out.println("Doba planovani " + s.solveTime + " ms.");
                            System.out.println("Doba generovani " + s.generateTime + " ms.");
                            System.out.println("Doba vyberu promenne " + s.selectVariableTime + " ms.");
                            System.out.println("Doba vyberu hodnoty " + s.selectValueTime + " ms.");
                            if ((long)p.activities.size() == s.maxScheduledActivities) {
                                ++poc100;
                                prumPocIterNapl += (long)s.nrIters;
                                prumDobaPlanNap += s.solveTime;
                                solverSucceed = true;
                            }
                            prumPocIter += (long)s.nrIters;
                            prumPocAkt += (long)p.activities.size();
                            prumPocNaplAkt += s.maxScheduledActivities;
                            prumDobaPlan += s.solveTime;
                            long softTotal = 0L;
                            long softViolated = 0L;
                            int i3 = 0;
                            while (i3 < p.activities.size()) {
                                a = p.activities.get(i3);
                                softTotal += (long)a.getPreference().countSOFT();
                                if (a.start >= 0) {
                                    softViolated += (long)a.getPreference().countViolatedSOFT(a.start, a.length);
                                    j = 0;
                                    while (j < a.selectedResources.size()) {
                                        if (a.selectedResources.isGroup(j)) {
                                            int l = 0;
                                            while (l < a.selectedResources.getResources(j).size()) {
                                                softViolated += (long)a.selectedResources.getResources(j).get(l).getPreference().countViolatedSOFT(a.start, a.length);
                                                ++l;
                                            }
                                        } else {
                                            softViolated += (long)a.selectedResources.getResource(j).getPreference().countViolatedSOFT(a.start, a.length);
                                        }
                                        ++j;
                                    }
                                }
                                ++i3;
                            }
                            i3 = 0;
                            while (i3 < p.resources.length) {
                                j = 0;
                                while (j < p.resources[i3].size()) {
                                    softTotal += (long)p.resources[i3].get(j).getPreference().countSOFT();
                                    ++j;
                                }
                                ++i3;
                            }
                            prumSoftTotal += softTotal;
                            prumSoftViolated += softViolated;
                            if (pokus == 0 || (double)minPocNaplAkt / (double)minPocAkt < (double)s.maxScheduledActivities / (double)p.activities.size() || (double)minPocNaplAkt / (double)minPocAkt < (double)s.maxScheduledActivities / (double)p.activities.size() && minPocIter > (long)s.nrIters) {
                                minPocIter = s.nrIters;
                                minDobaPlan = s.solveTime;
                                minPocNaplAkt = s.maxScheduledActivities;
                                minPocAkt = p.activities.size();
                            }
                            ++pokus;
                        }
                        int pocPokusu = k.getInt("POCET_POKUSU");
                        this.println(first + "," + second + "," + minPocIter + "," + (double)prumPocIter / (double)pocPokusu + "," + (double)prumPocAkt / (double)pocPokusu + "," + minPocNaplAkt + "," + (double)prumPocNaplAkt / (double)pocPokusu + "," + 100.0 * (double)minPocNaplAkt / (double)minPocAkt + "," + 100.0 * (double)prumPocNaplAkt / (double)prumPocAkt + "," + 100.0 * (double)poc100 / (double)pocPokusu + "," + minDobaPlan + "," + (double)prumDobaPlan / (double)pocPokusu + (poc100 <= 0L ? "" : "," + (double)prumPocIterNapl / (double)poc100 + "," + (double)prumDobaPlanNap / (double)poc100) + "," + (double)prumSoftTotal / (double)pocPokusu + "," + (double)prumSoftViolated / (double)pocPokusu);
                        System.out.println("--------------------------------------------------------------------------------");
                        second += sVStep;
                    }
                    first += fVStep;
                }
            }
            finally {
                Object var55_41 = null;
                this.closeOutput();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        Test2D t = new Test2D();
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                t.test(args[i]);
                ++i;
            }
        } else {
            t.test(null);
        }
    }
}

