/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable;

import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.data.User;
import edu.purdue.smas.timetable.serverfwk.GeneralTimetableServer;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.FileOperations;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.Timing;
import edu.purdue.smas.timetable.util.ToolBox;
import java.io.File;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Web {
    private static Date sStartUpDate;
    private static String sTempDir;
    private static SimpleDateFormat sDateFormat;
    private static DecimalFormat sDoubleFormat;
    private static boolean sTempDirInitialized;
    private static boolean sInitialized;
    private static LocalServerThread sLocalServer;

    public static String getVersionString() {
        return ToolBox.replaceIgnoreCase(ToolBox.replaceIgnoreCase(ToolBox.replaceIgnoreCase(ToolBox.replaceIgnoreCase(Constants.VERSION_STRING_FORMAT, "%ver%", Web.getVersion()), "%phase%", Web.getPhase()), "%bldnum%", String.valueOf(Web.getBuildNumber())), "%reldate%", Web.getRelDate());
    }

    public static String getVersion() {
        return Constants.VERSION;
    }

    public static String getPhase() {
        return Constants.PHASE;
    }

    public static String getRelDate() {
        return Constants.REL_DATE;
    }

    public static int getBuildNumber() {
        return Constants.BLD_NUMBER;
    }

    public static String getStartUpDate() {
        return new SimpleDateFormat(Constants.STARTUP_DATE_FORMAT, Locale.US).format(sStartUpDate == null ? new Date() : sStartUpDate);
    }

    public static String doubleSlashes(String param) {
        if (param == null) {
            return null;
        }
        return ToolBox.replace(param, "\\", "\\\\");
    }

    public static String metaExpireNow() {
        return "<META http-equiv=\"Expires\" content=\"Mon, 1 Jan 1970 01:00:00 GMT\">";
    }

    public static String getTempDir() {
        if (!sTempDirInitialized) {
            sTempDir = Config.get("TEMP_DIR", "c:\\temp");
            if (!new File(sTempDir).exists()) {
                new File(sTempDir).mkdirs();
            }
            sTempDirInitialized = true;
        }
        return sTempDir;
    }

    public static void emptyTempDir() {
        Debug.log("Empty '" + Web.getTempDir() + "'.");
        FileOperations.empty(Web.getTempDir());
    }

    public static Timing getTiming(HttpSession session) {
        Timing timing = (Timing)session.getAttribute("Timing");
        if (timing == null) {
            timing = new Timing("session " + session.getId());
            session.setAttribute("Timing", (Object)timing);
        }
        return timing;
    }

    public static boolean isLoggedIn(HttpSession session) {
        return session.getAttribute("User") != null && session.getAttribute("User") instanceof User;
    }

    public static User getUser(HttpSession session) {
        if (!Web.isLoggedIn(session)) {
            return null;
        }
        return (User)session.getAttribute("User");
    }

    public static boolean isAdmin(HttpSession session) {
        User user = Web.getUser(session);
        return user == null ? false : user.isAdmin();
    }

    public static String format(Date date) {
        return date == null ? "" : sDateFormat.format(date);
    }

    public static String format(double x) {
        return sDoubleFormat.format(x);
    }

    public static String getHeader(String message) {
        return "<br><table border='0' width='100%'><tr><td width=12>&nbsp;</td><td bgcolor='#BBCDE4' align='right'><div class=WelcomeHead>" + message + "&nbsp;</div></td></tr></table><br>";
    }

    public static int getOrder(HttpSession session, String code) {
        Hashtable orderInfo = (Hashtable)session.getAttribute("OrderInfo");
        if (orderInfo == null) {
            orderInfo = new Hashtable();
            session.setAttribute("OrderInfo", orderInfo);
        }
        return orderInfo.containsKey(code) ? (Integer)orderInfo.get(code) : 0;
    }

    public static void setOrder(HttpSession session, String code, String order, int defOrder) {
        Hashtable<String, Integer> orderInfo = (Hashtable<String, Integer>)session.getAttribute("OrderInfo");
        if (orderInfo == null) {
            orderInfo = new Hashtable<String, Integer>();
            session.setAttribute("OrderInfo", orderInfo);
        }
        if (order != null) {
            orderInfo.put(code, Integer.valueOf(order));
        } else if (!orderInfo.containsKey(code)) {
            orderInfo.put(code, new Integer(defOrder));
        }
    }

    public static void setOrder(HttpSession session, String code, String order) {
        if (order == null) {
            return;
        }
        Hashtable<String, Integer> orderInfo = (Hashtable<String, Integer>)session.getAttribute("OrderInfo");
        if (orderInfo == null) {
            orderInfo = new Hashtable<String, Integer>();
            session.setAttribute("OrderInfo", orderInfo);
        }
        orderInfo.put(code, Integer.valueOf(order));
    }

    public static void createFilter(HttpSession session, String code, String[] columns, boolean[] defaults) {
        Hashtable filters = (Hashtable)session.getAttribute("FilterInfo");
        if (filters == null) {
            filters = new Hashtable();
            session.setAttribute("FilterInfo", filters);
        }
        if (!filters.containsKey(code)) {
            Hashtable<String, Boolean> filter = new Hashtable<String, Boolean>();
            for (int i = 0; i < columns.length; ++i) {
                filter.put(columns[i], new Boolean(defaults[i]));
            }
            filters.put(code, filter);
        }
    }

    public static Hashtable getFilter(HttpSession session, String code) {
        Hashtable filters = (Hashtable)session.getAttribute("FilterInfo");
        if (filters == null) {
            filters = new Hashtable();
            session.setAttribute("FilterInfo", filters);
        }
        return filters.containsKey(code) ? (Hashtable)filters.get(code) : null;
    }

    public static void alterFilter(HttpSession session, HttpServletRequest request, String code) {
        Hashtable filter = Web.getFilter(session, code);
        if (filter == null) {
            return;
        }
        Enumeration e = filter.keys();
        while (e.hasMoreElements()) {
            String column = (String)e.nextElement();
            filter.put(column, new Boolean(request.getParameter("cf_" + column) == null));
        }
    }

    public static String changeFilterHTML(HttpSession session, String code, String[] columns) {
        Hashtable filter = Web.getFilter(session, code);
        if (filter == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            boolean def = (Boolean)filter.get(column);
            ret.append("<input name='cf_" + column + "' type='checkbox' " + (def ? "" : "checked") + "> " + column);
            if (i + 1 >= columns.length) continue;
            ret.append("<br>");
        }
        return ret.toString();
    }

    public static int filterCountFiltered(HttpSession session, String code) {
        Hashtable filter = Web.getFilter(session, code);
        if (filter == null) {
            return 0;
        }
        int ret = 0;
        Enumeration e = filter.keys();
        while (e.hasMoreElements()) {
            String column = (String)e.nextElement();
            if (!((Boolean)filter.get(column)).booleanValue()) continue;
            ++ret;
        }
        return ret;
    }

    public static long getVersionNumber(HttpSession session) throws TTException {
        long ret = -1L;
        if (Web.isAdmin(session) && session.getAttribute("selectedVersion") != null) {
            ret = (Long)session.getAttribute("selectedVersion");
        }
        return ret >= 0L ? ret : TimetableVersion.getCurrentVersionNumber();
    }

    public static TimetableVersion getCurrentVersion(HttpSession session) throws TTException {
        try {
            return TimetableVersion.getCurrentVersion();
        }
        catch (SQLException e) {
            throw new TTException(e);
        }
    }

    public static TimetableVersion getVersion(HttpSession session) throws TTException {
        try {
            TimetableVersion ret = null;
            if (Web.isAdmin(session) && session.getAttribute("selectedVersion") != null) {
                ret = TimetableVersion.load((Long)session.getAttribute("selectedVersion"));
            }
            return ret != null ? ret : TimetableVersion.getCurrentVersion();
        }
        catch (SQLException e) {
            throw new TTException(e);
        }
    }

    public static void setVersion(HttpSession session, TimetableVersion ver) throws TTException {
        if (!Web.isAdmin(session) || ver == null || Web.getCurrentVersion(session).equals(ver)) {
            if (session.getAttribute("selectedVersion") != null) {
                session.removeAttribute("selectedVersion");
            }
        } else {
            session.setAttribute("selectedVersion", (Object)new Long(ver.getVersion()));
        }
    }

    public static void init(ServletContext application) throws TTException {
        if (sInitialized) {
            return;
        }
        Config.init(application.getResourceAsStream("tt.cfg.jsp"));
        Debug.init();
        try {
            sStartUpDate = new Date();
            Debug.log("Web server is up and running ...");
            int port = Config.getInt("LS_SOLVER_PORT", -1);
            if (port > 0) {
                Class<?> serverClass = Class.forName(Config.get("LS_SOLVER_CLASS", "ttsolver.TimetableServer"));
                GeneralTimetableServer server = (GeneralTimetableServer)serverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                sLocalServer = new LocalServerThread(server, port);
                sLocalServer.start();
            }
        }
        catch (Exception e) {
            System.err.println("Wev server initialization failed.");
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
        sInitialized = true;
    }

    public static String field(boolean isNew, String prev, String current) {
        if (isNew) {
            return "<span style='color:green'><u>" + current + "</u></span>";
        }
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return "<span style='color:red'><s>" + prev + "</s></span> <span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String field(boolean isNew, boolean isDiff, String current) {
        if (isNew) {
            return "<span style='color:green'><u>" + current + "</u></span>";
        }
        if (isDiff) {
            return "<span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String fieldBG(boolean isNew, String prev, String current) {
        if (isNew) {
            return "<span style='background-color:green'><u>" + current + "</u></span>";
        }
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return "<span style='background-color:red'><s>" + prev + "</s></span> <span style='background-color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String fieldBG(boolean isNew, String prev, String current, boolean dispPrev) {
        if (isNew) {
            return "<span style='background-color:green'><u>" + current + "</u></span>";
        }
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return (dispPrev ? "<span style='background-color:red'><s>" + prev + "</s></span> " : "") + "<span style='background-color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String fieldBG(boolean isNew, boolean isDiff, String current) {
        if (isNew) {
            return "<span style='background-color:green'><u>" + current + "</u></span>";
        }
        if (isDiff) {
            return "<span style='background-color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String fieldBG(boolean isNew, boolean isDiff, String prev, String current) {
        if (isNew) {
            return "<span style='background-color:green'><u>" + current + "</u></span>";
        }
        if (isDiff && prev != null) {
            return "<span style='color:red'><s>" + prev + "</s></span> <span style='background-color:blue'><u>" + current + "</u></span>";
        }
        if (isDiff) {
            return "<span style='background-color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String field(boolean isNew, String prev, String current, String separator) {
        if (isNew) {
            return "<span style='color:green'><u>" + current + "</u></span>";
        }
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return "<span style='color:red'><s>" + prev + "</s></span>" + (prev != null && prev.length() > 0 ? separator : "") + "<span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String field(String prev, String current) {
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return "<span style='color:red'><s>" + prev + "</s></span> <span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String field(String prev, String current, String separator) {
        boolean isDiff = Web.diff(prev, current);
        if (isDiff) {
            return "<span style='color:red'><s>" + prev + "</s></span>" + (prev != null && prev.length() > 0 ? separator : "") + "<span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static String fieldRem(String prev) {
        return "<span style='color:red'><s>" + prev + "</s></span>";
    }

    public static String fieldBGRem(String prev) {
        return "<span style='background-color:red'><s>" + prev + "</s></span>";
    }

    public static String field(boolean isDiff, String current) {
        if (isDiff) {
            return "<span style='color:blue'><u>" + current + "</u></span>";
        }
        return current;
    }

    public static boolean diff(String prev, String current) {
        return prev == null ? current == null : (current == null ? false : !prev.equals(current));
    }

    public static LocalServerThread getLocalServerThread() {
        return sLocalServer;
    }

    static {
        sDateFormat = new SimpleDateFormat(Constants.DATE_FORMAT, Locale.US);
        sDoubleFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
        sTempDirInitialized = false;
        sInitialized = false;
        sLocalServer = null;
    }

    public static class LocalServerThread
    extends Thread {
        private int iPort;
        private GeneralTimetableServer iServer;

        public LocalServerThread(GeneralTimetableServer server, int port) {
            this.iPort = port;
            this.iServer = server;
        }

        public int getPort() {
            return this.iPort;
        }

        public GeneralTimetableServer getServer() {
            return this.iServer;
        }

        public void run() {
            try {
                if (this.iServer != null && this.iPort > 0) {
                    this.iServer.start(this.iPort);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Debug.error(e);
            }
        }
    }
}

