/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.ITypes;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.Room;
import edu.purdue.smas.timetable.data.RoomFeatures;
import edu.purdue.smas.timetable.data.TimePatterns;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.data.User;
import edu.purdue.smas.timetable.data.pattern.EveningTimePattern;
import edu.purdue.smas.timetable.data.pattern.GenericTimePattern;
import edu.purdue.smas.timetable.data.pattern.SaturdayTimePattern;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class Class {
    private long iId = -1L;
    private String iSubject;
    private String iCourseNbr;
    private String iIType;
    private int iSection;
    private int iTimePattern;
    private int iExpectedCapacity;
    private long iNrEnrolments = -1L;
    private String iInstrId;
    private Date iStartDate;
    private Date iEndDate;
    private long iVersion;
    private Vector iProhibitedTimePatterns = null;
    private Hashtable iRequiredRoomFeatures = null;
    private Hashtable iRequiredBuildings = null;
    private Hashtable iRequiredRooms = null;
    private Hashtable iTimeRequirements = null;
    private String iNonStandardRequirements = null;
    private Vector iSameClasses = null;
    private String iOwnerRole = null;
    static /* synthetic */ java.lang.Class class$edu$purdue$smas$timetable$data$Class;

    public long getId() {
        return this.iId;
    }

    protected void setId(long id) {
        this.iId = id;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getCourseNumber() {
        return this.iCourseNbr;
    }

    public void setCourseNumber(String courseNumber) {
        this.iCourseNbr = courseNumber;
    }

    public String getIType() {
        return this.iIType;
    }

    public String getITypeDescription() {
        return ITypes.getDescription(this.iIType);
    }

    public void setIType(String itype) {
        this.iIType = itype;
    }

    public int getSection() {
        return this.iSection;
    }

    public void setSection(int section) {
        this.iSection = section;
    }

    public int getTimePatternId() {
        return this.iTimePattern;
    }

    public TimePatterns.TimePattern getTimePattern() {
        return TimePatterns.getTimePattern(this.iTimePattern);
    }

    public void setTimePattern(int timePattern) {
        this.iTimePattern = timePattern;
    }

    public void setTimePattern(TimePatterns.TimePattern timePattern) {
        this.iTimePattern = timePattern.getId();
    }

    public int getExpectedCapacity() {
        return this.iExpectedCapacity;
    }

    public void setExpectedCapacity(int expectedCapacity) {
        this.iExpectedCapacity = expectedCapacity;
    }

    public String getInstructorId() {
        return this.iInstrId;
    }

    public void setInstructorId(String instructorId) {
        this.iInstrId = instructorId;
    }

    public String getOwnerRole() {
        return this.iOwnerRole;
    }

    public void setOwnerRole(String ownerRole) {
        this.iOwnerRole = ownerRole;
    }

    public Date getStartDate() {
        return this.iStartDate;
    }

    public void setStartDate(Date startDate) {
        this.iStartDate = startDate;
    }

    public void setStartDate(java.util.Date startDate) {
        this.iStartDate = new Date(startDate.getTime());
    }

    public Date getEndDate() {
        return this.iEndDate;
    }

    public void setEndDate(Date endDate) {
        this.iEndDate = endDate;
    }

    public void setEndDate(java.util.Date endDate) {
        this.iEndDate = new Date(endDate.getTime());
    }

    public long getVersion() {
        return this.iVersion;
    }

    public void setVersion(long version) {
        this.iVersion = version;
    }

    public String getNonStandardRequirements() {
        return this.iNonStandardRequirements;
    }

    public void setNonStandardRequirements(String nonStandardRequirements) {
        this.iNonStandardRequirements = nonStandardRequirements;
    }

    public Vector getProhibitedTimePaterns() throws SQLException, TTException {
        if (this.iProhibitedTimePatterns != null) {
            return this.iProhibitedTimePatterns;
        }
        this.iProhibitedTimePatterns = new Vector();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()) + " ORDER BY PATTERN_ID");
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            int id = rs.getInt("PATTERN_ID");
            TimePatterns.TimePattern tp = TimePatterns.getTimePattern(id);
            if (tp == null) continue;
            this.iProhibitedTimePatterns.addElement(tp);
        }
        s.close();
        return this.iProhibitedTimePatterns;
    }

    public boolean isProhibitedTimePattern(int patternid) throws SQLException, TTException {
        TimePatterns.TimePattern tp = TimePatterns.getTimePattern(patternid);
        return tp == null ? false : this.getProhibitedTimePaterns().indexOf(tp) >= 0;
    }

    public Vector getSameClasses() throws SQLException, TTException {
        if (this.iSameClasses != null) {
            return this.iSameClasses;
        }
        this.iSameClasses = new Vector();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            this.iSameClasses.addElement(new SameClass(rs.getString("SUBJECT"), rs.getString("COURSE_NBR"), rs.getString("ITYPE"), rs.getInt("SECTION")));
        }
        s.close();
        return this.iSameClasses;
    }

    public static long loadSameClassId(String subject, String courseNbr, String itype, int section, long version) throws SQLException, TTException {
        Statement s = Database.execute("select class_id from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where VERSION=" + Database.prepParam(version) + " and SUBJECT=" + Database.prepParam(subject) + " and ITYPE=" + Database.prepParam(itype) + " and course_nbr=" + Database.prepParam(courseNbr) + " and section=" + Database.prepParam(section));
        if (s.getResultSet().next()) {
            return s.getResultSet().getLong("CLASS_ID");
        }
        return -1L;
    }

    public static Hashtable loadAllSameClasses(long version) throws SQLException, TTException {
        Hashtable<Long, Vector<SameClass>> ret = new Hashtable<Long, Vector<SameClass>>();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where VERSION=" + Database.prepParam(version));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            Long classId = new Long(rs.getLong("CLASS_ID"));
            Vector<SameClass> sameClasses = (Vector<SameClass>)ret.get(classId);
            if (sameClasses == null) {
                sameClasses = new Vector<SameClass>(1);
                ret.put(classId, sameClasses);
            }
            sameClasses.addElement(new SameClass(rs.getString("SUBJECT"), rs.getString("COURSE_NBR"), rs.getString("ITYPE"), rs.getInt("SECTION")));
        }
        s.close();
        return ret;
    }

    public Hashtable getRequiredRoomFeatures() throws SQLException, TTException {
        if (this.iRequiredRoomFeatures != null) {
            return this.iRequiredRoomFeatures;
        }
        this.iRequiredRoomFeatures = new Hashtable();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            String featureid = rs.getString("FEATURE_ID");
            int prefid = rs.getInt("PREF_ID");
            RoomFeatures.RoomFeature feature = RoomFeatures.getRoomFeature(featureid);
            Preferences.Preference pref = Preferences.getPreference(prefid);
            if (feature == null || pref == null) continue;
            this.iRequiredRoomFeatures.put(feature, pref);
        }
        s.close();
        return this.iRequiredRoomFeatures;
    }

    public Hashtable getRequiredBuildings() throws SQLException, TTException {
        if (this.iRequiredBuildings != null) {
            return this.iRequiredBuildings;
        }
        this.iRequiredBuildings = new Hashtable();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            String buildingid = rs.getString("BLDG_ID");
            int prefid = rs.getInt("PREF_ID");
            Building building = Building.load(buildingid, this.getVersion());
            Preferences.Preference pref = Preferences.getPreference(prefid);
            if (building == null || pref == null) continue;
            this.iRequiredBuildings.put(building, pref);
        }
        s.close();
        return this.iRequiredBuildings;
    }

    public Hashtable getRequiredRooms() throws SQLException, TTException {
        if (this.iRequiredRooms != null) {
            return this.iRequiredRooms;
        }
        this.iRequiredRooms = new Hashtable();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            String roomid = rs.getString("ROOM_ID");
            int prefid = rs.getInt("PREF_ID");
            Room room = Room.load(roomid, this.getVersion());
            Preferences.Preference pref = Preferences.getPreference(prefid);
            if (room == null || pref == null) continue;
            this.iRequiredRooms.put(room, pref);
        }
        s.close();
        return this.iRequiredRooms;
    }

    public Hashtable getTimeRequirements() throws SQLException, TTException {
        if (this.iTimeRequirements != null) {
            return this.iTimeRequirements;
        }
        this.iTimeRequirements = new Hashtable();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        while (s.getResultSet().next()) {
            TimeRequirement timeReq = new TimeRequirement(s.getResultSet());
            Preferences.Preference pref = Preferences.getPreference(s.getResultSet().getInt("PREF_ID"));
            if (timeReq == null || pref == null) continue;
            this.iTimeRequirements.put(timeReq, pref);
        }
        s.close();
        return this.iTimeRequirements;
    }

    protected static Class load(ResultSet rs) throws SQLException, TTException {
        Class c = new Class();
        c.iId = rs.getLong("CLASS_ID");
        c.iSubject = rs.getString("SUBJECT");
        c.iCourseNbr = rs.getString("COURSE_NBR");
        c.iIType = rs.getString("ITYPE");
        c.iSection = rs.getInt("SECTION");
        c.iTimePattern = rs.getInt("TIME_PATTERN_ID");
        c.iExpectedCapacity = rs.getInt("EXPECTED_CAPACITY");
        c.iInstrId = rs.getString("INSTR_UID");
        c.iOwnerRole = rs.getString("OWNER_ROLE");
        c.iStartDate = rs.getDate("START_DATE");
        c.iEndDate = rs.getDate("END_DATE");
        c.iVersion = rs.getLong("VERSION");
        c.iNonStandardRequirements = rs.getString("NONSTANDARD_REQ");
        return c;
    }

    public static Class load(long id, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Class c = null;
        if (s.getResultSet().next()) {
            c = Class.load(s.getResultSet());
        }
        s.close();
        return c;
    }

    public static Class load(String subject, String courseNbr, String iType, int section, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where TRIM(SUBJECT)=" + Database.prepParam(subject) + " and TRIM(COURSE_NBR)=" + Database.prepParam(courseNbr) + " and ITYPE=" + Database.prepParam(iType) + " and SECTION=" + Database.prepParam(section) + " and VERSION=" + Database.prepParam(version));
        Class c = null;
        if (s.getResultSet().next()) {
            c = Class.load(s.getResultSet());
        }
        s.close();
        return c;
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(version));
        Vector<Class> ret = new Vector<Class>();
        while (s.getResultSet().next()) {
            ret.addElement(Class.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public static Vector loadAll(long version, String condition) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(version) + (condition == null ? "" : " AND " + condition));
        Vector<Class> ret = new Vector<Class>();
        while (s.getResultSet().next()) {
            ret.addElement(Class.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public static Hashtable loadAllComplete(long version, User user, String condition, boolean countStudents, boolean readProhibitedTimePatterns, boolean readRequiredRoomFeatures, boolean readRequiredBuildings, boolean readRequiredRooms, boolean readTimeRequirements) throws SQLException, TTException {
        Preferences.Preference pref;
        Long cid;
        Statement s = null;
        ResultSet rs = null;
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS c where VERSION=" + Database.prepParam(version) + (condition == null ? "" : " AND " + condition));
        rs = s.getResultSet();
        Hashtable<Long, Class> ret = new Hashtable<Long, Class>();
        while (rs.next()) {
            Class c = Class.load(rs);
            ret.put(new Long(c.getId()), c);
            if (readProhibitedTimePatterns) {
                c.iProhibitedTimePatterns = new Vector();
            }
            if (readRequiredRoomFeatures) {
                c.iRequiredRoomFeatures = new Hashtable();
            }
            if (readRequiredBuildings) {
                c.iRequiredBuildings = new Hashtable();
            }
            if (readRequiredRooms) {
                c.iRequiredRooms = new Hashtable();
            }
            if (readTimeRequirements) {
                c.iTimeRequirements = new Hashtable();
            }
            if (countStudents) {
                c.iNrEnrolments = 0L;
            }
            c.iSameClasses = new Vector();
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        s.close();
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where VERSION=" + Database.prepParam(version));
        rs = s.getResultSet();
        while (rs.next()) {
            cid = new Long(rs.getLong("CLASS_ID"));
            if (ret.get(cid) == null) continue;
            ((Class)ret.get((Object)cid)).iSameClasses.addElement(new SameClass(rs.getString("SUBJECT"), rs.getString("COURSE_NBR"), rs.getString("ITYPE"), rs.getInt("SECTION")));
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        s.close();
        if (readProhibitedTimePatterns) {
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where VERSION=" + Database.prepParam(version) + " ORDER BY PATTERN_ID");
            rs = s.getResultSet();
            while (rs.next()) {
                cid = new Long(rs.getLong("CLASS_ID"));
                int id = rs.getInt("PATTERN_ID");
                TimePatterns.TimePattern tp = TimePatterns.getTimePattern(id);
                if (tp == null || ret.get(cid) == null) continue;
                ((Class)ret.get((Object)cid)).iProhibitedTimePatterns.addElement(tp);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        if (readRequiredRoomFeatures) {
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where VERSION=" + Database.prepParam(version));
            rs = s.getResultSet();
            while (rs.next()) {
                cid = new Long(rs.getLong("CLASS_ID"));
                String featureid = rs.getString("FEATURE_ID");
                int prefid = rs.getInt("PREF_ID");
                RoomFeatures.RoomFeature feature = RoomFeatures.getRoomFeature(featureid);
                Preferences.Preference pref2 = Preferences.getPreference(prefid);
                if (feature == null || pref2 == null || ret.get(cid) == null) continue;
                ((Class)ret.get((Object)cid)).iRequiredRoomFeatures.put(feature, pref2);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        if (readRequiredBuildings) {
            Hashtable allBldgs = Building.loadAllHash(version);
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where VERSION=" + Database.prepParam(version));
            rs = s.getResultSet();
            while (rs.next()) {
                Long cid2 = new Long(rs.getLong("CLASS_ID"));
                String buildingid = rs.getString("BLDG_ID");
                int prefid = rs.getInt("PREF_ID");
                Building building = (Building)allBldgs.get(buildingid);
                pref = Preferences.getPreference(prefid);
                if (building == null || pref == null || ret.get(cid2) == null) continue;
                ((Class)ret.get((Object)cid2)).iRequiredBuildings.put(building, pref);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        if (readRequiredRooms) {
            Hashtable allRooms = Room.loadAllHash(version);
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where VERSION=" + Database.prepParam(version));
            rs = s.getResultSet();
            while (rs.next()) {
                Long cid3 = new Long(rs.getLong("CLASS_ID"));
                String roomid = rs.getString("ROOM_ID");
                int prefid = rs.getInt("PREF_ID");
                Room room = (Room)allRooms.get(roomid);
                pref = Preferences.getPreference(prefid);
                if (room == null || pref == null || ret.get(cid3) == null) continue;
                ((Class)ret.get((Object)cid3)).iRequiredRooms.put(room, pref);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        if (readTimeRequirements) {
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where VERSION=" + Database.prepParam(version));
            rs = s.getResultSet();
            while (rs.next()) {
                cid = new Long(rs.getLong("CLASS_ID"));
                TimeRequirement timeReq = new TimeRequirement(rs);
                Preferences.Preference pref3 = Preferences.getPreference(rs.getInt("PREF_ID"));
                if (timeReq == null || pref3 == null || ret.get(cid) == null) continue;
                ((Class)ret.get((Object)cid)).iTimeRequirements.put(timeReq, pref3);
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        if (countStudents) {
            s = Database.execute("select c.class_id, count(*) as NR_STUDENTS from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT s, " + Config.get("SQL_SCHEMA") + ".CLASS c where c.VERSION=" + Database.prepParam(version) + " and s.VERSION=" + Database.prepParam(version) + " and c.SUBJECT=s.SUBJECT and c.COURSE_NBR=s.COURSE_NBR and c.ITYPE=s.ITYPE and c.SECTION=s.SECTION and c.VERSION=s.VERSION group by c.CLASS_ID");
            rs = s.getResultSet();
            while (rs.next()) {
                cid = new Long(rs.getLong("CLASS_ID"));
                if (ret.get(cid) == null) continue;
                ((Class)ret.get((Object)cid)).iNrEnrolments = rs.getLong("NR_STUDENTS");
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
            s = Database.execute("select c.class_id, c.subject, c.course_nbr, c.itype, c.section, count(*) as NR_STUDENTS from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT s, " + Config.get("SQL_SCHEMA") + ".SAME_CLASS c where " + "c.VERSION=" + Database.prepParam(version) + " and s.VERSION=" + Database.prepParam(version) + " and " + "c.SUBJECT=s.SUBJECT and c.COURSE_NBR=s.COURSE_NBR and c.ITYPE=s.ITYPE and c.SECTION=s.SECTION " + "group by c.class_id, c.subject, c.course_nbr, c.itype, c.section");
            rs = s.getResultSet();
            while (rs.next()) {
                cid = new Long(rs.getLong("CLASS_ID"));
                Class cls = (Class)ret.get(cid);
                if (cls == null) continue;
                Enumeration e = cls.iSameClasses.elements();
                while (e.hasMoreElements()) {
                    SameClass sc = (SameClass)e.nextElement();
                    if (!sc.getSubject().equals(rs.getString("SUBJECT")) || !sc.getCourseNumber().equals(rs.getString("COURSE_NBR")) || !sc.getIType().equals(rs.getString("ITYPE")) || sc.getSection() != rs.getInt("SECTION")) continue;
                    sc.setNrEnrollments(rs.getLong("NR_STUDENTS"));
                }
            }
            try {
                rs.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            s.close();
        }
        return ret;
    }

    public static Hashtable loadAllHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(version));
        ResultSet rs = s.getResultSet();
        Hashtable<Long, Class> ret = new Hashtable<Long, Class>();
        while (rs.next()) {
            Class c = Class.load(rs);
            ret.put(new Long(c.getId()), c);
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        s.close();
        return ret;
    }

    public static long count(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(version));
    }

    public void save() throws SQLException, TTException {
        block24: {
            Preferences.Preference pref;
            Enumeration<Object> e;
            block23: {
                Preferences.Preference pref2;
                Enumeration<Object> e2;
                TimetableVersion.dirty(this.getVersion());
                if (this.getId() >= 0L) break block23;
                this.setId(Database.executeLong("select " + Config.get("SQL_SCHEMA") + ".SEQ_CLASS_ID.nextval from DUAL"));
                Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS (class_id,subject,course_nbr,itype,section,time_pattern_id,expected_capacity,instr_uid,start_date,end_date,version,nonstandard_req,owner_role) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(this.getSubject()) + ", " + Database.prepParam(this.getCourseNumber()) + ", " + Database.prepParam(this.getIType()) + ", " + Database.prepParam(this.getSection()) + ", " + Database.prepParam(this.getTimePatternId()) + ", " + Database.prepParam(this.getExpectedCapacity()) + ", " + Database.prepParam(this.getInstructorId()) + ", " + Database.prepParam(this.getStartDate()) + ", " + Database.prepParam(this.getEndDate()) + ", " + Database.prepParam(this.getVersion()) + ", " + Database.prepParam(this.getNonStandardRequirements()) + ", " + Database.prepParam(this.getOwnerRole()) + ")");
                if (this.iSameClasses != null && this.iSameClasses.size() > 0) {
                    e2 = this.iSameClasses.elements();
                    while (e2.hasMoreElements()) {
                        SameClass sc = (SameClass)e2.nextElement();
                        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".SAME_CLASS (class_id,subject,course_nbr,itype,section,version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(sc.getSubject()) + ", " + Database.prepParam(sc.getCourseNumber()) + ", " + Database.prepParam(sc.getIType()) + ", " + Database.prepParam(sc.getSection()) + ", " + Database.prepParam(this.getVersion()) + ")");
                    }
                }
                if (this.iProhibitedTimePatterns != null && this.iProhibitedTimePatterns.size() > 0) {
                    e2 = this.iProhibitedTimePatterns.elements();
                    while (e2.hasMoreElements()) {
                        int patternid = ((TimePatterns.TimePattern)e2.nextElement()).getId();
                        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN (class_id,pattern_id,version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(patternid) + ", " + Database.prepParam(this.getVersion()) + ")");
                    }
                }
                if (this.iRequiredRoomFeatures != null && this.iRequiredRoomFeatures.size() > 0) {
                    e2 = this.iRequiredRoomFeatures.keys();
                    while (e2.hasMoreElements()) {
                        RoomFeatures.RoomFeature feature = (RoomFeatures.RoomFeature)e2.nextElement();
                        pref2 = (Preferences.Preference)this.iRequiredRoomFeatures.get(feature);
                        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ (class_id, feature_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(feature.getId()) + ", " + Database.prepParam(pref2.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                    }
                }
                if (this.iRequiredBuildings != null && this.iRequiredBuildings.size() > 0) {
                    e2 = this.iRequiredBuildings.keys();
                    while (e2.hasMoreElements()) {
                        Building building = (Building)e2.nextElement();
                        pref2 = (Preferences.Preference)this.iRequiredBuildings.get(building);
                        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ (class_id, bldg_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(building.getId()) + ", " + Database.prepParam(pref2.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                    }
                }
                if (this.iRequiredRooms != null && this.iRequiredRooms.size() > 0) {
                    e2 = this.iRequiredRooms.keys();
                    while (e2.hasMoreElements()) {
                        Room room = (Room)e2.nextElement();
                        pref2 = (Preferences.Preference)this.iRequiredRooms.get(room);
                        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ (class_id, room_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(room.getId()) + ", " + Database.prepParam(pref2.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                    }
                }
                if (this.iTimeRequirements == null || this.iTimeRequirements.size() <= 0) break block24;
                int iReqId = 0;
                Enumeration e3 = this.iTimeRequirements.keys();
                while (e3.hasMoreElements()) {
                    TimeRequirement timeReq = (TimeRequirement)e3.nextElement();
                    Preferences.Preference pref3 = (Preferences.Preference)this.iTimeRequirements.get(timeReq);
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ (req_id, class_id, days, start_time, end_time, pref_id, version) values (" + Database.prepParam(iReqId++) + ", " + Database.prepParam(this.getId()) + ", " + Database.prepParam(timeReq.getDaysStr()) + ", " + Database.prepParam(timeReq.getStartTime()) + ", " + Database.prepParam(timeReq.getEndTime()) + ", " + Database.prepParam(pref3.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
                break block24;
            }
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".CLASS set " + "SUBJECT=" + Database.prepParam(this.getSubject()) + ", " + "COURSE_NBR=" + Database.prepParam(this.getCourseNumber()) + ", " + "ITYPE=" + Database.prepParam(this.getIType()) + ", " + "SECTION=" + Database.prepParam(this.getSection()) + ", " + "TIME_PATTERN_ID=" + Database.prepParam(this.getTimePatternId()) + ", " + "EXPECTED_CAPACITY=" + Database.prepParam(this.getExpectedCapacity()) + ", " + "INSTR_UID=" + Database.prepParam(this.getInstructorId()) + ", " + "OWNER_ROLE=" + Database.prepParam(this.getOwnerRole()) + ", " + "START_DATE=" + Database.prepParam(this.getStartDate()) + ", " + "END_DATE=" + Database.prepParam(this.getEndDate()) + ", " + "VERSION=" + Database.prepParam(this.getVersion()) + ", " + "NONSTANDARD_REQ=" + Database.prepParam(this.getNonStandardRequirements()) + " where CLASS_ID=" + Database.prepParam(this.getId()) + " AND VERSION=" + Database.prepParam(this.getVersion()));
            if (this.iSameClasses != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                e = this.iSameClasses.elements();
                while (e.hasMoreElements()) {
                    SameClass sc = (SameClass)e.nextElement();
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".SAME_CLASS (class_id,subject,course_nbr,itype,section,version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(sc.getSubject()) + ", " + Database.prepParam(sc.getCourseNumber()) + ", " + Database.prepParam(sc.getIType()) + ", " + Database.prepParam(sc.getSection()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
            if (this.iProhibitedTimePatterns != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                e = this.iProhibitedTimePatterns.elements();
                while (e.hasMoreElements()) {
                    int patternid = ((TimePatterns.TimePattern)e.nextElement()).getId();
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN (class_id,pattern_id,version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(patternid) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
            if (this.iRequiredRoomFeatures != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                e = this.iRequiredRoomFeatures.keys();
                while (e.hasMoreElements()) {
                    RoomFeatures.RoomFeature feature = (RoomFeatures.RoomFeature)e.nextElement();
                    pref = (Preferences.Preference)this.iRequiredRoomFeatures.get(feature);
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ (class_id, feature_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(feature.getId()) + ", " + Database.prepParam(pref.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
            if (this.iRequiredBuildings != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                e = this.iRequiredBuildings.keys();
                while (e.hasMoreElements()) {
                    Building building = (Building)e.nextElement();
                    pref = (Preferences.Preference)this.iRequiredBuildings.get(building);
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ (class_id, bldg_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(building.getId()) + ", " + Database.prepParam(pref.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
            if (this.iRequiredRooms != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                e = this.iRequiredRooms.keys();
                while (e.hasMoreElements()) {
                    Room room = (Room)e.nextElement();
                    pref = (Preferences.Preference)this.iRequiredRooms.get(room);
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ (class_id, room_id, pref_id, version) values (" + Database.prepParam(this.getId()) + ", " + Database.prepParam(room.getId()) + ", " + Database.prepParam(pref.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
            if (this.iTimeRequirements != null) {
                Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where CLASS_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
                int iReqId = 0;
                Enumeration e4 = this.iTimeRequirements.keys();
                while (e4.hasMoreElements()) {
                    TimeRequirement timeReq = (TimeRequirement)e4.nextElement();
                    Preferences.Preference pref4 = (Preferences.Preference)this.iTimeRequirements.get(timeReq);
                    Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ (req_id, class_id, days, start_time, end_time, pref_id, version) values (" + Database.prepParam(iReqId++) + ", " + Database.prepParam(this.getId()) + ", " + Database.prepParam(timeReq.getDaysStr()) + ", " + Database.prepParam(timeReq.getStartTime()) + ", " + Database.prepParam(timeReq.getEndTime()) + ", " + Database.prepParam(pref4.getId()) + ", " + Database.prepParam(this.getVersion()) + ")");
                }
            }
        }
    }

    public static void delete(long id, long version) throws SQLException, TTException {
        TimetableVersion.dirty(version);
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".CLASS where CLASS_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version));
    }

    public boolean canDelete() {
        return this.getId() >= 0L;
    }

    public long countStudents() throws SQLException, TTException {
        if (this.iNrEnrolments >= 0L) {
            return this.iNrEnrolments;
        }
        long ret = 0L;
        Statement s = Database.execute("select count(*) as NR_STUDENTS from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT where SUBJECT=" + Database.prepParam(this.getSubject()) + " and COURSE_NBR=" + Database.prepParam(this.getCourseNumber()) + " and ITYPE=" + Database.prepParam(this.getIType()) + " and SECTION=" + Database.prepParam(this.getSection()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        if (s.getResultSet().next()) {
            ret = s.getResultSet().getLong("NR_STUDENTS");
        }
        s.close();
        this.iNrEnrolments = ret;
        return ret;
    }

    public static long countJointEnrollments(Class c1, Class c2) throws SQLException, TTException {
        if (c1.getVersion() != c2.getVersion()) {
            throw new TTException(class$edu$purdue$smas$timetable$data$Class == null ? (class$edu$purdue$smas$timetable$data$Class = Class.class$("edu.purdue.smas.timetable.data.Class")) : class$edu$purdue$smas$timetable$data$Class, "Different versions.");
        }
        long ret = 0L;
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".JOINT_ENROLLMENT where" + " SUBJECT_1=" + Database.prepParam(c1.getSubject()) + " and COURSE_NBR_1=" + Database.prepParam(c1.getCourseNumber()) + " and ITYPE_1=" + Database.prepParam(c1.getIType()) + " and SECTION_1=" + Database.prepParam(c1.getSection()) + " and SUBJECT_2=" + Database.prepParam(c2.getSubject()) + " and COURSE_NBR_2=" + Database.prepParam(c2.getCourseNumber()) + " and ITYPE_2=" + Database.prepParam(c2.getIType()) + " and SECTION_2=" + Database.prepParam(c2.getSection()) + " and VERSION=" + Database.prepParam(c1.getVersion()));
        if (s.getResultSet().next()) {
            ret = s.getResultSet().getLong("JOINT_ENRL");
        }
        s.close();
        return ret;
    }

    public String toString() {
        return this.getSubject() + " " + this.getCourseNumber() + " " + ITypes.getDescription(this.getIType()) + " " + this.getSection();
    }

    public String idDisplayString() {
        return "" + this.getId();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Class)) {
            return false;
        }
        Class c = (Class)o;
        return c.getId() == this.getId();
    }

    public boolean isEqualTo(Class c) {
        if (!this.equals(c)) {
            return false;
        }
        if (!this.getSubject().equals(c.getSubject())) {
            return false;
        }
        if (!this.getCourseNumber().equals(c.getCourseNumber())) {
            return false;
        }
        if (!this.getIType().equals(c.getIType())) {
            return false;
        }
        if (this.getSection() != c.getSection()) {
            return false;
        }
        if (this.getTimePatternId() != c.getTimePatternId()) {
            return false;
        }
        if (this.getExpectedCapacity() != c.getExpectedCapacity()) {
            return false;
        }
        if (this.iNrEnrolments != c.iNrEnrolments) {
            return false;
        }
        if (ToolBox.diff(this.iInstrId, c.iInstrId)) {
            return false;
        }
        if (ToolBox.diff(this.iProhibitedTimePatterns, c.iProhibitedTimePatterns)) {
            return false;
        }
        if (ToolBox.diff(this.iRequiredRoomFeatures, c.iRequiredRoomFeatures)) {
            return false;
        }
        if (ToolBox.diff(this.iRequiredBuildings, c.iRequiredBuildings)) {
            return false;
        }
        if (ToolBox.diff(this.iRequiredRooms, c.iRequiredRooms)) {
            return false;
        }
        if (ToolBox.diff(this.iTimeRequirements, c.iTimeRequirements)) {
            return false;
        }
        if (ToolBox.diff(this.iNonStandardRequirements, c.iNonStandardRequirements)) {
            return false;
        }
        try {
            if (!c.getSameClasses().equals(this.getSameClasses())) {
                return false;
            }
        }
        catch (Exception e) {
            Debug.error(e);
            return false;
        }
        return true;
    }

    public static Hashtable createHashSameSubjectCourseIType(Vector setOfClasses) {
        Hashtable<String, Hashtable> ret = new Hashtable<String, Hashtable>();
        Enumeration e = setOfClasses.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            Hashtable sameSubject = null;
            if (ret.containsKey(c.getSubject())) {
                sameSubject = (Hashtable)ret.get(c.getSubject());
            } else {
                sameSubject = new Hashtable();
                ret.put(c.getSubject(), sameSubject);
            }
            Hashtable sameCourseNbr = null;
            if (sameSubject.containsKey(c.getCourseNumber())) {
                sameCourseNbr = (Hashtable)sameSubject.get(c.getCourseNumber());
            } else {
                sameCourseNbr = new Hashtable();
                sameSubject.put(c.getCourseNumber(), sameCourseNbr);
            }
            Vector sameIType = null;
            if (sameCourseNbr.containsKey(c.getIType())) {
                sameIType = (Vector)sameCourseNbr.get(c.getIType());
            } else {
                sameIType = new Vector();
                sameCourseNbr.put(c.getIType(), sameIType);
            }
            sameIType.addElement(new Integer(c.getSection()));
        }
        return ret;
    }

    public static Hashtable createHashSameSubjectCourseITypeClass(Vector setOfClasses) {
        Hashtable<String, Hashtable> ret = new Hashtable<String, Hashtable>();
        Enumeration e = setOfClasses.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            Hashtable sameSubject = null;
            if (ret.containsKey(c.getSubject())) {
                sameSubject = (Hashtable)ret.get(c.getSubject());
            } else {
                sameSubject = new Hashtable();
                ret.put(c.getSubject(), sameSubject);
            }
            Hashtable sameCourseNbr = null;
            if (sameSubject.containsKey(c.getCourseNumber())) {
                sameCourseNbr = (Hashtable)sameSubject.get(c.getCourseNumber());
            } else {
                sameCourseNbr = new Hashtable();
                sameSubject.put(c.getCourseNumber(), sameCourseNbr);
            }
            Vector sameIType = null;
            if (sameCourseNbr.containsKey(c.getIType())) {
                sameIType = (Vector)sameCourseNbr.get(c.getIType());
            } else {
                sameIType = new Vector();
                sameCourseNbr.put(c.getIType(), sameIType);
            }
            sameIType.addElement(c);
        }
        return ret;
    }

    public static Hashtable createHashSameSubjectCourseSection(Vector setOfClasses) {
        Hashtable<String, Hashtable> ret = new Hashtable<String, Hashtable>();
        Enumeration e = setOfClasses.elements();
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            Hashtable sameSubject = null;
            if (ret.containsKey(c.getSubject())) {
                sameSubject = (Hashtable)ret.get(c.getSubject());
            } else {
                sameSubject = new Hashtable();
                ret.put(c.getSubject(), sameSubject);
            }
            Hashtable sameCourseNbr = null;
            if (sameSubject.containsKey(c.getCourseNumber())) {
                sameCourseNbr = (Hashtable)sameSubject.get(c.getCourseNumber());
            } else {
                sameCourseNbr = new Hashtable();
                sameSubject.put(c.getCourseNumber(), sameCourseNbr);
            }
            Vector sameSection = null;
            if (sameCourseNbr.containsKey(new Integer(c.getSection()))) {
                sameSection = (Vector)sameCourseNbr.get(new Integer(c.getSection()));
            } else {
                sameSection = new Vector();
                sameCourseNbr.put(new Integer(c.getSection()), sameSection);
            }
            sameSection.addElement(c.getIType());
        }
        return ret;
    }

    public static Vector loadSubjects(long version) throws SQLException, TTException {
        Vector<String> ret = new Vector<String>();
        Statement s = Database.execute("select distinct SUBJECT from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + Database.prepParam(version) + " order by SUBJECT");
        if (s.getResultSet().next()) {
            ret.addElement(s.getResultSet().getString("SUBJECT"));
        }
        s.close();
        return ret;
    }

    public long countJointEnrollments(Class anotherClass) throws SQLException, TTException {
        return Class.countJointEnrollments(this, anotherClass);
    }

    public TimePatternModel getTimePatternModel() throws SQLException, TTException {
        return this.getTimePatternModel(true);
    }

    public TimePatternModel getTimePatternModel(boolean gen) throws SQLException, TTException {
        if (this.getTimePattern().getGenericType() == Constants.TIME_PATTERN_STANDARD) {
            return new StandardTimePattern(this.getTimePattern().getNumberOfMeetings(), this.getTimePattern().getHalfHoursPerMeeting());
        }
        if (this.getTimePattern().getGenericType() == Constants.TIME_PATTERN_GENERIC) {
            return new GenericTimePattern(this.getTimePattern().getNumberOfMeetings(), this.getTimePattern().getHalfHoursPerMeeting(), gen);
        }
        if (this.getTimePattern().getGenericType() == Constants.TIME_PATTERN_EVENING) {
            return new EveningTimePattern(this.getTimePattern().getNumberOfMeetings(), this.getTimePattern().getHalfHoursPerMeeting());
        }
        if (this.getTimePattern().getGenericType() == Constants.TIME_PATTERN_SATURDAY) {
            return new SaturdayTimePattern(this.getTimePattern().getNumberOfMeetings(), this.getTimePattern().getHalfHoursPerMeeting());
        }
        throw new TTException(this, "Unknown pattern type " + this.getTimePattern().getGenericType());
    }

    public String checkConsistency() throws SQLException, TTException {
        Vector<RoomFeatures.RoomFeature> requiredFeatures = new Vector<RoomFeatures.RoomFeature>();
        Vector<RoomFeatures.RoomFeature> prohibitedFeatures = new Vector<RoomFeatures.RoomFeature>();
        Enumeration e = this.getRequiredRoomFeatures().keys();
        while (e.hasMoreElements()) {
            RoomFeatures.RoomFeature feature = (RoomFeatures.RoomFeature)e.nextElement();
            Preferences.Preference pref = (Preferences.Preference)this.getRequiredRoomFeatures().get(feature);
            if (pref.getProlog().equalsIgnoreCase("R")) {
                requiredFeatures.addElement(feature);
            }
            if (!pref.getProlog().equalsIgnoreCase("P")) continue;
            prohibitedFeatures.addElement(feature);
        }
        e = this.getRequiredRooms().keys();
        while (e.hasMoreElements()) {
            RoomFeatures.RoomFeature feature;
            Room room = (Room)e.nextElement();
            if (room.getCapacity() < (long)this.getExpectedCapacity()) {
                Building bldg = Building.load(room.getBldgId(), room.getVersion());
                return "Room " + bldg.getABBV() + " " + room.getRoomNo() + " is smaller (" + room.getCapacity() + ") than enrollment limit.";
            }
            Enumeration e2 = requiredFeatures.elements();
            while (e2.hasMoreElements()) {
                feature = (RoomFeatures.RoomFeature)e2.nextElement();
                if (room.getFeatures().contains(feature)) continue;
                Building bldg = Building.load(room.getBldgId(), room.getVersion());
                return "Room " + bldg.getABBV() + " " + room.getRoomNo() + " does not contain required feature '" + feature.getName() + "'.";
            }
            e2 = prohibitedFeatures.elements();
            while (e2.hasMoreElements()) {
                feature = (RoomFeatures.RoomFeature)e2.nextElement();
                if (!room.getFeatures().contains(feature)) continue;
                Building bldg = Building.load(room.getBldgId(), room.getVersion());
                return "Room " + bldg.getABBV() + " " + room.getRoomNo() + " contains prohibited feature '" + feature.getName() + "'.";
            }
        }
        TimePatternModel model = this.getTimePatternModel();
        boolean hasLocation = false;
        for (int day = 0; !hasLocation && day < model.getNrDays(); ++day) {
            for (int time = 0; !hasLocation && time < model.getNrTimes(); ++time) {
                if (model.getPreference(day, time).toString().equalsIgnoreCase("P")) continue;
                hasLocation = true;
            }
        }
        if (!hasLocation) {
            return "There is no not-prohibited time preference.";
        }
        return null;
    }

    public long countStudents(SameClass sameClass) throws SQLException, TTException {
        if (sameClass.getNrEnrollments() >= 0L) {
            return sameClass.getNrEnrollments();
        }
        long ret = 0L;
        Statement s = Database.execute("select count(*) as NR_STUDENTS from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT where SUBJECT=" + Database.prepParam(sameClass.getSubject()) + " and COURSE_NBR=" + Database.prepParam(sameClass.getCourseNumber()) + " and ITYPE=" + Database.prepParam(sameClass.getIType()) + " and SECTION=" + Database.prepParam(sameClass.getSection()) + " and VERSION=" + Database.prepParam(this.getVersion()));
        if (s.getResultSet().next()) {
            ret = s.getResultSet().getLong("NR_STUDENTS");
        }
        s.close();
        sameClass.setNrEnrollments(ret);
        return ret;
    }

    public boolean mayEdit(User user) throws TTException, SQLException {
        if (user == null) {
            return false;
        }
        if (user.isAdmin()) {
            return true;
        }
        if (this.getOwnerRole() != null && this.getOwnerRole().equals(user.getCurrentRole())) {
            if (this.getOwnerRole().equals(Constants.DEPARTMENT_ROLE) && this.getSubject().length() > 0) {
                return user.hasSubject(this.getSubject());
            }
            return true;
        }
        return false;
    }

    public boolean mayDelete(User user) throws TTException, SQLException {
        return this.mayEdit(user);
    }

    static /* synthetic */ java.lang.Class class$(String x0) {
        try {
            return java.lang.Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SameClass {
        private String iSubject = null;
        private String iCourseNbr = null;
        private String iIType = null;
        private int iSection = -1;
        private long iNrEnrollments = -1L;

        public SameClass(String subject, String courseNbr, String iType, int section, long nrEnrollments) {
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
            this.iIType = iType;
            this.iSection = section;
            this.iNrEnrollments = nrEnrollments;
        }

        public SameClass(String subject, String courseNbr, String iType, int section) {
            this(subject, courseNbr, iType, section, -1L);
        }

        public String getSubject() {
            return this.iSubject;
        }

        public String getCourseNumber() {
            return this.iCourseNbr;
        }

        public String getIType() {
            return this.iIType;
        }

        public int getSection() {
            return this.iSection;
        }

        private long getNrEnrollments() {
            return this.iNrEnrollments;
        }

        private void setNrEnrollments(long nrEnrollments) {
            this.iNrEnrollments = nrEnrollments;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SameClass)) {
                return false;
            }
            SameClass s = (SameClass)o;
            if (!this.getSubject().equals(s.getSubject())) {
                return false;
            }
            if (!this.getCourseNumber().equals(s.getCourseNumber())) {
                return false;
            }
            if (!this.getIType().equals(s.getIType())) {
                return false;
            }
            return this.getSection() == s.getSection();
        }
    }

    public static class ClassComparator
    implements Comparator {
        Hashtable iAllClasses = null;

        public ClassComparator(Hashtable allClasses) {
            this.iAllClasses = allClasses;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || !(o1 instanceof Long) || !(o2 instanceof Long)) {
                return 0;
            }
            Class c1 = (Class)this.iAllClasses.get(o1);
            Class c2 = (Class)this.iAllClasses.get(o2);
            if (c1 == null || c2 == null || !(c1 instanceof Class) || !(c2 instanceof Class)) {
                return 0;
            }
            int ret = c1.getSubject().compareTo(c2.getSubject());
            if (ret != 0) {
                return ret;
            }
            ret = c1.getCourseNumber().compareTo(c2.getCourseNumber());
            if (ret != 0) {
                return ret;
            }
            ret = c1.getIType().compareTo(c2.getIType());
            if (ret != 0) {
                return ret;
            }
            return c1.getSection() - c2.getSection();
        }
    }

    public static class TimeRequirement {
        private long iReqId;
        private boolean[] iDays;
        private Time iStartTime;
        private Time iEndTime;

        public long getId() {
            return this.iReqId;
        }

        private void setId(long reqId) {
            this.iReqId = reqId;
        }

        public boolean[] getDays() {
            return this.iDays;
        }

        public String getDaysStr() {
            return (this.iDays[0] ? "1" : "0") + (this.iDays[1] ? "1" : "0") + (this.iDays[2] ? "1" : "0") + (this.iDays[3] ? "1" : "0") + (this.iDays[4] ? "1" : "0") + (this.iDays[5] ? "1" : "0") + (this.iDays[6] ? "1" : "0");
        }

        public void setDays(boolean[] days) {
            this.iDays = days;
        }

        public void setDay(int day, boolean req) {
            this.iDays[day] = req;
        }

        public Time getStartTime() {
            return this.iStartTime;
        }

        public void setStartTime(Time startTime) {
            this.iStartTime = startTime;
        }

        public Time getEndTime() {
            return this.iEndTime;
        }

        public void setEndTime(Time endTime) {
            this.iEndTime = endTime;
        }

        public TimeRequirement() {
            this.iReqId = -1L;
            this.iDays = new boolean[7];
            for (int i = 0; i < 7; ++i) {
                this.iDays[i] = i < 5;
            }
        }

        public TimeRequirement(long id, String days, Time startTime, Time endTime) {
            this.iReqId = id;
            this.iDays = new boolean[7];
            for (int i = 0; i < 7; ++i) {
                this.iDays[i] = days.length() > 0 && days.charAt(i) == '1';
            }
            this.iStartTime = startTime;
            this.iEndTime = endTime;
        }

        public TimeRequirement(ResultSet rs) throws SQLException, TTException {
            this.iReqId = rs.getLong("REQ_ID");
            this.iDays = new boolean[7];
            String days = rs.getString("DAYS");
            for (int i = 0; i < 7; ++i) {
                this.iDays[i] = days.length() > 0 && days.charAt(i) == '1';
            }
            this.iStartTime = rs.getTime("START_TIME");
            this.iEndTime = rs.getTime("END_TIME");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeRequirement)) {
                return false;
            }
            TimeRequirement t = (TimeRequirement)o;
            if (!this.getStartTime().equals(t.getStartTime()) || this.getEndTime() == null && t.getEndTime() != null || this.getEndTime() != null && t.getEndTime() == null || this.getEndTime() != null && t.getEndTime() != null && !this.getEndTime().equals(t.getEndTime())) {
                return false;
            }
            for (int i = 0; i < 7; ++i) {
                if (this.getDays()[i] == t.getDays()[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ("" + this.getId() + this.getStartTime().getTime() + (this.getEndTime() == null ? "" : "" + this.getEndTime().getTime()) + this.getDays()[0] + this.getDays()[1] + this.getDays()[2] + this.getDays()[3] + this.getDays()[4] + this.getDays()[5] + this.getDays()[6]).hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (!this.getDaysStr().equals("1111100")) {
                for (int i = 0; i < 7; ++i) {
                    if (!this.getDays()[i]) continue;
                    sb.append(Constants.DAY_NAMES_SHORT[i]);
                }
                sb.append(" ");
            }
            SimpleDateFormat df = new SimpleDateFormat("hh:mm", Locale.US);
            sb.append(df.format(this.getStartTime()));
            if (this.getEndTime() != null) {
                sb.append(" - ").append(df.format(this.getEndTime()));
            }
            return sb.toString();
        }
    }
}

