/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;

public class Departments {
    private static Hashtable sDepartments = new Hashtable();
    private static Hashtable sAllDepartments = new Hashtable();

    public static void load() throws TTException, SQLException {
        try {
            Statement s = Database.execute("select d.DEPT_CODE, d.DEPT_ABBV from " + Config.get("SQL_SCHEMA") + ".DEPARTMENT d, " + Config.get("SQL_SCHEMA") + ".this_term t where d.campus = t.campus and exists (select * from " + Config.get("SQL_SCHEMA") + ".SUBJECT s where s.DEPT_CODE=d.DEPT_CODE)");
            sDepartments.clear();
            while (s.getResultSet().next()) {
                sDepartments.put(s.getResultSet().getString("DEPT_CODE"), s.getResultSet().getString("DEPT_ABBV").trim());
            }
            s.close();
            s = Database.execute("select d.DEPT_CODE, d.DEPT_ABBV from " + Config.get("SQL_SCHEMA") + ".DEPARTMENT d, " + Config.get("SQL_SCHEMA") + ".this_term t where d.campus = t.campus");
            sAllDepartments.clear();
            while (s.getResultSet().next()) {
                sAllDepartments.put(s.getResultSet().getString("DEPT_CODE"), s.getResultSet().getString("DEPT_ABBV").trim());
            }
            s.close();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static Enumeration elements() {
        return sAllDepartments.keys();
    }

    public static int size() {
        return sAllDepartments.size();
    }

    public static String getABBV(String deptCode) {
        return (String)sAllDepartments.get(deptCode);
    }

    public boolean hasDepartment(String deptCode) {
        return sDepartments.containsKey(deptCode);
    }

    public static Hashtable getPreferredBuildings(String deptCode) throws SQLException, TTException {
        Hashtable<Building, Preferences.Preference> ht = new Hashtable<Building, Preferences.Preference>();
        long version = TimetableVersion.getCurrentVersionNumber();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where DEPT_CODE=" + Database.prepParam(deptCode) + " and VERSION=" + Database.prepParam(version));
        while (s.getResultSet().next()) {
            ResultSet rs = s.getResultSet();
            String buildingid = rs.getString("BLDG_ID");
            int prefid = rs.getInt("PREF_ID");
            Building building = Building.load(buildingid, version);
            Preferences.Preference pref = Preferences.getPreference(prefid);
            if (building == null || pref == null) continue;
            ht.put(building, pref);
        }
        s.close();
        return ht;
    }

    public static Hashtable getAllDepartments() {
        return sAllDepartments;
    }

    static {
        try {
            Departments.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static class DepartmentComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || !(o1 instanceof String) || !(o2 instanceof String)) {
                return 0;
            }
            return Departments.getABBV((String)o1).compareTo(Departments.getABBV((String)o2));
        }
    }
}

