/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class GroupConstraintTypes {
    private static Vector sGroupConstraintTypes = new Vector();
    private static boolean sInitialized = false;

    public static void init() {
        try {
            GroupConstraintTypes.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static void loadStatic() throws TTException {
        sGroupConstraintTypes.clear();
        sGroupConstraintTypes.addElement(new GroupConstraintType(1, "BTB", "back-to-back"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(2, "BTB_TIME", "back-to-back time"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(3, "SAME_TIME", "same time"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(4, "SAME_DAYS", "same days"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(5, "NHB(1)", "1 hr between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(6, "NHB(2)", "2 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(7, "NHB(3)", "3 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(8, "NHB(4)", "4 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(9, "NHB(5)", "5 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(10, "NHB(6)", "6 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(11, "NHB(7)", "7 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(12, "NHB(8)", "8 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(13, "DIFF_TIME", "different time"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(14, "NHB(1.5)", "1.5 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(15, "NHB(4.5)", "4.5 hrs between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(16, "SAME_START", "same start time"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(17, "SAME_ROOM", "same room"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(18, "NHB_GTE(1)", "greater than or equal to 1 hour between"));
        sGroupConstraintTypes.addElement(new GroupConstraintType(19, "NHB_LT(6)", "less than 6 hours between"));
        sInitialized = true;
    }

    public static void load() throws TTException, SQLException {
        try {
            Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ_DEF");
            sGroupConstraintTypes.clear();
            while (s.getResultSet().next()) {
                sGroupConstraintTypes.addElement(new GroupConstraintType(s.getResultSet().getInt("REQ_ID"), s.getResultSet().getString("TYPE"), s.getResultSet().getString("DESCRIPTION")));
            }
            s.close();
            sInitialized = true;
        }
        catch (Exception e) {
            Debug.error(e);
            Debug.log("Loading static content.");
            GroupConstraintTypes.loadStatic();
        }
    }

    public static Enumeration elements() {
        if (!sInitialized) {
            GroupConstraintTypes.init();
        }
        return sGroupConstraintTypes.elements();
    }

    public static int size() {
        if (!sInitialized) {
            GroupConstraintTypes.init();
        }
        return sGroupConstraintTypes.size();
    }

    public static GroupConstraintType elementAt(int i) {
        if (!sInitialized) {
            GroupConstraintTypes.init();
        }
        return (GroupConstraintType)sGroupConstraintTypes.elementAt(i);
    }

    public static GroupConstraintType getGroupConstraintType(int id) {
        if (!sInitialized) {
            GroupConstraintTypes.init();
        }
        Enumeration e = sGroupConstraintTypes.elements();
        while (e.hasMoreElements()) {
            GroupConstraintType gc = (GroupConstraintType)e.nextElement();
            if (gc.getId() != id) continue;
            return gc;
        }
        return null;
    }

    public static GroupConstraintType getGroupConstraintType(String type) {
        if (!sInitialized) {
            GroupConstraintTypes.init();
        }
        Enumeration e = sGroupConstraintTypes.elements();
        while (e.hasMoreElements()) {
            GroupConstraintType gc = (GroupConstraintType)e.nextElement();
            if (!gc.getType().equalsIgnoreCase(type)) continue;
            return gc;
        }
        return null;
    }

    public static class GroupConstraintType
    implements Comparable {
        int iId;
        String iType;
        String iDescription;

        private GroupConstraintType(int id, String type, String desc) {
            this.iId = id;
            this.iType = type;
            this.iDescription = desc;
        }

        public int getId() {
            return this.iId;
        }

        public String getType() {
            return this.iType;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof GroupConstraintType)) {
                return false;
            }
            return this.getId() == ((GroupConstraintType)o).getId();
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof GroupConstraintType)) {
                return 0;
            }
            GroupConstraintType g = (GroupConstraintType)o;
            return this.getId() - ((GroupConstraintType)o).getId();
        }
    }
}

