/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class Preferences {
    private static Vector sPreferences = new Vector();
    private static boolean sInitialized = false;

    public static void init() {
        try {
            Preferences.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static void loadStatic() throws TTException {
        sPreferences.clear();
        sPreferences.addElement(new Preference(1, "R", "Required"));
        sPreferences.addElement(new Preference(2, "-2", "Strongly Preferred"));
        sPreferences.addElement(new Preference(3, "-1", "Preferred"));
        sPreferences.addElement(new Preference(4, "0", "Neutral"));
        sPreferences.addElement(new Preference(5, "1", "Discouraged"));
        sPreferences.addElement(new Preference(6, "2", "Strongly Discouraged"));
        sPreferences.addElement(new Preference(7, "P", "Prohibited"));
        sInitialized = true;
    }

    public static void load() throws TTException, SQLException {
        try {
            Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".PREFERENCE");
            sPreferences.clear();
            while (s.getResultSet().next()) {
                sPreferences.addElement(new Preference(s.getResultSet().getInt("PREF_ID"), s.getResultSet().getString("PREF_PROLOG"), s.getResultSet().getString("PREF_NAME")));
            }
            s.close();
            sInitialized = true;
        }
        catch (Exception e) {
            Debug.error(e);
            Debug.log("Loading static content.");
            Preferences.loadStatic();
        }
    }

    public static Enumeration elements() {
        if (!sInitialized) {
            Preferences.init();
        }
        return sPreferences.elements();
    }

    public static int size() {
        if (!sInitialized) {
            Preferences.init();
        }
        return sPreferences.size();
    }

    public static Preference elementAt(int i) {
        if (!sInitialized) {
            Preferences.init();
        }
        return (Preference)sPreferences.elementAt(i);
    }

    public static Preference getPreference(int id) {
        if (!sInitialized) {
            Preferences.init();
        }
        Enumeration e = sPreferences.elements();
        while (e.hasMoreElements()) {
            Preference p = (Preference)e.nextElement();
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public static Preference getPreference(String prologId) {
        if (!sInitialized) {
            Preferences.init();
        }
        Enumeration e = sPreferences.elements();
        while (e.hasMoreElements()) {
            Preference p = (Preference)e.nextElement();
            if (!p.getProlog().equalsIgnoreCase(prologId)) continue;
            return p;
        }
        return null;
    }

    public static class Preference {
        private int iId;
        private String iProlog;
        private String iName;

        private Preference(int id, String prolog, String name) {
            this.iId = id;
            this.iProlog = prolog;
            this.iName = name;
        }

        public int getId() {
            return this.iId;
        }

        public String getProlog() {
            return this.iProlog;
        }

        public String getName() {
            return this.iName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Preference)) {
                return false;
            }
            return this.getId() == ((Preference)o).getId();
        }

        public int hashCode() {
            return this.iId;
        }

        public String toString() {
            return "Preference{id=" + this.iId + ",prolog=" + this.iProlog + ",name=" + this.iName + "}";
        }

        public Preference combine(Preference another) {
            if (this.getProlog().equals(another.getProlog())) {
                return this;
            }
            if (this.getProlog().equals("P") || another.getProlog().equals("P")) {
                return Preferences.getPreference("P");
            }
            if (this.getProlog().equals("R")) {
                return another;
            }
            if (another.getProlog().equals("R")) {
                return this;
            }
            return Preferences.getPreference(String.valueOf(Math.max(Integer.parseInt(this.getProlog()), Integer.parseInt(another.getProlog()))));
        }
    }
}

