/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class Role {
    private static Hashtable sRoles = null;

    public static Hashtable allRoles() throws TTException, SQLException {
        if (sRoles == null) {
            Role.load();
        }
        return sRoles;
    }

    public static Hashtable nonAdminRoles() throws TTException, SQLException {
        Hashtable ht = new Hashtable(Role.allRoles());
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equals(Constants.ADMINISTRATOR_ROLE)) continue;
            ht.remove(s);
            break;
        }
        return ht;
    }

    private static void load() throws TTException, SQLException {
        try {
            sRoles = new Hashtable();
            Statement s = Database.execute("select reference, abbv from " + Config.get("SQL_SCHEMA") + ".roles order by reference");
            while (s.getResultSet().next()) {
                sRoles.put(s.getResultSet().getString("reference"), s.getResultSet().getString("abbv").trim());
            }
            s.close();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

