/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.Departments;
import edu.purdue.smas.timetable.data.RoomFeatures;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Room {
    private String iId = null;
    private String iBldgId;
    private String iRoomNo;
    private long iCapacity;
    private long iRoomOrd;
    private long iXCoordinate;
    private long iYCoordinate;
    private long iVersion;
    private Vector iFeatures = new Vector();
    private Vector iDeptCodes = new Vector();
    private Vector iDeptShares = new Vector();

    private Room() {
    }

    public String getId() {
        return this.iId;
    }

    public String getBldgId() {
        return this.iBldgId;
    }

    public String getRoomNo() {
        return this.iRoomNo;
    }

    public long getCapacity() {
        return this.iCapacity;
    }

    public long getRoomOrd() {
        return this.iRoomOrd;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public Vector getFeatures() {
        return this.iFeatures;
    }

    public Vector getDeptCodes() {
        return this.iDeptCodes;
    }

    public Vector getDeptShares() {
        return this.iDeptShares;
    }

    public String getFeaturesAsString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.iFeatures.elements();
        while (e.hasMoreElements()) {
            RoomFeatures.RoomFeature rf = (RoomFeatures.RoomFeature)e.nextElement();
            sb.append(rf == null || rf.getName() == null ? "null" : rf.getName()).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public String getDeptsAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.iDeptCodes.size(); ++i) {
            String deptABBV = Departments.getABBV((String)this.iDeptCodes.elementAt(i));
            double deptShare = (Double)this.iDeptShares.elementAt(i);
            sb.append(i == 0 ? "" : "<br>").append(ToolBox.replace(deptABBV == null ? (String)this.iDeptCodes.elementAt(i) : deptABBV, " ", "&nbsp;")).append("&nbsp;(").append((int)deptShare).append("%)");
        }
        return sb.toString();
    }

    private static Room load(ResultSet rs, Hashtable featureCache, Hashtable deptCodeCache, Hashtable deptShareCache) throws SQLException, TTException {
        Room r = new Room();
        r.iId = rs.getString("ROOM_ID");
        r.iBldgId = rs.getString("BLDG_ID");
        r.iRoomNo = rs.getString("ROOM_NO");
        r.iCapacity = rs.getLong("CAPACITY");
        r.iRoomOrd = rs.getLong("ROOM_ORD");
        r.iXCoordinate = rs.getLong("X_COORDINATE");
        r.iYCoordinate = rs.getLong("Y_COORDINATE");
        r.iVersion = rs.getLong("VERSION");
        r.loadFeatures(featureCache);
        r.loadDepartments(deptCodeCache, deptShareCache);
        return r;
    }

    private void loadFeatures(Hashtable cache) throws SQLException, TTException {
        if (cache == null) {
            Statement s = Database.execute("select FEATURE_ID from " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE where ROOM_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()) + " order by FEATURE_ID");
            while (s.getResultSet().next()) {
                this.iFeatures.addElement(RoomFeatures.getRoomFeature(s.getResultSet().getString("FEATURE_ID")));
            }
            s.close();
        } else {
            this.iFeatures = cache.containsKey(this.getId()) ? (Vector)cache.get(this.getId()) : new Vector();
        }
    }

    private void loadDepartments(Hashtable deptCodeCache, Hashtable deptShareCache) throws SQLException, TTException {
        if (deptCodeCache == null || deptShareCache == null) {
            Statement s = Database.execute("select DEPT_CODE, PERCENT_SHARE from " + Config.get("SQL_SCHEMA") + ".ROOM_DEPT where ROOM_ID=" + Database.prepParam(this.getId()) + " and VERSION=" + Database.prepParam(this.getVersion()));
            while (s.getResultSet().next()) {
                this.iDeptCodes.addElement(s.getResultSet().getString("DEPT_CODE"));
                this.iDeptShares.addElement(new Double(s.getResultSet().getDouble("PERCENT_SHARE")));
            }
            s.close();
        } else {
            this.iDeptCodes = deptCodeCache.containsKey(this.getId()) ? (Vector)deptCodeCache.get(this.getId()) : new Vector();
            this.iDeptShares = deptShareCache.containsKey(this.getId()) ? (Vector)deptShareCache.get(this.getId()) : new Vector();
        }
    }

    private static Hashtable loadFeaturesHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select ROOM_ID, FEATURE_ID from " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE where VERSION=" + Database.prepParam(version) + " order by ROOM_ID, FEATURE_ID");
        Hashtable ret = new Hashtable();
        while (s.getResultSet().next()) {
            String id = s.getResultSet().getString("ROOM_ID");
            if (!ret.containsKey(id)) {
                ret.put(id, new Vector());
            }
            Vector features = (Vector)ret.get(id);
            features.addElement(RoomFeatures.getRoomFeature(s.getResultSet().getString("FEATURE_ID")));
        }
        s.close();
        return ret;
    }

    private static Hashtable[] loadDepartmentsHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select ROOM_ID, DEPT_CODE, PERCENT_SHARE from " + Config.get("SQL_SCHEMA") + ".ROOM_DEPT WHERE VERSION=" + Database.prepParam(version) + " order by ROOM_ID");
        Hashtable deptCodeCache = new Hashtable();
        Hashtable deptShareCache = new Hashtable();
        Hashtable[] ret = new Hashtable[]{deptCodeCache, deptShareCache};
        while (s.getResultSet().next()) {
            String id = s.getResultSet().getString("ROOM_ID");
            if (!deptCodeCache.containsKey(id)) {
                deptCodeCache.put(id, new Vector());
            }
            if (!deptShareCache.containsKey(id)) {
                deptShareCache.put(id, new Vector());
            }
            Vector deptCodes = (Vector)deptCodeCache.get(id);
            Vector deptShares = (Vector)deptShareCache.get(id);
            deptCodes.addElement(s.getResultSet().getString("DEPT_CODE"));
            deptShares.addElement(new Double(s.getResultSet().getDouble("PERCENT_SHARE")));
        }
        s.close();
        return ret;
    }

    public static Room load(String id, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ROOM where ROOM_ID=" + Database.prepParam(id) + " and VERSION=" + Database.prepParam(version) + " order by ROOM_ID");
        Room b = null;
        if (s.getResultSet().next()) {
            b = Room.load(s.getResultSet(), null, null, null);
        }
        s.close();
        return b;
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        Hashtable cache = Room.loadFeaturesHash(version);
        Hashtable[] deptCache = Room.loadDepartmentsHash(version);
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ROOM where VERSION=" + Database.prepParam(version) + " order by CAPACITY");
        Vector<Room> ret = new Vector<Room>();
        while (s.getResultSet().next()) {
            ret.addElement(Room.load(s.getResultSet(), cache, deptCache[0], deptCache[1]));
        }
        s.close();
        return ret;
    }

    public static Hashtable loadAllHash(long version) throws SQLException, TTException {
        Hashtable cache = Room.loadFeaturesHash(version);
        Hashtable[] deptCache = Room.loadDepartmentsHash(version);
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ROOM where VERSION=" + Database.prepParam(version));
        Hashtable<String, Room> ret = new Hashtable<String, Room>();
        while (s.getResultSet().next()) {
            Room r = Room.load(s.getResultSet(), cache, deptCache[0], deptCache[1]);
            ret.put(r.getId(), r);
        }
        s.close();
        return ret;
    }

    public static long count(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".ROOM where VERSION=" + Database.prepParam(version));
    }

    public int hashCode() {
        return (this.getId() == null ? "null" : this.getId()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Room)) {
            return false;
        }
        String id = ((Room)o).getId();
        if (this.getId() == null) {
            return id == null;
        }
        return id != null && this.getId().equals(id);
    }

    public long getXCoordinate() {
        return this.iXCoordinate;
    }

    public long getYCoordinate() {
        return this.iYCoordinate;
    }

    public static class RoomOrdComparator
    implements Comparator {
        private Hashtable iAllBuildings = null;

        public RoomOrdComparator(Hashtable allBuilidngs) {
            this.iAllBuildings = allBuilidngs;
        }

        public int compare(Object o1, Object o2) {
            int ret;
            if (o1 == null || o2 == null || !(o1 instanceof Room) || !(o2 instanceof Room)) {
                return 0;
            }
            Room r1 = (Room)o1;
            Room r2 = (Room)o2;
            if (r1.getRoomNo() == null || r2.getRoomNo() == null) {
                return 0;
            }
            long dif = r1.getCapacity() - r2.getCapacity();
            int n = dif < 0L ? -1 : (ret = dif > 0L ? 1 : 0);
            if (ret != 0) {
                return ret;
            }
            Building b1 = (Building)this.iAllBuildings.get(r1.getBldgId());
            Building b2 = (Building)this.iAllBuildings.get(r2.getBldgId());
            if (b1 == null || b2 == null) {
                return 0;
            }
            if (b1.getABBV() == null || b2.getABBV() == null) {
                return 0;
            }
            ret = b1.getABBV().compareTo(b2.getABBV());
            if (ret != 0) {
                return ret;
            }
            return r1.getRoomNo().compareTo(r2.getRoomNo());
        }
    }

    public static class RoomComparator
    implements Comparator {
        private Hashtable iAllBuildings = null;

        public RoomComparator(Hashtable allBuilidngs) {
            this.iAllBuildings = allBuilidngs;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || !(o1 instanceof Room) || !(o2 instanceof Room)) {
                return 0;
            }
            Room r1 = (Room)o1;
            Room r2 = (Room)o2;
            if (r1.getRoomNo() == null || r2.getRoomNo() == null) {
                return 0;
            }
            Building b1 = (Building)this.iAllBuildings.get(r1.getBldgId());
            Building b2 = (Building)this.iAllBuildings.get(r2.getBldgId());
            if (b1 == null || b2 == null) {
                return 0;
            }
            if (b1.getABBV() == null || b2.getABBV() == null) {
                return 0;
            }
            int ret = b1.getABBV().compareTo(b2.getABBV());
            if (ret != 0) {
                return ret;
            }
            return r1.getRoomNo().compareTo(r2.getRoomNo());
        }
    }
}

