/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.pattern.EveningTimePattern;
import edu.purdue.smas.timetable.data.pattern.GenericTimePattern;
import edu.purdue.smas.timetable.data.pattern.SaturdayTimePattern;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.util.BinaryRelation;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class TimePatterns {
    private static Hashtable sTimePatterns = null;
    private static BinaryRelation sAlternatives = null;
    static /* synthetic */ Class class$edu$purdue$smas$timetable$data$TimePatterns;

    public static void load() throws TTException, SQLException {
        ResultSet rs;
        sTimePatterns = new Hashtable();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIME_PATTERN_DEF order by NBR_MTGS, MIN_PER_MTG");
        while (s.getResultSet().next()) {
            rs = s.getResultSet();
            int id = rs.getInt("PATTERN_ID");
            TimePattern tp = new TimePattern(id, rs.getInt("NBR_MTGS"), rs.getInt("HALF_HOURS_PER_MTG"), rs.getInt("MIN_PER_MTG"), rs.getInt("TYPE"), rs.getInt("GENERIC"));
            sTimePatterns.put(new Integer(id), tp);
        }
        s.close();
        sAlternatives = new BinaryRelation();
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".ALT_TIME_PATTERN_DEF");
        while (s.getResultSet().next()) {
            rs = s.getResultSet();
            TimePattern tp1 = TimePatterns.getTimePattern(rs.getInt("PATTERN_ID"));
            TimePattern tp2 = TimePatterns.getTimePattern(rs.getInt("PATTERN_ALT_ID"));
            if (tp1 == null || tp2 == null) continue;
            sAlternatives.setEqual(tp1, tp2);
        }
        s.close();
    }

    public static Enumeration getTimePatterns() {
        return sTimePatterns.elements();
    }

    public static TimePattern getTimePattern(int id) {
        return sTimePatterns.containsKey(new Integer(id)) ? (TimePattern)sTimePatterns.get(new Integer(id)) : null;
    }

    public static TimePatternModel getTimePatternModel(TimePattern pattern) throws SQLException, TTException {
        if (pattern.getGenericType() == Constants.TIME_PATTERN_STANDARD) {
            return new StandardTimePattern(pattern.getNumberOfMeetings(), pattern.getHalfHoursPerMeeting());
        }
        if (pattern.getGenericType() == Constants.TIME_PATTERN_GENERIC) {
            return new GenericTimePattern(pattern.getNumberOfMeetings(), pattern.getHalfHoursPerMeeting(), true);
        }
        if (pattern.getGenericType() == Constants.TIME_PATTERN_EVENING) {
            return new EveningTimePattern(pattern.getNumberOfMeetings(), pattern.getHalfHoursPerMeeting());
        }
        if (pattern.getGenericType() == Constants.TIME_PATTERN_SATURDAY) {
            return new SaturdayTimePattern(pattern.getNumberOfMeetings(), pattern.getHalfHoursPerMeeting());
        }
        throw new TTException(class$edu$purdue$smas$timetable$data$TimePatterns == null ? (class$edu$purdue$smas$timetable$data$TimePatterns = TimePatterns.class$("edu.purdue.smas.timetable.data.TimePatterns")) : class$edu$purdue$smas$timetable$data$TimePatterns, "Unknown pattern type " + pattern.getGenericType());
    }

    public static int size() {
        return sTimePatterns.size();
    }

    public static Enumeration getTimePatternsOfType(int type) {
        return new SameTypeTimePatternEnumeration(type);
    }

    public int countTimePatternsOfType(int type) {
        int ret = 0;
        Enumeration e = sTimePatterns.elements();
        while (e.hasMoreElements()) {
            TimePattern tp = (TimePattern)e.nextElement();
            if (tp.getType() != type) continue;
            ++ret;
        }
        return ret;
    }

    public static Enumeration getAlternativeTimePatterns(TimePattern tp) {
        return sAlternatives.getRelations(tp);
    }

    public static Enumeration getAlternativeTimePatterns(int id) {
        return sAlternatives.getRelations(TimePatterns.getTimePattern(id));
    }

    public static int countAlternativeTimePatterns(TimePattern tp) {
        return sAlternatives.countRelations(tp);
    }

    public static int countAlternativeTimePatterns(int id) {
        return sAlternatives.countRelations(TimePatterns.getTimePattern(id));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            TimePatterns.load();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static class SameTypeTimePatternEnumeration
    implements Enumeration {
        int iType;
        Enumeration iTimePatterns;
        TimePattern iNextElement;

        private SameTypeTimePatternEnumeration(int type) {
            this.iType = type;
            this.iTimePatterns = sTimePatterns.elements();
            this.next();
        }

        public boolean hasMoreElements() {
            return this.iNextElement != null;
        }

        public Object nextElement() {
            TimePattern ret = this.iNextElement;
            this.next();
            return ret;
        }

        private void next() {
            this.iNextElement = null;
            while (this.iTimePatterns.hasMoreElements() && (this.iNextElement == null || this.iNextElement.getType() != this.iType)) {
                this.iNextElement = (TimePattern)this.iTimePatterns.nextElement();
            }
            if (this.iNextElement != null && this.iNextElement.getType() != this.iType) {
                this.iNextElement = null;
            }
        }
    }

    public static class TimePattern
    implements Comparable {
        private int iId;
        private int iNumberOfMeetings;
        private int iHalfHoursPerMeeting;
        private int iMinutesPerMeeting;
        private int iType;
        private int iAlternatives;
        private int iGeneric;

        private TimePattern(int id, int nbrMtgs, int hhMtg, int minMtg, int type, int generic) {
            this.iId = id;
            this.iNumberOfMeetings = nbrMtgs;
            this.iHalfHoursPerMeeting = hhMtg;
            this.iMinutesPerMeeting = minMtg;
            this.iType = type;
            this.iGeneric = generic;
        }

        public int getId() {
            return this.iId;
        }

        public int getTimePatternId() {
            return this.iId;
        }

        public int getNumberOfMeetings() {
            return this.iNumberOfMeetings;
        }

        public int getHalfHoursPerMeeting() {
            return this.iHalfHoursPerMeeting;
        }

        public int getMinutesPerMeeting() {
            return this.iMinutesPerMeeting;
        }

        public int getType() {
            return this.iType;
        }

        public boolean isGeneric() {
            return this.iGeneric > 0;
        }

        public int getGenericType() {
            return this.iGeneric;
        }

        public String getDescription() {
            return this.iNumberOfMeetings + " x " + this.iMinutesPerMeeting + (this.iGeneric == Constants.TIME_PATTERN_GENERIC && this.iNumberOfMeetings == 2 ? " ext." : "") + (this.iGeneric == Constants.TIME_PATTERN_EVENING ? " evening" : "") + (this.iGeneric == Constants.TIME_PATTERN_SATURDAY ? (this.iNumberOfMeetings == 3 ? " morning" : " Sat") : "");
        }

        public String toString() {
            return this.getDescription();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimePattern)) {
                return false;
            }
            return this.getId() == ((TimePattern)o).getId();
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof TimePattern)) {
                return -1;
            }
            TimePattern t = (TimePattern)o;
            return this.getNumberOfMeetings() < t.getNumberOfMeetings() ? -1 : (this.getNumberOfMeetings() > t.getNumberOfMeetings() ? 1 : (this.getMinutesPerMeeting() < t.getMinutesPerMeeting() ? -1 : (this.getMinutesPerMeeting() > t.getMinutesPerMeeting() ? 1 : (this.getGenericType() < t.getGenericType() ? -1 : (this.getGenericType() > t.getGenericType() ? 1 : 0)))));
        }

        public TimePatternModel getModel() throws SQLException, TTException {
            return TimePatterns.getTimePatternModel(this);
        }
    }
}

