/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.Room;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Timetable {
    private long iClassId;
    private long iVersion;
    private int iMtgNumber;
    private String iRoomId;
    private int iHalfHoursPerMtg;
    private String iDay;
    private int iHalfHour;
    private boolean iNew = false;
    private Info iInfo;
    static /* synthetic */ java.lang.Class class$edu$purdue$smas$timetable$data$Timetable;

    private Timetable() {
    }

    public Timetable(long classId, long version, int mtgNumber) {
        this.iClassId = classId;
        this.iVersion = version;
        this.iMtgNumber = mtgNumber;
        this.iNew = true;
    }

    public Timetable(Class c, int mtgNumber) {
        this.iClassId = c.getId();
        this.iVersion = c.getVersion();
        this.iMtgNumber = mtgNumber;
        this.iNew = true;
    }

    public long getClassId() {
        return this.iClassId;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public int getMtgNumber() {
        return this.iMtgNumber;
    }

    public void setRoom(String roomId) {
        this.iRoomId = roomId;
    }

    public void setRoom(Room room) {
        this.iRoomId = room.getId();
    }

    public String getRoomId() {
        return this.iRoomId;
    }

    public void setHalfHoursPerMtg(int halfHoursPerMtg) {
        this.iHalfHoursPerMtg = halfHoursPerMtg;
    }

    public int getHalfHoursPerMtg() {
        return this.iHalfHoursPerMtg;
    }

    public void setSlot(int slot) {
        this.iHalfHour = slot % Constants.SLOTS_PER_DAY;
        this.iDay = Constants.DAY_NAMES_SHORT[slot / Constants.SLOTS_PER_DAY];
    }

    public int getSlot() {
        int dayIdx = 0;
        while (!Constants.DAY_NAMES_SHORT[dayIdx].equals(this.iDay)) {
            ++dayIdx;
        }
        return dayIdx * Constants.SLOTS_PER_DAY + this.iHalfHour;
    }

    public void setDay(String day) {
        this.iDay = day;
    }

    public void setHalfHour(int halfHour) {
        this.iHalfHour = halfHour;
    }

    public int getHalfHour() {
        return this.iHalfHour;
    }

    public String getDay() {
        return this.iDay;
    }

    public void setInfo(Info info) {
        this.iInfo = info;
    }

    public Info getInfo() {
        return this.iInfo;
    }

    public static Hashtable loadGlobalInfo(long version) throws SQLException, TTException {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO where VERSION=" + Database.prepParam(version));
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            ret.put(rs.getString("KEY"), rs.getString("VALUE"));
        }
        s.close();
        return ret;
    }

    public static void saveGlobalInfo(Dictionary info, long version) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO where VERSION=" + Database.prepParam(version));
        Enumeration e = info.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = info.get(key).toString();
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO (version, key, value) values (" + Database.prepParam(version) + ", " + Database.prepParam(key) + ", " + Database.prepParam(value) + ")");
        }
    }

    public static Hashtable loadSolverParams(long version) throws SQLException, TTException {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS where VERSION=" + Database.prepParam(version));
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            ret.put(rs.getString("KEY"), rs.getString("VALUE"));
        }
        s.close();
        return ret;
    }

    public static void saveSolverParams(Dictionary params, long version) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS where VERSION=" + Database.prepParam(version));
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = params.get(key).toString();
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS (version, key, value) values (" + Database.prepParam(version) + ", " + Database.prepParam(key) + ", " + Database.prepParam(value) + ")");
        }
    }

    public void save() throws SQLException, TTException {
        if (this.iNew) {
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE (class_id, version, mtg_nbr, room_id, half_hours_per_mtg, day, half_hour) values (" + Database.prepParam(this.getClassId()) + ", " + Database.prepParam(this.getVersion()) + ", " + Database.prepParam(this.getMtgNumber()) + ", " + Database.prepParam(this.getRoomId()) + ", " + Database.prepParam(this.getHalfHoursPerMtg()) + ", " + Database.prepParam(this.getDay()) + ", " + Database.prepParam(this.getHalfHour()) + ")");
        } else {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE set " + "ROOM_ID=" + Database.prepParam(this.getRoomId()) + ", " + "HALF_HOURS_PER_MTG=" + Database.prepParam(this.getHalfHoursPerMtg()) + ", " + "DAY=" + Database.prepParam(this.getDay()) + ", " + "HALF_HOUR=" + Database.prepParam(this.getHalfHour()) + " where CLASS_ID=" + Database.prepParam(this.getClassId()) + " AND VERSION=" + Database.prepParam(this.getVersion()) + " AND MTG_NBR=" + Database.prepParam(this.getMtgNumber()));
            Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where CLASS_ID=" + Database.prepParam(this.getClassId()) + " AND VERSION=" + Database.prepParam(this.getVersion()) + (this.getMtgNumber() == 0 ? " AND MTG_NBR<=0" : " AND MTG_NBR=" + Database.prepParam(this.getMtgNumber())));
        }
        if (!(this.getInfo() == null || this.getInfo().isForAllMtgs() && this.getMtgNumber() != 0)) {
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO (CLASS_ID, VERSION, MTG_NBR, VAR_ORD_NUM, ASSIGN_NUM, MIN_TIME, FAC_PREF, STUD_CONF, MIN_ROOM, ROOM_PREF) values (" + Database.prepParam(this.getClassId()) + ", " + Database.prepParam(this.getVersion()) + ", " + Database.prepParam(this.getInfo().isForAllMtgs() ? -1L : (long)this.getMtgNumber()) + ", " + Database.prepParam(this.getInfo().getVarOrdNum()) + ", " + Database.prepParam(this.getInfo().getAssignNum()) + ", " + Database.prepParam(this.getInfo().getMinTime()) + ", " + Database.prepParam(this.getInfo().getFacPref()) + ", " + Database.prepParam(this.getInfo().getStudConf()) + ", " + Database.prepParam(this.getInfo().getMinRoom()) + ", " + Database.prepParam(this.getInfo().getRoomPref()) + ")");
        }
        this.iNew = false;
    }

    public static void delete(long classId, long version, int mtgNumber) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version) + (mtgNumber == 0 ? " AND MTG_NBR<=0" : " AND MTG_NBR=" + Database.prepParam(mtgNumber)));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version) + " AND MTG_NBR=" + Database.prepParam(mtgNumber));
    }

    public static void deleteAll(long version) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where VERSION=" + Database.prepParam(version));
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where VERSION=" + Database.prepParam(version));
    }

    public static boolean hasTimetable(long version) throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where VERSION=" + Database.prepParam(version)) > 0L;
    }

    protected static Timetable load(ResultSet rs) throws SQLException, TTException {
        Timetable t = new Timetable();
        t.iClassId = rs.getLong("CLASS_ID");
        t.iVersion = rs.getLong("VERSION");
        t.iMtgNumber = rs.getInt("MTG_NBR");
        t.setRoom(rs.getString("ROOM_ID"));
        t.setDay(rs.getString("DAY"));
        t.setHalfHour(rs.getInt("HALF_HOUR"));
        t.setHalfHoursPerMtg(rs.getInt("HALF_HOURS_PER_MTG"));
        return t;
    }

    protected static Info loadInfo(ResultSet rs) throws SQLException, TTException {
        return new Info(rs.getInt("MTG_NBR") < 0, rs.getLong("VAR_ORD_NUM"), rs.getLong("ASSIGN_NUM"), rs.getLong("MIN_TIME"), rs.getLong("FAC_PREF"), rs.getLong("STUD_CONF"), rs.getLong("MIN_ROOM"), rs.getLong("ROOM_PREF"));
    }

    public static Timetable load(long classId, long version, int mtgNumber) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version) + " AND MTG_NBR=" + Database.prepParam(mtgNumber));
        Timetable t = null;
        if (s.getResultSet().next()) {
            t = Timetable.load(s.getResultSet());
        }
        s.close();
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version) + " AND (MTG_NBR=" + Database.prepParam(mtgNumber) + " OR MTG_NBR<0)");
        if (s.getResultSet().next()) {
            t.setInfo(Timetable.loadInfo(s.getResultSet()));
        }
        s.close();
        return t;
    }

    public static Vector load(long classId, long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version) + " ORDER BY MTG_NBR");
        Vector<Timetable> ret = new Vector<Timetable>();
        while (s.getResultSet().next()) {
            ret.addElement(Timetable.load(s.getResultSet()));
        }
        s.close();
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where CLASS_ID=" + Database.prepParam(classId) + " AND VERSION=" + Database.prepParam(version));
        while (s.getResultSet().next()) {
            int mtgNum = s.getResultSet().getInt("MTG_NBR");
            if (mtgNum < 0) {
                Info info = Timetable.loadInfo(s.getResultSet());
                Enumeration e = ret.elements();
                while (e.hasMoreElements()) {
                    Timetable t = (Timetable)e.nextElement();
                    t.setInfo(info);
                }
                continue;
            }
            Enumeration e = ret.elements();
            while (e.hasMoreElements()) {
                Timetable t = (Timetable)e.nextElement();
                if (mtgNum != t.getMtgNumber()) continue;
                t.setInfo(Timetable.loadInfo(s.getResultSet()));
            }
        }
        s.close();
        return ret;
    }

    public static Vector loadAll(long version) throws SQLException, TTException {
        return Timetable.loadAll(version, false);
    }

    public static Vector loadAll(long version, boolean loadInfo) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where VERSION=" + Database.prepParam(version) + " ORDER BY ROOM_ID, MTG_NBR");
        Vector<Timetable> ret = new Vector<Timetable>();
        while (s.getResultSet().next()) {
            ret.addElement(Timetable.load(s.getResultSet()));
        }
        s.close();
        if (loadInfo) {
            s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where VERSION=" + Database.prepParam(version));
            while (s.getResultSet().next()) {
                int mtgNum = s.getResultSet().getInt("MTG_NBR");
                long classId = s.getResultSet().getLong("CLASS_ID");
                if (mtgNum < 0) {
                    Info info = Timetable.loadInfo(s.getResultSet());
                    Enumeration e = ret.elements();
                    while (e.hasMoreElements()) {
                        Timetable t = (Timetable)e.nextElement();
                        if (t.getClassId() != classId) continue;
                        t.setInfo(info);
                    }
                    continue;
                }
                Enumeration e = ret.elements();
                while (e.hasMoreElements()) {
                    Timetable t = (Timetable)e.nextElement();
                    if (t.getClassId() != classId || mtgNum != t.getMtgNumber()) continue;
                    t.setInfo(Timetable.loadInfo(s.getResultSet()));
                }
            }
            s.close();
        }
        return ret;
    }

    public static Hashtable loadAllHash(long version) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE where VERSION=" + Database.prepParam(version) + " ORDER BY CLASS_ID, MTG_NBR");
        Hashtable ret = new Hashtable();
        while (s.getResultSet().next()) {
            Vector<Timetable> v;
            Timetable t = Timetable.load(s.getResultSet());
            Long key = new Long(t.getClassId());
            Vector<Timetable> vector = v = ret.containsKey(key) ? (Vector<Timetable>)ret.get(key) : null;
            if (v == null) {
                v = new Vector<Timetable>();
                ret.put(key, v);
            }
            v.addElement(Timetable.load(s.getResultSet()));
        }
        s.close();
        s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where VERSION=" + Database.prepParam(version));
        while (s.getResultSet().next()) {
            int mtgNum = s.getResultSet().getInt("MTG_NBR");
            long classId = s.getResultSet().getLong("CLASS_ID");
            Long key = new Long(classId);
            Vector v = ret.containsKey(key) ? (Vector)ret.get(key) : null;
            if (v == null) continue;
            if (mtgNum < 0) {
                Info info = Timetable.loadInfo(s.getResultSet());
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Timetable t = (Timetable)e.nextElement();
                    t.setInfo(info);
                }
                continue;
            }
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Timetable t = (Timetable)e.nextElement();
                if (mtgNum != t.getMtgNumber()) continue;
                t.setInfo(Timetable.loadInfo(s.getResultSet()));
            }
        }
        s.close();
        return ret;
    }

    public static Hashtable getRoomSlotArry(Vector allTimetables) throws TTException {
        Hashtable<String, Timetable[]> ret = new Hashtable<String, Timetable[]>();
        Enumeration e = allTimetables.elements();
        while (e.hasMoreElements()) {
            Timetable[] table;
            Timetable t = (Timetable)e.nextElement();
            Timetable[] timetableArray = table = ret.containsKey(t.getRoomId()) ? (Timetable[])ret.get(t.getRoomId()) : null;
            if (table == null) {
                table = new Timetable[Constants.SLOTS_PER_DAY * Constants.DAY_CODES.length];
                for (int i = 0; i < table.length; ++i) {
                    table[i] = null;
                }
                ret.put(t.getRoomId(), table);
            }
            if (table[t.getSlot()] != null) {
                throw new TTException(class$edu$purdue$smas$timetable$data$Timetable == null ? (class$edu$purdue$smas$timetable$data$Timetable = Timetable.class$("edu.purdue.smas.timetable.data.Timetable")) : class$edu$purdue$smas$timetable$data$Timetable, "Slot " + t.getSlot() + " used more than once.");
            }
            table[t.getSlot()] = t;
        }
        return ret;
    }

    static /* synthetic */ java.lang.Class class$(String x0) {
        try {
            return java.lang.Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Info {
        private boolean iAllMtgs;
        private long iVarOrdNum;
        private long iAssignNum;
        private long iMinTime;
        private long iFacPref;
        private long iStudConf;
        private long iMinRoom;
        private long iRoomPref;

        public Info(boolean allMtgs, long varOrdNum, long assignNum, long minTime, long facPref, long studConf, long minRoom, long roomPref) {
            this.iAllMtgs = allMtgs;
            this.iVarOrdNum = varOrdNum;
            this.iAssignNum = assignNum;
            this.iMinTime = minTime;
            this.iFacPref = facPref;
            this.iStudConf = studConf;
            this.iMinRoom = minRoom;
            this.iRoomPref = roomPref;
        }

        public boolean isForAllMtgs() {
            return this.iAllMtgs;
        }

        public long getVarOrdNum() {
            return this.iVarOrdNum;
        }

        public long getAssignNum() {
            return this.iAssignNum;
        }

        public long getMinTime() {
            return this.iMinTime;
        }

        public long getFacPref() {
            return this.iFacPref;
        }

        public long getStudConf() {
            return this.iStudConf;
        }

        public long getMinRoom() {
            return this.iMinRoom;
        }

        public long getRoomPref() {
            return this.iRoomPref;
        }
    }
}

