/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data.config;

import edu.purdue.smas.timetable.data.config.DbConfigObj;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbConfig {
    private String dbConfigTable = "CONFIG";

    public void setConfigTable(String _dbConfigTable) {
        this.dbConfigTable = _dbConfigTable;
    }

    public String getConfigTable() {
        return this.dbConfigTable;
    }

    public boolean configTableExists() {
        try {
            if (this.dbConfigTable == null || this.dbConfigTable.trim().length() == 0) {
                return false;
            }
            String sql = " select count(*) from " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable;
            Statement s = Database.execute(sql);
            ResultSet rs = s.getResultSet();
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public Vector getAll() throws SQLException, TTException {
        String sql = "select KEY, INDX, VALUE, DESCRIPTION from " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " order by LOWER(KEY), INDX asc";
        return this.runSelect(sql);
    }

    public Vector getValue(String key) throws SQLException, TTException {
        String sql = "select KEY, INDX, VALUE, DESCRIPTION from " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " where KEY=" + Database.prepParam(key) + " order by INDX asc";
        return this.runSelect(sql);
    }

    public Vector getValue(String key, int indx) throws SQLException, TTException {
        String sql = "select KEY, VALUE, INDX, DESCRIPTION from " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " where KEY=" + Database.prepParam(key) + " and INDX=" + Database.prepParam(indx);
        return this.runSelect(sql);
    }

    private Vector runSelect(String sql) throws SQLException, TTException {
        Vector<DbConfigObj> result = new Vector<DbConfigObj>();
        Statement s = Database.execute(sql);
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            DbConfigObj v = new DbConfigObj();
            v.setKey(rs.getString("KEY"));
            v.setIndex(rs.getInt("INDX"));
            v.setValue(rs.getString("VALUE"));
            v.setDescription(rs.getString("DESCRIPTION"));
            result.addElement(v);
        }
        s.close();
        return result;
    }

    public void insert(String key, int indx, String value, String description) throws SQLException, TTException {
        String sql = "insert into " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + "( KEY, INDX, VALUE, DESCRIPTION ) VALUES (" + Database.prepParam(key) + ", " + Database.prepParam(indx) + ", " + Database.prepParam(value) + ", " + Database.prepParam(description) + ") ";
        Database.executeNoOutput(sql);
    }

    public void insert(DbConfigObj p) throws SQLException, TTException {
        this.insert(p.getKey(), p.getIndex(), p.getValue(), p.getDescription());
    }

    public void update(String key, int indx, String value, String description) throws SQLException, TTException {
        String sql = "update " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " set VALUE=" + Database.prepParam(value) + " , DESCRIPTION=" + Database.prepParam(description) + " where KEY=" + Database.prepParam(key) + " and INDX=" + Database.prepParam(indx);
        Database.executeNoOutput(sql);
    }

    public void update(DbConfigObj p) throws SQLException, TTException {
        this.update(p.getKey(), p.getIndex(), p.getValue(), p.getDescription());
    }

    public void rename(String oldKey, String newKey, int oldIndx, int newIndx) throws SQLException, TTException {
        String sql = "update " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " set KEY=" + Database.prepParam(newKey) + " , INDX=" + Database.prepParam(newIndx) + " where KEY=" + Database.prepParam(oldKey) + " and INDX=" + Database.prepParam(oldIndx);
        Database.executeNoOutput(sql);
    }

    public void rename(DbConfigObj p) throws SQLException, TTException {
        this.rename(p.getOldKey(), p.getKey(), p.getOldIndex(), p.getIndex());
    }

    public void delete(String key, int indx) throws SQLException, TTException {
        String sql = "delete from " + Config.get("SQL_SCHEMA") + "." + this.dbConfigTable + " where KEY=" + Database.prepParam(key) + " and INDX=" + Database.prepParam(indx);
        Database.executeNoOutput(sql);
    }

    public void delete(DbConfigObj p) throws SQLException, TTException {
        this.delete(p.getKey(), p.getIndex());
    }
}

