/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data.pattern;

import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.util.Hashtable;

public class GenericTimePattern
extends StandardTimePattern {
    private boolean iGenericRepr;

    public GenericTimePattern(int nrMeetings, int halfHoursPerMeeting, boolean genericRepr) throws TTException {
        super(nrMeetings, halfHoursPerMeeting);
        this.iGenericRepr = genericRepr;
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() throws TTException {
        if (this.iGenericRepr) {
            if (this.getNrMeetings() == 4) {
                this.iDayCodes = new int[]{Constants.DAY_CODES[1] + Constants.DAY_CODES[2] + Constants.DAY_CODES[3] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[2] + Constants.DAY_CODES[3] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[1] + Constants.DAY_CODES[3] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[1] + Constants.DAY_CODES[2] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[1] + Constants.DAY_CODES[2] + Constants.DAY_CODES[3]};
                this.iDays = new String[]{Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[3]};
            } else if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 3) {
                this.iDayCodes = new int[]{Constants.DAY_CODES[0] + Constants.DAY_CODES[2], Constants.DAY_CODES[2] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[4]};
                this.iDays = new String[]{Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[4]};
            } else if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 2) {
                this.iDayCodes = new int[]{Constants.DAY_CODES[0] + Constants.DAY_CODES[1], Constants.DAY_CODES[0] + Constants.DAY_CODES[2], Constants.DAY_CODES[0] + Constants.DAY_CODES[3], Constants.DAY_CODES[0] + Constants.DAY_CODES[4], Constants.DAY_CODES[1] + Constants.DAY_CODES[2], Constants.DAY_CODES[1] + Constants.DAY_CODES[3], Constants.DAY_CODES[1] + Constants.DAY_CODES[4], Constants.DAY_CODES[2] + Constants.DAY_CODES[3], Constants.DAY_CODES[2] + Constants.DAY_CODES[4], Constants.DAY_CODES[3] + Constants.DAY_CODES[4]};
                this.iDays = new String[]{Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[1], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[3], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3], Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[3], Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[4]};
            } else {
                if (this.getNrMeetings() != 2) throw new TTException(this, "Unknown generic pattern " + this.getNrMeetings() + " x " + this.getNrHalfHoursPerMeeting() * 25 + ".");
                this.iDayCodes = new int[]{Constants.DAY_CODES[0] + Constants.DAY_CODES[2], Constants.DAY_CODES[2] + Constants.DAY_CODES[4], Constants.DAY_CODES[0] + Constants.DAY_CODES[4], Constants.DAY_CODES[1] + Constants.DAY_CODES[3]};
                this.iDays = new String[]{Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[4], Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3]};
            }
        } else if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 3) {
            this.iDayCodes = new int[]{Constants.DAY_CODES[0], Constants.DAY_CODES[2], Constants.DAY_CODES[4]};
            this.iDays = new String[]{Constants.DAY_NAMES_SHORT[0], Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[4]};
        } else {
            this.iDays = new String[5];
            this.iDayCodes = new int[5];
            for (int i = 0; i < 5; ++i) {
                this.iDays[i] = Constants.DAY_NAMES_SHORT[i];
                this.iDayCodes[i] = Constants.DAY_CODES[i];
            }
        }
        this.iPreferences = new Preferences.Preference[this.iDays.length][this.iHours.length];
        this.clear();
    }

    public String getText(int day, int time) {
        return super.getText(day, time) + (this.iNrMeetings != 4 ? " Ext" : "");
    }

    public String toString() {
        return super.toString() + " gen.";
    }

    public void loadTimeRequirements(Hashtable requirements) {
        try {
            boolean oldGenericRepr = this.iGenericRepr;
            this.setGenericRepresentaion(false);
            super.loadTimeRequirements(requirements);
            this.setGenericRepresentaion(oldGenericRepr);
        }
        catch (TTException e) {
            Debug.error(e);
        }
    }

    public void storeTimeRequirements(Hashtable requirements) {
        try {
            boolean oldGenericRepr = this.iGenericRepr;
            this.setGenericRepresentaion(false);
            super.storeTimeRequirements(requirements);
            this.setGenericRepresentaion(oldGenericRepr);
        }
        catch (TTException e) {
            Debug.error(e);
        }
    }

    public void setGenericRepresentaion(boolean genericRepr) throws TTException {
        if (this.iGenericRepr == genericRepr) {
            return;
        }
        String[] oldDays = this.iDays;
        int[] oldDayCodes = this.iDayCodes;
        Preferences.Preference[][] oldPreferences = this.iPreferences;
        this.iGenericRepr = genericRepr;
        this.init();
        Object dayConvert = null;
        if (this.getNrMeetings() == 4) {
            dayConvert = new int[][]{{1, 2, 3, 4}, {0, 2, 3, 4}, {0, 1, 3, 4}, {0, 1, 2, 4}, {0, 1, 2, 3}};
        } else if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 3) {
            dayConvert = this.iGenericRepr ? (Object)new int[][]{{0, 1}, {1, 2}, {0, 2}} : (Object)new int[][]{{0, 2}, {0, 1}, {1, 2}};
        } else if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 2) {
            dayConvert = this.iGenericRepr ? (Object)new int[][]{{0, 1}, {0, 2}, {0, 3}, {0, 4}, {1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}} : (Object)new int[][]{{0, 1, 2, 3}, {0, 4, 5, 6}, {1, 4, 7, 8}, {2, 5, 7, 9}, {3, 6, 8, 9}};
        } else if (this.getNrMeetings() == 2) {
            dayConvert = this.iGenericRepr ? (Object)new int[][]{{0, 2}, {2, 4}, {0, 4}, {1, 3}} : (Object)new int[][]{{0, 2}, {3}, {0, 1}, {3}, {1, 2}};
        }
        if (dayConvert == null) {
            throw new TTException(this, "Unknown generic pattern " + this.getNrMeetings() + " x " + this.getNrHalfHoursPerMeeting() * 25 + ".");
        }
        for (int day = 0; day < this.iDays.length; ++day) {
            for (int time = 0; time < this.iHours.length; ++time) {
                this.iPreferences[day][time] = oldPreferences[dayConvert[day][0]][time];
                for (int i = 1; i < dayConvert[day].length; ++i) {
                    this.iPreferences[day][time] = this.iPreferences[day][time].combine(oldPreferences[dayConvert[day][i]][time]);
                }
            }
        }
    }

    public int[][] getPrologDays() {
        if (this.getNrMeetings() == 4) {
            return new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 4}};
        }
        if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 3) {
            return new int[][]{{0, 1}, {1, 2}};
        }
        if (this.getNrMeetings() == 2 && this.getNrHalfHoursPerMeeting() == 2) {
            return new int[][]{{0, 1, 2, 3}, {1, 2, 3, 4}};
        }
        if (this.getNrMeetings() == 2) {
            return new int[][]{{0, 1, 2}, {2, 3, 4}};
        }
        return null;
    }
}

