/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.prolog;

import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.GroupConstraint;
import edu.purdue.smas.timetable.data.Instructor;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.Room;
import edu.purdue.smas.timetable.data.RoomFeatures;
import edu.purdue.smas.timetable.data.Subjects;
import edu.purdue.smas.timetable.data.TimePatterns;
import edu.purdue.smas.timetable.data.Timetable;
import edu.purdue.smas.timetable.data.TimetableConfig;
import edu.purdue.smas.timetable.data.TimetableVersion;
import edu.purdue.smas.timetable.data.pattern.EveningTimePattern;
import edu.purdue.smas.timetable.data.pattern.GenericTimePattern;
import edu.purdue.smas.timetable.data.pattern.SaturdayTimePattern;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.serverfwk.GeneralTimetableServer;
import edu.purdue.smas.timetable.serverfwk.ParameterDefinition;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class PrologFileReaderWriter {
    public static Vector readTermsFromStream(InputStream is, String term) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Vector<Term> ret = new Vector<Term>();
        while (br.ready()) {
            Term t = PrologFileReaderWriter.readTerm(new SpecialReader(br));
            if (t != null && t.getText() != null && t.getText().startsWith(term)) {
                ret.addElement(t);
            }
            br.readLine();
        }
        br.close();
        return ret;
    }

    public static void writeTerms(PrintWriter pw, Vector terms) throws IOException {
        Enumeration e = terms.elements();
        while (e.hasMoreElements()) {
            Term t = (Term)e.nextElement();
            PrologFileReaderWriter.writeTerm(pw, t);
        }
    }

    private static Term readTerm(SpecialReader is) throws IOException {
        int i;
        StringBuffer text = new StringBuffer();
        Vector<Term> content = null;
        while ((i = is.read()) >= 0) {
            char ch = (char)i;
            if (ch == '(' || ch == '[') {
                content = new Vector<Term>();
                content.addElement(PrologFileReaderWriter.readTerm(is));
                continue;
            }
            if (content == null && (ch == ',' || ch == ')' || ch == ']')) {
                is.flush(ch);
                break;
            }
            if (ch == ',') {
                content.addElement(PrologFileReaderWriter.readTerm(is));
                continue;
            }
            if (ch == ')' || ch == ']') break;
            text.append(ch);
        }
        Term ret = new Term(text.toString().trim(), content);
        return ret;
    }

    private static void writeTerm(PrintWriter pw, Term t) {
        pw.println(t.toString() + ".");
    }

    private static int halfHoursToMinutes(int i) {
        switch (i) {
            case 1: {
                return 30;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 75;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 150;
            }
            case 6: {
                return 150;
            }
            case 7: {
                return 200;
            }
            case 8: {
                return 200;
            }
        }
        return 0;
    }

    public static void loadData(File folder, String schema) throws IOException, TTException {
        System.out.println("Load data from folder '" + folder + "'.");
        PrintWriter out = null;
        Vector room = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(folder.getPath() + File.separator + "room.pl"), "room");
        System.out.println("  Readed " + room.size() + " rooms.");
        out = new PrintWriter(new FileWriter(folder.getPath() + File.separator + "02_room.sql"));
        out.println("delete " + schema + ".ROOM_FEATURE;");
        out.println("delete " + schema + ".ROOM;");
        out.println("delete " + schema + ".BUILDING;");
        out.println("delete " + schema + ".ROOM_FEATURE_DEF;");
        out.println("insert into " + schema + ".ROOM_FEATURE_DEF (FEATURE_ID,NAME,VERSION) values ('audioRecording','Audio Recording',1);");
        out.println("insert into " + schema + ".ROOM_FEATURE_DEF (FEATURE_ID,NAME,VERSION) values ('computerProjection','Computer Projection',1);");
        out.println("insert into " + schema + ".ROOM_FEATURE_DEF (FEATURE_ID,NAME,VERSION) values ('docucam','Docucam',1);");
        out.println("insert into " + schema + ".ROOM_FEATURE_DEF (FEATURE_ID,NAME,VERSION) values ('puccComputer','Computer',1);");
        Vector<String> bldg = new Vector<String>();
        Enumeration e = room.elements();
        while (e.hasMoreElements()) {
            Term t = (Term)e.nextElement();
            if (bldg.indexOf(t.elementAt(0).elementAt(0).getText()) < 0) {
                out.println("insert into " + schema + ".BUILDING (BLDG_ID, ABBV, NAME, VERSION) values ('" + t.elementAt(0).elementAt(0).getText() + "','" + t.elementAt(0).elementAt(0).getText().toUpperCase() + "','" + t.elementAt(0).elementAt(0).getText().toUpperCase() + "',1);");
                bldg.addElement(t.elementAt(0).elementAt(0).getText());
            }
            out.println("insert into " + schema + ".ROOM (ROOM_ID,BLDG_ID,ROOM_NO,CAPACITY,ROOM_ORD,VERSION, X_COORDINATE, Y_COORDINATE) values (" + "'" + t.elementAt(0).elementAt(0).getText() + t.elementAt(0).elementAt(1).getText() + "'," + "'" + t.elementAt(0).elementAt(0).getText() + "','" + t.elementAt(0).elementAt(1).getText().toUpperCase() + "'," + t.elementAt(2).getText() + "," + t.elementAt(1).getText() + ",1);");
            Term f = t.elementAt(3);
            if (f.elementAt(0).toInt() == 1) {
                out.println("insert into " + schema + ".ROOM_FEATURE (ROOM_ID, FEATURE_ID, VERSION) values (" + "'" + t.elementAt(0).elementAt(0).getText() + t.elementAt(0).elementAt(1).getText() + "','computerProjection',1);");
            }
            if (f.elementAt(1).toInt() == 1) {
                out.println("insert into " + schema + ".ROOM_FEATURE (ROOM_ID, FEATURE_ID, VERSION) values (" + "'" + t.elementAt(0).elementAt(0).getText() + t.elementAt(0).elementAt(1).getText() + "','puccComputer',1);");
            }
            if (f.elementAt(2).toInt() == 1) {
                out.println("insert into " + schema + ".ROOM_FEATURE (ROOM_ID, FEATURE_ID, VERSION) values (" + "'" + t.elementAt(0).elementAt(0).getText() + t.elementAt(0).elementAt(1).getText() + "','audioRecording',1);");
            }
            if (f.elementAt(3).toInt() != 1) continue;
            out.println("insert into " + schema + ".ROOM_FEATURE (ROOM_ID, FEATURE_ID, VERSION) values (" + "'" + t.elementAt(0).elementAt(0).getText() + t.elementAt(0).elementAt(1).getText() + "','docucam',1);");
        }
        out.println("commit;");
        out.close();
        room = null;
        bldg = null;
        Vector course = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(folder.getPath() + File.separator + "course.pl"), "csid");
        System.out.println("  Readed " + course.size() + " courses.");
        out = new PrintWriter(new FileWriter(folder.getPath() + File.separator + "03_course.sql"));
        out.println("delete " + schema + ".ALT_TIME_PATTERN_DEF;");
        out.println("delete " + schema + ".PROHIBITED_TIME_PATTERN;");
        out.println("delete " + schema + ".TIME_PATTERN_DEF;");
        out.println("delete " + schema + ".INSTRUCTOR;");
        out.println("delete " + schema + ".CLASS_FEATURE_REQ;");
        out.println("delete " + schema + ".CLASS_ROOM_REQ;");
        out.println("delete " + schema + ".CLASS_BUILDING_REQ;");
        out.println("delete " + schema + ".CLASS_TIME_REQ;");
        out.println("delete " + schema + ".CLASS;");
        out.println("delete " + schema + ".PREFERENCE;");
        Hashtable<String, String> pref = new Hashtable<String, String>();
        Enumeration e2 = Preferences.elements();
        while (e2.hasMoreElements()) {
            Preferences.Preference pr = (Preferences.Preference)e2.nextElement();
            out.println("insert into " + schema + ".PREFERENCE (pref_id, pref_prolog, pref_name) values (" + pr.getId() + ",'" + pr.getProlog() + "','" + pr.getName() + "');");
            pref.put(pr.getProlog(), String.valueOf(pr.getId()));
        }
        Hashtable<String, String> pattern = new Hashtable<String, String>();
        out.println("insert into " + schema + ".TIME_PATTERN_DEF (PATTERN_ID,NBR_MTGS,HALF_HOURS_PER_MTG,MIN_PER_MTG,TYPE,GENERIC) values (" + "1,3,2," + PrologFileReaderWriter.halfHoursToMinutes(2) + ",1,0);");
        out.println("insert into " + schema + ".TIME_PATTERN_DEF (PATTERN_ID,NBR_MTGS,HALF_HOURS_PER_MTG,MIN_PER_MTG,TYPE,GENERIC) values (" + "2,2,3," + PrologFileReaderWriter.halfHoursToMinutes(3) + ",2,0);");
        out.println("insert into " + schema + ".ALT_TIME_PATTERN_DEF (PATTERN_ID,PATTERN_ALT_ID) values (1,2);");
        pattern.put("3x2", "1");
        pattern.put("2x3", "2");
        Vector<String> instr = new Vector<String>();
        int class_id = 0;
        int req_id = 0;
        Vector<String> classIds = new Vector<String>();
        Enumeration e3 = course.elements();
        while (e3.hasMoreElements()) {
            int i;
            Term t = (Term)e3.nextElement();
            Term id = t.elementAt(0);
            String subject = id.elementAt(0).getText().substring(0, 4);
            String courseNbr = id.elementAt(0).getText().substring(4);
            String itype = id.elementAt(1).getText();
            Term generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            int section = id.elementAt(2).toInt();
            Term base = t.elementAt(1);
            int nbrMtgs = base.elementAt(0).toInt();
            if (generic != null) {
                nbrMtgs = 4;
            }
            int halfHours = base.elementAt(1).toInt();
            Term csroom = base.elementAt(2);
            int expCapac = csroom.elementAt(0).toInt();
            String fProjector = (String)pref.get(csroom.elementAt(1).elementAt(0).getText().toUpperCase());
            String fComputer = (String)pref.get(csroom.elementAt(1).elementAt(1).getText().toUpperCase());
            String fRecord = (String)pref.get(csroom.elementAt(1).elementAt(2).getText().toUpperCase());
            String fDocucam = (String)pref.get(csroom.elementAt(1).elementAt(3).getText().toUpperCase());
            String instructor = base.elementAt(3).elementAt(0).getText();
            if (instructor.equals("_")) {
                instructor = null;
            }
            Term faculty = t.elementAt(3);
            Term reqs = faculty.elementAt(0).elementAt(0);
            Term prefs = faculty.elementAt(1).elementAt(0);
            Term rooms = csroom.elementAt(2);
            Term roomReqs = csroom.elementAt(3);
            Term bldgs = csroom.elementAt(4);
            Term bldgReqs = csroom.elementAt(5);
            if (classIds.indexOf("id(" + subject + "," + courseNbr + "," + itype + "," + section + ")") >= 0) {
                System.err.println("Skipping:" + id);
                continue;
            }
            classIds.addElement("id(" + subject + "," + courseNbr + "," + itype + "," + section + ")");
            ++class_id;
            if (instructor != null && instr.indexOf(instructor) < 0) {
                out.println("insert into " + schema + ".INSTRUCTOR (INSTR_UID,FIRST_NAME,MIDDLE_NAME,LAST_NAME,VERSION) values ('" + instructor.substring(0, Math.min(instructor.length(), 10)) + "','','','" + instructor.substring(0, 1).toUpperCase() + instructor.substring(1) + "',1);");
                instr.addElement(instructor);
            }
            if (!pattern.containsKey(nbrMtgs + "x" + halfHours)) {
                out.println("insert into " + schema + ".TIME_PATTERN_DEF (PATTERN_ID,NBR_MTGS,HALF_HOURS_PER_MTG,MIN_PER_MTG,TYPE,GENERIC) values (" + (pattern.size() + 1) + "," + nbrMtgs + "," + halfHours + "," + PrologFileReaderWriter.halfHoursToMinutes(halfHours) + "," + (pattern.size() + 1) + "," + (generic != null ? 1 : 0) + ");");
                pattern.put(nbrMtgs + "x" + halfHours, String.valueOf(pattern.size() + 1));
            }
            out.println("insert into " + schema + ".CLASS (CLASS_ID,SUBJECT,COURSE_NBR,ITYPE,SECTION,TIME_PATTERN_ID,EXPECTED_CAPACITY,INSTR_UID,OWNER_ROLE,START_DATE,END_DATE,VERSION,NONSTANDARD_REQ) values (" + class_id + ",'" + ToolBox.replace(ToolBox.replace(subject, "_", " "), "A", "'||CHR(38)||'").toUpperCase() + "','" + ToolBox.replace(courseNbr, "_", " ").toUpperCase() + "','" + itype + "'," + section + "," + pattern.get(nbrMtgs + "x" + halfHours) + "," + expCapac + "," + (instructor == null ? "NULL" : "'" + instructor.substring(0, Math.min(instructor.length(), 10)) + "'") + ",NULL,NULL,NULL,1,NULL);");
            if (pattern.get(nbrMtgs + "x" + halfHours).equals("1")) {
                out.println("insert into " + schema + ".PROHIBITED_TIME_PATTERN (PATTERN_ID, CLASS_ID, VERSION) values (2," + class_id + ",1);");
            }
            if (pattern.get(nbrMtgs + "x" + halfHours).equals("2")) {
                out.println("insert into " + schema + ".PROHIBITED_TIME_PATTERN (PATTERN_ID, CLASS_ID, VERSION) values (1," + class_id + ",1);");
            }
            if (!fProjector.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'computerProjection'," + fProjector + ",1);");
            }
            if (!fComputer.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'puccComputer'," + fComputer + ",1);");
            }
            if (!fRecord.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'audioRecording'," + fRecord + ",1);");
            }
            if (!fDocucam.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'docucam'," + fDocucam + ",1);");
            }
            if (rooms != null && rooms.elementAt(0).size() > 0) {
                for (i = 0; i < rooms.size(); ++i) {
                    out.println("insert into " + schema + ".CLASS_ROOM_REQ (CLASS_ID,ROOM_ID,PREF_ID,VERSION) values (" + class_id + ",'" + rooms.elementAt(i).elementAt(0).getText() + rooms.elementAt(i).elementAt(1).getText() + "'," + pref.get(roomReqs.elementAt(i).getText().toUpperCase()) + ",1);");
                }
            }
            if (bldgs != null && bldgs.getContent() != null && bldgs.elementAt(0).getText().length() > 0) {
                for (i = 0; i < bldgs.size(); ++i) {
                    out.println("insert into " + schema + ".CLASS_BUILDING_REQ (CLASS_ID,BLDG_ID,PREF_ID,VERSION) values (" + class_id + ",'" + bldgs.elementAt(i).getText() + "'," + pref.get(bldgReqs.elementAt(i).getText().toUpperCase()) + ",1);");
                }
            }
            if (prefs.size() <= 1) {
                System.err.println("No prefs for: " + id);
            }
            if (reqs.size() <= 1 && prefs.size() <= 1) continue;
            StandardTimePattern tpm = generic == null ? new StandardTimePattern(nbrMtgs, halfHours) : new GenericTimePattern(nbrMtgs, halfHours, false);
            for (int j = 0; j < tpm.getNrDays(); ++j) {
                int i2;
                if (j > 0) {
                    t = (Term)e3.nextElement();
                    faculty = t.elementAt(3);
                    reqs = faculty.elementAt(0).elementAt(0);
                    prefs = faculty.elementAt(1).elementAt(0);
                }
                if (prefs.size() > 1) {
                    for (i2 = 0; i2 < prefs.size(); ++i2) {
                        tpm.setPreference(j, i2, Preferences.getPreference(String.valueOf(-prefs.elementAt(i2).toInt())));
                    }
                }
                if (reqs.size() <= 1) continue;
                for (i2 = 0; i2 < reqs.size(); ++i2) {
                    if (reqs.elementAt(i2).toInt() != 0) continue;
                    tpm.setPreference(j, i2, Preferences.getPreference("P"));
                }
            }
            Hashtable timeReqs = new Hashtable();
            tpm.storeTimeRequirements(timeReqs);
            Enumeration tre = timeReqs.keys();
            while (tre.hasMoreElements()) {
                Class.TimeRequirement r = (Class.TimeRequirement)tre.nextElement();
                Preferences.Preference p = (Preferences.Preference)timeReqs.get(r);
                out.println("insert into " + schema + ".CLASS_TIME_REQ (req_id, class_id, days, start_time, end_time, pref_id, version) values (" + ++req_id + "," + class_id + ",'" + r.getDaysStr() + "'," + Database.prepParam(r.getStartTime()) + "," + Database.prepParam(r.getEndTime()) + "," + p.getId() + ",1);");
            }
        }
        out.println("commit;");
        out.close();
        Vector add = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(folder.getPath() + File.separator + "add.pl"), "cbs");
        System.out.println("  Readed " + add.size() + " group constraints.");
        out = new PrintWriter(new FileWriter(folder.getPath() + File.separator + "04_add.sql"));
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_GROUP;");
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_REQ;");
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_REQ_DEF;");
        Hashtable<String, String> constrDef = new Hashtable<String, String>();
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (1,'BTB','back-to-back');");
        constrDef.put("BTB", "1");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (2,'BTB_TIME','back-to-back time');");
        constrDef.put("BTB_TIME", "2");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (3,'SAME_TIME','same time');");
        constrDef.put("SAME_TIME", "3");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (4,'SAME_DAYS','same days');");
        constrDef.put("SAME_DAYS", "4");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (5,'NHB(1)','1 hr between');");
        constrDef.put("NHB(1)", "5");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (6,'NHB(2)','2 hrs between');");
        constrDef.put("NHB(2)", "6");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (7,'NHB(3)','3 hrs between');");
        constrDef.put("NHB(3)", "7");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (8,'NHB(4)','4 hrs between');");
        constrDef.put("NHB(4)", "8");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (9,'NHB(5)','5 hrs between');");
        constrDef.put("NHB(5)", "9");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (10,'NHB(6)','6 hrs between');");
        constrDef.put("NHB(6)", "10");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (11,'NHB(7)','7 hrs between');");
        constrDef.put("NHB(7)", "11");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (12,'NHB(8)','8 hrs between');");
        constrDef.put("NHB(8)", "12");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (13,'DIFF_TIME','different time');");
        constrDef.put("DIFF_TIME", "13");
        int const_id = 0;
        Enumeration e4 = add.elements();
        while (e4.hasMoreElements()) {
            Term t = (Term)e4.nextElement();
            ++const_id;
            String key = t.elementAt(0).getText().toUpperCase();
            if (key.equals("NHB")) {
                key = key + "(" + t.elementAt(0).elementAt(0).getText() + ")";
            }
            if (constrDef.containsKey(key)) {
                out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ (GROUP_ID,REQ_ID,OWNER_ROLE,PREF_ID,VERSION) values (" + const_id + "," + constrDef.get(key) + ",-1,1,1);");
                Term classes = t.elementAt(1);
                for (int i = 0; i < classes.size(); ++i) {
                    String subject = ToolBox.replace(ToolBox.replace(classes.elementAt(i).elementAt(0).getText().substring(0, 4), "_", " "), "A", "'||CHR(38)||'").toUpperCase();
                    String courseNbr = ToolBox.replace(classes.elementAt(i).elementAt(0).getText().substring(4), "_", " ").toUpperCase();
                    String itype = classes.elementAt(i).elementAt(1).getText();
                    int section = classes.elementAt(i).elementAt(2).toInt();
                    out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_GROUP (GROUP_ID,SUBJECT,COURSE_NBR,ITYPE,SECTION,VERSION) values (" + const_id + ",'" + subject + "','" + courseNbr + "','" + itype + "'," + section + ",1);");
                }
                continue;
            }
            System.out.println("unkonwn key: '" + key + "'");
        }
        out.println("commit;");
        out.close();
    }

    private static String toSubject(String subject) {
        String formattedSubject = "";
        if (subject != null && subject.length() > 0) {
            formattedSubject = ToolBox.replace(subject, "_", " ");
            formattedSubject = ToolBox.replace(formattedSubject, "A", "&");
            formattedSubject = formattedSubject.toUpperCase();
        }
        return formattedSubject;
    }

    private static String getClassId(String schema, String subject, String itype, String section, String version) {
        String classId = "";
        String sql = "";
        try {
            sql = "SELECT class_id FROM " + schema + ".CLASS " + "WHERE UPPER(subject)='" + subject.substring(0, subject.length() - 4).trim() + "' " + "  AND UPPER(course_nbr)='" + subject.substring(subject.length() - 4).trim() + "' " + "  AND itype='" + itype + "' " + "  AND section=" + section + "  AND version=" + version;
            long result = Database.executeLong(sql);
            if (result > 0L) {
                classId = "" + result;
            }
        }
        catch (Exception e) {
            Debug.log("Error retrieving class id: " + e.getMessage() + "\nSQL: " + sql);
        }
        return classId;
    }

    private static Vector class2ids(edu.purdue.smas.timetable.data.Class c) throws TTException, SQLException {
        Vector<Term> ids = new Vector<Term>();
        if (c.getTimePattern() != null && c.getTimePatternModel() instanceof GenericTimePattern) {
            for (int i = 1; i <= c.getTimePattern().getNumberOfMeetings(); ++i) {
                Term spec = c.getTimePattern().getNumberOfMeetings() == 4 ? new Term("spec", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting()))}) : new Term("spec", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting())), new Term("ext")});
                Term generic_pattern = new Term("generic_pattern", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(i)), spec});
                Term id = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term(new Term[]{generic_pattern})});
                ids.addElement(id);
            }
        } else {
            Term id = null;
            id = c.getTimePattern() != null && c.getTimePatternModel() instanceof EveningTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,evn]")}) : (c.getTimePattern() != null && c.getTimePatternModel() instanceof SaturdayTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,sat]")}) : new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))}));
            ids.addElement(id);
        }
        return ids;
    }

    public static Vector storeData(File outputFile, long version, boolean expCourse, boolean expAdd, boolean expRoom, boolean expInstructor, boolean expStudent, boolean expJenr, boolean invertTimeReq, boolean addWithGenIds, boolean jenrWithGenIds, boolean expSolution) throws IOException, SQLException, TTException {
        return PrologFileReaderWriter.storeData(outputFile, version, expCourse, expAdd, expRoom, expInstructor, expStudent, expJenr, invertTimeReq, addWithGenIds, jenrWithGenIds, expSolution, null);
    }

    public static Vector storeData(File outputFile, long version, boolean expCourse, boolean expAdd, boolean expRoom, boolean expInstructor, boolean expStudent, boolean expJenr, boolean invertTimeReq, boolean addWithGenIds, boolean jenrWithGenIds, boolean expSolution, String[] info) throws IOException, SQLException, TTException {
        ResultSet rs;
        Statement s;
        Enumeration<Object> e;
        Enumeration e2;
        Enumeration e3;
        Hashtable allTimetable;
        Vector<String> log = new Vector<String>();
        Debug.log("Exporting input data to prolog ...");
        log.addElement("Exporting input data to prolog ...");
        String header1 = "% Large Lecture Room Timetabling";
        String header2 = "% Data:    " + TimetableConfig.get(TimetableConfig.CFG_SEMESTER) + " " + TimetableConfig.get(TimetableConfig.CFG_YEAR) + " v" + version + (TimetableVersion.load(version).isEditable() ? "" : " r/o");
        String header3 = "% Created: " + new SimpleDateFormat(Constants.STARTUP_DATE_FORMAT, Locale.US).format(new Date());
        String header4 = "% File:    ";
        String header5 = "%";
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(outputFile));
        Hashtable allClasses = edu.purdue.smas.timetable.data.Class.loadAllComplete(version, null, null, false, true, true, true, true, true);
        Hashtable allBuilings = Building.loadAllHash(version);
        Vector allRooms = Room.loadAll(version);
        Collections.sort(allRooms, new Room.RoomOrdComparator(allBuilings));
        Hashtable<String, String> allRoomsHash = new Hashtable<String, String>();
        if (expSolution) {
            for (int i = 0; i < allRooms.size(); ++i) {
                allRoomsHash.put(((Room)allRooms.elementAt(i)).getId(), String.valueOf(i + 1));
            }
        }
        Hashtable allInstructors = Instructor.loadAllHash(version);
        Hashtable hashtable = allTimetable = expSolution ? Timetable.loadAllHash(version) : new Hashtable();
        if (expCourse) {
            Debug.log("  Exporting course.pl ...");
            log.addElement("  Exporting course.pl ...");
            if (expSolution && allTimetable.isEmpty()) {
                log.addElement("    Cannot export solution -- no solution assigned to version " + version + ".");
                Debug.warning("    Cannot export solution -- no solution assigned to version " + version + ".");
            }
            Vector allClassesTerms = new Vector();
            Vector<Term> altClassesTerms = new Vector<Term>();
            Vector sameClassesTerms = new Vector();
            Enumeration e4 = ToolBox.sortEnumeration(allClasses.keys(), new Class.ClassComparator(allClasses));
            while (e4.hasMoreElements()) {
                Long classId = (Long)e4.nextElement();
                edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)allClasses.get(classId);
                if (c.getTimePattern() == null) {
                    Debug.warning("    Class " + c + " skipped -- time pattern not assigned.");
                    log.addElement("    Class " + c + " skipped -- time pattern not assigned.");
                    continue;
                }
                Term id = null;
                Term roomProp = new Term(new Term[]{new Term(c.getRequiredRoomFeatures().containsKey(RoomFeatures.getRoomFeature("computerProjection")) ? ((Preferences.Preference)c.getRequiredRoomFeatures().get(RoomFeatures.getRoomFeature("computerProjection"))).getProlog().toLowerCase() : "0"), new Term(c.getRequiredRoomFeatures().containsKey(RoomFeatures.getRoomFeature("puccComputer")) ? ((Preferences.Preference)c.getRequiredRoomFeatures().get(RoomFeatures.getRoomFeature("puccComputer"))).getProlog().toLowerCase() : "0"), new Term(c.getRequiredRoomFeatures().containsKey(RoomFeatures.getRoomFeature("audioRecording")) ? ((Preferences.Preference)c.getRequiredRoomFeatures().get(RoomFeatures.getRoomFeature("audioRecording"))).getProlog().toLowerCase() : "0"), new Term(c.getRequiredRoomFeatures().containsKey(RoomFeatures.getRoomFeature("docucam")) ? ((Preferences.Preference)c.getRequiredRoomFeatures().get(RoomFeatures.getRoomFeature("docucam"))).getProlog().toLowerCase() : "0")});
                Vector<Term> rooms = new Vector<Term>();
                Vector<Term> roomPrefs = new Vector<Term>();
                Enumeration re = c.getRequiredRooms().keys();
                while (re.hasMoreElements()) {
                    Room r = (Room)re.nextElement();
                    Preferences.Preference p = (Preferences.Preference)c.getRequiredRooms().get(r);
                    if (p.getProlog().equals("0")) continue;
                    rooms.addElement(new Term("id", new Term[]{new Term(((Building)allBuilings.get(r.getBldgId())).getABBV().trim().toLowerCase()), new Term(r.getRoomNo().trim().toLowerCase())}));
                    roomPrefs.addElement(new Term(p.getProlog().toLowerCase()));
                }
                Vector<Term> bldgs = new Vector<Term>();
                Vector<Term> bldgPrefs = new Vector<Term>();
                Enumeration be = c.getRequiredBuildings().keys();
                while (be.hasMoreElements()) {
                    Building b = (Building)be.nextElement();
                    Preferences.Preference p = (Preferences.Preference)c.getRequiredBuildings().get(b);
                    if (p.getProlog().equals("0")) continue;
                    bldgs.addElement(new Term(b.getABBV().trim().toLowerCase()));
                    bldgPrefs.addElement(new Term(p.getProlog().toLowerCase()));
                }
                Term csroom = new Term("csroom", new Term[]{new Term(String.valueOf(c.getExpectedCapacity())), roomProp, new Term(rooms), new Term(roomPrefs), new Term(bldgs), new Term(bldgPrefs)});
                TimePatternModel tpm = c.getTimePatternModel(false);
                tpm.loadTimeRequirements(c.getTimeRequirements());
                if (tpm instanceof GenericTimePattern) {
                    int[][] days = ((GenericTimePattern)tpm).getPrologDays();
                    if (days == null) {
                        Debug.log("    Class " + c + " skipped -- unknown or not implemented generic pattern " + c.getTimePattern().getNumberOfMeetings() + " x " + c.getTimePattern().getHalfHoursPerMeeting());
                        log.addElement("    Class " + c + " skipped -- unknown or not implemented generic pattern " + c.getTimePattern().getNumberOfMeetings() + " x " + c.getTimePattern().getHalfHoursPerMeeting());
                        continue;
                    }
                    Vector<Term> ids = new Vector<Term>();
                    for (int i = 1; i <= c.getTimePattern().getNumberOfMeetings(); ++i) {
                        Preferences.Preference p;
                        int t;
                        int d;
                        Term spec = c.getTimePattern().getNumberOfMeetings() == 4 ? new Term("spec", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting()))}) : new Term("spec", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting())), new Term("ext")});
                        Term generic_pattern = new Term("generic_pattern", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(i)), spec});
                        id = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term(new Term[]{generic_pattern})});
                        ids.addElement(id);
                        Term[][] reqs = new Term[days[i - 1].length][tpm.getNrTimes()];
                        Term[][] prefs = new Term[days[i - 1].length][tpm.getNrTimes()];
                        boolean noReqs = true;
                        boolean hasRequired = false;
                        for (d = 0; !hasRequired && d < days[i - 1].length; ++d) {
                            for (t = 0; !hasRequired && t < tpm.getNrTimes(); ++t) {
                                p = tpm.getPreference(days[i - 1][d], t);
                                if (!p.getProlog().equals("R")) continue;
                                hasRequired = true;
                            }
                        }
                        for (d = 0; d < days[i - 1].length; ++d) {
                            for (t = 0; t < tpm.getNrTimes(); ++t) {
                                p = tpm.getPreference(days[i - 1][d], t);
                                if (hasRequired) {
                                    reqs[d][t] = p.getProlog().equals("R") ? new Term("1") : new Term("0");
                                    prefs[d][t] = new Term("0");
                                    noReqs = false;
                                    continue;
                                }
                                if (p.getProlog().equals("P")) {
                                    reqs[d][t] = new Term("0");
                                    prefs[d][t] = new Term("0");
                                    noReqs = false;
                                    continue;
                                }
                                reqs[d][t] = new Term("1");
                                prefs[d][t] = p.getProlog().equals("R") ? new Term("0") : new Term(String.valueOf((invertTimeReq ? -1 : 1) * Integer.parseInt(p.getProlog())));
                            }
                        }
                        Term[] reqsT = new Term[days[i - 1].length];
                        Term[] prefsT = new Term[days[i - 1].length];
                        for (int d2 = 0; d2 < days[i - 1].length; ++d2) {
                            reqsT[d2] = noReqs ? new Term(new Term[0]) : new Term(reqs[d2]);
                            prefsT[d2] = new Term(prefs[d2]);
                        }
                        Term faculty = new Term("faculty", new Term[]{new Term(reqsT), new Term(prefsT)});
                        Term base = new Term("base", new Term[]{new Term("1"), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting())), csroom, new Term("instr", new Term[]{new Term(c.getInstructorId() == null ? "_" : c.getInstructorId())}), PrologFileReaderWriter.deptTerm(c)});
                        Term advice = null;
                        boolean isAlternative = false;
                        if (allTimetable.containsKey(new Long(c.getId()))) {
                            Vector tts = (Vector)allTimetable.get(new Long(c.getId()));
                            System.err.println("id=" + id + ", id=" + c.getId() + ", tt=" + tts);
                            if (c.getTimePattern().getModel().contains(tts)) {
                                Timetable tt = (Timetable)tts.elementAt(i - 1);
                                advice = new Term("advice", new Term[]{new Term("ok"), new Term(new Term[]{new Term(new Term[]{new Term(String.valueOf(tt.getSlot()))})}), new Term("ok"), new Term(new Term[]{new Term(new Term[]{new Term((String)allRoomsHash.get(tt.getRoomId()))})})});
                            } else {
                                isAlternative = true;
                                advice = new Term("_");
                            }
                        } else {
                            advice = expSolution ? new Term("advice", new Term[]{new Term("compute"), new Term(new Term[]{new Term(new Term[0])}), new Term("compute"), new Term(new Term[]{new Term(new Term[0])})}) : new Term("_");
                        }
                        Term csid = new Term("csid", new Term[]{id, base, advice, faculty, new Term("_"), new Term("_")});
                        (isAlternative ? altClassesTerms : allClassesTerms).addElement(csid);
                    }
                } else {
                    Preferences.Preference p;
                    int d;
                    id = tpm instanceof EveningTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,evn]")}) : (tpm instanceof SaturdayTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,sat]")}) : new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))}));
                    Term[][] reqs = new Term[tpm.getNrDays()][tpm.getNrTimes()];
                    Term[][] prefs = new Term[tpm.getNrDays()][tpm.getNrTimes()];
                    boolean noReqs = true;
                    boolean hasRequired = false;
                    for (d = 0; !hasRequired && d < tpm.getNrDays(); ++d) {
                        for (int t = 0; !hasRequired && t < tpm.getNrTimes(); ++t) {
                            p = tpm.getPreference(d, t);
                            if (!p.getProlog().equals("R")) continue;
                            hasRequired = true;
                        }
                    }
                    for (d = 0; d < tpm.getNrDays(); ++d) {
                        for (int t = 0; t < tpm.getNrTimes(); ++t) {
                            p = tpm.getPreference(d, t);
                            if (hasRequired) {
                                reqs[d][t] = p.getProlog().equals("R") ? new Term("1") : new Term("0");
                                prefs[d][t] = new Term("0");
                                noReqs = false;
                                continue;
                            }
                            if (p.getProlog().equals("P")) {
                                reqs[d][t] = new Term("0");
                                prefs[d][t] = new Term("0");
                                noReqs = false;
                                continue;
                            }
                            reqs[d][t] = new Term("1");
                            prefs[d][t] = p.getProlog().equals("R") ? new Term("2") : new Term(String.valueOf((invertTimeReq ? -1 : 1) * Integer.parseInt(p.getProlog())));
                        }
                    }
                    Term[] reqsT = new Term[tpm.getNrDays()];
                    Term[] prefsT = new Term[tpm.getNrDays()];
                    for (int d3 = 0; d3 < tpm.getNrDays(); ++d3) {
                        reqsT[d3] = noReqs ? new Term(new Term[0]) : new Term(reqs[d3]);
                        prefsT[d3] = new Term(prefs[d3]);
                    }
                    Term faculty = new Term("faculty", new Term[]{new Term(reqsT), new Term(prefsT)});
                    Term base = new Term("base", new Term[]{new Term(String.valueOf(c.getTimePattern().getNumberOfMeetings())), new Term(String.valueOf(c.getTimePattern().getHalfHoursPerMeeting())), csroom, new Term("instr", new Term[]{new Term(c.getInstructorId() == null ? "_" : c.getInstructorId())}), PrologFileReaderWriter.deptTerm(c)});
                    Term advice = null;
                    boolean isAlternative = false;
                    if (allTimetable.containsKey(new Long(c.getId()))) {
                        Vector tts = (Vector)allTimetable.get(new Long(c.getId()));
                        if (c.getTimePattern().getModel().contains(tts)) {
                            Vector<Term> adviceTime = new Vector<Term>();
                            Vector<Term> adviceRoom = new Vector<Term>();
                            Enumeration ea = tts.elements();
                            while (ea.hasMoreElements()) {
                                Timetable tt = (Timetable)ea.nextElement();
                                adviceTime.addElement(new Term(new Term[]{new Term(String.valueOf(tt.getSlot()))}));
                                adviceRoom.addElement(new Term(new Term[]{new Term((String)allRoomsHash.get(tt.getRoomId()))}));
                            }
                            advice = new Term("advice", new Term[]{new Term("ok"), new Term(adviceTime), new Term("ok"), new Term(adviceRoom)});
                        } else {
                            advice = new Term("_");
                            isAlternative = true;
                        }
                    } else {
                        advice = expSolution ? new Term("advice", new Term[]{new Term("compute"), new Term(new Term[]{new Term(new Term[0])}), new Term("compute"), new Term(new Term[]{new Term(new Term[0])})}) : new Term("_");
                    }
                    Term csid = new Term("csid", new Term[]{id, base, advice, faculty, new Term("_"), new Term("_")});
                    (isAlternative ? altClassesTerms : allClassesTerms).addElement(csid);
                }
                if (c.getTimePattern() == null || TimePatterns.getAlternativeTimePatterns(c.getTimePattern()) == null) continue;
                Enumeration et = TimePatterns.getAlternativeTimePatterns(c.getTimePattern());
                while (et.hasMoreElements()) {
                    int d;
                    TimePatterns.TimePattern altPattern = (TimePatterns.TimePattern)et.nextElement();
                    if (c.getProhibitedTimePaterns().contains(altPattern)) continue;
                    tpm = TimePatterns.getTimePatternModel(altPattern);
                    tpm.loadTimeRequirements(c.getTimeRequirements());
                    if (tpm instanceof GenericTimePattern) {
                        int[][] days = ((GenericTimePattern)tpm).getPrologDays();
                        if (days == null) {
                            Debug.log("    Alternative class " + c + " skipped -- unknown or not implemented generic pattern " + altPattern.getNumberOfMeetings() + " x " + altPattern.getHalfHoursPerMeeting());
                            log.addElement("    Alternative class " + c + " skipped -- unknown or not implemented generic pattern " + altPattern.getNumberOfMeetings() + " x " + altPattern.getHalfHoursPerMeeting());
                            continue;
                        }
                        Vector<Term> ids = new Vector<Term>();
                        for (int i = 1; i <= altPattern.getNumberOfMeetings(); ++i) {
                            Preferences.Preference p;
                            int d4;
                            Term spec = altPattern.getNumberOfMeetings() == 4 ? new Term("spec", new Term[]{new Term(String.valueOf(altPattern.getNumberOfMeetings())), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting()))}) : new Term("spec", new Term[]{new Term(String.valueOf(altPattern.getNumberOfMeetings())), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting())), new Term("ext")});
                            Term generic_pattern = new Term("generic_pattern", new Term[]{new Term(String.valueOf(altPattern.getNumberOfMeetings())), new Term(String.valueOf(i)), spec});
                            id = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term(new Term[]{generic_pattern})});
                            ids.addElement(id);
                            Term[][] reqs = new Term[days[i - 1].length][tpm.getNrTimes()];
                            Term[][] prefs = new Term[days[i - 1].length][tpm.getNrTimes()];
                            boolean noReqs = true;
                            boolean hasRequired = false;
                            for (d4 = 0; !hasRequired && d4 < days[i - 1].length; ++d4) {
                                for (int t = 0; !hasRequired && t < tpm.getNrTimes(); ++t) {
                                    p = tpm.getPreference(days[i - 1][d4], t);
                                    if (!p.getProlog().equals("R")) continue;
                                    hasRequired = true;
                                }
                            }
                            for (d4 = 0; d4 < days[i - 1].length; ++d4) {
                                for (int t = 0; t < tpm.getNrTimes(); ++t) {
                                    p = tpm.getPreference(days[i - 1][d4], t);
                                    if (hasRequired) {
                                        reqs[d4][t] = p.getProlog().equals("R") ? new Term("1") : new Term("0");
                                        prefs[d4][t] = new Term("0");
                                        noReqs = false;
                                        continue;
                                    }
                                    if (p.getProlog().equals("P")) {
                                        reqs[d4][t] = new Term("0");
                                        prefs[d4][t] = new Term("0");
                                        noReqs = false;
                                        continue;
                                    }
                                    reqs[d4][t] = new Term("1");
                                    prefs[d4][t] = p.getProlog().equals("R") ? new Term("2") : new Term(String.valueOf((invertTimeReq ? -1 : 1) * Integer.parseInt(p.getProlog())));
                                }
                            }
                            Term[] reqsT = new Term[days[i - 1].length];
                            Term[] prefsT = new Term[days[i - 1].length];
                            for (int d5 = 0; d5 < days[i - 1].length; ++d5) {
                                reqsT[d5] = noReqs ? new Term(new Term[0]) : new Term(reqs[d5]);
                                prefsT[d5] = new Term(prefs[d5]);
                            }
                            Term faculty = new Term("faculty", new Term[]{new Term(reqsT), new Term(prefsT)});
                            Term xbase = new Term("base", new Term[]{new Term("1"), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting())), new Term("_"), new Term("_")});
                            Term base = new Term("base", new Term[]{new Term("1"), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting())), csroom, new Term("instr", new Term[]{new Term(c.getInstructorId() == null ? "_" : c.getInstructorId())}), PrologFileReaderWriter.deptTerm(c)});
                            Term advice = null;
                            boolean isAlternative = true;
                            if (allTimetable.containsKey(new Long(c.getId()))) {
                                Vector tts = (Vector)allTimetable.get(new Long(c.getId()));
                                System.err.println("id=" + id + ", id=" + c.getId() + ", tt=" + tts);
                                if (altPattern.getModel().contains(tts)) {
                                    Timetable tt = (Timetable)tts.elementAt(i - 1);
                                    advice = new Term("advice", new Term[]{new Term("ok"), new Term(new Term[]{new Term(new Term[]{new Term(String.valueOf(tt.getSlot()))})}), new Term("ok"), new Term(new Term[]{new Term(new Term[]{new Term((String)allRoomsHash.get(tt.getRoomId()))})})});
                                    isAlternative = false;
                                } else {
                                    advice = new Term("_");
                                }
                            } else {
                                advice = expSolution ? new Term("advice", new Term[]{new Term("compute"), new Term(new Term[]{new Term(new Term[0])}), new Term("compute"), new Term(new Term[]{new Term(new Term[0])})}) : new Term("_");
                            }
                            Term csid = new Term("csid", new Term[]{id, base, advice, faculty, new Term("_"), new Term("_")});
                            (isAlternative ? altClassesTerms : allClassesTerms).addElement(csid);
                        }
                        continue;
                    }
                    id = tpm instanceof EveningTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,evn]")}) : (tpm instanceof SaturdayTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,sat]")}) : new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))}));
                    Term[][] reqs = new Term[tpm.getNrDays()][tpm.getNrTimes()];
                    Term[][] prefs = new Term[tpm.getNrDays()][tpm.getNrTimes()];
                    boolean noReqs = true;
                    boolean hasRequired = false;
                    for (d = 0; !hasRequired && d < tpm.getNrDays(); ++d) {
                        for (int t = 0; !hasRequired && t < tpm.getNrTimes(); ++t) {
                            Preferences.Preference p = tpm.getPreference(d, t);
                            if (!p.getProlog().equals("R")) continue;
                            hasRequired = true;
                        }
                    }
                    for (d = 0; d < tpm.getNrDays(); ++d) {
                        for (int t = 0; t < tpm.getNrTimes(); ++t) {
                            Preferences.Preference p = tpm.getPreference(d, t);
                            if (hasRequired) {
                                reqs[d][t] = p.getProlog().equals("R") ? new Term("1") : new Term("0");
                                prefs[d][t] = new Term("0");
                                noReqs = false;
                                continue;
                            }
                            if (p.getProlog().equals("P")) {
                                reqs[d][t] = new Term("0");
                                prefs[d][t] = new Term("0");
                                noReqs = false;
                                continue;
                            }
                            reqs[d][t] = new Term("1");
                            prefs[d][t] = p.getProlog().equals("R") ? new Term("2") : new Term(String.valueOf((invertTimeReq ? -1 : 1) * Integer.parseInt(p.getProlog())));
                        }
                    }
                    Term[] reqsT = new Term[tpm.getNrDays()];
                    Term[] prefsT = new Term[tpm.getNrDays()];
                    for (int d6 = 0; d6 < tpm.getNrDays(); ++d6) {
                        reqsT[d6] = noReqs ? new Term(new Term[0]) : new Term(reqs[d6]);
                        prefsT[d6] = new Term(prefs[d6]);
                    }
                    Term faculty = new Term("faculty", new Term[]{new Term(reqsT), new Term(prefsT)});
                    Term base = new Term("base", new Term[]{new Term(String.valueOf(altPattern.getNumberOfMeetings())), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting())), csroom, new Term("instr", new Term[]{new Term(c.getInstructorId() == null ? "_" : c.getInstructorId())}), PrologFileReaderWriter.deptTerm(c)});
                    Term xbase = new Term("base", new Term[]{new Term(String.valueOf(altPattern.getNumberOfMeetings())), new Term(String.valueOf(altPattern.getHalfHoursPerMeeting())), new Term("_"), new Term("_")});
                    Term advice = null;
                    boolean isAlternative = true;
                    if (allTimetable.containsKey(new Long(c.getId()))) {
                        Vector tts = (Vector)allTimetable.get(new Long(c.getId()));
                        if (altPattern.getModel().contains(tts)) {
                            Vector<Term> adviceTime = new Vector<Term>();
                            Vector<Term> adviceRoom = new Vector<Term>();
                            Enumeration ea = tts.elements();
                            while (ea.hasMoreElements()) {
                                Timetable tt = (Timetable)ea.nextElement();
                                adviceTime.addElement(new Term(new Term[]{new Term(String.valueOf(tt.getSlot()))}));
                                adviceRoom.addElement(new Term(new Term[]{new Term((String)allRoomsHash.get(tt.getRoomId()))}));
                            }
                            advice = new Term("advice", new Term[]{new Term("ok"), new Term(adviceTime), new Term("ok"), new Term(adviceRoom)});
                            isAlternative = false;
                        } else {
                            advice = new Term("_");
                        }
                    } else {
                        advice = expSolution ? new Term("advice", new Term[]{new Term("compute"), new Term(new Term[]{new Term(new Term[0])}), new Term("compute"), new Term(new Term[]{new Term(new Term[0])})}) : new Term("_");
                    }
                    Term csid = new Term("csid", new Term[]{id, base, advice, faculty, new Term("_"), new Term("_")});
                    (isAlternative ? altClassesTerms : allClassesTerms).addElement(csid);
                }
            }
            zip.putNextEntry(new ZipEntry("course.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "course.pl");
            pw.println(header5);
            if (invertTimeReq) {
                pw.println("% Remark: Preferences in the time preference matrix inverted.");
                pw.println("%");
            }
            if (info != null) {
                for (int i = 0; i < info.length; ++i) {
                    pw.println("% " + info[i]);
                }
            }
            if (expSolution) {
                Hashtable globalInfo = Timetable.loadGlobalInfo(version);
                if (globalInfo != null && !globalInfo.isEmpty()) {
                    pw.println("% Solution Info");
                    e3 = ToolBox.sortEnumeration(globalInfo.keys());
                    while (e3.hasMoreElements()) {
                        String key = (String)e3.nextElement();
                        String val = (String)globalInfo.get(key);
                        pw.println("%   " + key + ": " + ToolBox.replace(val, "<br>", ", "));
                    }
                    pw.println("%");
                }
                Hashtable solverParams = Timetable.loadSolverParams(version);
                Vector<ParameterDefinition> paramNames = new Vector<ParameterDefinition>();
                try {
                    Class<?> serverClass = Class.forName(Config.get("LS_SOLVER_CLASS", "ttsolver.TimetableServer"));
                    paramNames.addAll(((GeneralTimetableServer)serverClass.getConstructor(new Class[0]).newInstance(new Object[0])).getParams());
                }
                catch (Exception e5) {
                    Debug.error(e5);
                }
                paramNames.addElement(new ParameterDefinition("General", "VERSION", "Source Version", 2, "Unknown"));
                if (solverParams != null && !solverParams.isEmpty()) {
                    pw.println("% Solver Parameters");
                    e2 = ToolBox.sortEnumeration(solverParams.keys());
                    while (e2.hasMoreElements()) {
                        String key = (String)e2.nextElement();
                        String name = null;
                        String cat = null;
                        boolean show = true;
                        Iterator i = paramNames.iterator();
                        while (i.hasNext()) {
                            ParameterDefinition def = (ParameterDefinition)i.next();
                            if (!def.getName().equals(key)) continue;
                            name = def.getDescription();
                            cat = def.getCategory();
                            if (def.getDependencies() == null) continue;
                            Iterator i2 = def.getDependencies().iterator();
                            while (show && i2.hasNext()) {
                                ParameterDefinition.Dependency dep = (ParameterDefinition.Dependency)i2.next();
                                if (!solverParams.containsKey(dep.getParameterName()) || solverParams.get(dep.getParameterName()).equals(dep.getParameterValue())) continue;
                                show = false;
                            }
                        }
                        String val = (String)solverParams.get(key);
                        if (!show) continue;
                        pw.println("%   " + (cat == null ? "" : cat + ": ") + (name == null ? key : name) + ": " + val);
                    }
                    pw.println("%");
                }
            }
            PrologFileReaderWriter.writeTerms(pw, allClassesTerms);
            Debug.log("    course.pl: " + allClassesTerms.size() + " terms stored.");
            log.addElement("    course.pl: " + allClassesTerms.size() + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
            zip.putNextEntry(new ZipEntry("altcourse.pl"));
            pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "altcourse.pl");
            pw.println(header5);
            if (invertTimeReq) {
                pw.println("% Remark: Preferences in the time preference matrix inverted.");
                pw.println("%");
            }
            PrologFileReaderWriter.writeTerms(pw, altClassesTerms);
            Debug.log("    altcourse.pl: " + altClassesTerms.size() + " terms stored.");
            log.addElement("    altcourse.pl: " + altClassesTerms.size() + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        if (expAdd) {
            Enumeration ide;
            Debug.log("  Exporting add.pl ...");
            log.addElement("  Exporting add.pl ...");
            Vector<Term> addTerms = new Vector<Term>();
            Hashtable diffTimes = new Hashtable();
            Hashtable sameTimes = new Hashtable();
            Vector allConstraints = GroupConstraint.loadAll(version);
            Enumeration e6 = allConstraints.elements();
            while (e6.hasMoreElements()) {
                GroupConstraint gc = (GroupConstraint)e6.nextElement();
                if (gc.getPreference().getProlog().equals("0")) continue;
                Vector ids = new Vector();
                ids.addElement(new Vector());
                Enumeration ce = gc.getClasses().elements();
                while (ce.hasMoreElements()) {
                    Vector<edu.purdue.smas.timetable.data.Class> sameTimeClasses;
                    edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                    if (addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof GenericTimePattern) {
                        Vector classids = PrologFileReaderWriter.class2ids(c);
                        Vector<Vector> newids = new Vector<Vector>();
                        Enumeration ide2 = ids.elements();
                        while (ide2.hasMoreElements()) {
                            Vector idselem = (Vector)ide2.nextElement();
                            Enumeration ie = classids.elements();
                            while (ie.hasMoreElements()) {
                                Vector newidselem = (Vector)idselem.clone();
                                newidselem.addElement(ie.nextElement());
                                newids.addElement(newidselem);
                            }
                        }
                        ids = newids;
                    } else {
                        Term id = null;
                        id = addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof EveningTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,evn]")}) : (addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof SaturdayTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,sat]")}) : new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))}));
                        ide = ids.elements();
                        while (ide.hasMoreElements()) {
                            Vector idselem = (Vector)ide.nextElement();
                            idselem.addElement(id);
                        }
                    }
                    if (!gc.getConstraintType().getType().equalsIgnoreCase("same_time")) continue;
                    Vector<edu.purdue.smas.timetable.data.Class> vector = sameTimeClasses = sameTimes.containsKey(new Long(c.getId())) ? (Vector<edu.purdue.smas.timetable.data.Class>)sameTimes.get(new Long(c.getId())) : null;
                    if (sameTimeClasses == null) {
                        sameTimeClasses = new Vector<edu.purdue.smas.timetable.data.Class>();
                        sameTimes.put(new Long(c.getId()), sameTimeClasses);
                    }
                    Enumeration cce = gc.getClasses().elements();
                    while (cce.hasMoreElements()) {
                        edu.purdue.smas.timetable.data.Class cc = (edu.purdue.smas.timetable.data.Class)cce.nextElement();
                        if (c.equals(cc)) continue;
                        sameTimeClasses.addElement(cc);
                    }
                }
                Enumeration ide3 = ids.elements();
                while (ide3.hasMoreElements()) {
                    Vector idselem = (Vector)ide3.nextElement();
                    Term cbs = new Term("cbs", new Term[]{new Term(gc.getConstraintType().getType().trim().toLowerCase()), new Term(idselem)});
                    addTerms.addElement(new Term("cbs", new Term[]{new Term(gc.getConstraintType().getType().trim().toLowerCase()), new Term(idselem), new Term(gc.getPreference().getProlog().toLowerCase())}));
                }
            }
            e6 = ToolBox.sortEnumeration(allClasses.keys(), new Class.ClassComparator(allClasses));
            while (e6.hasMoreElements()) {
                Long classId = (Long)e6.nextElement();
                edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)allClasses.get(classId);
                if (c.getTimePattern() == null || !(c.getTimePatternModel() instanceof GenericTimePattern)) continue;
                Vector ids = PrologFileReaderWriter.class2ids(c);
                addTerms.addElement(new Term("cbs", new Term[]{new Term("generic_pattern"), new Term(ids), new Term(Preferences.getPreference("R").getProlog().toLowerCase())}));
            }
            Vector allClassesVec = new Vector();
            e3 = allClasses.elements();
            while (e3.hasMoreElements()) {
                allClassesVec.addElement(e3.nextElement());
            }
            Hashtable sameSubjectCourseITypeSection = edu.purdue.smas.timetable.data.Class.createHashSameSubjectCourseITypeClass(allClassesVec);
            Vector<Vector> diffTimeConstraints = new Vector<Vector>();
            Enumeration subjectEn = sameSubjectCourseITypeSection.keys();
            while (subjectEn.hasMoreElements()) {
                String subject = (String)subjectEn.nextElement();
                Hashtable sameCourseITypeSection = (Hashtable)sameSubjectCourseITypeSection.get(subject);
                Enumeration courseNbrEn = sameCourseITypeSection.keys();
                while (courseNbrEn.hasMoreElements()) {
                    String itype;
                    String courseNumber = (String)courseNbrEn.nextElement();
                    Hashtable sameITypeSection = (Hashtable)sameCourseITypeSection.get(courseNumber);
                    Vector moreThanOne = new Vector();
                    Enumeration itypeEn = sameITypeSection.keys();
                    while (itypeEn.hasMoreElements()) {
                        itype = (String)itypeEn.nextElement();
                        Vector sameSection = (Vector)sameITypeSection.get(itype);
                        if (sameSection.size() <= 1) continue;
                        moreThanOne.addElement(sameSection);
                    }
                    if (moreThanOne.size() == 0) {
                        moreThanOne.addElement(new Vector());
                    }
                    itypeEn = sameITypeSection.keys();
                    while (itypeEn.hasMoreElements()) {
                        itype = (String)itypeEn.nextElement();
                        Vector sameSection = (Vector)sameITypeSection.get(itype);
                        if (sameSection.size() != 1) continue;
                        edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)sameSection.elementAt(0);
                        Enumeration e7 = moreThanOne.elements();
                        while (e7.hasMoreElements()) {
                            ((Vector)e7.nextElement()).addElement(c);
                        }
                    }
                    if (moreThanOne.size() <= 1 && ((Vector)moreThanOne.elementAt(0)).size() <= 1) continue;
                    Enumeration e8 = moreThanOne.elements();
                    while (e8.hasMoreElements()) {
                        Vector classes = (Vector)e8.nextElement();
                        boolean noConflict = true;
                        Enumeration ce = classes.elements();
                        while (noConflict && ce.hasMoreElements()) {
                            edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                            if (!sameTimes.containsKey(new Long(c.getId()))) continue;
                            Vector sameTimeClasses = (Vector)sameTimes.get(new Long(c.getId()));
                            Enumeration ce2 = classes.elements();
                            while (noConflict && ce2.hasMoreElements()) {
                                edu.purdue.smas.timetable.data.Class c2 = (edu.purdue.smas.timetable.data.Class)ce2.nextElement();
                                if (sameTimeClasses.indexOf(c2) < 0) continue;
                                noConflict = false;
                                Vector<edu.purdue.smas.timetable.data.Class> conflictSameTime = new Vector<edu.purdue.smas.timetable.data.Class>();
                                conflictSameTime.addElement(c);
                                Enumeration ce3 = sameTimeClasses.elements();
                                while (ce3.hasMoreElements()) {
                                    conflictSameTime.addElement((edu.purdue.smas.timetable.data.Class)ce3.nextElement());
                                }
                                Debug.log("    Cannot put diff time constraint between classes " + classes + " -- in conflict with same time constraint on classes " + conflictSameTime + ".");
                                log.addElement("    Cannot put diff time constraint between classes " + classes + " -- in conflict with same time constraint on classes " + conflictSameTime + ".");
                            }
                        }
                        if (!noConflict) continue;
                        diffTimeConstraints.addElement(classes);
                    }
                }
            }
            e2 = diffTimeConstraints.elements();
            while (e2.hasMoreElements()) {
                Vector gcclasses = (Vector)e2.nextElement();
                Vector ids = new Vector();
                ids.addElement(new Vector());
                Enumeration ce = gcclasses.elements();
                while (ce.hasMoreElements()) {
                    edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                    if (addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof GenericTimePattern) {
                        Vector classids = PrologFileReaderWriter.class2ids(c);
                        Vector<Vector> newids = new Vector<Vector>();
                        Enumeration ide4 = ids.elements();
                        while (ide4.hasMoreElements()) {
                            Vector idselem = (Vector)ide4.nextElement();
                            Enumeration ie = classids.elements();
                            while (ie.hasMoreElements()) {
                                Vector newidselem = (Vector)idselem.clone();
                                newidselem.addElement(ie.nextElement());
                                newids.addElement(newidselem);
                            }
                        }
                        ids = newids;
                        continue;
                    }
                    Term id = null;
                    id = addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof EveningTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,evn]")}) : (addWithGenIds && c.getTimePattern() != null && c.getTimePatternModel() instanceof SaturdayTimePattern ? new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection())), new Term("[standard,sat]")}) : new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))}));
                    Enumeration ide5 = ids.elements();
                    while (ide5.hasMoreElements()) {
                        Vector idselem = (Vector)ide5.nextElement();
                        idselem.addElement(id);
                    }
                }
                ide = ids.elements();
                while (ide.hasMoreElements()) {
                    Vector idselem = (Vector)ide.nextElement();
                    Term cbs = new Term("cbs", new Term[]{new Term("diff_time"), new Term(idselem), new Term(Preferences.getPreference("R").getProlog().toLowerCase())});
                    addTerms.addElement(cbs);
                }
            }
            zip.putNextEntry(new ZipEntry("add.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "add.pl");
            pw.println(header5);
            if (addWithGenIds) {
                pw.println("% Remark: Generic ids in group constraints used.");
                pw.println("%");
            }
            pw.println(":- discontiguous cbs/2.");
            pw.println(":- dynamic cbs/2.");
            PrologFileReaderWriter.writeTerms(pw, addTerms);
            Debug.log("    add.pl: " + addTerms.size() + " terms stored.");
            log.addElement("    add.pl: " + addTerms.size() + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        if (expRoom) {
            Debug.log("  Exporting room.pl ...");
            log.addElement("  Exporting room.pl ...");
            int roomOrd = 0;
            Vector<Term> roomTerms = new Vector<Term>();
            Enumeration e9 = allRooms.elements();
            while (e9.hasMoreElements()) {
                Room r = (Room)e9.nextElement();
                Term id = new Term("id", new Term[]{new Term(((Building)allBuilings.get(r.getBldgId())).getABBV().trim().toLowerCase()), new Term(r.getRoomNo().trim().toLowerCase())});
                Term features = new Term(new Term[]{new Term(r.getFeatures().indexOf(RoomFeatures.getRoomFeature("computerProjection")) < 0 ? "0" : "1"), new Term(r.getFeatures().indexOf(RoomFeatures.getRoomFeature("puccComputer")) < 0 ? "0" : "1"), new Term(r.getFeatures().indexOf(RoomFeatures.getRoomFeature("audioRecording")) < 0 ? "0" : "1"), new Term(r.getFeatures().indexOf(RoomFeatures.getRoomFeature("docucam")) < 0 ? "0" : "1")});
                Term room = new Term("room", new Term[]{id, new Term(String.valueOf(++roomOrd)), new Term(String.valueOf(r.getCapacity())), features, new Term("_"), new Term("location", new Term[]{new Term(String.valueOf(r.getXCoordinate())), new Term(String.valueOf(r.getYCoordinate()))})});
                roomTerms.addElement(room);
            }
            zip.putNextEntry(new ZipEntry("room.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "room.pl");
            pw.println(header5);
            PrologFileReaderWriter.writeTerms(pw, roomTerms);
            Debug.log("    room.pl: " + roomTerms.size() + " terms stored.");
            log.addElement("    room.pl: " + roomTerms.size() + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        if (expInstructor) {
            Debug.log("  Exporting instructor.pl ...");
            log.addElement("  Exporting instructor.pl ...");
            Vector<Term> instructorTerms = new Vector<Term>();
            e = allInstructors.elements();
            while (e.hasMoreElements()) {
                Instructor i = (Instructor)e.nextElement();
                instructorTerms.addElement(new Term("instructor", new Term[]{new Term(i.getId()), new Term(i.getNameAsProlog())}));
            }
            zip.putNextEntry(new ZipEntry("instructor.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "instructor.pl");
            pw.println(header5);
            PrologFileReaderWriter.writeTerms(pw, instructorTerms);
            Debug.log("    instructor.pl: " + instructorTerms.size() + " terms stored.");
            log.addElement("    instructor.pl: " + instructorTerms.size() + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        if (expStudent) {
            Debug.log("  Exporting student.pl ...");
            log.addElement("  Exporting student.pl ...");
            zip.putNextEntry(new ZipEntry("student.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "student.pl");
            pw.println(header5);
            s = Database.execute("select c.CLASS_ID, s.STUDENT_ID from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT s, " + Config.get("SQL_SCHEMA") + ".CLASS c where s.VERSION=" + Database.prepParam(version) + " AND " + "c.VERSION=s.VERSION AND c.SUBJECT=s.SUBJECT AND c.COURSE_NBR=s.COURSE_NBR and c.ITYPE=s.ITYPE and c.SECTION=s.SECTION " + "order by s.SUBJECT, s.COURSE_NBR, s.ITYPE, s.SECTION, s.STUDENT_ID");
            int cntStudents = 0;
            while (s.getResultSet().next()) {
                rs = s.getResultSet();
                edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)allClasses.get(new Long(rs.getLong("CLASS_ID")));
                Term id = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c.getIType()), new Term(String.valueOf(c.getSection()))});
                Term student = new Term("student", new Term[]{id, new Term(rs.getString("STUDENT_ID"))});
                PrologFileReaderWriter.writeTerm(pw, student);
                ++cntStudents;
            }
            s.close();
            Debug.log("    student.pl: " + cntStudents + " terms stored.");
            log.addElement("    student.pl: " + cntStudents + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        if (expJenr) {
            Debug.log("  Exporting jenr.pl ...");
            log.addElement("  Exporting jenr.pl ...");
            zip.putNextEntry(new ZipEntry("jenr.pl"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
            pw.println(header1);
            pw.println(header2);
            pw.println(header3);
            pw.println(header4 + "jenr.pl");
            pw.println(header5);
            if (jenrWithGenIds) {
                pw.println("% Remark: Generic ids in joint enrollments used.");
                pw.println("%");
            }
            pw.println(":- discontiguous jenr/3.");
            pw.println(":- dynamic jenr/3.");
            s = Database.execute("SELECT c1.CLASS_ID AS CLASS_ID_1, c2.CLASS_ID AS CLASS_ID_2, j.JOINT_ENRL FROM (   SELECT   s1.subject AS subject_1, s1.course_nbr AS course_nbr_1,              s1.itype AS itype_1, s1.section AS section_1,              s2.subject AS subject_2, s2.course_nbr AS course_nbr_2,              s2.itype AS itype_2, s2.section AS section_2,              count(*) AS joint_enrl, s1.version     FROM     " + Config.get("SQL_SCHEMA") + ".student_enrollment s1, " + Config.get("SQL_SCHEMA") + ".student_enrollment s2 " + "    WHERE    s1.student_id=s2.student_id AND s1.version=s2.version AND s1.version=" + Database.prepParam(version) + " " + "    GROUP BY s1.subject, s1.course_nbr, s1.itype, s1.section, " + "             s2.subject, s2.course_nbr, s2.itype, s2.section, s1.version " + ") j, " + Config.get("SQL_SCHEMA") + ".class c1, " + Config.get("SQL_SCHEMA") + ".class c2 " + "     WHERE   c1.SUBJECT=j.SUBJECT_1 AND c1.COURSE_NBR=j.COURSE_NBR_1 AND c1.ITYPE=j.ITYPE_1 AND c1.SECTION=j.SECTION_1 AND c1.VERSION=j.VERSION AND " + "             c2.SUBJECT=j.SUBJECT_2 AND c2.COURSE_NBR=j.COURSE_NBR_2 AND c2.ITYPE=j.ITYPE_2 AND c2.SECTION=j.SECTION_2 AND c2.VERSION=j.VERSION AND " + "             (c1.SUBJECT<c2.SUBJECT OR (c1.SUBJECT=c2.SUBJECT AND c1.COURSE_NBR<c2.COURSE_NBR) OR " + "             (c1.SUBJECT=c2.SUBJECT AND c1.COURSE_NBR=c2.COURSE_NBR AND c1.ITYPE<c2.ITYPE) OR " + "             (c1.SUBJECT=c2.SUBJECT AND c1.COURSE_NBR=c2.COURSE_NBR AND c1.ITYPE=c2.ITYPE AND c1.SECTION<c2.SECTION)) " + "     ORDER BY c1.SUBJECT, c1.COURSE_NBR, c1.ITYPE, c1.SECTION, c2.SUBJECT, c2.COURSE_NBR, c2.ITYPE, c2.SECTION ");
            int cntJENR = 0;
            while (s.getResultSet().next()) {
                rs = s.getResultSet();
                edu.purdue.smas.timetable.data.Class c1 = (edu.purdue.smas.timetable.data.Class)allClasses.get(new Long(rs.getLong("CLASS_ID_1")));
                edu.purdue.smas.timetable.data.Class c2 = (edu.purdue.smas.timetable.data.Class)allClasses.get(new Long(rs.getLong("CLASS_ID_2")));
                if (jenrWithGenIds) {
                    Vector ids1 = PrologFileReaderWriter.class2ids(c1);
                    Vector ids2 = PrologFileReaderWriter.class2ids(c2);
                    Enumeration e1 = ids1.elements();
                    while (e1.hasMoreElements()) {
                        Term id1 = (Term)e1.nextElement();
                        Enumeration e22 = ids2.elements();
                        while (e22.hasMoreElements()) {
                            Term id2 = (Term)e22.nextElement();
                            Term student = new Term("jenr", new Term[]{id1, id2, new Term(rs.getString("JOINT_ENRL"))});
                            PrologFileReaderWriter.writeTerm(pw, student);
                            ++cntJENR;
                        }
                    }
                    continue;
                }
                Term id1 = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c1.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c1.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c1.getIType()), new Term(String.valueOf(c1.getSection()))});
                Term id2 = new Term("id", new Term[]{new Term(ToolBox.replace(ToolBox.replace(c2.getSubject().toLowerCase() + ToolBox.expand(String.valueOf(c2.getCourseNumber()).toLowerCase(), 4, '_', false), "&", "A"), " ", "_")), new Term(c2.getIType()), new Term(String.valueOf(c2.getSection()))});
                Term student = new Term("jenr", new Term[]{id1, id2, new Term(rs.getString("JOINT_ENRL"))});
                PrologFileReaderWriter.writeTerm(pw, student);
                ++cntJENR;
            }
            s.close();
            Debug.log("    jenr.pl: " + cntJENR + " terms stored.");
            log.addElement("    jenr.pl: " + cntJENR + " terms stored.");
            pw.println("% end of file.");
            pw.flush();
            zip.closeEntry();
        }
        log.addElement("Export is done.");
        zip.putNextEntry(new ZipEntry("export.log"));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(zip));
        e = log.elements();
        while (e.hasMoreElements()) {
            pw.println(e.nextElement());
        }
        pw.flush();
        zip.closeEntry();
        zip.close();
        Debug.log("Export is done.");
        return log;
    }

    public static void importSolution(File solutionFile, File reportDataFile, long version) throws IOException, TTException, SQLException {
        Vector solution = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(solutionFile), "solution");
        System.out.println("  Readed " + solution.size() + " solutions.");
        Hashtable allClasses = edu.purdue.smas.timetable.data.Class.loadAllComplete(version, null, null, false, false, false, false, false, false);
        Vector allClassesVec = new Vector();
        Hashtable allBuilings = Building.loadAllHash(version);
        Vector allRooms = Room.loadAll(version);
        Collections.sort(allRooms, new Room.RoomOrdComparator(allBuilings));
        Hashtable allRoomsHash = new Hashtable();
        for (int i = 0; i < allRooms.size(); ++i) {
            allRoomsHash.put(new Integer(i + 1), allRooms.elementAt(i));
        }
        Enumeration e = allClasses.elements();
        while (e.hasMoreElements()) {
            allClassesVec.addElement(e.nextElement());
        }
        Hashtable sameSubjectCourseITypeSection = edu.purdue.smas.timetable.data.Class.createHashSameSubjectCourseITypeClass(allClassesVec);
        Timetable.deleteAll(version);
        Hashtable allTimetablesHash = new Hashtable();
        Enumeration e2 = solution.elements();
        while (e2.hasMoreElements()) {
            Term generic;
            Term t = (Term)e2.nextElement();
            Term id = t.elementAt(0);
            Term base = t.elementAt(1);
            Term advice = t.elementAt(2);
            int nbrMtgs = base.elementAt(0).toInt();
            int halfHours = base.elementAt(1).toInt();
            Term term = generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            if (generic != null) {
                nbrMtgs = Integer.parseInt(generic.elementAt(0).getText());
            }
            if (!advice.elementAt(0).getText().equals("ok") || !advice.elementAt(2).getText().equals("ok")) continue;
            Term slots = advice.elementAt(1);
            Term rooms = advice.elementAt(3);
            String subject = ToolBox.replace(ToolBox.replace(id.elementAt(0).getText().substring(0, 4), "_", " "), "A", "&").toUpperCase();
            String courseNbr = ToolBox.replace(id.elementAt(0).getText().substring(4), "_", " ").toUpperCase();
            String itype = id.elementAt(1).getText();
            int section = id.elementAt(2).toInt();
            Hashtable sameCourseITypeSection = (Hashtable)sameSubjectCourseITypeSection.get(subject);
            if (sameCourseITypeSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            Hashtable sameITypeSection = (Hashtable)sameCourseITypeSection.get(courseNbr);
            if (sameITypeSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            Vector sameSection = (Vector)sameITypeSection.get(itype);
            if (sameSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            edu.purdue.smas.timetable.data.Class c = null;
            Enumeration ce = sameSection.elements();
            while (c == null && ce.hasMoreElements()) {
                edu.purdue.smas.timetable.data.Class x = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                if (x.getSection() != section) continue;
                c = x;
            }
            if (c == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            System.err.println("id=" + id + ", rooms=" + rooms + ", slots=" + slots);
            for (int i = 0; i < nbrMtgs; ++i) {
                Vector<Timetable> timetables;
                Timetable timetable = new Timetable(c, i);
                timetable.setHalfHoursPerMtg(halfHours);
                if (generic != null) {
                    if (i > 0) {
                        t = (Term)e2.nextElement();
                        advice = t.elementAt(2);
                        slots = advice.elementAt(1);
                        rooms = advice.elementAt(3);
                    }
                    timetable.setRoom((Room)allRoomsHash.get(Integer.valueOf(rooms.elementAt(0).elementAt(0).getText())));
                    timetable.setSlot(Integer.parseInt(slots.elementAt(0).elementAt(0).getText()));
                } else {
                    timetable.setRoom((Room)allRoomsHash.get(Integer.valueOf(rooms.elementAt(i).elementAt(0).getText())));
                    timetable.setSlot(Integer.parseInt(slots.elementAt(i).elementAt(0).getText()));
                }
                timetable.save();
                Vector<Timetable> vector = timetables = allTimetablesHash.containsKey(new Long(timetable.getClassId())) ? (Vector)allTimetablesHash.get(new Long(timetable.getClassId())) : null;
                if (timetables == null) {
                    timetables = new Vector<Timetable>();
                    allTimetablesHash.put(new Long(timetable.getClassId()), timetables);
                }
                timetables.addElement(timetable);
            }
        }
        if (reportDataFile == null) {
            return;
        }
        Vector reports = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(reportDataFile), "report_data");
        System.out.println("  Readed " + reports.size() + " reports.");
        Enumeration e3 = reports.elements();
        while (e3.hasMoreElements()) {
            Term t = (Term)e3.nextElement();
            Term id = t.elementAt(0);
            Term generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            String subject = ToolBox.replace(ToolBox.replace(id.elementAt(0).getText().substring(0, 4), "_", " "), "A", "&").toUpperCase();
            String courseNbr = ToolBox.replace(id.elementAt(0).getText().substring(4), "_", " ").toUpperCase();
            String itype = id.elementAt(1).getText();
            int section = id.elementAt(2).toInt();
            Hashtable sameCourseITypeSection = (Hashtable)sameSubjectCourseITypeSection.get(subject);
            if (sameCourseITypeSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            Hashtable sameITypeSection = (Hashtable)sameCourseITypeSection.get(courseNbr);
            if (sameITypeSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            Vector sameSection = (Vector)sameITypeSection.get(itype);
            if (sameSection == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            edu.purdue.smas.timetable.data.Class c = null;
            Enumeration ce = sameSection.elements();
            while (c == null && ce.hasMoreElements()) {
                edu.purdue.smas.timetable.data.Class x = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                if (x.getSection() != section) continue;
                c = x;
            }
            if (c == null) {
                System.err.println("Unable to import class with id " + id + " -- class not exists in database");
                continue;
            }
            Vector timetables = (Vector)allTimetablesHash.get(new Long(c.getId()));
            if (timetables == null) continue;
            if (generic == null) {
                System.err.println("id=" + id);
                Timetable.Info info = new Timetable.Info(true, Long.parseLong(t.elementAt(1).getText()), Long.parseLong(t.elementAt(2).getText()), Long.parseLong(t.elementAt(3).getText()), Long.parseLong(t.elementAt(4).getText()), Long.parseLong(t.elementAt(5).getText()), Long.parseLong(t.elementAt(6).getText()), Long.parseLong(t.elementAt(7).getText()));
                Enumeration et = timetables.elements();
                while (et.hasMoreElements()) {
                    Timetable timetable = (Timetable)et.nextElement();
                    if (timetable.getMtgNumber() != 0) continue;
                    timetable.setInfo(info);
                    timetable.save();
                }
                continue;
            }
            int nbrMtgs = Integer.parseInt(generic.elementAt(0).getText());
            for (int i = 0; i < nbrMtgs; ++i) {
                System.err.println("id=" + id + ", mtg=" + i);
                if (i > 0) {
                    t = (Term)e3.nextElement();
                }
                Timetable.Info info = new Timetable.Info(false, Long.parseLong(t.elementAt(1).getText()), Long.parseLong(t.elementAt(2).getText()), Long.parseLong(t.elementAt(3).getText()), Long.parseLong(t.elementAt(4).getText()), Long.parseLong(t.elementAt(5).getText()), Long.parseLong(t.elementAt(6).getText()), Long.parseLong(t.elementAt(7).getText()));
                Enumeration et = timetables.elements();
                while (et.hasMoreElements()) {
                    Timetable timetable = (Timetable)et.nextElement();
                    if (timetable.getMtgNumber() != i) continue;
                    timetable.setInfo(info);
                    timetable.save();
                }
            }
        }
    }

    public static String importSolution2(File solutionFile, File reportDataFile, String schema, long version) throws IOException, TTException, SQLException {
        StringBuffer errors = new StringBuffer("");
        Hashtable allClasses = edu.purdue.smas.timetable.data.Class.loadAllComplete(version, null, null, false, false, false, false, false, false);
        Vector allClassesVec = new Vector();
        Enumeration e = allClasses.elements();
        while (e.hasMoreElements()) {
            allClassesVec.addElement(e.nextElement());
        }
        Hashtable allBuilings = Building.loadAllHash(version);
        Vector allRooms = Room.loadAll(version);
        Collections.sort(allRooms, new Room.RoomOrdComparator(allBuilings));
        Hashtable allRoomsHash = new Hashtable();
        for (int i = 0; i < allRooms.size(); ++i) {
            allRoomsHash.put(new Integer(i + 1), allRooms.elementAt(i));
        }
        Hashtable sameSubjectCourseITypeSection = edu.purdue.smas.timetable.data.Class.createHashSameSubjectCourseITypeClass(allClassesVec);
        Vector solution = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(solutionFile), "solution");
        Debug.log("  Read " + solution.size() + " solutions.");
        Timetable.deleteAll(version);
        Hashtable allTimetablesHash = new Hashtable();
        Enumeration e2 = solution.elements();
        while (e2.hasMoreElements()) {
            Term generic;
            Term t = (Term)e2.nextElement();
            Term id = t.elementAt(0);
            Term base = t.elementAt(1);
            Term advice = t.elementAt(2);
            int nbrMtgs = base.elementAt(0).toInt();
            int halfHours = base.elementAt(1).toInt();
            Term term = generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            if (!(generic == null || generic.getText() != null && generic.getText().equalsIgnoreCase("standard"))) {
                nbrMtgs = Integer.parseInt(generic.elementAt(0).getText());
            }
            if (advice.elementAt(0).getText().equals("ok") && advice.elementAt(2).getText().equals("ok")) {
                Term slots = advice.elementAt(1);
                Term rooms = advice.elementAt(3);
                String subjCrs = id.elementAt(0).getText();
                String subject = ToolBox.replace(ToolBox.replace(subjCrs.substring(0, subjCrs.length() - 4), "_", " "), "A", "&").toUpperCase();
                String courseNbr = ToolBox.replace(subjCrs.substring(subjCrs.length() - 4), "_", " ").toUpperCase();
                String itype = id.elementAt(1).getText();
                int section = id.elementAt(2).toInt();
                System.out.println("Processing: '" + subject.trim() + "' - '" + courseNbr.trim() + "'");
                Hashtable sameCourseITypeSection = (Hashtable)sameSubjectCourseITypeSection.get(subject.trim());
                if (sameCourseITypeSection == null) {
                    errors.append("(A) Unable to import class with id -- " + id + " -- Subject does not exist in database\n");
                    continue;
                }
                Hashtable sameITypeSection = (Hashtable)sameCourseITypeSection.get(courseNbr.trim());
                if (sameITypeSection == null) {
                    errors.append("(A) Unable to import class with id -- " + id + " -- Course Nbr does not exist for the subject\n");
                    continue;
                }
                Vector sameSection = (Vector)sameITypeSection.get(itype.trim());
                if (sameSection == null) {
                    errors.append("(A) Unable to import class with id -- " + id + " -- Itype does not exist for the Course\n");
                    continue;
                }
                edu.purdue.smas.timetable.data.Class c = null;
                Enumeration ce = sameSection.elements();
                while (c == null && ce.hasMoreElements()) {
                    edu.purdue.smas.timetable.data.Class x = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                    if (x.getSection() != section) continue;
                    c = x;
                }
                if (c == null) {
                    errors.append("(A) Unable to import class with id -- " + id + " -- Section does not exist for the Course / Itype\n");
                    continue;
                }
                for (int i = 0; i < nbrMtgs; ++i) {
                    Vector<Timetable> timetables;
                    Timetable timetable = new Timetable(c, i);
                    timetable.setHalfHoursPerMtg(halfHours);
                    if (!(generic == null || generic.getText() != null && generic.getText().equalsIgnoreCase("standard"))) {
                        if (i > 0) {
                            t = (Term)e2.nextElement();
                            advice = t.elementAt(2);
                            slots = advice.elementAt(1);
                            rooms = advice.elementAt(3);
                        }
                        timetable.setRoom((Room)allRoomsHash.get(Integer.valueOf(rooms.elementAt(0).elementAt(0).getText())));
                        timetable.setSlot(Integer.parseInt(slots.elementAt(0).elementAt(0).getText()));
                    } else {
                        timetable.setRoom((Room)allRoomsHash.get(Integer.valueOf(rooms.elementAt(i).elementAt(0).getText())));
                        timetable.setSlot(Integer.parseInt(slots.elementAt(i).elementAt(0).getText()));
                    }
                    timetable.save();
                    Vector<Timetable> vector = timetables = allTimetablesHash.containsKey(new Long(timetable.getClassId())) ? (Vector)allTimetablesHash.get(new Long(timetable.getClassId())) : null;
                    if (timetables == null) {
                        timetables = new Vector<Timetable>();
                        allTimetablesHash.put(new Long(timetable.getClassId()), timetables);
                    }
                    timetables.addElement(timetable);
                }
                continue;
            }
            errors.append("(C) Ignored class with id -- " + id + " -- Advice :" + advice.elementAt(0).getText() + " - " + advice.elementAt(2).getText() + "\n");
        }
        if (reportDataFile == null) {
            return errors.toString();
        }
        Vector reports = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(reportDataFile), "report_data");
        Debug.log("  Read " + reports.size() + " reports.");
        Enumeration e3 = reports.elements();
        while (e3.hasMoreElements()) {
            Term t = (Term)e3.nextElement();
            Term id = t.elementAt(0);
            String subjCrs = id.elementAt(0).getText();
            String subject = ToolBox.replace(ToolBox.replace(subjCrs.substring(0, subjCrs.length() - 4), "_", " "), "A", "&").toUpperCase();
            String courseNbr = ToolBox.replace(subjCrs.substring(subjCrs.length() - 4), "_", " ").toUpperCase();
            String itype = id.elementAt(1).getText();
            int section = id.elementAt(2).toInt();
            Term generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            Hashtable sameCourseITypeSection = (Hashtable)sameSubjectCourseITypeSection.get(subject);
            if (sameCourseITypeSection == null) {
                errors.append("(B) Unable to import class with id -- " + id + " -- Subject does not exist in database\n");
                continue;
            }
            Hashtable sameITypeSection = (Hashtable)sameCourseITypeSection.get(courseNbr.trim());
            if (sameITypeSection == null) {
                errors.append("(B) Unable to import class with id -- " + id + " -- Course Nbr does not exist for the subject\n");
                continue;
            }
            Vector sameSection = (Vector)sameITypeSection.get(itype.trim());
            if (sameSection == null) {
                errors.append("(B) Unable to import class with id -- " + id + " -- Itype does not exist for the Course\n");
                continue;
            }
            edu.purdue.smas.timetable.data.Class c = null;
            Enumeration ce = sameSection.elements();
            while (c == null && ce.hasMoreElements()) {
                edu.purdue.smas.timetable.data.Class x = (edu.purdue.smas.timetable.data.Class)ce.nextElement();
                if (x.getSection() != section) continue;
                c = x;
            }
            if (c == null) {
                errors.append("(B) Unable to import class with id -- " + id + " -- Section does not exist for the Course / Itype\n");
                continue;
            }
            Vector timetables = (Vector)allTimetablesHash.get(new Long(c.getId()));
            if (timetables == null) continue;
            if (generic == null || generic.getText() != null && generic.getText().equalsIgnoreCase("standard")) {
                Timetable.Info info = new Timetable.Info(true, Long.parseLong(t.elementAt(1).getText()), Long.parseLong(t.elementAt(2).getText()), Long.parseLong(t.elementAt(3).getText()), Long.parseLong(t.elementAt(4).getText()), Long.parseLong(t.elementAt(5).getText()), Long.parseLong(t.elementAt(6).getText()), Long.parseLong(t.elementAt(7).getText()));
                Enumeration et = timetables.elements();
                while (et.hasMoreElements()) {
                    Timetable timetable = (Timetable)et.nextElement();
                    if (timetable.getMtgNumber() != 0) continue;
                    timetable.setInfo(info);
                    timetable.save();
                }
                continue;
            }
            int nbrMtgs = Integer.parseInt(generic.elementAt(0).getText());
            for (int i = 0; i < nbrMtgs; ++i) {
                if (i > 0) {
                    t = (Term)e3.nextElement();
                }
                Timetable.Info info = new Timetable.Info(false, Long.parseLong(t.elementAt(1).getText()), Long.parseLong(t.elementAt(2).getText()), Long.parseLong(t.elementAt(3).getText()), Long.parseLong(t.elementAt(4).getText()), Long.parseLong(t.elementAt(5).getText()), Long.parseLong(t.elementAt(6).getText()), Long.parseLong(t.elementAt(7).getText()));
                Enumeration et = timetables.elements();
                while (et.hasMoreElements()) {
                    Timetable timetable = (Timetable)et.nextElement();
                    if (timetable.getMtgNumber() != i) continue;
                    timetable.setInfo(info);
                    timetable.save();
                }
            }
        }
        return errors.toString();
    }

    public static void main(String[] args) {
        try {
            Config.init(new File("c:\\java\\tomcat4.1.27\\webapps\\purdue\\fal2004local\\tt.cfg.jsp"));
            Debug.init();
            PrologFileReaderWriter.storeData(new File("d:\\export.zip"), 5L, true, true, true, true, true, true, true, true, true, true);
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void loadDataEx(File folder, String schema, long version) throws IOException, TTException, SQLException {
        System.out.println("Load data from folder '" + folder + "'.");
        PrintWriter out = null;
        Hashtable allRooms = Room.loadAllHash(version);
        Hashtable allBldgs = Building.loadAllHash(version);
        Hashtable allInstructors = Instructor.loadAllHash(version);
        Vector course = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(folder.getPath() + File.separator + "course.pl"), "csid");
        System.out.println("  Readed " + course.size() + " courses.");
        out = new PrintWriter(new FileWriter(folder.getPath() + File.separator + "01ex_course.sql"));
        out.println("delete " + schema + ".PROHIBITED_TIME_PATTERN;");
        out.println("delete " + schema + ".CLASS_FEATURE_REQ;");
        out.println("delete " + schema + ".CLASS_ROOM_REQ;");
        out.println("delete " + schema + ".CLASS_BUILDING_REQ;");
        out.println("delete " + schema + ".CLASS_TIME_REQ;");
        out.println("delete " + schema + ".CLASS;");
        Hashtable<String, String> pref = new Hashtable<String, String>();
        Enumeration e = Preferences.elements();
        while (e.hasMoreElements()) {
            Preferences.Preference pr = (Preferences.Preference)e.nextElement();
            pref.put(pr.getProlog(), String.valueOf(pr.getId()));
        }
        int class_id = 0;
        int req_id = 0;
        Vector<String> classIds = new Vector<String>();
        Enumeration e2 = course.elements();
        while (e2.hasMoreElements()) {
            Object r;
            Term t = (Term)e2.nextElement();
            Term id = t.elementAt(0);
            String subject = id.elementAt(0).getText().substring(0, 4);
            String courseNbr = id.elementAt(0).getText().substring(4);
            String itype = id.elementAt(1).getText();
            Term generic = id.elementAt(3) != null ? id.elementAt(3).elementAt(0) : null;
            int section = id.elementAt(2).toInt();
            Term base = t.elementAt(1);
            int nbrMtgs = base.elementAt(0).toInt();
            if (generic != null) {
                nbrMtgs = 4;
            }
            int halfHours = base.elementAt(1).toInt();
            Term csroom = base.elementAt(2);
            int expCapac = csroom.elementAt(0).toInt();
            String fProjector = (String)pref.get(csroom.elementAt(1).elementAt(0).getText().toUpperCase());
            String fComputer = (String)pref.get(csroom.elementAt(1).elementAt(1).getText().toUpperCase());
            String fRecord = (String)pref.get(csroom.elementAt(1).elementAt(2).getText().toUpperCase());
            String fDocucam = (String)pref.get(csroom.elementAt(1).elementAt(3).getText().toUpperCase());
            String instructor = base.elementAt(3).elementAt(0).getText();
            if (instructor.equals("_")) {
                instructor = null;
            }
            Term faculty = t.elementAt(3);
            Term reqs = faculty.elementAt(0).elementAt(0);
            Term prefs = faculty.elementAt(1).elementAt(0);
            Term rooms = csroom.elementAt(2);
            Term roomReqs = csroom.elementAt(3);
            Term bldgs = csroom.elementAt(4);
            Term bldgReqs = csroom.elementAt(5);
            if (classIds.indexOf("id(" + subject + "," + courseNbr + "," + itype + "," + section + ")") >= 0) {
                System.err.println("Skipping:" + id);
                continue;
            }
            classIds.addElement("id(" + subject + "," + courseNbr + "," + itype + "," + section + ")");
            ++class_id;
            if (instructor != null) {
                String instId = null;
                Enumeration ie = allInstructors.elements();
                while (ie.hasMoreElements()) {
                    Instructor inst = (Instructor)ie.nextElement();
                    if (inst.getLastName() == null || !inst.getLastName().trim().equalsIgnoreCase(instructor)) continue;
                    instId = inst.getId();
                }
                if (instId == null) {
                    out.println("-- unknown instructor '" + instructor + "'");
                    instructor = null;
                } else {
                    instructor = instId;
                }
            }
            int timePatternId = -1;
            Enumeration tpe = TimePatterns.getTimePatterns();
            while (tpe.hasMoreElements()) {
                TimePatterns.TimePattern tp = (TimePatterns.TimePattern)tpe.nextElement();
                if (tp.getNumberOfMeetings() != nbrMtgs || tp.getHalfHoursPerMeeting() != halfHours) continue;
                timePatternId = tp.getId();
            }
            if (timePatternId < 0) {
                out.println("-- unknown time pattern " + nbrMtgs + "x" + halfHours);
            }
            out.println("insert into " + schema + ".CLASS (CLASS_ID,SUBJECT,COURSE_NBR,ITYPE,SECTION,TIME_PATTERN_ID,EXPECTED_CAPACITY,INSTR_UID,OWNER_ROLE,START_DATE,END_DATE,VERSION,NONSTANDARD_REQ) values (" + class_id + ",'" + ToolBox.replace(ToolBox.replace(subject, "_", " "), "A", "'||CHR(38)||'").toUpperCase() + "','" + ToolBox.replace(courseNbr, "_", " ").toUpperCase() + "','" + itype + "'," + section + "," + timePatternId + "," + expCapac + "," + (instructor == null ? "NULL" : "'" + instructor.substring(0, Math.min(instructor.length(), 10)) + "'") + ",NULL,NULL,NULL,1,NULL);");
            if (TimePatterns.getAlternativeTimePatterns(timePatternId) != null) {
                Enumeration atpe = TimePatterns.getAlternativeTimePatterns(timePatternId);
                while (atpe.hasMoreElements()) {
                    TimePatterns.TimePattern atp = (TimePatterns.TimePattern)atpe.nextElement();
                    out.println("insert into " + schema + ".PROHIBITED_TIME_PATTERN (PATTERN_ID, CLASS_ID, VERSION) values (" + atp.getId() + "," + class_id + ",1);");
                }
            }
            if (!fProjector.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'computerProjection'," + fProjector + ",1);");
            }
            if (!fComputer.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'puccComputer'," + fComputer + ",1);");
            }
            if (!fRecord.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'audioRecording'," + fRecord + ",1);");
            }
            if (!fDocucam.equals("4")) {
                out.println("insert into " + schema + ".CLASS_FEATURE_REQ (CLASS_ID,FEATURE_ID,PREF_ID,VERSION) values (" + class_id + ",'docucam'," + fDocucam + ",1);");
            }
            if (rooms != null && rooms.elementAt(0).size() > 0) {
                for (int i = 0; i < rooms.size(); ++i) {
                    String roomId = null;
                    Enumeration re = allRooms.elements();
                    while (re.hasMoreElements()) {
                        r = (Room)re.nextElement();
                        Building b = (Building)allBldgs.get(((Room)r).getBldgId());
                        if (!b.getABBV().equalsIgnoreCase(rooms.elementAt(i).elementAt(0).getText()) || !((Room)r).getRoomNo().equalsIgnoreCase(rooms.elementAt(i).elementAt(1).getText())) continue;
                        roomId = ((Room)r).getId();
                    }
                    if (roomId == null) {
                        out.println("-- unknown room " + rooms.elementAt(i).elementAt(0).getText() + rooms.elementAt(i).elementAt(1).getText());
                        continue;
                    }
                    out.println("insert into " + schema + ".CLASS_ROOM_REQ (CLASS_ID,ROOM_ID,PREF_ID,VERSION) values (" + class_id + ",'" + roomId + "'," + pref.get(roomReqs.elementAt(i).getText().toUpperCase()) + ",1);");
                }
            }
            if (bldgs != null && bldgs.getContent() != null && bldgs.elementAt(0).getText().length() > 0) {
                for (int i = 0; i < bldgs.size(); ++i) {
                    String bldgId = null;
                    Enumeration be = allBldgs.elements();
                    while (be.hasMoreElements()) {
                        Building b = (Building)be.nextElement();
                        if (!b.getABBV().equalsIgnoreCase(bldgs.elementAt(i).getText())) continue;
                        bldgId = b.getId();
                    }
                    if (bldgId == null) {
                        out.println("-- unknown building " + bldgs.elementAt(i).getText());
                        continue;
                    }
                    out.println("insert into " + schema + ".CLASS_BUILDING_REQ (CLASS_ID,BLDG_ID,PREF_ID,VERSION) values (" + class_id + ",'" + bldgId + "'," + pref.get(bldgReqs.elementAt(i).getText().toUpperCase()) + ",1);");
                }
            }
            if (prefs.size() <= 1) {
                System.err.println("No prefs for: " + id);
            }
            if (reqs.size() <= 1 && prefs.size() <= 1) continue;
            StandardTimePattern tpm = generic == null ? new StandardTimePattern(nbrMtgs, halfHours) : new GenericTimePattern(nbrMtgs, halfHours, false);
            for (int j = 0; j < tpm.getNrDays(); ++j) {
                int i;
                if (j > 0) {
                    t = (Term)e2.nextElement();
                    faculty = t.elementAt(3);
                    reqs = faculty.elementAt(0).elementAt(0);
                    prefs = faculty.elementAt(1).elementAt(0);
                }
                if (prefs.size() > 1) {
                    for (i = 0; i < prefs.size(); ++i) {
                        tpm.setPreference(j, i, Preferences.getPreference(String.valueOf(-prefs.elementAt(i).toInt())));
                    }
                }
                if (reqs.size() <= 1) continue;
                for (i = 0; i < reqs.size(); ++i) {
                    if (reqs.elementAt(i).toInt() != 0) continue;
                    tpm.setPreference(j, i, Preferences.getPreference("P"));
                }
            }
            Hashtable timeReqs = new Hashtable();
            tpm.storeTimeRequirements(timeReqs);
            Enumeration tre = timeReqs.keys();
            while (tre.hasMoreElements()) {
                r = (Class.TimeRequirement)tre.nextElement();
                Preferences.Preference p = (Preferences.Preference)timeReqs.get(r);
                out.println("insert into " + schema + ".CLASS_TIME_REQ (req_id, class_id, days, start_time, end_time, pref_id, version) values (" + ++req_id + "," + class_id + ",'" + ((Class.TimeRequirement)r).getDaysStr() + "'," + Database.prepParam(((Class.TimeRequirement)r).getStartTime()) + "," + Database.prepParam(((Class.TimeRequirement)r).getEndTime()) + "," + p.getId() + ",1);");
            }
        }
        out.println("commit;");
        out.close();
        Vector add = PrologFileReaderWriter.readTermsFromStream(new FileInputStream(folder.getPath() + File.separator + "add.pl"), "cbs");
        System.out.println("  Readed " + add.size() + " group constraints.");
        out = new PrintWriter(new FileWriter(folder.getPath() + File.separator + "04_add.sql"));
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_GROUP;");
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_REQ;");
        out.println("delete " + schema + ".CLASS_DISTRIBUTION_REQ_DEF;");
        Hashtable<String, String> constrDef = new Hashtable<String, String>();
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (1,'BTB','back-to-back');");
        constrDef.put("BTB", "1");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (2,'BTB_TIME','back-to-back time');");
        constrDef.put("BTB_TIME", "2");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (3,'SAME_TIME','same time');");
        constrDef.put("SAME_TIME", "3");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (4,'SAME_DAYS','same days');");
        constrDef.put("SAME_DAYS", "4");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (5,'NHB(1)','1 hr between');");
        constrDef.put("NHB(1)", "5");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (6,'NHB(2)','2 hrs between');");
        constrDef.put("NHB(2)", "6");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (7,'NHB(3)','3 hrs between');");
        constrDef.put("NHB(3)", "7");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (8,'NHB(4)','4 hrs between');");
        constrDef.put("NHB(4)", "8");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (9,'NHB(5)','5 hrs between');");
        constrDef.put("NHB(5)", "9");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (10,'NHB(6)','6 hrs between');");
        constrDef.put("NHB(6)", "10");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (11,'NHB(7)','7 hrs between');");
        constrDef.put("NHB(7)", "11");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (12,'NHB(8)','8 hrs between');");
        constrDef.put("NHB(8)", "12");
        out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ_DEF (REQ_ID, TYPE, DESCRIPTION) VALUES (13,'DIFF_TIME','different time');");
        constrDef.put("DIFF_TIME", "13");
        int const_id = 0;
        Enumeration e3 = add.elements();
        while (e3.hasMoreElements()) {
            Term t = (Term)e3.nextElement();
            ++const_id;
            String key = t.elementAt(0).getText().toUpperCase();
            if (key.equals("NHB")) {
                key = key + "(" + t.elementAt(0).elementAt(0).getText() + ")";
            }
            if (constrDef.containsKey(key)) {
                out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_REQ (GROUP_ID,REQ_ID,OWNER_FOLE,PREF_ID,VERSION) values (" + const_id + "," + constrDef.get(key) + ",-1,1,1);");
                Term classes = t.elementAt(1);
                for (int i = 0; i < classes.size(); ++i) {
                    String subject = ToolBox.replace(ToolBox.replace(classes.elementAt(i).elementAt(0).getText().substring(0, 4), "_", " "), "A", "'||CHR(38)||'").toUpperCase();
                    String courseNbr = ToolBox.replace(classes.elementAt(i).elementAt(0).getText().substring(4), "_", " ").toUpperCase();
                    String itype = classes.elementAt(i).elementAt(1).getText();
                    int section = classes.elementAt(i).elementAt(2).toInt();
                    out.println("INSERT INTO " + schema + ".CLASS_DISTRIBUTION_GROUP (GROUP_ID,SUBJECT,COURSE_NBR,ITYPE,SECTION,VERSION) values (" + const_id + ",'" + subject + "','" + courseNbr + "','" + itype + "'," + section + ",1);");
                }
                continue;
            }
            System.out.println("unkonwn key: '" + key + "'");
        }
        out.println("commit;");
        out.close();
    }

    private static Term deptTerm(edu.purdue.smas.timetable.data.Class c) {
        return new Term("dept", new Term[]{new Term(Subjects.getDeptCode(c.getSubject()))});
    }

    public static class Term {
        private String iText = null;
        private Vector iContent = null;

        public Term(String text) {
            this.iText = text;
            this.iContent = null;
        }

        public Term(Vector content) {
            this.iText = null;
            this.iContent = content;
        }

        public Term(String text, Vector content) {
            this.iText = text;
            this.iContent = content;
        }

        public Term(String text, Term[] content) {
            this.iText = text;
            if (content == null) {
                this.iContent = null;
            } else {
                this.iContent = new Vector();
                for (int i = 0; i < content.length; ++i) {
                    this.iContent.addElement(content[i]);
                }
            }
        }

        public Term(Term[] content) {
            this(null, content);
        }

        public String getText() {
            return this.iText;
        }

        public Vector getContent() {
            return this.iContent;
        }

        public int size() {
            return this.iContent == null ? -1 : this.iContent.size();
        }

        public int toInt() {
            return Integer.parseInt(this.iText);
        }

        public long toLong() {
            return Long.parseLong(this.iText);
        }

        public double toDouble() {
            return Double.parseDouble(this.iText);
        }

        public Term elementAt(int idx) {
            try {
                return (Term)this.iContent.elementAt(idx);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            boolean isArray = this.iText == null || this.iText.length() == 0;
            StringBuffer sb = new StringBuffer(isArray ? "" : this.iText);
            if (this.iContent != null) {
                sb.append(isArray ? "[" : "(");
                Enumeration e = this.iContent.elements();
                while (e.hasMoreElements()) {
                    sb.append(e.nextElement().toString());
                    sb.append(e.hasMoreElements() ? "," : "");
                }
                sb.append(isArray ? "]" : ")");
            }
            return sb.toString();
        }

        public Object clone() {
            return new Term(this.iText == null ? null : new String(this.iText), this.iContent == null ? this.iContent : (Vector)this.iContent.clone());
        }
    }

    public static class SpecialReader {
        private Reader iReader = null;
        private StringBuffer iFlushedChars = new StringBuffer();

        public SpecialReader(Reader r) {
            this.iReader = r;
        }

        public int read() throws IOException {
            if (this.iFlushedChars.length() == 0) {
                return this.iReader.read();
            }
            char ret = this.iFlushedChars.charAt(0);
            this.iFlushedChars.deleteCharAt(0);
            return ret;
        }

        public void flush(char ch) {
            this.iFlushedChars.insert(0, ch);
        }
    }
}

