/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.serverfwk;

import edu.purdue.smas.timetable.util.ToolBox;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class ParameterDefinition
implements Serializable {
    private String iName;
    private String iCategory;
    private String idescription;
    private int iType;
    private String iDefaultValue;
    private Vector iPossibleValues = null;
    private Vector iDependencies = null;
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_BOOLEAN = 2;

    public ParameterDefinition(String category, String name, String description, int type, String defaultValue) {
        this.iCategory = category;
        this.iName = name;
        this.idescription = description;
        this.iType = type;
        this.iDefaultValue = defaultValue;
    }

    public ParameterDefinition(String category, String name, String description, int type, String defaultValue, String[] possibleValues) {
        this(category, name, description, type, defaultValue);
        if (possibleValues != null) {
            this.addPossibleValues(possibleValues);
        }
    }

    public ParameterDefinition addDependency(Dependency dep) {
        if (this.iDependencies == null) {
            this.iDependencies = new Vector();
        }
        this.iDependencies.addElement(dep);
        return this;
    }

    public boolean hasDependences() {
        return this.iDependencies == null ? false : !this.iDependencies.isEmpty();
    }

    public Collection getDependencies() {
        return this.iDependencies;
    }

    public void addPossibleValue(String possibleValue) {
        if (this.iPossibleValues == null) {
            this.iPossibleValues = new Vector();
        }
        this.iPossibleValues.addElement(possibleValue);
    }

    public void addPossibleValues(String[] possibleValues) {
        if (this.iPossibleValues == null) {
            this.iPossibleValues = new Vector();
        }
        for (int i = 0; i < possibleValues.length; ++i) {
            this.iPossibleValues.addElement(possibleValues[i]);
        }
    }

    public String getCategory() {
        return this.iCategory;
    }

    public String getName() {
        return ToolBox.replace(this.iName, ".", "_");
    }

    public String getRealName() {
        return this.iName;
    }

    public String getDescription() {
        return this.idescription;
    }

    public int getType() {
        return this.iType;
    }

    public String getDefaultValue() {
        return this.iDefaultValue;
    }

    public void setDefaultValue(String value) {
        this.iDefaultValue = value;
    }

    public Collection getPossibleValues() {
        return this.iPossibleValues;
    }

    public boolean hasPossibleValues() {
        return this.iPossibleValues != null && !this.iPossibleValues.isEmpty();
    }

    public String toString() {
        return this.getRealName() + "=" + this.getDefaultValue();
    }

    public static class Dependency
    implements Serializable {
        private String iParameterName;
        private String iParameterValue;

        public Dependency(String paramName, String paramValue) {
            this.iParameterName = paramName;
            this.iParameterValue = paramValue;
        }

        public String getParameterRealName() {
            return this.iParameterName;
        }

        public String getParameterName() {
            return ToolBox.replace(this.iParameterName, ".", "_");
        }

        public String getParameterValue() {
            return this.iParameterValue;
        }
    }
}

