/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import edu.purdue.smas.timetable.util.ToolBox;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class Database {
    private static Hashtable sConnections = new Hashtable();
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.US);
    private static SimpleDateFormat sTimeFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
    public static final int iFetchSize = Config.getInt("SQL_FETCH_SIZE", 1000);
    static /* synthetic */ Class class$edu$purdue$smas$timetable$util$Database;

    public static Connection getConnection() {
        String name = Thread.currentThread().getName();
        return sConnections.containsKey(name) ? (Connection)sConnections.get(name) : null;
    }

    private static void setConnection(Connection connection) {
        String name = Thread.currentThread().getName();
        sConnections.put(name, connection);
    }

    public static String prepParam(Object param) {
        if (param instanceof Time) {
            return "TO_DATE('" + sTimeFormat.format((Time)param) + "','HH24:MI:SS')";
        }
        if (param instanceof Date) {
            return "TO_DATE('" + sDateFormat.format((Date)param) + "','DD-MM-YYYY HH24:MI:SS')";
        }
        if (param instanceof java.util.Date) {
            return "TO_DATE('" + sDateFormat.format((java.util.Date)param) + "','DD-MM-YYYY HH24:MI:SS')";
        }
        return param == null ? "NULL" : "'" + ToolBox.replace(param.toString(), "'", "''") + "'";
    }

    public static String prepParam(long param) {
        return String.valueOf(param);
    }

    private static Statement sqlExecute(String sqlCommand) throws SQLException, TTException {
        Debug.log("SQL:" + sqlCommand);
        Connection connection = null;
        try {
            connection = Database.getConnection();
            if (connection == null) {
                connection = Database.reconnect();
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            Statement statement = connection.createStatement();
            statement.setFetchSize(iFetchSize);
            return statement.execute(sqlCommand) ? statement : null;
        }
        catch (SQLException e) {
            Debug.log("SQL:" + sqlCommand);
            Debug.error(e);
            Debug.log("Trying to reconnect ...");
            try {
                connection = Database.reconnect();
            }
            catch (SQLException ex) {
                Debug.log("SQL:" + sqlCommand);
                Debug.log("reconnection failed.");
                Debug.error(ex);
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            Statement statement = connection.createStatement();
            statement.setFetchSize(iFetchSize);
            return statement.execute(sqlCommand) ? statement : null;
        }
    }

    private static int sqlExecuteUpdate(String sqlCommand) throws SQLException, TTException {
        Debug.log("SQL:" + sqlCommand);
        Connection connection = null;
        try {
            connection = Database.getConnection();
            if (connection == null) {
                connection = Database.reconnect();
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            Statement statement = connection.createStatement();
            statement.setFetchSize(iFetchSize);
            int ret = statement.executeUpdate(sqlCommand);
            statement.close();
            return ret;
        }
        catch (SQLException e) {
            Debug.log("SQL:" + sqlCommand);
            Debug.error(e);
            Debug.log("Trying to reconnect ...");
            try {
                connection = Database.reconnect();
            }
            catch (SQLException ex) {
                Debug.log("SQL:" + sqlCommand);
                Debug.log("reconnection failed.");
                Debug.error(ex);
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            Statement statement = connection.createStatement();
            statement.setFetchSize(1000);
            int ret = statement.executeUpdate(sqlCommand);
            statement.close();
            return ret;
        }
    }

    public static PreparedStatement prepare(String sqlCommand) throws SQLException, TTException {
        Debug.log("SQL:" + sqlCommand);
        Connection connection = null;
        try {
            connection = Database.getConnection();
            if (connection == null) {
                connection = Database.reconnect();
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            return connection.prepareStatement(sqlCommand);
        }
        catch (SQLException e) {
            Debug.log("SQL:" + sqlCommand);
            Debug.error(e);
            Debug.log("Trying to reconnect ...");
            try {
                connection = Database.reconnect();
            }
            catch (SQLException ex) {
                Debug.log("SQL:" + sqlCommand);
                Debug.log("reconnection failed.");
                Debug.error(ex);
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            return connection.prepareStatement(sqlCommand);
        }
    }

    public static int executeNoOutput(String sqlCommand) throws TTException {
        String ts = ToolBox.getCaller() + ":" + sqlCommand.substring(0, sqlCommand.indexOf(32));
        Debug.getGlobalTiming().begTS(ts);
        try {
            int ret = Database.sqlExecuteUpdate(sqlCommand);
            Debug.getGlobalTiming().endTS(ts);
            return ret;
        }
        catch (SQLException e) {
            Debug.getGlobalTiming().endTS(ts);
            throw new TTException(e);
        }
    }

    public static Statement execute(String sqlCommand) throws TTException {
        String ts = ToolBox.getCaller() + ":" + sqlCommand.substring(0, sqlCommand.indexOf(32));
        Debug.getGlobalTiming().begTS(ts);
        try {
            Statement statement = Database.sqlExecute(sqlCommand);
            if (statement == null) {
                return null;
            }
            Debug.getGlobalTiming().endTS(ts);
            return statement;
        }
        catch (SQLException e) {
            Debug.getGlobalTiming().endTS(ts);
            throw new TTException(e);
        }
    }

    public static long executeLong(String sqlCommand) throws TTException {
        String ts = ToolBox.getCaller() + ":" + sqlCommand.substring(0, sqlCommand.indexOf(32));
        Debug.getGlobalTiming().begTS(ts);
        try {
            Statement statement = Database.sqlExecute(sqlCommand);
            if (statement == null) {
                return -1L;
            }
            ResultSet rs = statement.getResultSet();
            long ret = -1L;
            if (rs != null && rs.next()) {
                ret = rs.getLong(1);
            }
            statement.close();
            Debug.getGlobalTiming().endTS(ts);
            return ret;
        }
        catch (SQLException e) {
            Debug.getGlobalTiming().endTS(ts);
            throw new TTException(e);
        }
    }

    public static int executeInt(String sqlCommand) throws TTException {
        String ts = ToolBox.getCaller() + ":" + sqlCommand.substring(0, sqlCommand.indexOf(32));
        Debug.getGlobalTiming().begTS(ts);
        try {
            Statement statement = Database.sqlExecute(sqlCommand);
            if (statement == null) {
                return -1;
            }
            ResultSet rs = statement.getResultSet();
            int ret = -1;
            if (rs != null && rs.next()) {
                ret = rs.getInt(1);
            }
            statement.close();
            Debug.getGlobalTiming().endTS(ts);
            return ret;
        }
        catch (SQLException e) {
            Debug.getGlobalTiming().endTS(ts);
            throw new TTException(e);
        }
    }

    private static synchronized Connection reconnect() throws SQLException {
        try {
            if (Database.getConnection() != null) {
                Database.getConnection().close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String connString = Config.get("SQL_DRIVER_CONN");
        String user = Config.get("SQL_USER");
        String passwd = Config.get("SQL_PASSWD", "hrdobec");
        Connection connection = DriverManager.getConnection(connString, user, passwd);
        connection.setAutoCommit(true);
        Database.setConnection(connection);
        return connection;
    }

    public static synchronized void setAutoCommit(boolean autoCommit) throws SQLException, TTException {
        Connection connection = null;
        try {
            connection = Database.getConnection();
            if (connection == null) {
                connection = Database.reconnect();
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            Debug.error(e);
            Debug.log("Trying to reconnect ...");
            try {
                connection = Database.reconnect();
            }
            catch (SQLException ex) {
                Debug.log("reconnection failed.");
                Debug.error(ex);
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            if (connection == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
            }
            connection.setAutoCommit(autoCommit);
        }
    }

    public static synchronized void commit() throws SQLException, TTException {
        block8: {
            Connection connection = null;
            try {
                connection = Database.getConnection();
                if (connection == null) {
                    connection = Database.reconnect();
                }
                if (connection == null) {
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                Debug.error(e);
                Debug.log("Trying to reconnect ...");
                try {
                    connection = Database.reconnect();
                }
                catch (SQLException ex) {
                    Debug.log("reconnection failed.");
                    Debug.error(ex);
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (connection == null) {
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (connection.getAutoCommit()) break block8;
                connection.commit();
            }
        }
    }

    public static synchronized void rollback() throws SQLException, TTException {
        block8: {
            Connection connection = null;
            try {
                connection = Database.getConnection();
                if (connection == null) {
                    connection = Database.reconnect();
                }
                if (connection == null) {
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                Debug.error(e);
                Debug.log("Trying to reconnect ...");
                try {
                    connection = Database.reconnect();
                }
                catch (SQLException ex) {
                    Debug.log("reconnection failed.");
                    Debug.error(ex);
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (connection == null) {
                    throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Database connection lost - unable to reconnect.");
                }
                if (connection.getAutoCommit()) break block8;
                connection.rollback();
            }
        }
    }

    private static void init() throws TTException {
        Connection connection = null;
        try {
            String driverClass = Config.get("SQL_DRIVER_CLASS");
            Debug.log("Database driver: " + driverClass);
            if (driverClass == null) {
                throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, "Unable to connect database.");
            }
            Class.forName(driverClass);
            String connString = Config.get("SQL_DRIVER_CONN");
            Debug.log("Connection string: " + connString);
            connection = Database.reconnect();
            if (connection != null) {
                Debug.log("Database connected.");
            }
        }
        catch (Exception e) {
            throw new TTException(e);
        }
        if (connection == null) {
            throw new TTException(class$edu$purdue$smas$timetable$util$Database == null ? (class$edu$purdue$smas$timetable$util$Database = Database.class$("edu.purdue.smas.timetable.util.Database")) : class$edu$purdue$smas$timetable$util$Database, TTException.getErrorCode("SQL"), "Unable to connect the database.");
        }
    }

    public static void close() throws TTException {
        try {
            if (Database.getConnection() != null) {
                Database.getConnection().close();
                Database.setConnection(null);
                Debug.log("Database disconnected.");
            }
        }
        catch (Exception e) {
            throw new TTException(e);
        }
    }

    public static void main(String[] args) {
        try {
            for (int qi = 0; qi < args.length; ++qi) {
                String query = args[qi];
                System.out.println("Q:" + query);
                Statement s = Database.execute(query);
                ResultSet rs = s.getResultSet();
                if (rs != null) {
                    ResultSetMetaData m = rs.getMetaData();
                    int columns = m.getColumnCount();
                    StringBuffer line = new StringBuffer();
                    for (int i = 0; i < columns; ++i) {
                        String cName = m.getColumnName(i + 1);
                        line.append(i > 0 ? "," : "").append(cName == null ? "null" : cName);
                    }
                    System.out.println("H:" + line.toString());
                    int lineNo = 0;
                    while (rs.next()) {
                        line = new StringBuffer();
                        for (int i = 0; i < columns; ++i) {
                            String o = rs.getString(i + 1);
                            line.append(i > 0 ? "," : "").append(o == null ? "null" : o.toString().trim());
                        }
                        System.out.println("R" + lineNo++ + ":" + line.toString());
                    }
                }
                s.close();
            }
        }
        catch (SQLException e) {
            System.err.println("ERR:" + e.getMessage());
            Debug.error(e);
        }
        catch (TTException e) {
            System.err.println("ERR:" + e.getMessage());
            Debug.error(e);
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Database.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

