/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.FileOperations;
import edu.purdue.smas.timetable.util.FilenameFilter;
import edu.purdue.smas.timetable.util.Timing;
import edu.purdue.smas.timetable.util.ToolBox;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Debug {
    private static String sFileName = null;
    private static PrintWriter sLogWriter = null;
    private static SimpleDateFormat iDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss.S ", Locale.US);
    private static NumberFormat iNumberFormat = new DecimalFormat("###,#00.00", new DecimalFormatSymbols(Locale.US));
    private static Runtime iRuntime = Runtime.getRuntime();
    private static Timing sGlobalTiming = new Timing("global");

    public static boolean isInitialized() {
        return sLogWriter != null;
    }

    private static synchronized void print(String logName, String message) {
        if (sLogWriter == null) {
            System.err.println(Debug.getTime() + Debug.getMem() + message);
        } else {
            sLogWriter.println(Debug.getTime() + Debug.getMem() + "[" + Thread.currentThread().getName() + "] " + message);
            sLogWriter.flush();
        }
    }

    public static void error(Throwable e) {
        Logger.getLogger((String)Debug.getSource(e)).error((Object)e.getMessage(), e);
    }

    public static void error(String message) {
        Logger.getLogger((String)ToolBox.getCaller()).error((Object)message);
    }

    public static void warning(String message) {
        Logger.getLogger((String)ToolBox.getCaller()).warn((Object)message);
    }

    public static void log(String message) {
        if (message != null) {
            if (message.startsWith("ERROR:")) {
                Logger.getLogger((String)ToolBox.getCaller()).error((Object)message.substring("ERROR:".length()).trim());
                return;
            }
            if (message.startsWith("WARNING:")) {
                Logger.getLogger((String)ToolBox.getCaller()).warn((Object)message.substring("WARNING:".length()).trim());
                return;
            }
            if (message.startsWith("INFO:")) {
                Logger.getLogger((String)ToolBox.getCaller()).info((Object)message.substring("INFO:".length()).trim());
                return;
            }
        }
        Logger.getLogger((String)ToolBox.getCaller()).debug((Object)message);
    }

    public static void info(String message) {
        Logger.getLogger((String)ToolBox.getCaller()).info((Object)message);
    }

    public static void log(int depth, String message) {
        if (message != null) {
            if (message.startsWith("ERROR:")) {
                Logger.getLogger((String)ToolBox.getCaller(4 + depth)).error((Object)message.substring("ERROR:".length()).trim());
                return;
            }
            if (message.startsWith("WARNING:")) {
                Logger.getLogger((String)ToolBox.getCaller(4 + depth)).warn((Object)message.substring("WARNING:".length()).trim());
                return;
            }
            if (message.startsWith("INFO:")) {
                Logger.getLogger((String)ToolBox.getCaller(4 + depth)).info((Object)message.substring("INFO:".length()).trim());
                return;
            }
        }
        Logger.getLogger((String)ToolBox.getCaller(4 + depth)).debug((Object)message);
    }

    public static String getSource(Class source) {
        String name = source.getName();
        if (name != null && name.indexOf(46) > 0) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public static String getSource(Object source) {
        if (source == null) {
            return "";
        }
        return Debug.getSource(source.getClass());
    }

    private static String getTime() {
        return iDateFormat.format(new Date());
    }

    public static String getMem() {
        return iNumberFormat.format((double)(iRuntime.totalMemory() - iRuntime.freeMemory()) / 1048576.0) + "M ";
    }

    public static void init() {
        try {
            Properties props;
            if (Debug.isInitialized()) {
                return;
            }
            String logDir = Config.get("DEBUG_DIR", "logfiles");
            System.out.println("Debug folder: " + new File(logDir).getCanonicalPath());
            FilenameFilter filter = new FilenameFilter("debug_*.log");
            String time = new SimpleDateFormat("yyyy-MM-dd_(HH.mm.ss)", Locale.US).format(new Date());
            sFileName = logDir + File.separator + "debug_" + time + ".log";
            sLogWriter = new PrintWriter(new LogWriter());
            Properties properties = props = Config.getProperties() == null ? new Properties() : (Properties)Config.getProperties().clone();
            if (!props.containsKey("log4j.rootLogger")) {
                props.setProperty("log4j.rootLogger", "debug, LogFile");
                props.setProperty("log4j.appender.LogFile", "org.apache.log4j.RollingFileAppender");
                props.setProperty("log4j.appender.LogFile.MaxFileSize", "5MB");
                props.setProperty("log4j.appender.LogFile.File", sFileName);
                props.setProperty("log4j.appender.LogFile.MaxBackupIndex", "5");
                props.setProperty("log4j.appender.LogFile.layout", "org.apache.log4j.PatternLayout");
                props.setProperty("log4j.appender.LogFile.layout.ConversionPattern", "%d{dd-MMM-yy HH:mm:ss.SSS} [%t] %-5p %c{2}> %m%n");
            }
            PropertyConfigurator.configure((Properties)props);
            FileOperations.deleteFiles(logDir, Config.getInt("DEBUG_MAXFILES", 10), filter);
            Logger log = Logger.getRootLogger();
            log.info((Object)"Timetabling debug file");
            log.info((Object)"");
            log.info((Object)("Created: " + new Date()));
            log.info((Object)"");
            log.info((Object)"System info:");
            log.info((Object)("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
            log.info((Object)("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding")));
            log.info((Object)("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"))));
            log.info((Object)("User:        " + System.getProperty("user.name")));
            log.info((Object)("Timezone:    " + System.getProperty("user.timezone")));
            log.info((Object)("Working dir: " + System.getProperty("user.dir")));
            log.info((Object)("Classpath:   " + System.getProperty("java.class.path")));
            log.info((Object)"");
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void close() {
        if (sLogWriter != null) {
            sLogWriter.close();
        }
        sLogWriter = null;
    }

    public static Timing getGlobalTiming() {
        return sGlobalTiming;
    }

    public static String getFileName() {
        return sFileName;
    }

    public static PrintWriter writer() {
        return sLogWriter;
    }

    private static class LogWriter
    extends Writer {
        private LogWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            Logger.getLogger((String)ToolBox.getCaller(8)).debug((Object)new String(cbuf, off, len));
        }
    }
}

