/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.FilenameFilter;
import java.io.File;
import java.util.Vector;

public class FileOperations {
    public static void deleteFiles(String dirPath, int maxFiles, FilenameFilter filter) {
        if (dirPath == null) {
            return;
        }
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        String[] files = null;
        files = filter != null ? dir.list(filter) : dir.list();
        if (files.length <= maxFiles) {
            return;
        }
        Vector sortedFiles = FileOperations.sort(files);
        for (int i = maxFiles; i < sortedFiles.size(); ++i) {
            File file = new File(dirPath, (String)sortedFiles.elementAt(i));
            Debug.log("Delete file " + file);
            file.delete();
        }
    }

    public static Vector sort(String[] files) {
        Vector<String> sortedFiles = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            boolean added = false;
            for (int j = 0; j < sortedFiles.size(); ++j) {
                if (fileName.compareTo((String)sortedFiles.elementAt(j)) <= 0) continue;
                sortedFiles.insertElementAt(fileName, j);
                added = true;
                break;
            }
            if (added) continue;
            sortedFiles.addElement(fileName);
        }
        return sortedFiles;
    }

    public static String getNameWithoutExtension(String filePath) {
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        String name = FileOperations.getNameWithoutExtension(file);
        return name;
    }

    public static String getNameWithoutExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static boolean empty(String name) {
        if (name == null) {
            return true;
        }
        return FileOperations.empty(new File(name));
    }

    public static boolean empty(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            Debug.error("File " + file.getAbsolutePath() + " does not exists.");
            return true;
        }
        if (!file.isDirectory()) {
            return true;
        }
        String[] allFiles = file.list();
        if (allFiles == null) {
            return true;
        }
        for (int i = 0; i < allFiles.length; ++i) {
            if (FileOperations.deleteFileNoCheck(new File(file.getPath() + File.separator + allFiles[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean deleteFileNoCheck(File file) {
        if (file.isDirectory()) {
            String[] allFiles = file.list();
            for (int i = 0; i < allFiles.length; ++i) {
                if (FileOperations.deleteFileNoCheck(new File(file.getPath() + File.separator + allFiles[i]))) continue;
                return false;
            }
            if (FileOperations.isEmpty(file) && !file.delete()) {
                Debug.warning("File " + file.toString() + " can not be deleted.");
            }
        } else if (!file.delete()) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return FileOperations.isEmpty(file);
    }

    public static boolean isEmpty(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return file.list().length == 0;
        }
        return file.length() == 0L;
    }
}

