/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import java.io.File;

public class FilenameFilter
implements java.io.FilenameFilter {
    private String iMask = null;
    private boolean iCaseSensitive = false;

    public FilenameFilter(String mask, boolean caseSensitive) {
        this.iCaseSensitive = caseSensitive;
        this.iMask = mask;
        if (!this.iCaseSensitive) {
            this.iMask = this.iMask.toLowerCase();
        }
    }

    public FilenameFilter(String mask) {
        this(mask, false);
    }

    private boolean match(String name, int nameIdx, int maskIdx) {
        if (maskIdx == this.iMask.length()) {
            return name.length() == nameIdx;
        }
        if (this.iMask.charAt(maskIdx) == '*') {
            boolean ok = false;
            for (int i = nameIdx; !ok && i <= name.length(); ++i) {
                ok = ok || this.match(name, i, maskIdx + 1);
            }
            return ok;
        }
        if (name.length() == nameIdx) {
            return false;
        }
        if (this.iMask.charAt(maskIdx) == name.charAt(nameIdx)) {
            return this.match(name, nameIdx + 1, maskIdx + 1);
        }
        if (this.iMask.charAt(maskIdx) == '?') {
            return this.match(name, nameIdx + 1, maskIdx + 1);
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        if (this.iMask == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return this.match(this.iCaseSensitive ? name : name.toLowerCase(), 0, 0);
    }
}

