/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Debug;
import java.util.Vector;

public class TTException
extends Exception {
    private int iErrCode = 0;
    private Object iSource = null;
    private Object iSourceClass = null;
    private static Vector sExceptions = new Vector();

    public TTException(Object source, int errCode, String message) {
        super(message);
        this.iSource = source;
        if (this.iSource != null) {
            this.iSourceClass = this.iSource.getClass();
        }
        this.iErrCode = errCode;
        System.err.println("Error: " + this.getMessage());
        Debug.error(this);
    }

    public TTException(Class source, int errCode, String message) {
        super(message);
        this.iSource = null;
        this.iSourceClass = source;
        this.iErrCode = errCode;
        System.err.println("Error: " + this.getMessage());
        Debug.error(this);
    }

    public TTException(Object source, String message) {
        super(message);
        this.iSource = source;
        this.iSourceClass = source.getClass();
        this.iErrCode = TTException.getErrorCode(source.getClass().getName());
        System.err.println("Error: " + this.getMessage());
        Debug.error(this);
    }

    public TTException(Class source, String message) {
        super(message);
        this.iSource = null;
        this.iSourceClass = source;
        this.iErrCode = TTException.getErrorCode(source.getName());
        System.err.println("Error: " + this.getMessage());
        Debug.error(this);
    }

    public TTException(Throwable source) {
        super(source.getMessage());
        this.iSource = source;
        this.iSourceClass = source.getClass();
        this.iErrCode = TTException.getErrorCode(source.getClass().getName());
        System.err.println("Error: " + this.getMessage());
        Debug.error(source);
        Debug.error(this);
    }

    public String getMessage() {
        return this.iErrCode < 0 ? "Unknown: " + super.getMessage() : sExceptions.elementAt(this.iErrCode) + ": " + super.getMessage();
    }

    public Object getSource() {
        return this.iSource;
    }

    public String getSourceMsg() {
        return this.iSource != null ? this.iSource.getClass().getName() : (this.iSourceClass != null ? this.iSourceClass.getClass().getName() : "Unknown");
    }

    public int getErrCode() {
        return this.iErrCode;
    }

    public static int registerException(String identifier) {
        sExceptions.addElement(identifier);
        return sExceptions.indexOf(identifier);
    }

    public static int getErrorCode(String identifier) {
        int idx = sExceptions.indexOf(identifier);
        return idx < 0 ? TTException.registerException(identifier) : idx;
    }

    public static void rethrow(Throwable e) throws TTException {
        if (e instanceof TTException) {
            throw (TTException)e;
        }
        throw new TTException(e);
    }
}

