/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Debug;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class Timing {
    private Hashtable iTimeStamps = new Hashtable();
    private Hashtable iTimesCounts = new Hashtable();
    private Hashtable iTimes = new Hashtable();
    private String iSource = null;

    public Timing(String source) {
        this.iSource = source;
    }

    public synchronized void begTS(Object key) {
        this.iTimeStamps.put(key, new Long(System.currentTimeMillis()));
    }

    public synchronized void endTS(Object key) {
        long endTS = System.currentTimeMillis();
        if (this.iTimeStamps.containsKey(key)) {
            long begTS = (Long)this.iTimeStamps.get(key);
            long totalTime = endTS - begTS;
            long count = 1L;
            this.iTimeStamps.remove(key);
            if (this.iTimes.containsKey(key)) {
                totalTime += ((Long)this.iTimes.get(key)).longValue();
            }
            if (this.iTimesCounts.containsKey(key)) {
                count += ((Long)this.iTimesCounts.get(key)).longValue();
            }
            this.iTimes.put(key, new Long(totalTime));
            this.iTimesCounts.put(key, new Long(count));
        }
    }

    public synchronized void clearTS() {
        this.iTimes.clear();
        this.iTimesCounts.clear();
    }

    public synchronized void printTS() {
        Debug.log("TIMELOG: (" + this.iSource + ")");
        DecimalFormat nf = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.US));
        Vector sortedKeys = new Vector();
        Enumeration<Object> e = this.iTimes.keys();
        while (e.hasMoreElements()) {
            sortedKeys.addElement(e.nextElement());
        }
        Collections.sort(sortedKeys);
        e = sortedKeys.elements();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            long time = (Long)this.iTimes.get(key);
            long count = (Long)this.iTimesCounts.get(key);
            Debug.log(key.toString() + " ... " + nf.format((double)time / 1000.0) + " s  (called " + count + "x)");
        }
        Debug.log("");
    }

    public Vector getAllKeys() {
        Vector keys = new Vector();
        Enumeration e = this.iTimes.keys();
        while (e.hasMoreElements()) {
            keys.addElement(e.nextElement());
        }
        Collections.sort(keys);
        return keys;
    }

    public long getTotalTime(Object key) {
        return (Long)this.iTimes.get(key);
    }

    public long getCallCount(Object key) {
        return (Long)this.iTimesCounts.get(key);
    }

    public synchronized long timeStamp(Object key) {
        long curTS = System.currentTimeMillis();
        long ts = 0L;
        if (this.iTimeStamps.containsKey(key)) {
            long lastTS = (Long)this.iTimeStamps.get(key);
            ts = curTS - lastTS;
        }
        this.iTimeStamps.put(key, new Long(curTS));
        return ts;
    }

    public synchronized void printTimeStamp(Object key) {
        Debug.log(key.toString() + " took " + this.timeStamp(key) + " ms");
    }
}

