/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.webutil;

import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.TimePatterns;
import edu.purdue.smas.timetable.data.Timetable;
import edu.purdue.smas.timetable.data.User;
import edu.purdue.smas.timetable.data.pattern.EveningTimePattern;
import edu.purdue.smas.timetable.data.pattern.GenericTimePattern;
import edu.purdue.smas.timetable.data.pattern.SaturdayTimePattern;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspWriter;

public class RequiredTimeTable {
    private TimePatternModel iModel = null;
    private String iName = "rtt";
    private static Preferences.Preference sNoPreference = Preferences.getPreference("0");
    private static Preferences.Preference sDefaultPreference = Preferences.getPreference("0");
    private static Hashtable sPref2color = null;
    private static Hashtable sAwtPref2color = null;
    private static SimpleDateFormat sTimeFormat = new SimpleDateFormat("h:mm");

    public RequiredTimeTable(int nrMeetings, int halfHoursPerMeeting, int patternType) throws TTException {
        if (patternType == Constants.TIME_PATTERN_STANDARD) {
            this.iModel = new StandardTimePattern(nrMeetings, halfHoursPerMeeting);
        } else if (patternType == Constants.TIME_PATTERN_GENERIC) {
            this.iModel = new GenericTimePattern(nrMeetings, halfHoursPerMeeting, false);
        } else if (patternType == Constants.TIME_PATTERN_EVENING) {
            this.iModel = new EveningTimePattern(nrMeetings, halfHoursPerMeeting);
        } else if (patternType == Constants.TIME_PATTERN_SATURDAY) {
            this.iModel = new SaturdayTimePattern(nrMeetings, halfHoursPerMeeting);
        } else {
            throw new TTException(this, "Unknown pattern type " + patternType);
        }
    }

    public RequiredTimeTable(int nrMeetings, int halfHoursPerMeeting, boolean ext) throws TTException {
        this(nrMeetings, halfHoursPerMeeting, ext ? Constants.TIME_PATTERN_GENERIC : Constants.TIME_PATTERN_STANDARD);
    }

    public RequiredTimeTable(TimePatterns.TimePattern tp) throws TTException {
        this(tp.getNumberOfMeetings(), tp.getHalfHoursPerMeeting(), tp.getGenericType());
    }

    public void setName(String name) {
        this.iName = name;
    }

    public static String pref2color(Preferences.Preference pref) {
        if (sPref2color.containsKey(pref.getProlog())) {
            return (String)sPref2color.get(pref.getProlog());
        }
        Debug.log("Unknown color for preference " + pref + ".");
        return "rgb(200,200,200)";
    }

    private static Color awtPref2color(Preferences.Preference pref) {
        if (sAwtPref2color.containsKey(pref.getProlog())) {
            return (Color)sAwtPref2color.get(pref.getProlog());
        }
        Debug.log("Unknown color for preference " + pref + ".");
        return new Color(200, 200, 200);
    }

    private String colorSelection() {
        StringBuffer ret = new StringBuffer("(");
        Enumeration e = Preferences.elements();
        while (e.hasMoreElements()) {
            Preferences.Preference pref = (Preferences.Preference)e.nextElement();
            if (e.hasMoreElements()) {
                ret.append(this.iName + "_reqSelect.value=='" + pref.getProlog() + "'?'" + RequiredTimeTable.pref2color(pref) + "':");
                continue;
            }
            ret.append("'" + RequiredTimeTable.pref2color(pref) + "'");
        }
        return ret.append(")").toString();
    }

    public void print(JspWriter out, boolean timeVertical) throws IOException {
        this.print(out, true, null, timeVertical);
    }

    private String checkConsistence(boolean timeVertical) {
        int cellY;
        int cellX;
        int maxY;
        int maxX;
        StringBuffer ret = new StringBuffer();
        ret.append("if(" + this.iName + "_reqSelect.value=='R') {");
        ret.append(this.iName + "_reqUsed.value='1';");
        if (timeVertical) {
            maxX = this.iModel.getNrTimes();
            maxY = this.iModel.getNrDays();
        } else {
            maxX = this.iModel.getNrDays();
            maxY = this.iModel.getNrTimes();
        }
        for (cellX = 0; cellX < maxX; ++cellX) {
            for (cellY = 0; cellY < maxY; ++cellY) {
                ret.append("if (" + this.iName + "_req_" + cellX + "_" + cellY + ".value!='R' && " + this.iName + "_req_" + cellX + "_" + cellY + ".value!='0') { " + this.iName + "_req_" + cellX + "_" + cellY + ".value='0'; document.getElementById('" + this.iName + "_" + cellX + "_" + cellY + "').style.backgroundColor='" + RequiredTimeTable.pref2color(Preferences.getPreference("0")) + "';};");
            }
        }
        ret.append("};");
        ret.append("if(" + this.iName + "_reqSelect.value!='0' && " + this.iName + "_reqSelect.value!='R') {");
        ret.append(this.iName + "_reqUsed.value='0';");
        for (cellX = 0; cellX < maxX; ++cellX) {
            for (cellY = 0; cellY < maxY; ++cellY) {
                ret.append("if (" + this.iName + "_req_" + cellX + "_" + cellY + ".value=='R') { " + this.iName + "_req_" + cellX + "_" + cellY + ".value='0'; document.getElementById('" + this.iName + "_" + cellX + "_" + cellY + "').style.backgroundColor='" + RequiredTimeTable.pref2color(Preferences.getPreference("0")) + "';};");
            }
        }
        ret.append("};");
        return ret.toString();
    }

    public String thHtmlText(boolean rowHeader, boolean timeVertical, boolean editable, int cellX, int cellY, int totalPositions, String headerText) {
        StringBuffer thText = new StringBuffer();
        int xPosition = 0;
        int yPosition = 0;
        if (!rowHeader) {
            yPosition = cellY;
        } else {
            xPosition = cellX;
        }
        thText.append("<th width='40' height='35' style='border:rgb(100,100,100) 1px solid;background-color:rgb(240,240,240)' onmouseover=\"this.style.border='rgb(0,0,242) 1px solid';" + (editable ? "this.style.cursor='pointer';" : "") + "\" " + "onmouseout=\"this.style.border='rgb(100,100,100) 1px solid';\" ");
        if (editable) {
            thText.append("onclick=\"" + this.checkConsistence(timeVertical) + " document.getElementById('" + this.iName + "_" + cellX + "_" + cellY + "').style.backgroundColor=" + this.colorSelection() + ";" + this.iName + "_req_" + cellX + "_" + cellY + ".value=" + this.iName + "_reqSelect.value;");
            for (int j = 1; j < totalPositions; ++j) {
                if (rowHeader) {
                    yPosition = j;
                } else {
                    xPosition = j;
                }
                thText.append("document.getElementById('" + this.iName + "_" + xPosition + "_" + yPosition + "').style.backgroundColor=document.getElementById('" + this.iName + "_" + cellX + "_" + cellY + "').style.backgroundColor;" + this.iName + "_req_" + xPosition + "_" + yPosition + ".value=" + this.iName + "_reqSelect.value;");
            }
            thText.append("\"");
        }
        thText.append(">" + headerText + "</th>");
        return thText.toString();
    }

    public String hiddenInputHtmlText(int day, int time, int cellX, int cellY) {
        return "<input type='hidden' name='" + this.iName + "_req_" + cellX + "_" + cellY + "' " + "id='" + this.iName + "_req_" + cellX + "_" + cellY + "' " + " value='" + this.iModel.getPreference(day, time).getProlog() + "'>";
    }

    public String annotationOnclickHtmlText(Preferences.Preference pref, String reqUsedValue, String alertText) {
        StringBuffer onclickText = new StringBuffer();
        onclickText.append("onClick=\"document.getElementById('" + this.iName + "_req'+" + this.iName + "_reqSelect.value).style.border='rgb(255,255,255) 2px solid';" + this.iName + "_reqSelect.value='" + pref.getProlog() + "';" + "document.getElementById('" + this.iName + "_req'+" + this.iName + "_reqSelect.value).style.border='rgb(0,0,240) 2px solid';");
        if (alertText != null) {
            onclickText.append("if (" + this.iName + "_reqUsed.value=='" + reqUsedValue + "') {alert('" + alertText + "'); };\" ");
        } else {
            onclickText.append("\" ");
        }
        return onclickText.toString();
    }

    public String annotationsTableHtmlText(boolean editable) {
        StringBuffer tableHtml = new StringBuffer();
        tableHtml.append("<table border='0' cellpadding='2' cellspacing='2'>");
        Enumeration e = Preferences.elements();
        while (e.hasMoreElements()) {
            Preferences.Preference pref = (Preferences.Preference)e.nextElement();
            boolean required = pref.getProlog().equals("R");
            boolean neutral = pref.getProlog().equals("0");
            tableHtml.append("<tr align='left' id='" + this.iName + "_req" + pref.getProlog() + "' ");
            if (editable) {
                if (required) {
                    tableHtml.append(this.annotationOnclickHtmlText(pref, "0", "WARNING: Application of required preference will remove all not required preferences."));
                } else if (!neutral) {
                    tableHtml.append(this.annotationOnclickHtmlText(pref, "1", "WARNING: Application of " + pref.getName().toLowerCase() + " preference will remove all required preferences."));
                } else {
                    tableHtml.append(this.annotationOnclickHtmlText(pref, null, null));
                }
            }
            tableHtml.append(" onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';" + (editable ? "this.style.cursor='pointer';" : "") + "\" " + " onmouseout=\"this.style.backgroundColor='rgb(255,255,255)';\">");
            tableHtml.append("<td width='40' style='border:rgb(0,0,0) 2px solid;background-color:" + RequiredTimeTable.pref2color(pref) + "'>&nbsp;</td>");
            tableHtml.append("<th>" + pref.getName() + "</th></tr>");
        }
        tableHtml.append("</table>");
        return tableHtml.toString();
    }

    public String tdHtmlText(boolean timeVertical, boolean editable, boolean reqUsed, Preferences.Preference pref, Vector slotsToHighlight, int day, int time, int cellX, int cellY) {
        StringBuffer tdText = new StringBuffer();
        String methName = "<tdHtmlText> - ";
        boolean highlight = slotsToHighlight != null && slotsToHighlight.containsAll(this.iModel.getStartSlots(day, time));
        tdText.append("<td id='" + this.iName + "_" + cellX + "_" + cellY + "' style='border:" + (highlight ? "rgb(0,0,242) 2px" : "rgb(100,100,100) 1px") + " solid;background-color:" + RequiredTimeTable.pref2color(pref) + "' " + "onmouseover=\"this.style.border='" + (highlight ? "rgb(0,0,242) 2px" : "rgb(0,0,242) 1px") + " solid';" + (editable ? "this.style.cursor='pointer';" : "") + "\" " + "onmouseout=\"this.style.border='" + (highlight ? "rgb(0,0,242) 2px" : "rgb(100,100,100) 1px") + " solid';\" ");
        if (editable) {
            tdText.append("onclick=\"" + this.checkConsistence(timeVertical) + " this.style.backgroundColor=" + this.colorSelection() + ";" + this.iName + "_req_" + cellX + "_" + cellY + ".value=" + this.iName + "_reqSelect.value;\"");
        }
        if (editable) {
            tdText.append(">&nbsp</td>");
        } else {
            tdText.append(">" + (int)this.iModel.getNormalizedPreference(day, time) + "</td>");
        }
        return tdText.toString();
    }

    public String timeHorizontalTimePrefTableHtml(boolean editable, Vector slotsToHighlight) {
        int j;
        int i;
        StringBuffer tableHtml = new StringBuffer();
        tableHtml.append("<table border='0'><tr><td>");
        tableHtml.append("<input type='hidden' name='" + this.iName + "_reqSelect' id='" + this.iName + "_reqSelect' value='" + sDefaultPreference.getProlog() + "'>");
        boolean reqUsed = false;
        for (i = 0; i < this.iModel.getNrTimes(); ++i) {
            for (j = 0; j < this.iModel.getNrDays(); ++j) {
                tableHtml.append(this.hiddenInputHtmlText(j, i, j, i));
            }
        }
        tableHtml.append("<table border='0' cellpadding='2' cellspacing='0'>");
        tableHtml.append("<tr><th align='right'>from:<br><font color='gray'>to:</font></th>");
        for (i = 0; i < this.iModel.getNrTimes(); ++i) {
            tableHtml.append(this.thHtmlText(false, false, editable, 0, i, this.iModel.getNrDays(), this.iModel.getTimeHeader(i)));
        }
        for (i = 0; i < this.iModel.getNrDays(); ++i) {
            tableHtml.append("<tr>");
            tableHtml.append(this.thHtmlText(true, false, editable, i, 0, this.iModel.getNrTimes(), this.iModel.getDayHeader(i)));
            for (j = 0; j < this.iModel.getNrTimes(); ++j) {
                Preferences.Preference pref = this.iModel.getPreference(i, j);
                if (pref.getProlog().equals("R")) {
                    reqUsed = true;
                }
                tableHtml.append(this.tdHtmlText(false, editable, reqUsed, pref, slotsToHighlight, i, j, i, j));
            }
            tableHtml.append("</tr>");
        }
        tableHtml.append("</table>");
        tableHtml.append("</td><td width='10'>&nbsp;</td><td>");
        tableHtml.append(this.annotationsTableHtmlText(editable));
        tableHtml.append("</td></tr></table>");
        if (editable) {
            tableHtml.append("<input type='hidden' name='" + this.iName + "_reqUsed' id='" + this.iName + "_reqUsed' value='" + (reqUsed ? "1" : "0") + "'>");
        }
        return tableHtml.toString();
    }

    public String timeVerticalTimePrefTableHtml(boolean editable, Vector slotsToHighlight) {
        int j;
        int i;
        StringBuffer tableHtml = new StringBuffer();
        tableHtml.append("<table border='0'><tr><td>");
        tableHtml.append("<input type='hidden' name='" + this.iName + "_reqSelect' id='" + this.iName + "_reqSelect' value='" + sDefaultPreference.getProlog() + "'>");
        boolean reqUsed = false;
        for (i = 0; i < this.iModel.getNrDays(); ++i) {
            for (j = 0; j < this.iModel.getNrTimes(); ++j) {
                tableHtml.append(this.hiddenInputHtmlText(i, j, j, i));
            }
        }
        tableHtml.append("<table border='0' cellpadding='2' cellspacing='0'>");
        tableHtml.append("<tr><th align='right'>from:<br><font color='gray'>to:</font></th>");
        for (i = 0; i < this.iModel.getNrDays(); ++i) {
            tableHtml.append(this.thHtmlText(false, true, editable, 0, i, this.iModel.getNrTimes(), this.iModel.getDayHeader(i)));
        }
        for (i = 0; i < this.iModel.getNrTimes(); ++i) {
            tableHtml.append("<tr>");
            tableHtml.append(this.thHtmlText(true, true, editable, i, 0, this.iModel.getNrDays(), this.iModel.getTimeHeader(i)));
            for (j = 0; j < this.iModel.getNrDays(); ++j) {
                Preferences.Preference pref = this.iModel.getPreference(j, i);
                if (pref.getProlog().equals("R")) {
                    reqUsed = true;
                }
                tableHtml.append(this.tdHtmlText(true, editable, reqUsed, pref, slotsToHighlight, j, i, i, j));
            }
            tableHtml.append("</tr>");
        }
        tableHtml.append("</table>");
        tableHtml.append("</td><td width='10'>&nbsp;</td><td>");
        tableHtml.append(this.annotationsTableHtmlText(editable));
        tableHtml.append("</td></tr></table>");
        if (editable) {
            tableHtml.append("<input type='hidden' name='" + this.iName + "_reqUsed' id='" + this.iName + "_reqUsed' value='" + (reqUsed ? "1" : "0") + "'>");
        }
        return tableHtml.toString();
    }

    public void print(JspWriter out, boolean editable, Vector timetable, boolean timeVertical) throws IOException {
        Vector<Integer> slotsToHighlight = null;
        if (timetable != null && !timetable.isEmpty()) {
            slotsToHighlight = new Vector<Integer>();
            Enumeration e = timetable.elements();
            while (e.hasMoreElements()) {
                Timetable t = (Timetable)e.nextElement();
                slotsToHighlight.addElement(new Integer(t.getSlot()));
            }
        }
        if (timeVertical) {
            out.print(this.timeVerticalTimePrefTableHtml(editable, slotsToHighlight));
        } else {
            out.print(this.timeHorizontalTimePrefTableHtml(editable, slotsToHighlight));
        }
    }

    public void update(ServletRequest request, boolean timeVertical) {
        int minY;
        int minX;
        if (timeVertical) {
            minX = this.iModel.getNrTimes();
            minY = this.iModel.getNrDays();
        } else {
            minX = this.iModel.getNrDays();
            minY = this.iModel.getNrTimes();
        }
        for (int cellX = 0; cellX < minX; ++cellX) {
            for (int cellY = 0; cellY < minY; ++cellY) {
                int time;
                int day;
                if (timeVertical) {
                    day = cellY;
                    time = cellX;
                } else {
                    day = cellX;
                    time = cellY;
                }
                String prefStr = request.getParameter(this.iName + "_req_" + cellX + "_" + cellY);
                this.iModel.setPreference(day, time, prefStr == null ? sNoPreference : Preferences.getPreference(prefStr));
            }
        }
    }

    public Vector toStrings() {
        Vector<String> ret = new Vector<String>();
        Hashtable req = new Hashtable();
        this.iModel.storeTimeRequirements(req);
        Enumeration e = req.keys();
        while (e.hasMoreElements()) {
            Class.TimeRequirement r = (Class.TimeRequirement)e.nextElement();
            Preferences.Preference p = (Preferences.Preference)req.get(r);
            ret.addElement(p.getName() + ": " + r.getDaysStr() + " " + sTimeFormat.format(r.getStartTime()) + (r.getEndTime() == null ? "" : sTimeFormat.format(r.getEndTime())));
        }
        return ret;
    }

    public void loadTimeRequirements(Hashtable requirements) {
        this.iModel.loadTimeRequirements(requirements);
    }

    public void storeTimeRequirements(Hashtable ret) {
        this.iModel.storeTimeRequirements(ret);
    }

    public void setDefaults(User user) throws TTException, SQLException {
        this.iModel.setDefaults(user);
    }

    public String toString() {
        return "RequiredTimes{" + this.toStrings() + "}";
    }

    public static void main(String[] args) {
        try {
            RequiredTimeTable rtt = new RequiredTimeTable(1, 2, false);
            rtt.getModel().setPreference(0, 2, Preferences.getPreference("R"));
            rtt.getModel().setPreference(1, 0, Preferences.getPreference("-1"));
            rtt.getModel().setPreference(2, 0, Preferences.getPreference("-2"));
            rtt.getModel().setPreference(3, 0, Preferences.getPreference("1"));
            rtt.getModel().setPreference(4, 0, Preferences.getPreference("P"));
            rtt.createImage(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public TimePatternModel getModel() {
        return this.iModel;
    }

    public String shortIdent() {
        BigInteger idn = new BigInteger("0");
        for (int d = 0; d < this.iModel.getNrDays(); ++d) {
            for (int t = 0; t < this.iModel.getNrTimes(); ++t) {
                idn = idn.multiply(new BigInteger("7")).add(new BigInteger(String.valueOf(this.iModel.getPreference(d, t).getId() - 1)));
            }
        }
        return this.iModel.getNrMeetings() + "x" + this.iModel.getNrHalfHoursPerMeeting() + "_" + idn.toString(16);
    }

    private static void drawVline(int x, int y1, int y2, int dy1, int dy2, Graphics2D g) {
        for (int v = y1; v <= y2; v += dy1 + dy2) {
            g.drawLine(x, v, x, Math.min(y2, v + dy1));
        }
    }

    private static void drawHline(int x1, int x2, int y, int dx1, int dx2, Graphics2D g) {
        for (int h = x1; h <= x2; h += dx1 + dx2) {
            g.drawLine(h, y, Math.min(x2, h + dx1), y);
        }
    }

    public static RequiredTimeTable getRequiredTimeTable(Class c) throws TTException, SQLException {
        if (c.getTimePattern() == null) {
            return null;
        }
        RequiredTimeTable rtt = new RequiredTimeTable(c.getTimePattern().getNumberOfMeetings(), c.getTimePattern().getHalfHoursPerMeeting(), c.getTimePattern().getGenericType());
        rtt.loadTimeRequirements(c.getTimeRequirements());
        return rtt;
    }

    private void putPixel(WritableRaster raster, int x, int y, Color color) {
        raster.setPixel(x, y, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
    }

    private void drawHline(WritableRaster raster, int x, int y, int width, Color color) {
        for (int i = 0; i < width; ++i) {
            this.putPixel(raster, x + i, y, color);
        }
    }

    private void drawVline(WritableRaster raster, int x, int y, int width, Color color) {
        for (int i = 0; i < width; ++i) {
            this.putPixel(raster, x, y + i, color);
        }
    }

    private void fillRect(WritableRaster raster, int x, int y, int width, int height, Color color) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.putPixel(raster, x + i, y + j, color);
            }
        }
    }

    public File createImage(boolean timeVertical) throws IOException {
        return this.createImage(false, null, null, timeVertical);
    }

    public File createImage(boolean stroked, boolean timeVertical) throws IOException {
        return this.createImage(stroked, null, null, timeVertical);
    }

    public File createImage(boolean stroked, Vector timetables, boolean timeVertical) throws IOException {
        return this.createImage(stroked, timetables, null, timeVertical);
    }

    public File createImage(boolean stroked, Vector timetables, Vector timetablesRed, boolean timeVertical) throws IOException {
        File file;
        Timetable t;
        Enumeration e;
        int cellsDown;
        int cellsAcross;
        char axisId;
        int lineWidth = 1;
        int cellWidth = 5;
        Vector<Integer> slotsToHighlight = null;
        Vector<Integer> slotsToHighlightRed = null;
        long slotNum = 0L;
        long slotNumRed = 0L;
        int cellX = 0;
        int cellY = 0;
        if (timeVertical) {
            axisId = 'V';
            cellsAcross = this.iModel.getNrDays();
            cellsDown = this.iModel.getNrTimes();
        } else {
            axisId = 'H';
            cellsAcross = this.iModel.getNrTimes();
            cellsDown = this.iModel.getNrDays();
        }
        if (timetables != null && !timetables.isEmpty()) {
            slotsToHighlight = new Vector<Integer>();
            e = timetables.elements();
            while (e.hasMoreElements()) {
                t = (Timetable)e.nextElement();
                slotsToHighlight.addElement(new Integer(t.getSlot()));
                slotNum = slotNum * (long)Constants.SLOTS_PER_DAY * (long)Constants.DAY_CODES.length + (long)t.getSlot();
            }
        }
        if (timetablesRed != null && !timetablesRed.isEmpty()) {
            slotsToHighlightRed = new Vector<Integer>();
            e = timetablesRed.elements();
            while (e.hasMoreElements()) {
                t = (Timetable)e.nextElement();
                slotsToHighlightRed.addElement(new Integer(t.getSlot()));
                slotNumRed = slotNumRed * (long)Constants.SLOTS_PER_DAY * (long)Constants.DAY_CODES.length + (long)t.getSlot();
            }
        }
        if ((file = new File(Config.get("TEMP_DIR") + File.separator + this.shortIdent() + (stroked ? "x" : "") + (timetables == null ? "" : Long.toString(slotNum, 16)) + (timetablesRed == null ? "" : "r" + Long.toString(slotNumRed, 16)) + axisId + ".png")).exists()) {
            return file;
        }
        Debug.log("Writing image " + file + " ...");
        BufferedImage image = new BufferedImage((cellsAcross * cellWidth + cellsAcross + 1) * lineWidth, cellsDown * cellWidth + (cellsDown + 1) * lineWidth, 1);
        WritableRaster raster = image.getRaster();
        int width = image.getWidth();
        int height = image.getHeight();
        for (int cellY2 = 0; cellY2 < cellsDown + 1; ++cellY2) {
            this.drawHline(raster, 0, cellY2 * (cellWidth + lineWidth), width, Color.darkGray);
            for (int cellX2 = 0; cellX2 < cellsAcross + 1; ++cellX2) {
                this.drawVline(raster, cellX2 * (cellWidth + lineWidth), 0, height, Color.darkGray);
            }
        }
        for (int day = 0; day < this.iModel.getNrDays() + 1; ++day) {
            if (timeVertical) {
                cellX = day;
            } else {
                cellY = day;
            }
            for (int time = 0; time < this.iModel.getNrTimes() + 1; ++time) {
                if (timeVertical) {
                    cellY = time;
                } else {
                    cellX = time;
                }
                if (day >= this.iModel.getNrDays() || time >= this.iModel.getNrTimes()) continue;
                if (slotsToHighlight != null && slotsToHighlight.containsAll(this.iModel.getStartSlots(day, time))) {
                    this.fillRect(raster, cellX * (cellWidth + lineWidth), cellY * (cellWidth + lineWidth), cellWidth + 2, cellWidth + 2, new Color(0, 0, 242));
                    this.fillRect(raster, cellX * (cellWidth + lineWidth) + 2, cellY * (cellWidth + lineWidth) + 2, cellWidth - 2, cellWidth - 2, RequiredTimeTable.awtPref2color(this.iModel.getPreference(day, time)));
                    continue;
                }
                if (slotsToHighlightRed != null && slotsToHighlightRed.containsAll(this.iModel.getStartSlots(day, time))) {
                    this.fillRect(raster, cellX * (cellWidth + lineWidth), cellY * (cellWidth + lineWidth), cellWidth + 2, cellWidth + 2, new Color(242, 0, 0));
                    this.fillRect(raster, cellX * (cellWidth + lineWidth) + 2, cellY * (cellWidth + lineWidth) + 2, cellWidth - 2, cellWidth - 2, RequiredTimeTable.awtPref2color(this.iModel.getPreference(day, time)));
                    continue;
                }
                this.fillRect(raster, cellX * (cellWidth + lineWidth) + 1, cellY * (cellWidth + lineWidth) + 1, cellWidth, cellWidth, RequiredTimeTable.awtPref2color(this.iModel.getPreference(day, time)));
            }
        }
        if (stroked) {
            double delta = (double)height / (double)width;
            double y = 0.0;
            for (int x = 0; x < width; ++x) {
                this.putPixel(raster, x, (int)Math.min(Math.round(y), (long)(height - 1)), Color.black);
                this.putPixel(raster, x, (int)Math.min((long)height - Math.round(y), (long)(height - 1)), Color.black);
                y += delta;
            }
        }
        ImageIO.write((RenderedImage)image, "PNG", file);
        return file;
    }

    static {
        sPref2color = new Hashtable();
        sPref2color.put("R", "rgb(60,60,180)");
        sPref2color.put("-2", "rgb(20,160,40)");
        sPref2color.put("-1", "rgb(150,240,40)");
        sPref2color.put("0", "rgb(240,240,240)");
        sPref2color.put("1", "rgb(240,200,40)");
        sPref2color.put("2", "rgb(240,100,40)");
        sPref2color.put("P", "rgb(200,30,20)");
        sAwtPref2color = new Hashtable();
        sAwtPref2color.put("R", new Color(60, 60, 180));
        sAwtPref2color.put("-2", new Color(20, 160, 40));
        sAwtPref2color.put("-1", new Color(150, 240, 40));
        sAwtPref2color.put("0", new Color(240, 240, 240));
        sAwtPref2color.put("1", new Color(240, 200, 40));
        sAwtPref2color.put("2", new Color(240, 100, 40));
        sAwtPref2color.put("P", new Color(200, 30, 20));
    }
}

