/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.csp;

import ifs.example.csp.CSPModel;
import ifs.example.csp.CSPVariable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import java.util.Enumeration;
import org.apache.log4j.BasicConfigurator;

public class SimpleTest {
    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        int n = 25;
        int n2 = 12;
        int n3 = 198;
        double d = 0.25;
        int n4 = n2 * n2;
        int n5 = (int)((1.0 - d) * (double)n4);
        long l = System.currentTimeMillis();
        System.out.println("CSP(" + n + "," + n2 + "," + n3 + "/" + n * (n - 1) / 2 + "," + (n4 - n5) + "/" + n4 + ")");
        DataProperties dataProperties = new DataProperties();
        dataProperties.setProperty("Termination.Class", "ifs.termination.GeneralTerminationCondition");
        dataProperties.setProperty("Termination.StopWhenComplete", "true");
        dataProperties.setProperty("Termination.TimeOut", "60");
        dataProperties.setProperty("Comparator.Class", "ifs.solution.GeneralSolutionComparator");
        dataProperties.setProperty("Value.Class", "ifs.heuristics.GeneralValueSelection");
        dataProperties.setProperty("Value.WeightConflicts", "1");
        dataProperties.setProperty("Variable.Class", "ifs.heuristics.GeneralVariableSelection");
        dataProperties.setProperty("Extensions.Classes", "ifs.extension.ConflictStatistics");
        CSPModel cSPModel = new CSPModel(n, n2, n3, n5, l);
        Solver solver = new Solver(dataProperties);
        solver.setInitalSolution(cSPModel);
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Solution solution = solver.lastSolution();
        solution.restoreBest();
        System.out.println("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations).");
        System.out.println("Number of assigned variables is " + solution.getModel().assignedVariables().size());
        System.out.println("Total value of the solution is " + solution.getModel().getTotalValue());
        int n6 = 1;
        Enumeration enumeration = solution.getModel().variables().elements();
        while (enumeration.hasMoreElements()) {
            CSPVariable cSPVariable = (CSPVariable)enumeration.nextElement();
            if (cSPVariable.getAssignment() == null) continue;
            System.out.println("Var" + n6++ + "=" + cSPVariable.getAssignment().toInt());
        }
    }
}

