/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.rpp;

import ifs.example.rpp.Location;
import ifs.example.rpp.Rectangle;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.ToolBox;
import java.util.Enumeration;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResourceConstraint
extends Constraint {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$rpp$ResourceConstraint == null ? (class$ifs$example$rpp$ResourceConstraint = ResourceConstraint.class$("ifs.example.rpp.ResourceConstraint")) : class$ifs$example$rpp$ResourceConstraint));
    private Variable[][] iResource;
    private int iWidth;
    private int iHeight;
    static /* synthetic */ Class class$ifs$example$rpp$ResourceConstraint;

    public ResourceConstraint(int n, int n2) {
        this.iWidth = n;
        this.iHeight = n2;
        this.iResource = new Variable[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.iResource[i][j] = null;
            }
        }
    }

    public void computeConflicts(Value value, Set set) {
        Rectangle rectangle = (Rectangle)value.variable();
        Location location = (Location)value;
        for (int i = location.getX(); i < Math.min(this.iWidth, location.getX() + rectangle.getWidth()); ++i) {
            for (int j = location.getY(); j < Math.min(this.iHeight, location.getY() + rectangle.getHeight()); ++j) {
                if (this.iResource[i][j] == null) continue;
                set.add(this.iResource[i][j].getAssignment());
            }
        }
    }

    public boolean inConflict(Value value) {
        Rectangle rectangle = (Rectangle)value.variable();
        Location location = (Location)value;
        for (int i = location.getX(); i < Math.min(this.iWidth, location.getX() + rectangle.getWidth()); ++i) {
            for (int j = location.getY(); j < Math.min(this.iHeight, location.getY() + rectangle.getHeight()); ++j) {
                if (this.iResource[i][j] == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        Rectangle rectangle = (Rectangle)value.variable();
        Location location = (Location)value;
        Rectangle rectangle2 = (Rectangle)value2.variable();
        Location location2 = (Location)value2;
        if (location2.getX() + rectangle2.getWidth() <= location.getX()) {
            return true;
        }
        if (location2.getX() >= location.getX() + rectangle.getWidth()) {
            return true;
        }
        if (location2.getY() + rectangle2.getHeight() <= location.getY()) {
            return true;
        }
        return location2.getY() >= location.getY() + rectangle.getHeight();
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        Rectangle rectangle = (Rectangle)value.variable();
        Location location = (Location)value;
        for (int i = location.getX(); i < Math.min(this.iWidth, location.getX() + rectangle.getWidth()); ++i) {
            for (int j = location.getY(); j < Math.min(this.iHeight, location.getY() + rectangle.getHeight()); ++j) {
                this.iResource[i][j] = value.variable();
            }
        }
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        Rectangle rectangle = (Rectangle)value.variable();
        Location location = (Location)value;
        for (int i = location.getX(); i < Math.min(this.iWidth, location.getX() + rectangle.getWidth()); ++i) {
            for (int j = location.getY(); j < Math.min(this.iHeight, location.getY() + rectangle.getHeight()); ++j) {
                this.iResource[i][j] = null;
            }
        }
    }

    public void check() {
        sLogger.debug((Object)"check");
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle = (Rectangle)enumeration.nextElement();
            Location location = (Location)rectangle.getAssignment();
            if (location == null) {
                sLogger.warn((Object)("Rectangle " + rectangle.getName() + " is not assigned."));
                continue;
            }
            sLogger.debug((Object)("Checking " + rectangle.getName() + "    (assigned:" + location.getName() + ", prohibited:" + rectangle.isProhibited(location.getX(), location.getY()) + ", initial:" + rectangle.getInitialAssignment() + ", prohibited:[" + rectangle.getProhibitedX() + "," + rectangle.getProhibitedY() + "])"));
            if (location.getX() == rectangle.getProhibitedX() || location.getY() == rectangle.getProhibitedY()) {
                sLogger.error((Object)"Placement is prohibited.");
            }
            if (location.getX() < rectangle.getMinX() || location.getX() > rectangle.getMaxX() || location.getY() < rectangle.getMinY() || location.getY() > rectangle.getMaxY()) {
                sLogger.error((Object)"Placement is outside bounds.");
            }
            for (int i = location.getX(); i < Math.min(this.iWidth, location.getX() + rectangle.getWidth()); ++i) {
                for (int j = location.getY(); j < Math.min(this.iHeight, location.getY() + rectangle.getHeight()); ++j) {
                    if (this.iResource[i][j] != null && this.iResource[i][j].equals(rectangle)) continue;
                    sLogger.error((Object)("Problem at [" + i + "," + j + "], " + this.iResource[i][j] + " is assigned there."));
                }
            }
        }
        sLogger.debug((Object)this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResourceConstraint{\n        ");
        for (int i = 0; i < this.iHeight; ++i) {
            for (int j = 0; j < this.iWidth; ++j) {
                stringBuffer.append(ToolBox.trim(this.iResource[j][i] == null ? "" : ((Rectangle)this.iResource[j][i]).getName().substring(4), 4));
            }
            stringBuffer.append("\n        ");
        }
        stringBuffer.append("\n      }");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

