/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.rpp;

import ifs.example.rpp.Location;
import ifs.example.rpp.RPPModel;
import ifs.example.rpp.Rectangle;
import ifs.example.rpp.ResourceConstraint;
import ifs.model.Model;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.JProf;
import ifs.util.Progress;
import ifs.util.ProgressWriter;
import ifs.util.PrologFile;
import ifs.util.ToolBox;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Test {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$rpp$Test == null ? (class$ifs$example$rpp$Test = Test.class$("ifs.example.rpp.Test")) : class$ifs$example$rpp$Test));
    static /* synthetic */ Class class$ifs$example$rpp$Test;

    private static Model loadModel(int n, int n2, Vector vector, Vector vector2, Vector vector3, int n3, int n4) {
        try {
            int n5;
            int n6;
            Object object;
            PrologFile.Term term;
            sLogger.debug((Object)("Loading model " + n3 + "." + n4 + " ..."));
            double d = JProf.currentTimeSec();
            RPPModel rPPModel = new RPPModel();
            ResourceConstraint resourceConstraint = new ResourceConstraint(n, n2);
            rPPModel.addConstraint(resourceConstraint);
            Enumeration enumeration = ((PrologFile.Term)((PrologFile.Term)vector.elementAt(0)).getContent().elementAt(0)).getContent().elements();
            while (enumeration.hasMoreElements()) {
                term = (PrologFile.Term)enumeration.nextElement();
                object = term.elementAt(0).elementAt(0).getText();
                n6 = term.elementAt(1).elementAt(0).elementAt(0).toInt();
                n5 = term.elementAt(1).elementAt(0).elementAt(1).toInt();
                String string = term.elementAt(2).elementAt(0).elementAt(0).getText();
                String string2 = term.elementAt(2).elementAt(0).elementAt(1).getText();
                int n7 = Integer.parseInt(string.substring(0, string.indexOf(45)));
                int n8 = Integer.parseInt(string.substring(string.indexOf(45) + 1));
                int n9 = Integer.parseInt(string2.substring(0, string2.indexOf(45)));
                int n10 = Integer.parseInt(string2.substring(string2.indexOf(45) + 1));
                Rectangle rectangle = new Rectangle((String)object, n6, n5, n7, n8, n9, n10, null);
                rPPModel.addVariable(rectangle);
                resourceConstraint.addVariable(rectangle);
            }
            enumeration = ((PrologFile.Term)vector2.elementAt(0)).elementAt(0).getContent().elements();
            while (enumeration.hasMoreElements()) {
                term = (PrologFile.Term)enumeration.nextElement();
                object = term.elementAt(0).getText();
                object = ((String)object).substring(0, ((String)object).length() - 1);
                n6 = term.elementAt(1).elementAt(0).toInt();
                term = (PrologFile.Term)enumeration.nextElement();
                n5 = term.elementAt(1).elementAt(0).toInt();
                rPPModel.getRectangle((String)object).setInitialAssignment(new Location(rPPModel.getRectangle((String)object), n6, n5));
            }
            enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                term = (PrologFile.Term)enumeration.nextElement();
                if (n4 != term.elementAt(0).toInt() || n3 != term.elementAt(1).toInt() || n3 <= 0) continue;
                object = term.elementAt(2).getContent().elements();
                while (object.hasMoreElements()) {
                    n6 = ((PrologFile.Term)object.nextElement()).toInt();
                    rPPModel.getRectangle("rect" + n6).setProhibited();
                }
            }
            sLogger.debug((Object)("Loaded in " + sDoubleFormat.format(JProf.currentTimeSec() - d) + " sec."));
            return rPPModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Model loadModel(int n, int n2, Vector vector) {
        try {
            sLogger.debug((Object)"Loading model ...");
            double d = JProf.currentTimeSec();
            RPPModel rPPModel = new RPPModel();
            ResourceConstraint resourceConstraint = new ResourceConstraint(n, n2);
            rPPModel.addConstraint(resourceConstraint);
            Enumeration enumeration = ((PrologFile.Term)((PrologFile.Term)vector.elementAt(0)).getContent().elementAt(0)).getContent().elements();
            while (enumeration.hasMoreElements()) {
                PrologFile.Term term = (PrologFile.Term)enumeration.nextElement();
                String string = term.elementAt(0).elementAt(0).getText();
                int n3 = term.elementAt(1).elementAt(0).elementAt(0).toInt();
                int n4 = term.elementAt(1).elementAt(0).elementAt(1).toInt();
                String string2 = term.elementAt(2).elementAt(0).elementAt(0).getText();
                String string3 = term.elementAt(2).elementAt(0).elementAt(1).getText();
                int n5 = Integer.parseInt(string2.substring(0, string2.indexOf(45)));
                int n6 = Integer.parseInt(string2.substring(string2.indexOf(45) + 1));
                int n7 = Integer.parseInt(string3.substring(0, string3.indexOf(45)));
                int n8 = Integer.parseInt(string3.substring(string3.indexOf(45) + 1));
                Rectangle rectangle = new Rectangle(string, n3, n4, n5, n6, n7, n8, null);
                rPPModel.addVariable(rectangle);
                resourceConstraint.addVariable(rectangle);
            }
            sLogger.debug((Object)("Loaded in " + sDoubleFormat.format(JProf.currentTimeSec() - d) + " sec."));
            return rPPModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void testMPP(DataProperties dataProperties) {
        try {
            FileInputStream fileInputStream = new FileInputStream(dataProperties.getProperty("General.Input") + ".pl");
            Vector vector = PrologFile.readTermsFromStream(fileInputStream, "objects");
            fileInputStream.close();
            fileInputStream = new FileInputStream(dataProperties.getProperty("General.Input") + ".solution");
            Vector vector2 = PrologFile.readTermsFromStream(fileInputStream, "assigned");
            fileInputStream.close();
            fileInputStream = new FileInputStream(dataProperties.getProperty("General.Input") + ".mpp");
            Vector vector3 = PrologFile.readTermsFromStream(fileInputStream, "perturbation");
            fileInputStream.close();
            PrintWriter printWriter = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "result.pl"));
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "stat.pl"));
            PrintWriter printWriter3 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "stat.csv"));
            printWriter3.println("pert;time[s];timeRMS;assigned;assignedRMS;perturbations;perturbationsRMS;iters;itersRMS");
            DecimalFormat decimalFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
            int n = -1;
            int n2 = dataProperties.getPropertyInt("Rpp.NrTests", 10);
            int n3 = dataProperties.getPropertyInt("Rpp.Step", 4);
            int n4 = dataProperties.getPropertyInt("Rpp.Min", 0);
            int n5 = dataProperties.getPropertyInt("Rpp.Max", -1);
            for (int i = n4; n == -1 || i <= (n5 > 0 ? Math.min(n5, n) : n); i += n3) {
                double d = 0.0;
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                double d2 = 0.0;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                for (int j = 1; j <= n2; ++j) {
                    Model model = Test.loadModel(dataProperties.getPropertyInt("Rpp.ProblemWidth", 40), dataProperties.getPropertyInt("Rpp.ProblemHeight", 14), vector, vector2, vector3, i, j);
                    if (n < 0) {
                        n = model.variables().size();
                    }
                    Solver solver = new Solver(dataProperties);
                    solver.setInitalSolution(model);
                    solver.start();
                    solver.getSolverThread().join();
                    Solution solution = solver.currentSolution();
                    solution.restoreBest();
                    printWriter.println("result(" + j + "," + i + "," + decimalFormat.format(solution.getBestTime()) + "," + (solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()) + "," + solution.getBestIteration() + ",");
                    Vector vector4 = solution.getModel().bestUnassignedVariables();
                    if (vector4 == null) {
                        vector4 = new FastVector();
                    }
                    printWriter.print("  unassigned(" + 2 * vector4.size() + "/[");
                    Object object = vector4.elements();
                    while (object.hasMoreElements()) {
                        Rectangle rectangle = (Rectangle)object.nextElement();
                        printWriter.print(rectangle.getName() + "X," + rectangle.getName() + "Y" + (object.hasMoreElements() ? "," : ""));
                    }
                    printWriter.println("]),");
                    object = new StringBuffer();
                    int n6 = 0;
                    Enumeration enumeration = solution.getModel().variables().elements();
                    while (enumeration.hasMoreElements()) {
                        Rectangle rectangle = (Rectangle)enumeration.nextElement();
                        if (!(rectangle.getBestAssignment() == null || rectangle.getInitialAssignment() != null && rectangle.getBestAssignment().equals(rectangle.getInitialAssignment()))) {
                            ((StringBuffer)object).append(((StringBuffer)object).length() == 0 ? "" : ",");
                            ((StringBuffer)object).append(rectangle.getName() + "X-" + ((Location)rectangle.getBestAssignment()).getX());
                            ((StringBuffer)object).append(((StringBuffer)object).length() == 0 ? "" : ",");
                            ((StringBuffer)object).append(rectangle.getName() + "Y-" + ((Location)rectangle.getBestAssignment()).getY());
                            ++n6;
                        }
                        if (rectangle.getBestAssignment() != null) continue;
                        ++n6;
                    }
                    printWriter.println("  perturbations(" + 2 * n6 + "/[" + object + "])");
                    printWriter.println(").");
                    printWriter.flush();
                    l3 += solution.getBestIteration();
                    l6 += solution.getBestIteration() * solution.getBestIteration();
                    d += solution.getBestTime();
                    d2 += solution.getBestTime() * solution.getBestTime();
                    l += (long)(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
                    l4 += (long)((solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()) * (solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()));
                    l2 += (long)n6;
                    l5 += (long)(n6 * n6);
                }
                printWriter3.println(i + ";" + decimalFormat.format(d / (double)n2) + ";" + decimalFormat.format(ToolBox.rms(n2, d, d2)) + ";" + decimalFormat.format((double)l / (double)n2) + ";" + decimalFormat.format(ToolBox.rms(n2, l, l4)) + ";" + decimalFormat.format((double)l2 / (double)n2) + ";" + decimalFormat.format(ToolBox.rms(n2, l2, l5)) + ";" + decimalFormat.format((double)l3 / (double)n2) + ";" + decimalFormat.format(ToolBox.rms(n2, l3, l6)));
                printWriter3.flush();
                printWriter2.println("averages( initperturbations( " + i + " ), time( " + decimalFormat.format(d / (double)n2) + " ), assigned( " + decimalFormat.format((double)l / (double)n2) + " ), perturbations( " + decimalFormat.format((double)l2 / (double)n2) + " ) ).");
                printWriter2.println("deviations( initperturbations( " + i + " ), time( " + decimalFormat.format(ToolBox.rms(n2, d, d2)) + " ), assigned( " + decimalFormat.format(ToolBox.rms(n2, l, l4)) + " ), perturbations( " + decimalFormat.format(ToolBox.rms(n2, l2, l5)) + " ) ).");
                printWriter2.flush();
            }
            printWriter.close();
            printWriter3.close();
            printWriter2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void test(DataProperties dataProperties) {
        try {
            int n = dataProperties.getPropertyInt("Rpp.NrTests", 10);
            int n2 = dataProperties.getPropertyInt("Rpp.Min", 0);
            int n3 = dataProperties.getPropertyInt("Rpp.Max", -1);
            PrintWriter printWriter = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "result.pl"));
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "stat.pl"));
            PrintWriter printWriter3 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "stat.csv"));
            printWriter3.println("gen;time[s];timeRMS;assigned;assignedRMS;iters;itersRMS");
            DecimalFormat decimalFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
            for (int i = n2; i <= n3; ++i) {
                FileInputStream fileInputStream = new FileInputStream(dataProperties.getProperty("General.Input") + File.separator + "gen" + i + ".pl");
                Vector vector = PrologFile.readTermsFromStream(fileInputStream, "objects");
                fileInputStream.close();
                double d = 0.0;
                long l = 0L;
                long l2 = 0L;
                double d2 = 0.0;
                long l3 = 0L;
                long l4 = 0L;
                for (int j = 1; j <= n; ++j) {
                    Comparable comparable;
                    Model model = Test.loadModel(dataProperties.getPropertyInt("Rpp.ProblemWidth", 40), dataProperties.getPropertyInt("Rpp.ProblemHeight", 14), vector);
                    Solver solver = new Solver(dataProperties);
                    solver.setInitalSolution(model);
                    solver.start();
                    solver.getSolverThread().join();
                    Solution solution = solver.currentSolution();
                    solution.restoreBest();
                    l2 += solution.getBestIteration();
                    l4 += solution.getBestIteration() * solution.getBestIteration();
                    d += solution.getBestTime();
                    d2 += solution.getBestTime() * solution.getBestTime();
                    l += (long)(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
                    l3 += (long)((solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()) * (solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()));
                    printWriter.println("result(" + i + "," + j + "," + decimalFormat.format(solution.getBestTime()) + "," + (solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()) + "," + solution.getBestIteration() + ",");
                    Vector vector2 = solution.getModel().bestUnassignedVariables();
                    if (vector2 == null) {
                        vector2 = new FastVector();
                    }
                    printWriter.print("  unassigned(" + 2 * vector2.size() + "/[");
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        comparable = (Rectangle)enumeration.nextElement();
                        printWriter.print(((Rectangle)comparable).getName() + "X," + ((Rectangle)comparable).getName() + "Y" + (enumeration.hasMoreElements() ? "," : ""));
                    }
                    printWriter.println("]),");
                    int n4 = 0;
                    comparable = new StringBuffer();
                    Enumeration enumeration2 = solution.getModel().variables().elements();
                    while (enumeration2.hasMoreElements()) {
                        Rectangle rectangle = (Rectangle)enumeration2.nextElement();
                        if (rectangle.getBestAssignment() == null) continue;
                        ((StringBuffer)comparable).append(((StringBuffer)comparable).length() == 0 ? "" : ",");
                        ((StringBuffer)comparable).append(rectangle.getName() + "X-" + ((Location)rectangle.getBestAssignment()).getX());
                        ((StringBuffer)comparable).append(((StringBuffer)comparable).length() == 0 ? "" : ",");
                        ((StringBuffer)comparable).append(rectangle.getName() + "Y-" + ((Location)rectangle.getBestAssignment()).getY());
                        ++n4;
                    }
                    printWriter.println("  assigned(" + 2 * n4 + "/[" + comparable + "])");
                    printWriter.println(").");
                    printWriter.flush();
                }
                printWriter3.println(i + ";" + decimalFormat.format(d / (double)n) + ";" + decimalFormat.format(ToolBox.rms(n, d, d2)) + ";" + decimalFormat.format((double)l / (double)n) + ";" + decimalFormat.format(ToolBox.rms(n, l, l3)) + ";" + decimalFormat.format((double)l2 / (double)n) + ";" + decimalFormat.format(ToolBox.rms(n, l2, l4)));
                printWriter3.flush();
                printWriter2.println("averages( problem( " + i + " ), time( " + decimalFormat.format(d / (double)n) + " ), assigned( " + decimalFormat.format((double)l / (double)n) + " ) ).");
                printWriter2.println("deviations( problem( " + i + " ), time( " + decimalFormat.format(ToolBox.rms(n, d, d2)) + " ), assigned( " + decimalFormat.format(ToolBox.rms(n, l, l3)) + " ) ).");
                printWriter2.flush();
            }
            printWriter.close();
            printWriter3.close();
            printWriter2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void test(File file, String string, String string2, String string3, String string4) throws Exception {
        if (string3 != null) {
            String string5;
            if (string3.indexOf(59) > 0) {
                string5 = string3.substring(0, string3.indexOf(59));
                string3 = string3.substring(string3.indexOf(59) + 1);
            } else {
                string5 = string3;
                string3 = null;
            }
            if (string5.startsWith("[") && string5.endsWith("]")) {
                Test.test(file, string, string2, string3, string4);
                string5 = string5.substring(1, string5.length() - 1);
            }
            if (string5.indexOf(123) >= 0 && string5.indexOf(125) >= 0) {
                String string6 = string5.substring(0, string5.indexOf(123));
                StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(string5.indexOf(123) + 1, string5.indexOf(125)), "|");
                String string7 = string5.substring(string5.indexOf(125) + 1);
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    Test.test(file, (string == null ? "" : string + "_") + string8, (string2 == null ? "" : string2 + ";") + string6 + string8 + string7, string3, string4);
                }
            } else {
                Test.test(file, string, (string2 == null ? "" : string2 + ";") + string5, string3, string4);
            }
        } else {
            Closeable closeable;
            String string9;
            DataProperties dataProperties = ToolBox.loadProperties(file);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string9 = stringTokenizer.nextToken();
                System.out.println("  Loading included file '" + string9 + "' ... ");
                closeable = null;
                if (new File(string9).exists()) {
                    closeable = new FileInputStream(string9);
                }
                if (new File(file.getParent() + File.separator + string9).exists()) {
                    closeable = new FileInputStream(file.getParent() + File.separator + string9);
                }
                if (closeable == null) {
                    System.err.println("Unable to find include file '" + string9 + "'.");
                }
                dataProperties.load((InputStream)closeable);
                ((FileInputStream)closeable).close();
            }
            string9 = (string4 == null ? dataProperties.getProperty("General.Output", ".") : string4) + File.separator + string + File.separator + sDateFormat.format(new Date());
            dataProperties.setProperty("General.Output", string9.toString());
            System.out.println("Output folder: " + dataProperties.getProperty("General.Output"));
            new File(string9).mkdirs();
            ToolBox.configureLogging(string9, null);
            closeable = new FileOutputStream(string9 + File.separator + "rcsp.conf");
            dataProperties.store((OutputStream)closeable, "Random CSP problem configuration file");
            ((OutputStream)closeable).flush();
            ((FileOutputStream)closeable).close();
            boolean bl = dataProperties.getPropertyBoolean("General.MPP", true);
            if (bl) {
                Test.testMPP(dataProperties);
            } else {
                Test.test(dataProperties);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File file = new File(stringArray[0]);
            DataProperties dataProperties = ToolBox.loadProperties(file);
            if (dataProperties.getProperty("INCLUDE_REGEXP") != null) {
                if (stringArray.length > 1) {
                    dataProperties.setProperty("General.Output", stringArray[1]);
                }
                Test.test(file, null, null, dataProperties.getProperty("INCLUDE_REGEXP"), stringArray.length > 1 ? stringArray[1] : null);
            } else {
                String string = dataProperties.getProperty("General.Output", ".") + File.separator + file.getName().substring(0, file.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
                if (stringArray.length > 1) {
                    string = stringArray[1] + File.separator + sDateFormat.format(new Date());
                }
                new File(string).mkdirs();
                dataProperties.setProperty("General.Output", string.toString());
                System.out.println("Output folder: " + dataProperties.getProperty("General.Output"));
                ToolBox.configureLogging(string, null);
                boolean bl = dataProperties.getPropertyBoolean("General.MPP", false);
                if (bl) {
                    Test.testMPP(dataProperties);
                } else {
                    Test.test(dataProperties);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

