/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.tt;

import ifs.example.tt.Activity;
import ifs.example.tt.Location;
import ifs.example.tt.TimetableModel;
import ifs.model.Constraint;
import ifs.model.Model;
import ifs.model.Value;
import java.util.HashSet;
import java.util.Set;

public class Resource
extends Constraint {
    private String iName = null;
    private String iResourceId = null;
    private Activity[] iResource;
    private Set iProhibitedSlots = new HashSet();
    private Set iDiscouragedSlots = new HashSet();
    private int iType = 3;
    public static final int TYPE_ROOM = 0;
    public static final int TYPE_INSTRUCTOR = 1;
    public static final int TYPE_CLASS = 2;
    public static final int TYPE_OTHER = 3;

    public Resource(String string, int n, String string2) {
        this.iResourceId = string;
        this.iName = string2;
        this.iType = n;
    }

    public void setModel(Model model) {
        super.setModel(model);
        this.iResource = new Activity[((TimetableModel)model).getNrDays() * ((TimetableModel)model).getNrHours()];
        for (int i = 0; i < this.iResource.length; ++i) {
            this.iResource[i] = null;
        }
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    public String getName() {
        return this.iName;
    }

    public int getType() {
        return this.iType;
    }

    public Set getProhibitedSlots() {
        return this.iProhibitedSlots;
    }

    public Set getDiscouragedSlots() {
        return this.iDiscouragedSlots;
    }

    public void addProhibitedSlot(int n, int n2) {
        this.iProhibitedSlots.add(new Integer(((TimetableModel)this.getModel()).getNrHours() * n + n2));
    }

    public void addDiscouragedSlot(int n, int n2) {
        this.iDiscouragedSlots.add(new Integer(((TimetableModel)this.getModel()).getNrHours() * n + n2));
    }

    public boolean isProhibitedSlot(int n, int n2) {
        return this.iProhibitedSlots.contains(new Integer(((TimetableModel)this.getModel()).getNrHours() * n + n2));
    }

    public boolean isDiscouragedSlot(int n, int n2) {
        return this.iDiscouragedSlots.contains(new Integer(((TimetableModel)this.getModel()).getNrHours() * n + n2));
    }

    public void addProhibitedSlot(int n) {
        this.iProhibitedSlots.add(new Integer(n));
    }

    public void addDiscouragedSlot(int n) {
        this.iDiscouragedSlots.add(new Integer(n));
    }

    public boolean isProhibitedSlot(int n) {
        return this.iProhibitedSlots.contains(new Integer(n));
    }

    public boolean isDiscouragedSlot(int n) {
        return this.iDiscouragedSlots.contains(new Integer(n));
    }

    public boolean isProhibited(int n, int n2, int n3) {
        int n4 = ((TimetableModel)this.getModel()).getNrHours() * n + n2;
        for (int i = 0; i < n3; ++i) {
            if (!this.iProhibitedSlots.contains(new Integer(n4 + i))) continue;
            return true;
        }
        return false;
    }

    public void computeConflicts(Value value, Set set) {
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            Activity activity2 = this.iResource[i];
            if (activity2 == null || activity.equals(activity2)) continue;
            set.add(activity2.getAssignment());
        }
    }

    public boolean inConflict(Value value) {
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        if (!location.containResource(this)) {
            return false;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            if (this.iResource[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        Location location = (Location)value;
        Location location2 = (Location)value2;
        return !location.containResource(this) || !location2.containResource(this) || !location.hasIntersection(location2);
    }

    public void assigned(long l, Value value) {
        super.assigned(l, value);
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            this.iResource[i] = activity;
        }
    }

    public void unassigned(long l, Value value) {
        super.unassigned(l, value);
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            this.iResource[i] = null;
        }
    }
}

