/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.tt;

import ifs.example.tt.Activity;
import ifs.example.tt.Dependence;
import ifs.example.tt.Location;
import ifs.example.tt.Resource;
import ifs.model.BinaryConstraint;
import ifs.model.Constraint;
import ifs.model.Model;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class TimetableModel
extends Model {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$tt$TimetableModel == null ? (class$ifs$example$tt$TimetableModel = TimetableModel.class$("ifs.example.tt.TimetableModel")) : class$ifs$example$tt$TimetableModel));
    private int iNrDays;
    private int iNrHours;
    static /* synthetic */ Class class$ifs$example$tt$TimetableModel;

    public TimetableModel(int n, int n2) {
        this.iNrDays = n;
        this.iNrHours = n2;
    }

    public int getNrDays() {
        return this.iNrDays;
    }

    public int getNrHours() {
        return this.iNrHours;
    }

    public static TimetableModel generate(DataProperties dataProperties) {
        Constraint constraint;
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14 = dataProperties.getPropertyInt("Generator.NrDays", 5);
        int n15 = dataProperties.getPropertyInt("Generator.NrHours", 20);
        int n16 = n14 * n15;
        TimetableModel timetableModel = new TimetableModel(n14, n15);
        int n17 = dataProperties.getPropertyInt("Generator.NrRooms", 20);
        int n18 = dataProperties.getPropertyInt("Generator.NrInstructors", 20);
        int n19 = dataProperties.getPropertyInt("Generator.NrClasses", 20);
        int n20 = dataProperties.getPropertyInt("Generator.NrGroupsOfRooms", 20);
        int n21 = dataProperties.getPropertyInt("Generator.NrRoomsInGroupMin", 1);
        int n22 = dataProperties.getPropertyInt("Generator.NrRoomsInGroupMax", 10);
        int n23 = dataProperties.getPropertyInt("Generator.NrRoomInGroupMin", 1);
        double d = dataProperties.getPropertyDouble("Generator.FillFactor", 0.8);
        int n24 = dataProperties.getPropertyInt("Generator.ActivityLengthMax", 5);
        double d2 = dataProperties.getPropertyDouble("Generator.HardFreeResource", 0.05);
        double d3 = dataProperties.getPropertyDouble("Generator.SoftFreeResource", 0.3);
        double d4 = dataProperties.getPropertyDouble("Generator.SoftUsedResource", 0.05);
        double d5 = dataProperties.getPropertyDouble("Generator.SoftUsedActivity", 0.05);
        double d6 = dataProperties.getPropertyDouble("Generator.SoftFreeActivity", 0.3);
        double d7 = dataProperties.getPropertyDouble("Generator.HardFreeActivity", 0.05);
        int n25 = dataProperties.getPropertyInt("Generator.NrDependencies", 50);
        Resource[] resourceArray = new Resource[n17];
        Vector[] vectorArray = new Vector[n17];
        for (int i = 0; i < n17; ++i) {
            resourceArray[i] = new Resource("r" + (i + 1), 0, "Room " + (i + 1));
            vectorArray[i] = new Vector();
            timetableModel.addConstraint(resourceArray[i]);
        }
        Vector[] vectorArray2 = new Vector[n20];
        for (n13 = 0; n13 < n20; ++n13) {
            vectorArray2[n13] = new FastVector();
            for (n12 = 0; n12 < ToolBox.random(1 + n22 - n21) + n21; ++n12) {
                n11 = 0;
                while (vectorArray2[n13].contains(resourceArray[n11 = ToolBox.random(n17)])) {
                }
                vectorArray2[n13].add(resourceArray[n11]);
                vectorArray[n11].add(vectorArray2[n13]);
            }
        }
        for (n13 = 0; n13 < n17; ++n13) {
            n12 = 0;
            for (n11 = 0; n11 < n20; ++n11) {
                if (!vectorArray2[n11].contains(resourceArray[n13])) continue;
                ++n12;
            }
            while (n12 < n23) {
                n11 = 0;
                while (vectorArray2[n11 = ToolBox.random(n20)].contains(resourceArray[n13])) {
                }
                vectorArray2[n11].add(resourceArray[n13]);
                vectorArray[n13].add(vectorArray2[n11]);
                ++n12;
            }
        }
        Resource[] resourceArray2 = new Resource[n18];
        for (n12 = 0; n12 < n18; ++n12) {
            resourceArray2[n12] = new Resource("t" + (n12 + 1), 1, "Teacher " + (n12 + 1));
            timetableModel.addConstraint(resourceArray2[n12]);
        }
        Resource[] resourceArray3 = new Resource[n19];
        for (n11 = 0; n11 < n19; ++n11) {
            resourceArray3[n11] = new Resource("c" + (n11 + 1), 2, "Class " + (n11 + 1));
            timetableModel.addConstraint(resourceArray3[n11]);
        }
        int[][] nArray = new int[n17][n16];
        int[][] nArray2 = new int[n18][n16];
        int[][] nArray3 = new int[n19][n16];
        int n26 = 0;
        for (n10 = 0; n10 < nArray.length; ++n10) {
            for (n9 = 0; n9 < nArray[n10].length; ++n9) {
                nArray[n10][n9] = 0;
            }
        }
        for (n10 = 0; n10 < nArray2.length; ++n10) {
            for (n9 = 0; n9 < nArray2[n10].length; ++n9) {
                nArray2[n10][n9] = 0;
            }
        }
        for (n10 = 0; n10 < nArray3.length; ++n10) {
            for (n9 = 0; n9 < nArray3[n10].length; ++n9) {
                nArray3[n10][n9] = 0;
            }
        }
        n10 = n17 * n16;
        n9 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        while ((double)n9 / (double)n10 < d) {
            n8 = 0;
            n7 = ToolBox.random(n16);
            n6 = ToolBox.random(n17);
            while (n8 < 500 && nArray[n6][n7] != 0) {
                n7 = ToolBox.random(n16);
                n6 = ToolBox.random(n17);
            }
            if (n8 == 500) {
                n5 = n7;
                n4 = n6;
                while (nArray[n4][n5] != 0) {
                    if (++n4 == n17) {
                        n4 = 0;
                    }
                    if (n4 == n6) {
                        ++n5;
                    }
                    if (n5 != n16) continue;
                    n5 = 0;
                }
                n7 = n5;
                n6 = n4;
            }
            n5 = n24;
            n4 = ToolBox.random(n19);
            n3 = ToolBox.random(n18);
            n8 = 0;
            while (n8 < 500 && (nArray3[n4][n7] != 0 || nArray2[n3][n7] != 0)) {
                n4 = ToolBox.random(n19);
                n3 = ToolBox.random(n18);
            }
            if (n8 == 500) continue;
            for (n2 = 1; n2 < n5 && (n7 + n2) % n15 != 0 && nArray[n6][n7 + n2] == 0 && nArray2[n3][n7 + n2] == 0 && nArray3[n4][n7 + n2] == 0; ++n2) {
            }
            object3 = (Vector)ToolBox.random(vectorArray[n6]);
            n9 += n2;
            Activity activity = new Activity(n2, "a" + ++n26, "Activity " + n26);
            activity.addResourceGroup((Vector)object3);
            activity.addResourceGroup(resourceArray2[n3]);
            activity.addResourceGroup(resourceArray3[n4]);
            timetableModel.addVariable(activity);
            vector.addElement(new Integer(n7));
            vector2.addElement(new Integer(n6));
            for (n = n7; n < n7 + n2; ++n) {
                nArray[n6][n] = n26;
                nArray2[n3][n] = n26;
                nArray3[n4][n] = n26;
            }
        }
        n8 = 0;
        n7 = 0;
        n6 = 0;
        for (n5 = 0; n5 < n16; ++n5) {
            for (n4 = 0; n4 < n17; ++n4) {
                if (nArray[n4][n5] == 0) {
                    if (ToolBox.random() < d2) {
                        ++n8;
                        resourceArray[n4].addProhibitedSlot(n5);
                        continue;
                    }
                    if (!(ToolBox.random() < d3 / (1.0 - d2))) continue;
                    ++n7;
                    resourceArray[n4].addDiscouragedSlot(n5);
                    continue;
                }
                if (!(ToolBox.random() < d4)) continue;
                ++n6;
                resourceArray[n4].addDiscouragedSlot(n5);
            }
            for (n4 = 0; n4 < n18; ++n4) {
                if (nArray2[n4][n5] == 0) {
                    if (ToolBox.random() < d2) {
                        ++n8;
                        resourceArray2[n4].addProhibitedSlot(n5);
                        continue;
                    }
                    if (!(ToolBox.random() < d3 / (1.0 - d2))) continue;
                    ++n7;
                    resourceArray2[n4].addDiscouragedSlot(n5);
                    continue;
                }
                if (!(ToolBox.random() < d4)) continue;
                ++n6;
                resourceArray2[n4].addDiscouragedSlot(n5);
            }
            for (n4 = 0; n4 < n19; ++n4) {
                if (nArray3[n4][n5] == 0) {
                    if (ToolBox.random() < d2) {
                        ++n8;
                        resourceArray3[n4].addProhibitedSlot(n5);
                        continue;
                    }
                    if (!(ToolBox.random() < d3 / (1.0 - d2))) continue;
                    ++n7;
                    resourceArray3[n4].addDiscouragedSlot(n5);
                    continue;
                }
                if (!(ToolBox.random() < d4)) continue;
                ++n6;
                resourceArray3[n4].addDiscouragedSlot(n5);
            }
        }
        n5 = 0;
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < timetableModel.variables().size(); ++n2) {
            object3 = (Activity)timetableModel.variables().elementAt(n2);
            for (int i = 0; i < n16; ++i) {
                n = (Integer)vector.elementAt(n2);
                if (i < n || i >= n + ((Activity)object3).getLength()) {
                    if (ToolBox.random() < d7) {
                        ++n3;
                        ((Activity)object3).addProhibitedSlot(i);
                        continue;
                    }
                    if (!(ToolBox.random() < d6 / (1.0 - d7))) continue;
                    ++n5;
                    ((Activity)object3).addDiscouragedSlot(i);
                    continue;
                }
                if (!(ToolBox.random() < d5)) continue;
                ++n4;
                ((Activity)object3).addDiscouragedSlot(i);
            }
            ((Activity)object3).init();
        }
        n2 = 0;
        while (n2 < n25) {
            int n27 = ToolBox.random(timetableModel.variables().size());
            int n28 = ToolBox.random(timetableModel.variables().size());
            while (n27 == n28) {
                n28 = ToolBox.random(timetableModel.variables().size());
            }
            n = (Integer)vector.elementAt(n27);
            int n29 = (Integer)vector.elementAt(n28);
            object2 = (Activity)timetableModel.variables().elementAt(n27);
            object = (Activity)timetableModel.variables().elementAt(n28);
            constraint = null;
            if (n < n29) {
                if (n + ((Activity)object2).getLength() == n29) {
                    constraint = new Dependence("d" + (n2 + 1), 2);
                } else if (n + ((Activity)object2).getLength() < n29) {
                    constraint = new Dependence("d" + (n2 + 1), 1);
                }
            } else if (n29 == n + ((Activity)object2).getLength()) {
                constraint = new Dependence("d" + (n2 + 1), 4);
            } else if (n29 > n + ((Activity)object2).getLength()) {
                constraint = new Dependence("d" + (n2 + 1), 3);
            }
            if (constraint == null) continue;
            ((BinaryConstraint)constraint).addVariable((Variable)object2);
            ((BinaryConstraint)constraint).addVariable((Variable)object);
            timetableModel.addConstraint(constraint);
            ++n2;
        }
        for (n2 = 0; n2 < timetableModel.variables().size(); ++n2) {
            Activity activity = (Activity)timetableModel.variables().elementAt(n2);
            int n30 = (Integer)vector.elementAt(n2);
            n = (Integer)vector2.elementAt(n2);
            Comparable comparable = null;
            object2 = activity.values().elements();
            while (object2.hasMoreElements()) {
                object = (Location)object2.nextElement();
                if (((Location)object).getSlot() != n30 || !((Location)object).getResource(0).getResourceId().equals("r" + (n + 1))) continue;
                comparable = object;
                break;
            }
            if (comparable != null) {
                object2 = timetableModel.conflictValues((Value)comparable);
                if (!object2.isEmpty()) {
                    sLogger.warn((Object)("Unable to assign " + comparable.getName() + " to " + activity.getName() + ", reason:"));
                    object = activity.constraints().elements();
                    while (object.hasMoreElements()) {
                        constraint = (Constraint)object.nextElement();
                        HashSet hashSet = new HashSet();
                        constraint.computeConflicts((Value)comparable, hashSet);
                        if (hashSet.isEmpty()) continue;
                        sLogger.warn((Object)("  -- Constraint " + constraint.getName() + " causes conflicts " + hashSet));
                    }
                } else {
                    activity.assign(0L, (Value)comparable);
                    activity.setInitialAssignment((Value)comparable);
                }
                activity.setInitialAssignment((Value)comparable);
                continue;
            }
            sLogger.warn((Object)("Unable to assign " + activity.getName() + " -- no location matching slot=" + n30 + " room='R" + (n + 1) + "'"));
        }
        if (!dataProperties.getPropertyBoolean("General.InitialAssignment", true)) {
            for (n2 = 0; n2 < timetableModel.variables().size(); ++n2) {
                Activity activity = (Activity)timetableModel.variables().elementAt(n2);
                activity.unassign(0L);
            }
        }
        if ((n2 = dataProperties.getPropertyInt("General.ForcedPerturbances", 0)) > 0) {
            Vector<Variable> vector3 = new Vector<Variable>();
            Enumeration enumeration = timetableModel.variables().elements();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                if (variable.getInitialAssignment() == null) continue;
                vector3.addElement(variable);
            }
            for (int i = 0; i < n2 && !vector3.isEmpty(); ++i) {
                Variable variable = (Variable)ToolBox.random(vector3);
                vector3.remove(variable);
                variable.removeInitialValue();
            }
        }
        sLogger.debug((Object)"-- Generator Info ---------------------------------------------------------");
        sLogger.debug((Object)("  Total number of " + timetableModel.variables().size() + " activities generated."));
        sLogger.debug((Object)("  Total number of " + n9 + " slots are filled (" + 100.0 * (double)n9 / (double)n10 + "% filled)."));
        sLogger.debug((Object)("  Average length of an activity is " + (double)n9 / (double)timetableModel.variables().size()));
        sLogger.debug((Object)("  Total number of hard constraints posted on free slots on activities: " + n3));
        sLogger.debug((Object)("  Total number of soft constraints posted on free slots on activities: " + n5));
        sLogger.debug((Object)("  Total number of soft constraints posted on used slots on activities: " + n4));
        sLogger.debug((Object)("  Total number of hard constraints posted on free slots on resources: " + n8));
        sLogger.debug((Object)("  Total number of soft constraints posted on free slots on resources: " + n7));
        sLogger.debug((Object)("  Total number of soft constraints posted on used slots on resources: " + n6));
        sLogger.debug((Object)("  Total number of " + n25 + " dependencies generated."));
        sLogger.debug((Object)"---------------------------------------------------------------------------");
        return timetableModel;
    }

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TimetableModel timetableModel = TimetableModel.generate(new DataProperties());
        System.out.println(timetableModel.getInfo());
    }

    public void saveAsXML(DataProperties dataProperties, boolean bl, Solution solution, File file) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Enumeration enumeration;
        Object object5;
        Object object6;
        Resource resource;
        Resource resource2;
        Constraint constraint;
        Vector<Object> vector;
        Object object7;
        Object object8;
        Cloneable cloneable;
        Object object9;
        file.getParentFile().mkdirs();
        sLogger.debug((Object)("Writting XML data to:" + file));
        Document document = DocumentHelper.createDocument();
        document.addComment("Interactive Timetabling - University Timetable Generator (version 2.0)");
        if (!this.assignedVariables().isEmpty()) {
            object9 = new StringBuffer("Solution Info:\n");
            cloneable = solution == null ? this.getInfo() : solution.getInfo();
            object8 = ToolBox.sortEnumeration(((Dictionary)((Object)cloneable)).keys());
            while (object8.hasMoreElements()) {
                object7 = (String)object8.nextElement();
                vector = ((Dictionary)((Object)cloneable)).get(object7);
                ((StringBuffer)object9).append("    " + (String)object7 + ": " + vector + "\n");
            }
            document.addComment(((StringBuffer)object9).toString());
        }
        object9 = document.addElement("Timetable");
        if (bl) {
            cloneable = object9.addElement("Generator");
            cloneable.addAttribute("version", "2.0");
            cloneable.addElement("DaysPerWeek").setText(String.valueOf(this.iNrDays));
            cloneable.addElement("SlotsPerDay").setText(String.valueOf(this.iNrHours));
            cloneable.addElement("NrRooms").setText(dataProperties.getProperty("Generator.NrRooms", "20"));
            cloneable.addElement("NrInstructors").setText(dataProperties.getProperty("Generator.NrInstructors", "20"));
            cloneable.addElement("NrClasses").setText(dataProperties.getProperty("Generator.NrClasses", "20"));
            cloneable.addElement("FillFactor").setText(dataProperties.getProperty("Generator.FillFactor", "0.8"));
            cloneable.addElement("ActivityLengthMax").setText(dataProperties.getProperty("Generator.ActivityLengthMax", "5"));
            cloneable.addElement("NrGroupsOfRooms").setText(dataProperties.getProperty("Generator.NrGroupsOfRooms", "20"));
            cloneable.addElement("NrRoomsInGroupMin").setText(dataProperties.getProperty("Generator.NrRoomsInGroupMin", "1"));
            cloneable.addElement("NrRoomsInGroupMax").setText(dataProperties.getProperty("Generator.NrRoomsInGroupMax", "10"));
            cloneable.addElement("NrRoomInGroupMin").setText(dataProperties.getProperty("Generator.NrRoomInGroupMin", "1"));
            cloneable.addElement("HardFreeResource").setText(dataProperties.getProperty("Generator.HardFreeResource", "0.05"));
            cloneable.addElement("SoftFreeResource").setText(dataProperties.getProperty("Generator.SoftFreeResource", "0.3"));
            cloneable.addElement("SoftUsedResource").setText(dataProperties.getProperty("Generator.SoftUsedResource", "0.05"));
            cloneable.addElement("SoftUsedActivity").setText(dataProperties.getProperty("Generator.SoftUsedActivity", "0.05"));
            cloneable.addElement("SoftFreeActivity").setText(dataProperties.getProperty("Generator.SoftFreeActivity", "0.3"));
            cloneable.addElement("HardFreeActivity").setText(dataProperties.getProperty("Generator.HardFreeActivity", "0.05"));
            cloneable.addElement("NrDependencies").setText(dataProperties.getProperty("Generator.NrDependencies", "50"));
        }
        cloneable = new Vector();
        object8 = new Vector();
        object7 = new Vector();
        vector = new Vector();
        Vector<Constraint> vector2 = new Vector<Constraint>();
        Element element = this.constraints().elements();
        block13: while (element.hasMoreElements()) {
            constraint = (Constraint)element.nextElement();
            if (constraint instanceof Resource) {
                resource2 = (Resource)constraint;
                switch (resource2.getType()) {
                    case 0: {
                        ((Vector)cloneable).addElement(resource2);
                        continue block13;
                    }
                    case 2: {
                        ((Vector)object8).addElement(resource2);
                        continue block13;
                    }
                    case 1: {
                        ((Vector)object7).addElement(resource2);
                        continue block13;
                    }
                }
                vector.addElement(resource2);
                continue;
            }
            if (!(constraint instanceof Dependence)) continue;
            vector2.addElement(constraint);
        }
        element = object9.addElement("Problem");
        element.addAttribute("version", "2.0");
        constraint = element.addElement("General");
        constraint.addElement("DaysPerWeek").setText(String.valueOf(this.iNrDays));
        constraint.addElement("SlotsPerDay").setText(String.valueOf(this.iNrHours));
        resource2 = constraint.addElement("Resources");
        resource2.addElement("Classrooms").setText(String.valueOf(((Vector)cloneable).size()));
        resource2.addElement("Teachers").setText(String.valueOf(((Vector)object7).size()));
        resource2.addElement("Classes").setText(String.valueOf(((Vector)object8).size()));
        resource2.addElement("Special").setText(String.valueOf(vector.size()));
        constraint.addElement("Activities").setText(String.valueOf(this.variables().size()));
        constraint.addElement("Dependences").setText(String.valueOf(vector2.size()));
        Element element2 = element.addElement("Resources");
        Element element3 = element2.addElement("Classrooms");
        Enumeration<Object> enumeration2 = ((Vector)cloneable).elements();
        while (enumeration2.hasMoreElements()) {
            resource = (Resource)enumeration2.nextElement();
            object6 = element3.addElement("Resource");
            object6.addAttribute("id", resource.getResourceId());
            object6.addElement("Name").setText(resource.getName());
            object5 = object6.addElement("TimePreferences");
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getDiscouragedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Soft").setText(enumeration.nextElement().toString());
            }
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getProhibitedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Hard").setText(enumeration.nextElement().toString());
            }
        }
        element3 = element2.addElement("Teachers");
        enumeration2 = ((Vector)object7).elements();
        while (enumeration2.hasMoreElements()) {
            resource = (Resource)enumeration2.nextElement();
            object6 = element3.addElement("Resource");
            object6.addAttribute("id", resource.getResourceId());
            object6.addElement("Name").setText(resource.getName());
            object5 = object6.addElement("TimePreferences");
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getDiscouragedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Soft").setText(enumeration.nextElement().toString());
            }
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getProhibitedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Hard").setText(enumeration.nextElement().toString());
            }
        }
        element3 = element2.addElement("Classes");
        enumeration2 = ((Vector)object8).elements();
        while (enumeration2.hasMoreElements()) {
            resource = (Resource)enumeration2.nextElement();
            object6 = element3.addElement("Resource");
            object6.addAttribute("id", resource.getResourceId());
            object6.addElement("Name").setText(resource.getName());
            object5 = object6.addElement("TimePreferences");
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getDiscouragedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Soft").setText(enumeration.nextElement().toString());
            }
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getProhibitedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Hard").setText(enumeration.nextElement().toString());
            }
        }
        element3 = element2.addElement("Special");
        enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            resource = (Resource)enumeration2.nextElement();
            object6 = element3.addElement("Resource");
            object6.addAttribute("id", resource.getResourceId());
            object6.addElement("Name").setText(resource.getName());
            object5 = object6.addElement("TimePreferences");
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getDiscouragedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Soft").setText(enumeration.nextElement().toString());
            }
            enumeration = ToolBox.sortEnumeration(new Vector(resource.getProhibitedSlots()).elements());
            while (enumeration.hasMoreElements()) {
                object5.addElement("Hard").setText(enumeration.nextElement().toString());
            }
        }
        boolean bl2 = false;
        resource = element.addElement("Activities");
        object6 = this.variables().elements();
        while (object6.hasMoreElements()) {
            object5 = (Activity)object6.nextElement();
            enumeration = resource.addElement("Activity");
            enumeration.addAttribute("id", ((Activity)object5).getActivityId());
            enumeration.addElement("Name").setText(((Activity)object5).getName());
            enumeration.addElement("Length").setText(String.valueOf(((Activity)object5).getLength()));
            if (((Variable)object5).getAssignment() != null) {
                bl2 = true;
            }
            object4 = enumeration.addElement("TimePreferences");
            object3 = ToolBox.sortEnumeration(new Vector(((Activity)object5).getDiscouragedSlots()).elements());
            while (object3.hasMoreElements()) {
                object4.addElement("Soft").setText(object3.nextElement().toString());
            }
            object3 = ToolBox.sortEnumeration(new Vector(((Activity)object5).getProhibitedSlots()).elements());
            while (object3.hasMoreElements()) {
                object4.addElement("Hard").setText(object3.nextElement().toString());
            }
            object3 = enumeration.addElement("RequiredResources");
            object2 = ((Activity)object5).getResourceGroups().elements();
            while (object2.hasMoreElements()) {
                object = (Vector)object2.nextElement();
                if (((Vector)object).size() == 1) {
                    object3.addElement("Resource").setText(((Resource)((Vector)object).firstElement()).getResourceId());
                    continue;
                }
                Element element4 = object3.addElement("Group").addAttribute("conjunctive", "no");
                Enumeration enumeration3 = ((Vector)object).elements();
                while (enumeration3.hasMoreElements()) {
                    element4.addElement("Resource").setText(((Resource)enumeration3.nextElement()).getResourceId());
                }
            }
        }
        object6 = element.addElement("Dependences");
        object5 = vector2.elements();
        block31: while (object5.hasMoreElements()) {
            enumeration = (Dependence)object5.nextElement();
            object4 = object6.addElement("Dependence");
            object4.addAttribute("id", ((Dependence)((Object)enumeration)).getResourceId());
            object4.addElement("FirstActivity").setText(((Activity)((BinaryConstraint)((Object)enumeration)).first()).getActivityId());
            object4.addElement("SecondActivity").setText(((Activity)((BinaryConstraint)((Object)enumeration)).second()).getActivityId());
            switch (((Dependence)((Object)enumeration)).getType()) {
                case 3: {
                    object4.addElement("Operator").setText("After");
                    continue block31;
                }
                case 1: {
                    object4.addElement("Operator").setText("Before");
                    continue block31;
                }
                case 2: {
                    object4.addElement("Operator").setText("Closely before");
                    continue block31;
                }
                case 4: {
                    object4.addElement("Operator").setText("Closely after");
                    continue block31;
                }
                case 5: {
                    object4.addElement("Operator").setText("Concurrently");
                    continue block31;
                }
            }
            object4.addElement("Operator").setText("Unknown");
        }
        if (bl2) {
            object5 = object9.addElement("Solution");
            object5.addAttribute("version", "2.0");
            enumeration = this.variables().elements();
            while (enumeration.hasMoreElements()) {
                object4 = (Activity)enumeration.nextElement();
                object3 = object5.addElement("Activity");
                object3.addAttribute("id", ((Activity)object4).getActivityId());
                if (((Variable)object4).getAssignment() == null) continue;
                object2 = (Location)((Variable)object4).getAssignment();
                object3.addElement("StartTime").setText(String.valueOf(((Location)object2).getSlot()));
                object = object3.addElement("UsedResources");
                for (int i = 0; i < ((Location)object2).getResources().length; ++i) {
                    object.addElement("Resource").setText(((Location)object2).getResources()[i].getResourceId());
                }
            }
        }
        object5 = new FileOutputStream(file);
        new XMLWriter((OutputStream)object5, OutputFormat.createPrettyPrint()).write(document);
        ((OutputStream)object5).flush();
        ((FileOutputStream)object5).close();
    }

    public static TimetableModel loadFromXML(File file, boolean bl) throws IOException, DocumentException {
        Object object;
        Object object2;
        Element element;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Document document = new SAXReader().read(file);
        Element element2 = document.getRootElement();
        if (!"Timetable".equals(element2.getName())) {
            sLogger.error((Object)"Given XML file is not interactive timetabling problem.");
            return null;
        }
        Element element3 = element2.element("Problem");
        Element element4 = element3.element("General");
        TimetableModel timetableModel = new TimetableModel(Integer.parseInt(element4.elementText("DaysPerWeek")), Integer.parseInt(element4.elementText("SlotsPerDay")));
        Element element5 = element3.element("Resources");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Element element6 = element5.element("Classrooms");
        Iterator iterator = element6.elementIterator("Resource");
        while (iterator.hasNext()) {
            object8 = (Element)iterator.next();
            object7 = new Resource(object8.attributeValue("id"), 0, object8.elementText("Name"));
            object6 = object8.element("TimePreferences");
            object5 = object6.elementIterator("Soft");
            while (object5.hasNext()) {
                ((Resource)object7).addDiscouragedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            object5 = object6.elementIterator("Hard");
            while (object5.hasNext()) {
                ((Resource)object7).addProhibitedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            timetableModel.addConstraint((Constraint)object7);
            hashtable.put(((Resource)object7).getResourceId(), object7);
        }
        element6 = element5.element("Teachers");
        iterator = element6.elementIterator("Resource");
        while (iterator.hasNext()) {
            object8 = (Element)iterator.next();
            object7 = new Resource(object8.attributeValue("id"), 1, object8.elementText("Name"));
            object6 = object8.element("TimePreferences");
            object5 = object6.elementIterator("Soft");
            while (object5.hasNext()) {
                ((Resource)object7).addDiscouragedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            object5 = object6.elementIterator("Hard");
            while (object5.hasNext()) {
                ((Resource)object7).addProhibitedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            timetableModel.addConstraint((Constraint)object7);
            hashtable.put(((Resource)object7).getResourceId(), object7);
        }
        element6 = element5.element("Classes");
        iterator = element6.elementIterator("Resource");
        while (iterator.hasNext()) {
            object8 = (Element)iterator.next();
            object7 = new Resource(object8.attributeValue("id"), 2, object8.elementText("Name"));
            object6 = object8.element("TimePreferences");
            object5 = object6.elementIterator("Soft");
            while (object5.hasNext()) {
                ((Resource)object7).addDiscouragedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            object5 = object6.elementIterator("Hard");
            while (object5.hasNext()) {
                ((Resource)object7).addProhibitedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            timetableModel.addConstraint((Constraint)object7);
            hashtable.put(((Resource)object7).getResourceId(), object7);
        }
        element6 = element5.element("Special");
        iterator = element6.elementIterator("Resource");
        while (iterator.hasNext()) {
            object8 = (Element)iterator.next();
            object7 = new Resource(object8.attributeValue("id"), 3, object8.elementText("Name"));
            object6 = object8.element("TimePreferences");
            object5 = object6.elementIterator("Soft");
            while (object5.hasNext()) {
                ((Resource)object7).addDiscouragedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            object5 = object6.elementIterator("Hard");
            while (object5.hasNext()) {
                ((Resource)object7).addProhibitedSlot(Integer.parseInt(((Element)object5.next()).getText()));
            }
            timetableModel.addConstraint((Constraint)object7);
            hashtable.put(((Resource)object7).getResourceId(), object7);
        }
        iterator = element3.element("Activities");
        object8 = new Hashtable();
        object7 = iterator.elementIterator("Activity");
        while (object7.hasNext()) {
            object6 = (Element)object7.next();
            object5 = new Activity(Integer.parseInt(object6.elementText("Length")), object6.attributeValue("id"), object6.elementText("Name"));
            Element element7 = object6.element("TimePreferences");
            object4 = element7.elementIterator("Soft");
            while (object4.hasNext()) {
                ((Activity)object5).addDiscouragedSlot(Integer.parseInt(((Element)object4.next()).getText()));
            }
            object4 = element7.elementIterator("Hard");
            while (object4.hasNext()) {
                ((Activity)object5).addProhibitedSlot(Integer.parseInt(((Element)object4.next()).getText()));
            }
            object4 = object6.element("RequiredResources");
            object3 = object4.elementIterator();
            while (object3.hasNext()) {
                element = (Element)object3.next();
                if ("Resource".equals(element.getName())) {
                    ((Activity)object5).addResourceGroup((Resource)hashtable.get(element.getText()));
                    continue;
                }
                if (!"Group".equals(element.getName())) continue;
                if ("no".equalsIgnoreCase(element.attributeValue("conjunctive")) || "false".equalsIgnoreCase(element.attributeValue("conjunctive"))) {
                    object2 = new Vector();
                    object = element.elementIterator("Resource");
                    while (object.hasNext()) {
                        ((Vector)object2).addElement(hashtable.get(((Element)object.next()).getText()));
                    }
                    ((Activity)object5).addResourceGroup((Vector)object2);
                    continue;
                }
                object2 = element.elementIterator("Resource");
                while (object2.hasNext()) {
                    ((Activity)object5).addResourceGroup((Resource)hashtable.get(((Element)object2.next()).getText()));
                }
            }
            timetableModel.addVariable((Variable)object5);
            ((Activity)object5).init();
            ((Hashtable)object8).put(((Activity)object5).getActivityId(), object5);
        }
        object7 = element3.element("Dependences");
        object6 = object7.elementIterator("Dependence");
        while (object6.hasNext()) {
            object5 = (Element)object6.next();
            int n = 0;
            object4 = object5.elementText("Operator");
            if ("After".equals(object4)) {
                n = 3;
            } else if ("Before".equals(object4)) {
                n = 1;
            } else if ("After".equals(object4)) {
                n = 3;
            } else if ("Closely before".equals(object4)) {
                n = 2;
            } else if ("Closely after".equals(object4)) {
                n = 4;
            } else if ("Concurrently".equals(object4)) {
                n = 5;
            }
            object3 = new Dependence(object5.attributeValue("id"), n);
            ((BinaryConstraint)object3).addVariable((Activity)((Hashtable)object8).get(object5.elementText("FirstActivity")));
            ((BinaryConstraint)object3).addVariable((Activity)((Hashtable)object8).get(object5.elementText("SecondActivity")));
            timetableModel.addConstraint((Constraint)object3);
        }
        object6 = element2.element("Solution");
        if (object6 != null) {
            object5 = object6.elementIterator("Activity");
            block19: while (object5.hasNext()) {
                Element element8 = (Element)object5.next();
                object4 = (Activity)((Hashtable)object8).get(element8.attributeValue("id"));
                if (object4 == null) continue;
                int n = Integer.parseInt(element8.elementText("StartTime"));
                element = element8.element("UsedResources");
                object2 = new Vector();
                object = element.elementIterator("Resource");
                while (object.hasNext()) {
                    ((Vector)object2).addElement(hashtable.get(((Element)object.next()).getText()));
                }
                object = ((Variable)object4).values().elements();
                while (object.hasMoreElements()) {
                    Location location = (Location)object.nextElement();
                    if (location.getSlot() != n || location.getResources().length != ((Vector)object2).size()) continue;
                    boolean bl2 = true;
                    for (int i = 0; i < location.getResources().length && bl2; ++i) {
                        if (((Vector)object2).elementAt(i).equals(location.getResources()[i])) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    ((Variable)object4).setInitialAssignment(location);
                    if (!bl) continue block19;
                    ((Variable)object4).assign(0L, location);
                    continue block19;
                }
            }
        }
        return timetableModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

