/*
 * Decompiled with CFR 0.152.
 */
package ifs.extension;

import ifs.extension.Assignment;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.FastVector;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AssignmentSet {
    private Vector iSet = new FastVector();
    private int iCounter = 1;
    private String iName = null;
    private String iDescription = null;
    private Constraint iConstraint = null;

    public AssignmentSet() {
    }

    public AssignmentSet(Assignment[] assignmentArray) {
        for (int i = 0; i < assignmentArray.length; ++i) {
            this.iSet.addElement(assignmentArray[i]);
        }
    }

    public AssignmentSet(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.iSet.addElement((Assignment)iterator.next());
        }
    }

    public static AssignmentSet createAssignmentSet(long l, Collection collection, double d) {
        AssignmentSet assignmentSet = new AssignmentSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Assignment) {
                assignmentSet.addAssignment((Assignment)e);
            }
            if (e instanceof Value) {
                assignmentSet.addAssignment(new Assignment(l, (Value)e, d));
            }
            if (!(e instanceof Variable) || ((Variable)e).getAssignment() == null) continue;
            assignmentSet.addAssignment(new Assignment(l, ((Variable)e).getAssignment(), d));
        }
        return assignmentSet;
    }

    public void incCounter() {
        ++this.iCounter;
    }

    public int getCounter() {
        return this.iCounter;
    }

    public Vector getSet() {
        return this.iSet;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String string) {
        this.iName = string;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String string) {
        this.iDescription = string;
    }

    public Constraint getConstraint() {
        return this.iConstraint;
    }

    public void setConstraint(Constraint constraint) {
        this.iConstraint = constraint;
    }

    public boolean contains(Assignment assignment) {
        return this.iSet.contains(assignment);
    }

    public boolean contains(AssignmentSet assignmentSet) {
        return this.iSet.containsAll(assignmentSet.getSet());
    }

    public boolean contains(Value value) {
        return this.iSet.contains(new Assignment(0L, value, 1.0));
    }

    public boolean contains(Variable variable) {
        return variable.getAssignment() == null ? false : this.iSet.contains(new Assignment(0L, variable.getAssignment(), 1.0));
    }

    public boolean contains(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                return false;
            }
            if (e instanceof Assignment && !this.iSet.contains((Assignment)e)) {
                return false;
            }
            if (e instanceof Value || !this.iSet.contains(new Assignment(0L, (Value)e, 1.0))) {
                return false;
            }
            if (!(e instanceof Variable) || ((Variable)e).getAssignment() != null && this.iSet.contains(new Assignment(0L, ((Variable)e).getAssignment(), 1.0))) continue;
            return false;
        }
        return true;
    }

    public void addAssignment(Assignment assignment) {
        if (!this.contains(assignment)) {
            this.iSet.addElement(assignment);
        }
    }

    public void addAssignment(long l, Value value, double d) {
        this.addAssignment(new Assignment(l, value, d));
    }

    public Assignment getAssignment(Value value) {
        Enumeration enumeration = this.getSet().elements();
        while (enumeration.hasMoreElements()) {
            Assignment assignment = (Assignment)enumeration.nextElement();
            if (assignment.getValue().getId() != value.getId()) continue;
            return assignment;
        }
        return null;
    }

    public int size() {
        return this.getSet().size();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AssignmentSet) {
            AssignmentSet assignmentSet = (AssignmentSet)object;
            if (this.getName() == null && assignmentSet.getName() != null) {
                return false;
            }
            if (this.getName() != null && assignmentSet.getName() == null) {
                return false;
            }
            if (this.getName() != null && !this.getName().equals(assignmentSet.getName())) {
                return false;
            }
            if (assignmentSet.getSet().size() != this.getSet().size()) {
                return false;
            }
            return this.contains(assignmentSet);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.size() != this.getSet().size()) {
                return false;
            }
            return this.contains(collection);
        }
        return false;
    }

    public static int xor(int n, int n2) {
        return (n | n2) & (~n | ~n2);
    }

    public int hashCode() {
        int n = this.getSet().size();
        Enumeration enumeration = this.getSet().elements();
        while (enumeration.hasMoreElements()) {
            Assignment assignment = (Assignment)enumeration.nextElement();
            n = AssignmentSet.xor(n, assignment.hashCode());
        }
        return n;
    }
}

