/*
 * Decompiled with CFR 0.152.
 */
package ifs.extension;

import ifs.extension.Extension;
import ifs.model.Constraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.Progress;
import ifs.util.Queue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MacPropagation
extends Extension {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$extension$MacPropagation == null ? (class$ifs$extension$MacPropagation = MacPropagation.class$("ifs.extension.MacPropagation")) : class$ifs$extension$MacPropagation));
    private boolean iJustForwardCheck = false;
    protected Vector iConstraints = null;
    protected long iIteration = 0L;
    static /* synthetic */ Class class$ifs$extension$MacPropagation;

    public MacPropagation(Solver solver, DataProperties dataProperties) {
        super(solver, dataProperties);
        this.iJustForwardCheck = dataProperties.getPropertyBoolean("MacPropagation.JustForwardCheck", false);
    }

    public void addConstraint(Constraint constraint) {
        if (this.iConstraints == null) {
            this.iConstraints = new FastVector();
        }
        this.iConstraints.addElement(constraint);
    }

    public boolean contains(Constraint constraint) {
        if (this.iConstraints == null) {
            return true;
        }
        return this.iConstraints.contains(constraint);
    }

    public void beforeAssigned(long l, Value value) {
        this.iIteration = l;
        if (value == null) {
            return;
        }
        if (!this.isGood(value)) {
            while (!this.isGood(value) && !this.noGood(value).isEmpty()) {
                Value value2 = (Value)this.noGood(value).iterator().next();
                value2.variable().unassign(l);
            }
        }
        if (!this.isGood(value)) {
            sLogger.warn((Object)("Going to assign a bad value " + value + " with empty no-good."));
        }
    }

    public void afterAssigned(long l, Value value) {
        this.iIteration = l;
        if (!this.isGood(value)) {
            sLogger.warn((Object)(value.variable().getName() + " = " + value.getName() + " -- not good value assigned (noGood:" + this.noGood(value) + ")"));
            this.setGood(value);
        }
        HashSet<Value> hashSet = new HashSet<Value>(1);
        hashSet.add(value);
        Enumeration enumeration = value.variable().values().elements();
        while (enumeration.hasMoreElements()) {
            Value value2 = (Value)enumeration.nextElement();
            if (value2.equals(value)) continue;
            this.setNoGood(value2, hashSet);
        }
        this.propagate(value.variable());
    }

    public void afterUnassigned(long l, Value value) {
        this.iIteration = l;
        if (!this.isGood(value)) {
            sLogger.error((Object)(value.variable().getName() + " = " + value.getName() + " -- not good value unassigned (noGood:" + this.noGood(value) + ")"));
        }
        Enumeration enumeration = value.variable().values().elements();
        while (enumeration.hasMoreElements()) {
            Value value2 = (Value)enumeration.nextElement();
            if (this.isGood(value2)) continue;
            Set set = value2.conflicts();
            if (set == null) {
                this.setGood(value2);
                continue;
            }
            this.setNoGood(value2, set);
        }
        this.undoPropagate(value.variable());
    }

    public boolean init(Solver solver) {
        Object[] objectArray;
        Object object;
        Object object2;
        Enumeration enumeration;
        boolean bl = true;
        Progress.getInstance().save();
        Progress.getInstance().setPhase("Initializing propagation:", 3 * this.getModel().variables().size());
        Object object3 = this.getModel().variables().elements();
        while (object3.hasMoreElements()) {
            enumeration = (Variable)object3.nextElement();
            this.supportValues((Variable)((Object)enumeration)).clear();
            this.goodValues((Variable)((Object)enumeration)).clear();
        }
        object3 = this.getModel().variables().elements();
        while (object3.hasMoreElements()) {
            enumeration = (Variable)object3.nextElement();
            object2 = ((Variable)((Object)enumeration)).values().elements();
            while (object2.hasMoreElements()) {
                object = (Value)object2.nextElement();
                objectArray = ((Value)object).conflicts();
                this.initNoGood((Value)object, (Set)objectArray);
                if (objectArray != null) continue;
                this.goodValues((Variable)((Object)enumeration)).add(object);
            }
            Progress.getInstance().incProgress();
        }
        object3 = new Queue(this.getModel().variables().size() + 1);
        enumeration = this.getModel().variables().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Variable)enumeration.nextElement();
            object = ((Variable)object2).hardConstraints().elements();
            while (object.hasMoreElements()) {
                objectArray = (Constraint)object.nextElement();
                this.propagate((Constraint)objectArray, (Variable)object2, (Queue)object3);
            }
            Progress.getInstance().incProgress();
        }
        if (!this.iJustForwardCheck) {
            this.propagate((Queue)object3);
        }
        enumeration = this.getModel().variables().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Variable)enumeration.nextElement();
            object = new FastVector();
            objectArray = ((Variable)object2).values().elements();
            while (objectArray.hasMoreElements()) {
                Value value = (Value)objectArray.nextElement();
                if (this.isGood(value) || !this.noGood(value).isEmpty()) continue;
                ((Vector)object).addElement(value);
            }
            objectArray = ((Vector)object).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Variable)object2).removeValue(0L, (Value)objectArray[i]);
            }
            if (((Variable)object2).values().isEmpty()) {
                sLogger.error((Object)(((Variable)object2).getName() + " has empty domain!"));
                bl = false;
            }
            Progress.getInstance().incProgress();
        }
        Progress.getInstance().restore();
        return bl;
    }

    protected void propagate(Variable variable) {
        Queue queue = new Queue(variable.getModel().variables().size() + 1);
        if (variable.getAssignment() != null) {
            Enumeration enumeration = variable.hardConstraints().elements();
            while (enumeration.hasMoreElements()) {
                Constraint constraint = (Constraint)enumeration.nextElement();
                if (!this.contains(constraint)) continue;
                this.propagate(constraint, variable.getAssignment(), queue);
            }
        } else {
            Enumeration enumeration = variable.hardConstraints().elements();
            while (enumeration.hasMoreElements()) {
                Constraint constraint = (Constraint)enumeration.nextElement();
                if (!this.contains(constraint)) continue;
                this.propagate(constraint, variable, queue);
            }
        }
        if (!this.iJustForwardCheck && !queue.isEmpty()) {
            this.propagate(queue);
        }
    }

    protected void propagate(Queue queue) {
        while (!queue.isEmpty()) {
            Variable variable = (Variable)queue.get();
            Enumeration enumeration = variable.hardConstraints().elements();
            while (enumeration.hasMoreElements()) {
                Constraint constraint = (Constraint)enumeration.nextElement();
                if (!this.contains(constraint)) continue;
                this.propagate(constraint, variable, queue);
            }
        }
    }

    public void undoPropagate(Variable variable) {
        Object object;
        Object object2;
        Object object3;
        Hashtable<Variable, Object> hashtable = new Hashtable<Variable, Object>();
        while (!this.supportValues(variable).isEmpty()) {
            object3 = (Value)this.supportValues(variable).iterator().next();
            object2 = ((Value)object3).conflicts();
            if (object2 == null) {
                this.setGood((Value)object3);
                object = (Vector)hashtable.get(((Value)object3).variable());
                if (object == null) {
                    object = new FastVector();
                    hashtable.put(((Value)object3).variable(), object);
                }
                ((Vector)object).addElement(object3);
                continue;
            }
            this.setNoGood((Value)object3, (Set)object2);
            if (!object2.isEmpty()) continue;
            ((Value)object3).variable().removeValue(this.iIteration, (Value)object3);
        }
        object3 = new Queue(variable.getModel().variables().size() + 1);
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (Variable)object2.nextElement();
            Vector vector = (Vector)hashtable.get(object);
            boolean bl = false;
            Enumeration enumeration = ((Variable)object).constraintVariables().keys();
            while (enumeration.hasMoreElements()) {
                if (!this.propagate((Variable)enumeration.nextElement(), (Variable)object, vector)) continue;
                bl = true;
            }
            if (!bl) continue;
            ((Queue)object3).put(object);
        }
        object2 = variable.constraintVariables().keys();
        while (object2.hasMoreElements()) {
            if (!this.propagate((Variable)object2.nextElement(), variable) || ((Queue)object3).contains(variable)) continue;
            ((Queue)object3).put(variable);
        }
        if (!this.iJustForwardCheck) {
            this.propagate((Queue)object3);
        }
    }

    protected boolean propagate(Variable variable, Variable variable2, Vector vector) {
        if (this.goodValues(variable).isEmpty()) {
            return false;
        }
        boolean bl = false;
        Vector vector2 = null;
        Enumeration enumeration = ((Vector)variable2.constraintVariables().get(variable)).elements();
        while (enumeration.hasMoreElements()) {
            Value value;
            Constraint constraint = (Constraint)enumeration.nextElement();
            Object object = this.goodValues(variable).iterator();
            while (object.hasNext()) {
                value = (Value)object.next();
                if ((vector2 = vector2 == null ? this.conflictValues(constraint, value, vector) : this.conflictValues(constraint, value, vector2)) != null && !vector2.isEmpty()) continue;
            }
            if (vector2 == null || vector2.isEmpty()) continue;
            object = vector2.elements();
            while (object.hasMoreElements()) {
                value = (Value)object.nextElement();
                HashSet hashSet = this.reason(constraint, variable, value);
                this.setNoGood(value, hashSet);
                vector.removeElement(value);
                if (hashSet.isEmpty()) {
                    value.variable().removeValue(this.iIteration, value);
                }
                bl = true;
            }
        }
        return bl;
    }

    protected boolean propagate(Variable variable, Variable variable2) {
        if (this.goodValues(variable2).isEmpty()) {
            return false;
        }
        return this.propagate(variable, variable2, new FastVector((Collection)this.goodValues(variable2)));
    }

    private Set supportValues(Variable variable) {
        Set[] setArray = (Set[])variable.getExtra();
        if (setArray == null) {
            setArray = new HashSet[]{new HashSet(1000), new HashSet()};
            variable.setExtra(setArray);
        }
        return setArray[0];
    }

    public Set goodValues(Variable variable) {
        Set[] setArray = (Set[])variable.getExtra();
        if (setArray == null) {
            setArray = new HashSet[]{new HashSet(1000), new HashSet()};
            variable.setExtra(setArray);
        }
        return setArray[1];
    }

    private void goodnessChanged(Value value) {
        if (this.isGood(value)) {
            this.goodValues(value.variable()).add(value);
        } else {
            this.goodValues(value.variable()).remove(value);
        }
    }

    private void removeSupport(Variable variable, Value value) {
        this.supportValues(variable).remove(value);
    }

    private void addSupport(Variable variable, Value value) {
        this.supportValues(variable).add(value);
    }

    public Set noGood(Value value) {
        return (Set)value.getExtra();
    }

    public boolean isGood(Value value) {
        return value.getExtra() == null;
    }

    protected void setGood(Value value) {
        Set set = this.noGood(value);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.removeSupport(((Value)iterator.next()).variable(), value);
            }
        }
        value.setExtra(null);
        this.goodnessChanged(value);
    }

    private void initNoGood(Value value, Set set) {
        value.setExtra(set);
    }

    public void setNoGood(Value value, Set set) {
        Iterator iterator;
        Set set2 = this.noGood(value);
        if (set2 != null) {
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                this.removeSupport(((Value)iterator.next()).variable(), value);
            }
        }
        value.setExtra(set);
        iterator = set.iterator();
        while (iterator.hasNext()) {
            Value value2 = (Value)iterator.next();
            this.addSupport(value2.variable(), value);
        }
        this.goodnessChanged(value);
    }

    private void propagate(Constraint constraint, Value value, Queue queue) {
        HashSet<Value> hashSet = new HashSet<Value>(1);
        hashSet.add(value);
        Vector vector = this.conflictValues(constraint, value);
        if (vector != null && !vector.isEmpty()) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Value value2 = (Value)iterator.next();
                this.setNoGood(value2, hashSet);
                if (queue.contains(value2.variable())) continue;
                queue.put(value2.variable());
            }
        }
    }

    private void propagate(Constraint constraint, Variable variable, Queue queue) {
        if (this.goodValues(variable).isEmpty()) {
            return;
        }
        Vector vector = this.conflictValues(constraint, variable);
        if (vector != null && !vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Value value = (Value)enumeration.nextElement();
                if (!queue.contains(value.variable())) {
                    queue.put(value.variable());
                }
                HashSet hashSet = this.reason(constraint, variable, value);
                this.setNoGood(value, hashSet);
                if (!hashSet.isEmpty()) continue;
                value.variable().removeValue(this.iIteration, value);
            }
        }
    }

    private Vector conflictValues(Constraint constraint, Value value) {
        FastVector fastVector = new FastVector();
        Enumeration enumeration = constraint.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.equals(value.variable()) || variable.getAssignment() != null) continue;
            Iterator iterator = this.goodValues(variable).iterator();
            while (iterator.hasNext()) {
                Value value2 = (Value)iterator.next();
                if (constraint.isConsistent(value, value2)) continue;
                fastVector.addElement(value2);
            }
        }
        return fastVector;
    }

    private Vector conflictValues(Constraint constraint, Value value, Vector vector) {
        FastVector fastVector = new FastVector(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Value value2 = (Value)enumeration.nextElement();
            if (constraint.isConsistent(value, value2)) continue;
            fastVector.addElement(value2);
        }
        return fastVector;
    }

    private Vector conflictValues(Constraint constraint, Variable variable) {
        Vector vector = null;
        Iterator iterator = this.goodValues(variable).iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if ((vector = vector == null ? this.conflictValues(constraint, value) : this.conflictValues(constraint, value, vector)) != null && !vector.isEmpty()) continue;
            return null;
        }
        return vector;
    }

    private HashSet reason(Constraint constraint, Variable variable, Value value) {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = variable.values().elements();
        while (enumeration.hasMoreElements()) {
            Value value2 = (Value)enumeration.nextElement();
            if (!constraint.isConsistent(value, value2)) continue;
            if (this.noGood(value2) == null) {
                sLogger.error((Object)("Something went wrong: value " + value2 + " cannot participate in a reason."));
                continue;
            }
            hashSet.addAll(this.noGood(value2));
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

