/*
 * Decompiled with CFR 0.152.
 */
package ifs.heuristics;

import ifs.extension.ConflictStatistics;
import ifs.extension.Extension;
import ifs.extension.MacPropagation;
import ifs.extension.ViolatedInitials;
import ifs.heuristics.ValueSelection;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GeneralValueSelection
implements ValueSelection {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$heuristics$GeneralValueSelection == null ? (class$ifs$heuristics$GeneralValueSelection = GeneralValueSelection.class$("ifs.heuristics.GeneralValueSelection")) : class$ifs$heuristics$GeneralValueSelection));
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private double iGoodSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightPotentialConflicts = 0.0;
    private double iWeightWeightedCoflicts = 0.0;
    private double iWeightCoflicts = 1.0;
    private double iWeightNrAssignments = 0.5;
    private double iWeightValue = 0.0;
    private int iTabuSize = 0;
    private ArrayList iTabu = null;
    private int iTabuPos = 0;
    private boolean iMPP = false;
    private ConflictStatistics iStat = null;
    private MacPropagation iProp = null;
    private ViolatedInitials iViolatedInitials = null;
    static /* synthetic */ Class class$ifs$heuristics$GeneralValueSelection;

    public GeneralValueSelection() {
    }

    public GeneralValueSelection(DataProperties dataProperties) {
        this.iMPP = dataProperties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = dataProperties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = dataProperties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = dataProperties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iGoodSelectionProb = dataProperties.getPropertyDouble("Value.GoodSelectionProb", 0.0);
        this.iWeightWeightedCoflicts = dataProperties.getPropertyDouble("Value.WeightWeightedConflicts", 1.0);
        this.iWeightPotentialConflicts = dataProperties.getPropertyDouble("Value.WeightPotentialConflicts", 0.0);
        this.iRandomWalkProb = dataProperties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightCoflicts = dataProperties.getPropertyDouble("Value.WeightConflicts", 1.0);
        this.iWeightNrAssignments = dataProperties.getPropertyDouble("Value.WeightNrAssignments", 0.5);
        this.iWeightValue = dataProperties.getPropertyDouble("Value.WeightValue", 0.0);
        this.iTabuSize = dataProperties.getPropertyInt("Value.Tabu", 0);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension instanceof ConflictStatistics) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (extension instanceof MacPropagation) {
                this.iProp = (MacPropagation)extension;
            }
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public Value selectValue(Solution solution, Variable variable) {
        Collection<Value> collection;
        if (this.iMPP && variable.getInitialAssignment() != null) {
            if (solution.getModel().unassignedVariables().isEmpty() && solution.getModel().perturbVariables().size() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getModel().perturbVariables().size() - 1;
            }
            if (this.iMPPLimit >= 0 && solution.getModel().perturbVariables().size() > this.iMPPLimit) {
                return variable.getInitialAssignment();
            }
            if (variable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb) {
                return variable.getInitialAssignment();
            }
        }
        Vector vector = variable.values();
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return (Value)ToolBox.random(vector);
        }
        if (this.iProp != null && variable.getAssignment() == null && ToolBox.random() <= this.iGoodSelectionProb && !(collection = this.iProp.goodValues(variable)).isEmpty()) {
            vector = new FastVector(collection);
        }
        if (vector.size() == 1) {
            return (Value)vector.firstElement();
        }
        collection = null;
        double d = 0.0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Value value = (Value)object.nextElement();
            if (this.iTabu != null && this.iTabu.contains(value) || variable.getAssignment() != null && variable.getAssignment().equals(value)) continue;
            Set set = solution.getModel().conflictValues(value);
            double d2 = this.iStat == null || this.iWeightCoflicts == 0.0 ? 0.0 : this.iStat.countRemovals(solution.getIteration(), set, value);
            double d3 = this.iStat == null || this.iWeightPotentialConflicts == 0.0 ? 0.0 : (double)this.iStat.countPotentialConflicts(solution.getIteration(), value, 3);
            long l = 0L;
            if (this.iMPP && this.iWeightDeltaInitialAssignment != 0.0) {
                Object object2;
                Object object3;
                if (this.iViolatedInitials != null && (object3 = this.iViolatedInitials.getViolatedInitials(value)) != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        Value value2 = (Value)object2.next();
                        if (value2.variable().getAssignment() != null && !value2.variable().getAssignment().equals(value2)) continue;
                        l += 2L;
                    }
                }
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (Value)object3.next();
                    if (((Value)object2).variable().getInitialAssignment() == null) continue;
                    --l;
                }
                if (variable.getInitialAssignment() != null && !variable.getInitialAssignment().equals(value)) {
                    ++l;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables().size() + l > (long)this.iMPPLimit) continue;
            }
            double d4 = this.iWeightDeltaInitialAssignment * (double)l + this.iWeightPotentialConflicts * d3 + this.iWeightWeightedCoflicts * d2 + this.iWeightCoflicts * (double)set.size() + this.iWeightNrAssignments * (double)value.countAssignments() + this.iWeightValue * (double)value.toInt();
            if (collection == null || d > d4) {
                d = d4;
                if (collection == null) {
                    collection = new FastVector();
                } else {
                    ((Vector)collection).clear();
                }
                ((Vector)collection).addElement(value);
                continue;
            }
            if (d != d4) continue;
            ((Vector)collection).addElement(value);
        }
        object = (Value)(collection == null ? null : ToolBox.random(collection));
        if (object == null) {
            object = (Value)ToolBox.random(vector);
        }
        if (this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(object);
            } else {
                this.iTabu.set(this.iTabuPos, object);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return collection == null ? null : object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

