/*
 * Decompiled with CFR 0.152.
 */
package ifs.heuristics;

import ifs.extension.Extension;
import ifs.extension.MacPropagation;
import ifs.heuristics.VariableSelection;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.Enumeration;
import java.util.Set;

public class GeneralVariableSelection
implements VariableSelection {
    private boolean iUnassignWhenNotGood = false;
    private double iUnassignWhenNotGoodRandWalk = 0.02;
    private boolean iRandomSelection = true;
    private boolean iMPP = false;
    private MacPropagation iProp = null;

    public GeneralVariableSelection(DataProperties dataProperties) {
        this.iUnassignWhenNotGood = dataProperties.getPropertyBoolean("Variable.UnassignWhenNoGood", this.iUnassignWhenNotGood);
        this.iUnassignWhenNotGoodRandWalk = dataProperties.getPropertyDouble("Variable.UnassignWhenNoGoodRandomWalk", this.iUnassignWhenNotGoodRandWalk);
        this.iRandomSelection = dataProperties.getPropertyBoolean("Variable.RandomSelection", this.iRandomSelection);
    }

    public GeneralVariableSelection() {
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!(extension instanceof MacPropagation)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    public Variable selectVariable(Solution solution) {
        Object object;
        Object object2;
        FastVector fastVector;
        if (solution.getModel().unassignedVariables().isEmpty()) {
            if (!solution.getModel().perturbVariables().isEmpty()) {
                return (Variable)ToolBox.random(solution.getModel().perturbVariables());
            }
            return (Variable)ToolBox.random(solution.getModel().assignedVariables());
        }
        if (this.iProp != null && this.iUnassignWhenNotGood) {
            fastVector = new FastVector();
            Enumeration enumeration = solution.getModel().unassignedVariables().elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Variable)enumeration.nextElement();
                if (!this.iProp.goodValues((Variable)object2).isEmpty()) continue;
                fastVector.addElement(object2);
            }
            if (!fastVector.isEmpty()) {
                if (ToolBox.random() < this.iUnassignWhenNotGoodRandWalk) {
                    return (Variable)ToolBox.random(solution.getModel().assignedVariables());
                }
                for (int i = 0; i < 10; ++i) {
                    object2 = (Variable)ToolBox.random(fastVector);
                    object = (Value)ToolBox.random(((Variable)object2).values());
                    Set set = this.iProp.noGood((Value)object);
                    if (set == null || set.isEmpty()) continue;
                    return ((Value)ToolBox.random(set)).variable();
                }
            }
        }
        if (this.iRandomSelection) {
            return (Variable)ToolBox.random(solution.getModel().unassignedVariables());
        }
        fastVector = new FastVector();
        int n = 0;
        object2 = solution.getModel().unassignedVariables().elements();
        while (object2.hasMoreElements()) {
            object = (Variable)object2.nextElement();
            int n2 = ((Variable)object).getInitialAssignment() != null ? 3 * (1 + solution.getModel().conflictValues(((Variable)object).getInitialAssignment()).size()) : 1;
            fastVector.addElement(new Integer(n += n2));
        }
        int n3 = ToolBox.random(n);
        object = solution.getModel().unassignedVariables().elements();
        for (int i = 0; object.hasMoreElements() && i < fastVector.size(); ++i) {
            Variable variable = (Variable)object.nextElement();
            int n4 = (Integer)fastVector.elementAt(i);
            if (n4 <= n3) continue;
            return variable;
        }
        return (Variable)ToolBox.random(solution.getModel().unassignedVariables());
    }
}

