/*
 * Decompiled with CFR 0.152.
 */
package ifs.model;

import ifs.model.ConstraintListener;
import ifs.model.Model;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.util.FastVector;
import ifs.util.IdGenerator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class Constraint {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$model$Constraint == null ? (class$ifs$model$Constraint = Constraint.class$("ifs.model.Constraint")) : class$ifs$model$Constraint));
    private static IdGenerator iIdGenerator = new IdGenerator();
    private long iId = -1L;
    private Vector iVariables = new FastVector();
    private Vector iAssignedVariables = new FastVector();
    private Model iModel = null;
    private Vector iConstraintListeners = null;
    static /* synthetic */ Class class$ifs$model$Constraint;

    public Constraint() {
        this.iId = iIdGenerator.newId();
    }

    public Model getModel() {
        return this.iModel;
    }

    public void setModel(Model model) {
        this.iModel = model;
    }

    public Vector variables() {
        return this.iVariables;
    }

    public Vector assignedVariables() {
        return this.iAssignedVariables;
    }

    public int countVariables() {
        return this.iVariables.size();
    }

    public int countAssignedVariables() {
        return this.iAssignedVariables.size();
    }

    public void addVariable(Variable variable) {
        this.iVariables.addElement(variable);
        variable.addContstraint(this);
        if (variable.getAssignment() != null) {
            this.assigned(0L, variable.getAssignment());
            this.iAssignedVariables.addElement(variable);
        }
    }

    public void removeVariable(Variable variable) {
        variable.removeContstraint(this);
        this.iVariables.removeElement(variable);
        if (this.iAssignedVariables.contains(variable)) {
            this.iAssignedVariables.removeElement(variable);
        }
    }

    public abstract void computeConflicts(Value var1, Set var2);

    public boolean isConsistent(Value value, Value value2) {
        return true;
    }

    public boolean inConflict(Value value) {
        HashSet hashSet = new HashSet();
        this.computeConflicts(value, hashSet);
        return !hashSet.isEmpty();
    }

    public void assigned(long l, Value value) {
        Enumeration enumeration;
        HashSet hashSet = null;
        if (this.isHard()) {
            hashSet = new HashSet();
            this.computeConflicts(value, hashSet);
        }
        if (this.iConstraintListeners != null) {
            enumeration = this.iConstraintListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ConstraintListener)enumeration.nextElement()).constraintBeforeAssigned(l, this, value, hashSet);
            }
        }
        if (hashSet != null) {
            enumeration = hashSet.iterator();
            while (enumeration.hasNext()) {
                Value value2 = (Value)enumeration.next();
                value2.variable().unassign(l);
            }
        }
        this.iAssignedVariables.addElement(value.variable());
        if (this.iConstraintListeners != null) {
            enumeration = this.iConstraintListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ConstraintListener)enumeration.nextElement()).constraintAfterAssigned(l, this, value, hashSet);
            }
        }
    }

    public void unassigned(long l, Value value) {
        this.iAssignedVariables.removeElement(value.variable());
    }

    public void addConstraintListener(ConstraintListener constraintListener) {
        if (this.iConstraintListeners == null) {
            this.iConstraintListeners = new FastVector();
        }
        this.iConstraintListeners.addElement(constraintListener);
    }

    public void removeConstraintListener(ConstraintListener constraintListener) {
        if (this.iConstraintListeners == null) {
            this.iConstraintListeners = new FastVector();
        }
        this.iConstraintListeners.removeElement(constraintListener);
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public boolean isHard() {
        return true;
    }

    public void getInfo(Dictionary dictionary) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

