/*
 * Decompiled with CFR 0.152.
 */
package ifs.perturbations;

import ifs.extension.Extension;
import ifs.extension.ViolatedInitials;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.perturbations.PerturbationsCounter;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class DefaultPerturbationsCounter
implements PerturbationsCounter {
    private ViolatedInitials iViolatedInitials = null;
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    public DefaultPerturbationsCounter(DataProperties dataProperties) {
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public double getPerturbationPenalty(Solution solution) {
        double d = 0.0;
        Enumeration enumeration = solution.getModel().perturbVariables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getAssignment() == null || variable.getInitialAssignment() == null || variable.getAssignment().equals(variable.getInitialAssignment())) continue;
            d += this.getPenaltyD(variable.getAssignment(), variable.getInitialAssignment());
        }
        return d;
    }

    protected ViolatedInitials getViolatedInitials() {
        return this.iViolatedInitials;
    }

    protected double getPenalty(Value value, Value value2) {
        return 1.0;
    }

    protected double getPenaltyA(Value value, Value value2) {
        return this.getPenalty(null, value2);
    }

    protected double getPenaltyB(Value value, Value value2, Value value3) {
        return this.getPenalty(value2, value3);
    }

    protected double getPenaltyC(Value value, Value value2, Value value3) {
        return -this.getPenalty(value2, value3);
    }

    protected double getPenaltyD(Value value, Value value2) {
        return this.getPenalty(value, value2);
    }

    public double getPerturbationPenalty(Solution solution, Value value, Collection collection) {
        Value value2;
        Iterator iterator;
        Set set;
        double d = 0.0;
        Set set2 = set = this.getViolatedInitials() == null ? null : this.getViolatedInitials().getViolatedInitials(value);
        if (set != null) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                value2 = (Value)iterator.next();
                if (value2.variable().getAssignment() != null) continue;
                d += this.getPenaltyA(value, value2);
            }
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            value2 = (Value)iterator.next();
            Value value3 = value2.variable().getInitialAssignment();
            if (value3 == null) continue;
            if (value3.equals(value2)) {
                d += this.getPenaltyB(value, value2, value3);
                continue;
            }
            if (set != null && set.contains(value3)) continue;
            d += this.getPenaltyC(value, value2, value3);
        }
        if (value.variable().getInitialAssignment() != null && !value.equals(value.variable().getInitialAssignment())) {
            d += this.getPenaltyD(value, value.variable().getInitialAssignment());
        }
        return d;
    }

    public void getInfo(Dictionary dictionary, Solution solution) {
        dictionary.put("Perturbations: Total penalty", sDoubleFormat.format(this.getPerturbationPenalty(solution)));
    }
}

