/*
 * Decompiled with CFR 0.152.
 */
package ifs.solution;

import ifs.model.Model;
import ifs.perturbations.PerturbationsCounter;
import ifs.solution.SolutionListener;
import ifs.solver.Solver;
import ifs.util.FastVector;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Solution {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$solution$Solution == null ? (class$ifs$solution$Solution = Solution.class$("ifs.solution.Solution")) : class$ifs$solution$Solution));
    private static DecimalFormat sTimeFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private Model iModel;
    private long iIteration = 0L;
    private double iTime = 0.0;
    private boolean iBestComplete = false;
    private Hashtable iBestInfo = null;
    private long iBestIteration = -1L;
    private double iBestTime = -1.0;
    private double iBestPerturbationsPenaly = -1.0;
    private int iBestValue = 0;
    private int iBestPertirbations = -1;
    private Vector iSolutionListeners = new FastVector();
    private PerturbationsCounter iPerturbationsCounter = null;
    static /* synthetic */ Class class$ifs$solution$Solution;

    public Solution(Model model) {
        this(model, 0L, 0.0);
    }

    public Solution(Model model, long l, double d) {
        this.iModel = model;
        this.iIteration = l;
        this.iTime = d;
    }

    public long getIteration() {
        return this.iIteration;
    }

    public Model getModel() {
        return this.iModel;
    }

    public double getTime() {
        return this.iTime;
    }

    public void update(double d) {
        this.iTime = d;
        ++this.iIteration;
        Enumeration enumeration = this.iSolutionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SolutionListener)enumeration.nextElement()).solutionUpdated(this);
        }
    }

    public void init(Solver solver) {
        this.iIteration = 0L;
        this.iTime = 0.0;
        if (this.iModel != null) {
            this.iModel.init(solver);
        }
        this.iPerturbationsCounter = solver.getPerturbationsCounter();
    }

    public String toString() {
        return "Solution{\n  model=" + this.iModel + ",\n  iteration=" + this.iIteration + ",\n  time=" + this.iTime + "\n}";
    }

    public Hashtable getInfo() {
        Hashtable hashtable = this.getModel().getInfo();
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().getInfo(hashtable, this);
        }
        hashtable.put("Time", sTimeFormat.format(this.getTime()) + " sec");
        hashtable.put("Iteration", String.valueOf(this.getIteration()));
        if (this.getTime() > 0.0) {
            hashtable.put("Speed", sTimeFormat.format((double)this.getIteration() / this.getTime()) + " it/s");
        }
        Enumeration enumeration = this.iSolutionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SolutionListener)enumeration.nextElement()).getInfo(this, hashtable);
        }
        return hashtable;
    }

    public Hashtable getBestInfo() {
        return this.iBestInfo;
    }

    public long getBestIteration() {
        return this.iBestIteration < 0L ? this.getIteration() : this.iBestIteration;
    }

    public double getBestTime() {
        return this.iBestTime < 0.0 ? this.getTime() : this.iBestTime;
    }

    public int getBestPertirbations() {
        return this.iBestPertirbations;
    }

    public boolean isBestComplete() {
        return this.iBestComplete;
    }

    public int getBestValue() {
        return this.iBestValue;
    }

    public double getBestPerturbationsPenalty() {
        return this.iBestPerturbationsPenaly;
    }

    public PerturbationsCounter getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    public void clearBest() {
        this.iBestInfo = null;
        this.iBestTime = 0.0;
        this.iBestIteration = 0L;
        this.iBestPertirbations = -1;
        this.iBestComplete = false;
        this.iBestValue = 0;
        this.iBestPerturbationsPenaly = -1.0;
        Enumeration enumeration = this.iSolutionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SolutionListener)enumeration.nextElement()).bestCleared(this);
        }
    }

    public void saveBest() {
        this.getModel().saveBest();
        this.iBestInfo = this.getInfo();
        this.iBestTime = this.getTime();
        this.iBestIteration = this.getIteration();
        this.iBestPertirbations = this.getModel().perturbVariables().size();
        this.iBestComplete = this.getModel().unassignedVariables().isEmpty();
        this.iBestValue = this.getModel().getTotalValue();
        this.iBestPerturbationsPenaly = this.iPerturbationsCounter.getPerturbationPenalty(this);
        Enumeration enumeration = this.iSolutionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SolutionListener)enumeration.nextElement()).bestSaved(this);
        }
    }

    public void restoreBest() {
        if (this.iBestInfo == null) {
            return;
        }
        this.getModel().restoreBest();
        this.iTime = this.iBestTime;
        this.iIteration = this.iBestIteration;
        Enumeration enumeration = this.iSolutionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SolutionListener)enumeration.nextElement()).bestRestored(this);
        }
    }

    public void addSolutionListener(SolutionListener solutionListener) {
        this.iSolutionListeners.addElement(solutionListener);
    }

    public void removeSolutionListener(SolutionListener solutionListener) {
        this.iSolutionListeners.removeElement(solutionListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

