/*
 * Decompiled with CFR 0.152.
 */
package ifs.termination;

import ifs.solution.Solution;
import ifs.termination.TerminationCondition;
import ifs.util.DataProperties;
import org.apache.log4j.Logger;

public class MPPTerminationCondition
implements TerminationCondition {
    protected static Logger sLogger = Logger.getLogger((Class)(class$ifs$termination$MPPTerminationCondition == null ? (class$ifs$termination$MPPTerminationCondition = MPPTerminationCondition.class$("ifs.termination.MPPTerminationCondition")) : class$ifs$termination$MPPTerminationCondition));
    private int iMinPerturbances;
    private int iMaxIter;
    private double iTimeOut;
    private double iMinPertPenalty;
    private boolean iStopWhenComplete;
    static /* synthetic */ Class class$ifs$termination$MPPTerminationCondition;

    public MPPTerminationCondition(DataProperties dataProperties) {
        this.iMaxIter = dataProperties.getPropertyInt("Termination.MaxIters", -1);
        this.iTimeOut = dataProperties.getPropertyDouble("Termination.TimeOut", -1.0);
        this.iMinPerturbances = dataProperties.getPropertyInt("Termination.MinPerturbances", -1);
        this.iStopWhenComplete = dataProperties.getPropertyBoolean("Termination.StopWhenComplete", false);
        this.iMinPertPenalty = dataProperties.getPropertyDouble("Termination.MinPerturbationPenalty", -1.0);
    }

    public MPPTerminationCondition(int n, double d, int n2) {
        this.iMaxIter = n;
        this.iMinPerturbances = n2;
        this.iTimeOut = d;
    }

    public boolean canContinue(Solution solution) {
        if (this.iMinPerturbances >= 0 && solution.getModel().unassignedVariables().isEmpty() && solution.getModel().perturbVariables().size() <= this.iMinPerturbances) {
            sLogger.info((Object)"A complete solution with allowed number of perturbances found.");
            return false;
        }
        if (this.iMinPertPenalty >= 0.0 && solution.getModel().unassignedVariables().isEmpty() && solution.getPerturbationsCounter().getPerturbationPenalty(solution) <= this.iMinPertPenalty) {
            sLogger.info((Object)"A complete solution with allowed perturbation penalty found.");
            return false;
        }
        if (this.iMaxIter >= 0 && solution.getIteration() >= (long)this.iMaxIter) {
            sLogger.info((Object)"Maximum number of iteration reached.");
            return false;
        }
        if (this.iTimeOut >= 0.0 && solution.getTime() > this.iTimeOut) {
            sLogger.info((Object)"Timeout reached.");
            return false;
        }
        if (this.iStopWhenComplete || this.iMaxIter < 0 && this.iTimeOut < 0.0) {
            boolean bl;
            boolean bl2 = bl = !solution.getModel().unassignedVariables().isEmpty();
            if (!bl) {
                sLogger.info((Object)"Complete solution found.");
            }
            return bl;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

